/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Für (lokale) Störfallindikatoren können hier für ihre angenommenen Ausdehnung individuelle Werte angegeben werden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlRdsAusdehnungProLSI implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _lSI
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _ausdehnungVor
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 _ausdehnungNach
			;
	
		/**
		Referenz auf Objekt, dessen Ausdehnung individuell parametriert wird, wenn es als lokaler Stötfallindikator benutzt wird.
		<p>
		
		</p>
		
		@return der Wert von LSI.
		*/
			public 	Object
			 getLSI() {
			return _lSI;
		}
	
		/**
		Referenz auf Objekt, dessen Ausdehnung individuell parametriert wird, wenn es als lokaler Stötfallindikator benutzt wird.
		<p>
		
		</p>
		
		@param _lSI der neue Wert von LSI.
		*/
		public void setLSI(	Object
		 _lSI) {
			this._lSI = _lSI;
		}
	
		/**
		Angenommene Ausdehnung vor einer Störung, die durch den weiter oben referenzierten (lokalen) Störfallindikator detektiert wurde.
		<p>
		
		</p>
		
		@return der Wert von AusdehnungVor.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getAusdehnungVor() {
			return _ausdehnungVor;
		}
	
		/**
		Angenommene Ausdehnung vor einer Störung, die durch den weiter oben referenzierten (lokalen) Störfallindikator detektiert wurde.
		<p>
		
		</p>
		
		@param _ausdehnungVor der neue Wert von AusdehnungVor.
		*/
		public void setAusdehnungVor(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _ausdehnungVor) {
			this._ausdehnungVor = _ausdehnungVor;
		}
	
		/**
		Angenommene Ausdehnung nach einer Störung, die durch den weiter oben referenzierten (lokalen) Störfallindikator detektiert wurde.
		<p>
		
		</p>
		
		@return der Wert von AusdehnungNach.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
			 getAusdehnungNach() {
			return _ausdehnungNach;
		}
	
		/**
		Angenommene Ausdehnung nach einer Störung, die durch den weiter oben referenzierten (lokalen) Störfallindikator detektiert wurde.
		<p>
		
		</p>
		
		@param _ausdehnungNach der neue Wert von AusdehnungNach.
		*/
		public void setAusdehnungNach(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
		 _ausdehnungNach) {
			this._ausdehnungNach = _ausdehnungNach;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soLSI = getLSI();
					final SystemObject tmpLSI;
						if (soLSI instanceof SystemObject) {
							tmpLSI = (SystemObject)soLSI;
						} else if(soLSI instanceof SystemObjekt){
							tmpLSI = ((SystemObjekt)soLSI).getSystemObject();
						} else{
							tmpLSI = null;
						}
					datum.getReferenceValue("LSI").setSystemObject(tmpLSI);
				// GanzzahlAttributTyp
				if (getAusdehnungVor() != null) {
	                if (getAusdehnungVor().isZustand()) {
	                    datum.getUnscaledValue("AusdehnungVor").setText(getAusdehnungVor().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AusdehnungVor").set(getAusdehnungVor().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAusdehnungNach() != null) {
	                if (getAusdehnungNach().isZustand()) {
	                    datum.getUnscaledValue("AusdehnungNach").setText(getAusdehnungNach().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AusdehnungNach").set(getAusdehnungNach().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idLSI = daten.getReferenceValue("LSI").getId();
					final SystemObjekt tmpLSI;
					if (idLSI == 0) {
						tmpLSI = null;
					} else {
						final SystemObject soLSI = factory.getDav().getDataModel().getObject(idLSI);
						if (soLSI == null) {
								tmpLSI = new BaseUngueltigesSystemObjekt(idLSI);
						} else {
							tmpLSI = factory.getModellobjekt(soLSI);
						}
					}
					setLSI((	Object
					) tmpLSI);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AusdehnungVor").isState()) {
							setAusdehnungVor(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("AusdehnungVor").getText()));
						} else {
						setAusdehnungVor(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("AusdehnungVor").
								longValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AusdehnungNach").isState()) {
							setAusdehnungNach(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
							.getZustand(daten.getScaledValue("AusdehnungNach").getText()));
						} else {
						setAusdehnungNach(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttStreckeMeter
						(daten.
							getUnscaledValue
						("AusdehnungNach").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsAusdehnungProLSI clone() {
		AtlRdsAusdehnungProLSI klon = new AtlRdsAusdehnungProLSI();
		
						klon.setLSI(getLSI());
						klon.setAusdehnungVor(getAusdehnungVor());
						klon.setAusdehnungNach(getAusdehnungNach());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
