/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ereignis-Informationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsEreignis implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten
			> _ereignisDaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten
			>(0, true);
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisInBeidenRichtungen
			;
			@Defaultwert(wert = "prEN ISO 14819-2 (Alert-C)")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKodierung
			 _ereignisKodierung
			;
			@Defaultwert(wert = "1")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 _ereignisTabelleNummer
			;
			@Defaultwert(wert = "")
			private String
			 _ereignisTabelleVersion
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisTyp
			> _ereignisTyp = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisTyp
			>(0, true);
	
		/**
		Ereignis-Daten.
		<p>
		TIC Info XML Element: EventData, enthält die Daten zum Ereignis.
		</p>
		
		@return der Wert von EreignisDaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten
			> getEreignisDaten() {
			return _ereignisDaten;
		}
	
	
		/**
		Die Information ist bi-direktional (ja) oder nicht (nein).
		<p>
		TIC Info XML Element: EventBiDirectionFlag.
		</p>
		
		@return der Wert von EreignisInBeidenRichtungen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getEreignisInBeidenRichtungen() {
			return _ereignisInBeidenRichtungen;
		}
	
		/**
		Die Information ist bi-direktional (ja) oder nicht (nein).
		<p>
		TIC Info XML Element: EventBiDirectionFlag.
		</p>
		
		@param _ereignisInBeidenRichtungen der neue Wert von EreignisInBeidenRichtungen.
		*/
		public void setEreignisInBeidenRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _ereignisInBeidenRichtungen) {
			this._ereignisInBeidenRichtungen = _ereignisInBeidenRichtungen;
		}
	
		/**
		Tabelle, nach der das Ereignis zu interpretieren ist.
		<p>
		TIC Info XML Element: EventType.
		</p>
		
		@return der Wert von EreignisKodierung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKodierung
			 getEreignisKodierung() {
			return _ereignisKodierung;
		}
	
		/**
		Tabelle, nach der das Ereignis zu interpretieren ist.
		<p>
		TIC Info XML Element: EventType.
		</p>
		
		@param _ereignisKodierung der neue Wert von EreignisKodierung.
		*/
		public void setEreignisKodierung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKodierung
		 _ereignisKodierung) {
			this._ereignisKodierung = _ereignisKodierung;
		}
	
		/**
		Nummer der Ereignistabelle.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventTableNumber, Nummer der benutzten Ereignistabelle (0: unbekannt, 1-65535: definiert durch GEWI).&lt;&#47;absatz&gt;
								&lt;absatz&gt;Nummer = 1 entspricht Ereignistabelle nach DIN EN ISO 14819-2&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von EreignisTabelleNummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 getEreignisTabelleNummer() {
			return _ereignisTabelleNummer;
		}
	
		/**
		Nummer der Ereignistabelle.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventTableNumber, Nummer der benutzten Ereignistabelle (0: unbekannt, 1-65535: definiert durch GEWI).&lt;&#47;absatz&gt;
								&lt;absatz&gt;Nummer = 1 entspricht Ereignistabelle nach DIN EN ISO 14819-2&lt;&#47;absatz&gt;
		</p>
		
		@param _ereignisTabelleNummer der neue Wert von EreignisTabelleNummer.
		*/
		public void setEreignisTabelleNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
		 _ereignisTabelleNummer) {
			this._ereignisTabelleNummer = _ereignisTabelleNummer;
		}
	
		/**
		Version der Ereignistabelle.
		<p>
		TIC Info XML Element: EventTableVersion, textuelle Angabe der Version der Ereignistabelle.
		</p>
		
		@return der Wert von EreignisTabelleVersion.
		*/
			public String
			 getEreignisTabelleVersion() {
			return _ereignisTabelleVersion;
		}
	
		/**
		Version der Ereignistabelle.
		<p>
		TIC Info XML Element: EventTableVersion, textuelle Angabe der Version der Ereignistabelle.
		</p>
		
		@param _ereignisTabelleVersion der neue Wert von EreignisTabelleVersion.
		*/
		public void setEreignisTabelleVersion(String
		 _ereignisTabelleVersion) {
			if (_ereignisTabelleVersion.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ereignisTabelleVersion = _ereignisTabelleVersion;
		}
	
		/**
		Art des Verkehrsereignisses.
		<p>
		TIC Info XML Element: EventTrafficTypes, pro Ereignis muss mindestens ein Typ gesetzt sein.
		</p>
		
		@return der Wert von EreignisTyp.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisTyp
			> getEreignisTyp() {
			return _ereignisTyp;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayEreignisDaten = datum.getArray("EreignisDaten");
					arrayEreignisDaten.setLength(getEreignisDaten().size());
					for (int i = 0; i < arrayEreignisDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten
						 atl = getEreignisDaten().get(i);
						atl.bean2Atl(arrayEreignisDaten.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getEreignisInBeidenRichtungen() != null) {
	                if (getEreignisInBeidenRichtungen().isZustand()) {
	                    datum.getUnscaledValue("EreignisInBeidenRichtungen").setText(getEreignisInBeidenRichtungen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisInBeidenRichtungen").set(getEreignisInBeidenRichtungen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEreignisKodierung() != null) {
	                if (getEreignisKodierung().isZustand()) {
	                    datum.getUnscaledValue("EreignisKodierung").setText(getEreignisKodierung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisKodierung").set(getEreignisKodierung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEreignisTabelleNummer() != null) {
	                if (getEreignisTabelleNummer().isZustand()) {
	                    datum.getUnscaledValue("EreignisTabelleNummer").setText(getEreignisTabelleNummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisTabelleNummer").set(getEreignisTabelleNummer().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getEreignisTabelleVersion() != null) {
					datum.getTextValue("EreignisTabelleVersion").setText(getEreignisTabelleVersion());
				}
				// GanzzahlAttributTyp
				if (getEreignisTyp() != null) {
					final Data.NumberArray arrayEreignisTyp = datum.
						getUnscaledArray
						("EreignisTyp");
					arrayEreignisTyp.setLength(getEreignisTyp().size());
					for (int i = 0; i < arrayEreignisTyp.getLength(); ++i) {
						arrayEreignisTyp.getValue(i).set(getEreignisTyp().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayEreignisDaten = daten.getArray("EreignisDaten");
					for (int i = 0; i < arrayEreignisDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisDaten
						 ();
						atl.atl2Bean(arrayEreignisDaten.getItem(i), factory);
						getEreignisDaten().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisInBeidenRichtungen").isState()) {
							setEreignisInBeidenRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("EreignisInBeidenRichtungen").getText()));
						} else {
						setEreignisInBeidenRichtungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("EreignisInBeidenRichtungen").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisKodierung").isState()) {
							setEreignisKodierung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKodierung
							.getZustand(daten.getScaledValue("EreignisKodierung").getText()));
						} else {
						setEreignisKodierung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKodierung
						(daten.
							getUnscaledValue
						("EreignisKodierung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setEreignisTabelleNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
						(daten.
							getUnscaledValue
						("EreignisTabelleNummer").
								intValue
						()));
				// ZeichenkettenAttributTyp
					setEreignisTabelleVersion(daten.getTextValue("EreignisTabelleVersion").getText());
				// GanzzahlAttributTyp
					final Data.NumberArray arrayEreignisTyp = daten.
						getUnscaledArray
					("EreignisTyp");
	
					for (int i = 0; i < arrayEreignisTyp.getLength(); ++i) {
	                    if (arrayEreignisTyp.getValue(i).isState()) {
	                        getEreignisTyp().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisTyp
	                        .getZustand(arrayEreignisTyp.getValue(i).getState().getName()));
	                    } else {
	                    getEreignisTyp().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisTyp
	                    (arrayEreignisTyp.
	                    		byteValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsEreignis clone() {
		AtlRdsEreignis klon = new AtlRdsEreignis();
		
					klon._ereignisDaten = getEreignisDaten().clone();
						klon.setEreignisInBeidenRichtungen(getEreignisInBeidenRichtungen());
						klon.setEreignisKodierung(getEreignisKodierung());
						klon.setEreignisTabelleNummer(getEreignisTabelleNummer());
						klon.setEreignisTabelleVersion(getEreignisTabelleVersion());
					klon._ereignisTyp = getEreignisTyp().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
