/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ereignis-Daten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsEreignisDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
			 _ereignisKategorie
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			 _ereignisCode
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
			 _empfehlungsCode
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
			 _vorhersageCode
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
			 _ereignisDauer
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet
			> _ereignisQuantitaet = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet
			>(0, true);
	
		/**
		numerischer Wert der Ereignis-Kategorie.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCategory, numerischer Wert der Ereignis-Kategorie&lt;&#47;absatz&gt;
							 	&lt;absatz&gt;1 - 39: Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section, Spalte 'C'), Attribut &lt;verweis pid="att.rdsEreignisCode"&gt;&lt;&#47;verweis&gt; ist gültig.&lt;&#47;absatz&gt;
								&lt;absatz&gt;40 - 49: nicht benutzt&lt;&#47;absatz&gt;
								&lt;absatz&gt;50: spezielle Kategorie, kennzeichnet dieses Ereignis als eine Empfehlung entsprechend DIN EN ISO 14819-2 (Tabelle 'SUPPLEMENTARY INFORMATION LIST', Spalte 'Code'), Attribut &lt;verweis pid="att.rdsEmpfehlungsCode"&gt;&lt;&#47;verweis&gt; ist gültig&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von EreignisKategorie.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
			 getEreignisKategorie() {
			return _ereignisKategorie;
		}
	
		/**
		numerischer Wert der Ereignis-Kategorie.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCategory, numerischer Wert der Ereignis-Kategorie&lt;&#47;absatz&gt;
							 	&lt;absatz&gt;1 - 39: Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section, Spalte 'C'), Attribut &lt;verweis pid="att.rdsEreignisCode"&gt;&lt;&#47;verweis&gt; ist gültig.&lt;&#47;absatz&gt;
								&lt;absatz&gt;40 - 49: nicht benutzt&lt;&#47;absatz&gt;
								&lt;absatz&gt;50: spezielle Kategorie, kennzeichnet dieses Ereignis als eine Empfehlung entsprechend DIN EN ISO 14819-2 (Tabelle 'SUPPLEMENTARY INFORMATION LIST', Spalte 'Code'), Attribut &lt;verweis pid="att.rdsEmpfehlungsCode"&gt;&lt;&#47;verweis&gt; ist gültig&lt;&#47;absatz&gt;
		</p>
		
		@param _ereignisKategorie der neue Wert von EreignisKategorie.
		*/
		public void setEreignisKategorie(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
		 _ereignisKategorie) {
			this._ereignisKategorie = _ereignisKategorie;
		}
	
		/**
		Ereignis-Code.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCode, Codenummer des Ereignisses entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Das Attribut ist gültig bei 'att.rdsEreignisKategorie=1-39'.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von EreignisCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			 getEreignisCode() {
			return _ereignisCode;
		}
	
		/**
		Ereignis-Code.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCode, Codenummer des Ereignisses entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Das Attribut ist gültig bei 'att.rdsEreignisKategorie=1-39'.&lt;&#47;absatz&gt;
		</p>
		
		@param _ereignisCode der neue Wert von EreignisCode.
		*/
		public void setEreignisCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
		 _ereignisCode) {
			this._ereignisCode = _ereignisCode;
		}
	
		/**
		Empfehlungs-Code.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCode, Codenummer der Empfehlung entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Das Attribut ist gültig bei 'att.rdsEreignisKategorie=50'.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von EmpfehlungsCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
			 getEmpfehlungsCode() {
			return _empfehlungsCode;
		}
	
		/**
		Empfehlungs-Code.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCode, Codenummer der Empfehlung entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Das Attribut ist gültig bei 'att.rdsEreignisKategorie=50'.&lt;&#47;absatz&gt;
		</p>
		
		@param _empfehlungsCode der neue Wert von EmpfehlungsCode.
		*/
		public void setEmpfehlungsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
		 _empfehlungsCode) {
			this._empfehlungsCode = _empfehlungsCode;
		}
	
		/**
		Vorhersage-Code.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCode, Codenummer der Vorhersage entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Das Attribut ist bei 'att.rdsAttribute.Vorhersage=ja'.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von VorhersageCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
			 getVorhersageCode() {
			return _vorhersageCode;
		}
	
		/**
		Vorhersage-Code.
		<p>
		&lt;absatz&gt;TIC Info XML Element: EventDataCode, Codenummer der Vorhersage entsprechend DIN EN ISO 14819-2.&lt;&#47;absatz&gt;
								&lt;absatz&gt;Das Attribut ist bei 'att.rdsAttribute.Vorhersage=ja'.&lt;&#47;absatz&gt;
		</p>
		
		@param _vorhersageCode der neue Wert von VorhersageCode.
		*/
		public void setVorhersageCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
		 _vorhersageCode) {
			this._vorhersageCode = _vorhersageCode;
		}
	
		/**
		Dauer des Ereignisses.
		<p>
		TIC Info XML Element: EventDataDurationType.
		</p>
		
		@return der Wert von EreignisDauer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
			 getEreignisDauer() {
			return _ereignisDauer;
		}
	
		/**
		Dauer des Ereignisses.
		<p>
		TIC Info XML Element: EventDataDurationType.
		</p>
		
		@param _ereignisDauer der neue Wert von EreignisDauer.
		*/
		public void setEreignisDauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
		 _ereignisDauer) {
			this._ereignisDauer = _ereignisDauer;
		}
	
		/**
		Quantitätsangaben zum Ereignis.
		<p>
		TIC Info XML Element: EventDataQuantities.
		</p>
		
		@return der Wert von EreignisQuantitaet.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet
			> getEreignisQuantitaet() {
			return _ereignisQuantitaet;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getEreignisKategorie() != null) {
	                if (getEreignisKategorie().isZustand()) {
	                    datum.getUnscaledValue("EreignisKategorie").setText(getEreignisKategorie().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisKategorie").set(getEreignisKategorie().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEreignisCode() != null) {
	                if (getEreignisCode().isZustand()) {
	                    datum.getUnscaledValue("EreignisCode").setText(getEreignisCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisCode").set(getEreignisCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEmpfehlungsCode() != null) {
	                if (getEmpfehlungsCode().isZustand()) {
	                    datum.getUnscaledValue("EmpfehlungsCode").setText(getEmpfehlungsCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EmpfehlungsCode").set(getEmpfehlungsCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVorhersageCode() != null) {
	                if (getVorhersageCode().isZustand()) {
	                    datum.getUnscaledValue("VorhersageCode").setText(getVorhersageCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VorhersageCode").set(getVorhersageCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEreignisDauer() != null) {
	                if (getEreignisDauer().isZustand()) {
	                    datum.getUnscaledValue("EreignisDauer").setText(getEreignisDauer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EreignisDauer").set(getEreignisDauer().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayEreignisQuantitaet = datum.getArray("EreignisQuantität");
					arrayEreignisQuantitaet.setLength(getEreignisQuantitaet().size());
					for (int i = 0; i < arrayEreignisQuantitaet.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet
						 atl = getEreignisQuantitaet().get(i);
						atl.bean2Atl(arrayEreignisQuantitaet.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisKategorie").isState()) {
							setEreignisKategorie(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
							.getZustand(daten.getScaledValue("EreignisKategorie").getText()));
						} else {
						setEreignisKategorie(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
						(daten.
							getUnscaledValue
						("EreignisKategorie").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisCode").isState()) {
							setEreignisCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
							.getZustand(daten.getScaledValue("EreignisCode").getText()));
						} else {
						setEreignisCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
						(daten.
							getUnscaledValue
						("EreignisCode").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EmpfehlungsCode").isState()) {
							setEmpfehlungsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
							.getZustand(daten.getScaledValue("EmpfehlungsCode").getText()));
						} else {
						setEmpfehlungsCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
						(daten.
							getUnscaledValue
						("EmpfehlungsCode").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VorhersageCode").isState()) {
							setVorhersageCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
							.getZustand(daten.getScaledValue("VorhersageCode").getText()));
						} else {
						setVorhersageCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
						(daten.
							getUnscaledValue
						("VorhersageCode").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EreignisDauer").isState()) {
							setEreignisDauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
							.getZustand(daten.getScaledValue("EreignisDauer").getText()));
						} else {
						setEreignisDauer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
						(daten.
							getUnscaledValue
						("EreignisDauer").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayEreignisQuantitaet = daten.getArray("EreignisQuantität");
					for (int i = 0; i < arrayEreignisQuantitaet.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignisQuantitaet
						 ();
						atl.atl2Bean(arrayEreignisQuantitaet.getItem(i), factory);
						getEreignisQuantitaet().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsEreignisDaten clone() {
		AtlRdsEreignisDaten klon = new AtlRdsEreignisDaten();
		
						klon.setEreignisKategorie(getEreignisKategorie());
						klon.setEreignisCode(getEreignisCode());
						klon.setEmpfehlungsCode(getEmpfehlungsCode());
						klon.setVorhersageCode(getVorhersageCode());
						klon.setEreignisDauer(getEreignisDauer());
					klon._ereignisQuantitaet = getEreignisQuantitaet().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
