/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu den Locationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsLocationDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation
			> _rDSLocation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation
			>(0, true);
			@Defaultwert(wert = "TMC Location")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationFormat
			 _rDSLocationFormat
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 _locationExtent
			;
			@Defaultwert(wert = "erste Feldposition ist primäre Location und letzte Feldposition ist sekundäre Location")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationMethode
			 _locationMethode
			;
			@Defaultwert(wert = "Positiv")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung
			 _tMCRichtung
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
			 _locationPrimaerEntfernung
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
			 _locationSekundaerEntfernung
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationVorLocation
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 _locationNachLocation
			;
			@Defaultwert(wert = "Segment")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationKategorie
			 _locationKategorie
			;
			@Defaultwert(wert = "unbekannt")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationRichtungTextID
			 _locationRichtungTextID
			;
	
		/**
		Liste der Locationen.
		<p>
		&lt;absatz&gt;Das erste Element des Feldes ist die primäre Location. Das letzte Element des Feldes ist die sekundäre Location. &lt;&#47;absatz&gt;
								&lt;absatz&gt;Alle weiteren liegen entsprechend ihrer Platzierung an der Straße dazwischen.&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von RDSLocation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation
			> getRDSLocation() {
			return _rDSLocation;
		}
	
	
		/**
		Location-Format.
		<p>
		TIC Info XML Element: LocationFormat, Format des referenzierten Location-Systems.
		</p>
		
		@return der Wert von RDSLocationFormat.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationFormat
			 getRDSLocationFormat() {
			return _rDSLocationFormat;
		}
	
		/**
		Location-Format.
		<p>
		TIC Info XML Element: LocationFormat, Format des referenzierten Location-Systems.
		</p>
		
		@param _rDSLocationFormat der neue Wert von RDSLocationFormat.
		*/
		public void setRDSLocationFormat(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationFormat
		 _rDSLocationFormat) {
			this._rDSLocationFormat = _rDSLocationFormat;
		}
	
		/**
		Ausdehnung der primären Location.
		<p>
		TIC Info XML Element: LocationExtent, Ausdehnung der primären Location, entspricht der Schrittweite innerhalb der LCL ausgehend von der primären Location.
		</p>
		
		@return der Wert von LocationExtent.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 getLocationExtent() {
			return _locationExtent;
		}
	
		/**
		Ausdehnung der primären Location.
		<p>
		TIC Info XML Element: LocationExtent, Ausdehnung der primären Location, entspricht der Schrittweite innerhalb der LCL ausgehend von der primären Location.
		</p>
		
		@param _locationExtent der neue Wert von LocationExtent.
		*/
		public void setLocationExtent(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
		 _locationExtent) {
			this._locationExtent = _locationExtent;
		}
	
		/**
		Location-Kodierung.
		<p>
		TIC Info XML Element: LocationMethod, die Kodierungsmethode der Location.
		</p>
		
		@return der Wert von LocationMethode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationMethode
			 getLocationMethode() {
			return _locationMethode;
		}
	
		/**
		Location-Kodierung.
		<p>
		TIC Info XML Element: LocationMethod, die Kodierungsmethode der Location.
		</p>
		
		@param _locationMethode der neue Wert von LocationMethode.
		*/
		public void setLocationMethode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationMethode
		 _locationMethode) {
			this._locationMethode = _locationMethode;
		}
	
		/**
		TMC-Richtung.
		<p>
		TIC Info XML Element: LocationDirection, bezeichnet die TMC-Richtung der Location.
		</p>
		
		@return der Wert von TMCRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung
			 getTMCRichtung() {
			return _tMCRichtung;
		}
	
		/**
		TMC-Richtung.
		<p>
		TIC Info XML Element: LocationDirection, bezeichnet die TMC-Richtung der Location.
		</p>
		
		@param _tMCRichtung der neue Wert von TMCRichtung.
		*/
		public void setTMCRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung
		 _tMCRichtung) {
			this._tMCRichtung = _tMCRichtung;
		}
	
		/**
		Entfernung zur primären Location in m.
		<p>
		TIC Info XML Element: LocationPrimaryDistance.
		</p>
		
		@return der Wert von LocationPrimaerEntfernung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
			 getLocationPrimaerEntfernung() {
			return _locationPrimaerEntfernung;
		}
	
		/**
		Entfernung zur primären Location in m.
		<p>
		TIC Info XML Element: LocationPrimaryDistance.
		</p>
		
		@param _locationPrimaerEntfernung der neue Wert von LocationPrimaerEntfernung.
		*/
		public void setLocationPrimaerEntfernung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
		 _locationPrimaerEntfernung) {
			this._locationPrimaerEntfernung = _locationPrimaerEntfernung;
		}
	
		/**
		Entfernung zur sekundären Location in m.
		<p>
		TIC Info XML Element: LocationSecondaryDistance.
		</p>
		
		@return der Wert von LocationSekundaerEntfernung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
			 getLocationSekundaerEntfernung() {
			return _locationSekundaerEntfernung;
		}
	
		/**
		Entfernung zur sekundären Location in m.
		<p>
		TIC Info XML Element: LocationSecondaryDistance.
		</p>
		
		@param _locationSekundaerEntfernung der neue Wert von LocationSekundaerEntfernung.
		*/
		public void setLocationSekundaerEntfernung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
		 _locationSekundaerEntfernung) {
			this._locationSekundaerEntfernung = _locationSekundaerEntfernung;
		}
	
		/**
		Locationcode Vorgänger der sekundären Location.
		<p>
		TIC Info XML Element: LocationPreLocation.
		</p>
		
		@return der Wert von LocationVorLocation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationVorLocation() {
			return _locationVorLocation;
		}
	
		/**
		Locationcode Vorgänger der sekundären Location.
		<p>
		TIC Info XML Element: LocationPreLocation.
		</p>
		
		@param _locationVorLocation der neue Wert von LocationVorLocation.
		*/
		public void setLocationVorLocation(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationVorLocation) {
			this._locationVorLocation = _locationVorLocation;
		}
	
		/**
		Locationcode Nachfolger der primären Location.
		<p>
		TIC Info XML Element: LocationPostLocation.
		</p>
		
		@return der Wert von LocationNachLocation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
			 getLocationNachLocation() {
			return _locationNachLocation;
		}
	
		/**
		Locationcode Nachfolger der primären Location.
		<p>
		TIC Info XML Element: LocationPostLocation.
		</p>
		
		@param _locationNachLocation der neue Wert von LocationNachLocation.
		*/
		public void setLocationNachLocation(de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
		 _locationNachLocation) {
			this._locationNachLocation = _locationNachLocation;
		}
	
		/**
		Kategorie der Location.
		<p>
		TIC Info XML Element: LocationPreLocation, Kategorie der Location (nur bei LocationFormat = TIC Location).
		</p>
		
		@return der Wert von LocationKategorie.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationKategorie
			 getLocationKategorie() {
			return _locationKategorie;
		}
	
		/**
		Kategorie der Location.
		<p>
		TIC Info XML Element: LocationPreLocation, Kategorie der Location (nur bei LocationFormat = TIC Location).
		</p>
		
		@param _locationKategorie der neue Wert von LocationKategorie.
		*/
		public void setLocationKategorie(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationKategorie
		 _locationKategorie) {
			this._locationKategorie = _locationKategorie;
		}
	
		/**
		Text zur Beschreibung der Richtung einer Strasse oder eines Segmentes.
		<p>
		TIC Info XML Element: LocationDirectionTextID, Zuordnung einer ID zu einem Richtungstext.
		</p>
		
		@return der Wert von LocationRichtungTextID.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationRichtungTextID
			 getLocationRichtungTextID() {
			return _locationRichtungTextID;
		}
	
		/**
		Text zur Beschreibung der Richtung einer Strasse oder eines Segmentes.
		<p>
		TIC Info XML Element: LocationDirectionTextID, Zuordnung einer ID zu einem Richtungstext.
		</p>
		
		@param _locationRichtungTextID der neue Wert von LocationRichtungTextID.
		*/
		public void setLocationRichtungTextID(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationRichtungTextID
		 _locationRichtungTextID) {
			this._locationRichtungTextID = _locationRichtungTextID;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayRDSLocation = datum.getArray("RDSLocation");
					arrayRDSLocation.setLength(getRDSLocation().size());
					for (int i = 0; i < arrayRDSLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation
						 atl = getRDSLocation().get(i);
						atl.bean2Atl(arrayRDSLocation.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getRDSLocationFormat() != null) {
	                if (getRDSLocationFormat().isZustand()) {
	                    datum.getUnscaledValue("RDSLocationFormat").setText(getRDSLocationFormat().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("RDSLocationFormat").set(getRDSLocationFormat().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationExtent() != null) {
	                if (getLocationExtent().isZustand()) {
	                    datum.getUnscaledValue("LocationExtent").setText(getLocationExtent().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationExtent").set(getLocationExtent().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationMethode() != null) {
	                if (getLocationMethode().isZustand()) {
	                    datum.getUnscaledValue("LocationMethode").setText(getLocationMethode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationMethode").set(getLocationMethode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTMCRichtung() != null) {
	                if (getTMCRichtung().isZustand()) {
	                    datum.getUnscaledValue("TMCRichtung").setText(getTMCRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TMCRichtung").set(getTMCRichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationPrimaerEntfernung() != null) {
	                if (getLocationPrimaerEntfernung().isZustand()) {
	                    datum.getUnscaledValue("LocationPrimärEntfernung").setText(getLocationPrimaerEntfernung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationPrimärEntfernung").set(getLocationPrimaerEntfernung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationSekundaerEntfernung() != null) {
	                if (getLocationSekundaerEntfernung().isZustand()) {
	                    datum.getUnscaledValue("LocationSekundärEntfernung").setText(getLocationSekundaerEntfernung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationSekundärEntfernung").set(getLocationSekundaerEntfernung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationVorLocation() != null) {
	                if (getLocationVorLocation().isZustand()) {
	                    datum.getUnscaledValue("LocationVorLocation").setText(getLocationVorLocation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationVorLocation").set(getLocationVorLocation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationNachLocation() != null) {
	                if (getLocationNachLocation().isZustand()) {
	                    datum.getUnscaledValue("LocationNachLocation").setText(getLocationNachLocation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationNachLocation").set(getLocationNachLocation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationKategorie() != null) {
	                if (getLocationKategorie().isZustand()) {
	                    datum.getUnscaledValue("LocationKategorie").setText(getLocationKategorie().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationKategorie").set(getLocationKategorie().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLocationRichtungTextID() != null) {
	                if (getLocationRichtungTextID().isZustand()) {
	                    datum.getUnscaledValue("LocationRichtungTextID").setText(getLocationRichtungTextID().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationRichtungTextID").set(getLocationRichtungTextID().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayRDSLocation = daten.getArray("RDSLocation");
					for (int i = 0; i < arrayRDSLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocation
						 ();
						atl.atl2Bean(arrayRDSLocation.getItem(i), factory);
						getRDSLocation().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RDSLocationFormat").isState()) {
							setRDSLocationFormat(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationFormat
							.getZustand(daten.getScaledValue("RDSLocationFormat").getText()));
						} else {
						setRDSLocationFormat(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationFormat
						(daten.
							getUnscaledValue
						("RDSLocationFormat").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setLocationExtent(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
						(daten.
							getUnscaledValue
						("LocationExtent").
								intValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LocationMethode").isState()) {
							setLocationMethode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationMethode
							.getZustand(daten.getScaledValue("LocationMethode").getText()));
						} else {
						setLocationMethode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationMethode
						(daten.
							getUnscaledValue
						("LocationMethode").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TMCRichtung").isState()) {
							setTMCRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung
							.getZustand(daten.getScaledValue("TMCRichtung").getText()));
						} else {
						setTMCRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsTMCRichtung
						(daten.
							getUnscaledValue
						("TMCRichtung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setLocationPrimaerEntfernung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
						(daten.
							getUnscaledValue
						("LocationPrimärEntfernung").
								longValue
						()));
				// GanzzahlAttributTyp
						setLocationSekundaerEntfernung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEntfernungMeter
						(daten.
							getUnscaledValue
						("LocationSekundärEntfernung").
								longValue
						()));
				// GanzzahlAttributTyp
						setLocationVorLocation(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationVorLocation").
								intValue
						()));
				// GanzzahlAttributTyp
						setLocationNachLocation(new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcLocationCode
						(daten.
							getUnscaledValue
						("LocationNachLocation").
								intValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LocationKategorie").isState()) {
							setLocationKategorie(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationKategorie
							.getZustand(daten.getScaledValue("LocationKategorie").getText()));
						} else {
						setLocationKategorie(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationKategorie
						(daten.
							getUnscaledValue
						("LocationKategorie").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LocationRichtungTextID").isState()) {
							setLocationRichtungTextID(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationRichtungTextID
							.getZustand(daten.getScaledValue("LocationRichtungTextID").getText()));
						} else {
						setLocationRichtungTextID(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationRichtungTextID
						(daten.
							getUnscaledValue
						("LocationRichtungTextID").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsLocationDaten clone() {
		AtlRdsLocationDaten klon = new AtlRdsLocationDaten();
		
					klon._rDSLocation = getRDSLocation().clone();
						klon.setRDSLocationFormat(getRDSLocationFormat());
						klon.setLocationExtent(getLocationExtent());
						klon.setLocationMethode(getLocationMethode());
						klon.setTMCRichtung(getTMCRichtung());
						klon.setLocationPrimaerEntfernung(getLocationPrimaerEntfernung());
						klon.setLocationSekundaerEntfernung(getLocationSekundaerEntfernung());
						klon.setLocationVorLocation(getLocationVorLocation());
						klon.setLocationNachLocation(getLocationNachLocation());
						klon.setLocationKategorie(getLocationKategorie());
						klon.setLocationRichtungTextID(getLocationRichtungTextID());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
