/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Koordinaten der Location.
<p>
Koordinaten im WGS 84 Format in Grad mit 10 mikroGrad Auflösung (1&#47;100000)
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRdsLocationKoordinaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 _rDSLocationKoordinateX
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 _rDSLocationKoordinateY
			;
	
		/**
		Länge.
		<p>
		TIC Info XML Element: LocationLocCoordinatesX.
		</p>
		
		@return der Wert von RDSLocationKoordinateX.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 getRDSLocationKoordinateX() {
			return _rDSLocationKoordinateX;
		}
	
		/**
		Länge.
		<p>
		TIC Info XML Element: LocationLocCoordinatesX.
		</p>
		
		@param _rDSLocationKoordinateX der neue Wert von RDSLocationKoordinateX.
		*/
		public void setRDSLocationKoordinateX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
		 _rDSLocationKoordinateX) {
			this._rDSLocationKoordinateX = _rDSLocationKoordinateX;
		}
	
		/**
		Breite.
		<p>
		TIC Info XML Element: LocationLocCoordinatesY.
		</p>
		
		@return der Wert von RDSLocationKoordinateY.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 getRDSLocationKoordinateY() {
			return _rDSLocationKoordinateY;
		}
	
		/**
		Breite.
		<p>
		TIC Info XML Element: LocationLocCoordinatesY.
		</p>
		
		@param _rDSLocationKoordinateY der neue Wert von RDSLocationKoordinateY.
		*/
		public void setRDSLocationKoordinateY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
		 _rDSLocationKoordinateY) {
			this._rDSLocationKoordinateY = _rDSLocationKoordinateY;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getRDSLocationKoordinateX() != null) {
	                if (getRDSLocationKoordinateX().isZustand()) {
	                    datum.getUnscaledValue("RDSLocationKoordinateX").setText(getRDSLocationKoordinateX().toString());
	                } else {
						datum.
						getScaledValue
	                	("RDSLocationKoordinateX").set(getRDSLocationKoordinateX().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRDSLocationKoordinateY() != null) {
	                if (getRDSLocationKoordinateY().isZustand()) {
	                    datum.getUnscaledValue("RDSLocationKoordinateY").setText(getRDSLocationKoordinateY().toString());
	                } else {
						datum.
						getScaledValue
	                	("RDSLocationKoordinateY").set(getRDSLocationKoordinateY().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RDSLocationKoordinateX").isState()) {
							setRDSLocationKoordinateX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
							.getZustand(daten.getScaledValue("RDSLocationKoordinateX").getText()));
						} else {
						setRDSLocationKoordinateX(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
						(daten.
							getScaledValue
						("RDSLocationKoordinateX").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RDSLocationKoordinateY").isState()) {
							setRDSLocationKoordinateY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
							.getZustand(daten.getScaledValue("RDSLocationKoordinateY").getText()));
						} else {
						setRDSLocationKoordinateY(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
						(daten.
							getScaledValue
						("RDSLocationKoordinateY").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsLocationKoordinaten clone() {
		AtlRdsLocationKoordinaten klon = new AtlRdsLocationKoordinaten();
		
						klon.setRDSLocationKoordinateX(getRDSLocationKoordinateX());
						klon.setRDSLocationKoordinateY(getRDSLocationKoordinateY());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
