/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zur benutzten Location-Tabelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsLocationTabelleInfo implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "undefiniert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelle
			 _locationTabelle
			;
			@Defaultwert(wert = "")
			private String
			 _locationTabelleVersion
			= new String
			()
			;
			@Defaultwert(wert = "TMC Location Tabelle")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelleTyp
			 _locationTabelleTyp
			;
			@Defaultwert(wert = "")
			private String
			 _locationTabelleName
			= new String
			()
			;
	
		/**
		RDS Location-Tabelle.
		<p>
		spezifiziert die zugrundeliegende Location-Tabelle.
		</p>
		
		@return der Wert von LocationTabelle.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelle
			 getLocationTabelle() {
			return _locationTabelle;
		}
	
		/**
		RDS Location-Tabelle.
		<p>
		spezifiziert die zugrundeliegende Location-Tabelle.
		</p>
		
		@param _locationTabelle der neue Wert von LocationTabelle.
		*/
		public void setLocationTabelle(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelle
		 _locationTabelle) {
			this._locationTabelle = _locationTabelle;
		}
	
		/**
		Version der Location-Tabelle.
		<p>
		TIC Info XML Element: LocationTableVersion.
		</p>
		
		@return der Wert von LocationTabelleVersion.
		*/
			public String
			 getLocationTabelleVersion() {
			return _locationTabelleVersion;
		}
	
		/**
		Version der Location-Tabelle.
		<p>
		TIC Info XML Element: LocationTableVersion.
		</p>
		
		@param _locationTabelleVersion der neue Wert von LocationTabelleVersion.
		*/
		public void setLocationTabelleVersion(String
		 _locationTabelleVersion) {
			if (_locationTabelleVersion.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationTabelleVersion = _locationTabelleVersion;
		}
	
		/**
		Typ der Location-Tabelle.
		<p>
		TIC Info XML Element: LocationTableType.
		</p>
		
		@return der Wert von LocationTabelleTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelleTyp
			 getLocationTabelleTyp() {
			return _locationTabelleTyp;
		}
	
		/**
		Typ der Location-Tabelle.
		<p>
		TIC Info XML Element: LocationTableType.
		</p>
		
		@param _locationTabelleTyp der neue Wert von LocationTabelleTyp.
		*/
		public void setLocationTabelleTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelleTyp
		 _locationTabelleTyp) {
			this._locationTabelleTyp = _locationTabelleTyp;
		}
	
		/**
		Name der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableName.
		</p>
		
		@return der Wert von LocationTabelleName.
		*/
			public String
			 getLocationTabelleName() {
			return _locationTabelleName;
		}
	
		/**
		Name der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableName.
		</p>
		
		@param _locationTabelleName der neue Wert von LocationTabelleName.
		*/
		public void setLocationTabelleName(String
		 _locationTabelleName) {
			if (_locationTabelleName.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationTabelleName = _locationTabelleName;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLocationTabelle() != null) {
	                if (getLocationTabelle().isZustand()) {
	                    datum.getUnscaledValue("LocationTabelle").setText(getLocationTabelle().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationTabelle").set(getLocationTabelle().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getLocationTabelleVersion() != null) {
					datum.getTextValue("LocationTabelleVersion").setText(getLocationTabelleVersion());
				}
				// GanzzahlAttributTyp
				if (getLocationTabelleTyp() != null) {
	                if (getLocationTabelleTyp().isZustand()) {
	                    datum.getUnscaledValue("LocationTabelleTyp").setText(getLocationTabelleTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LocationTabelleTyp").set(getLocationTabelleTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getLocationTabelleName() != null) {
					datum.getTextValue("LocationTabelleName").setText(getLocationTabelleName());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LocationTabelle").isState()) {
							setLocationTabelle(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelle
							.getZustand(daten.getScaledValue("LocationTabelle").getText()));
						} else {
						setLocationTabelle(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelle
						(daten.
							getUnscaledValue
						("LocationTabelle").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setLocationTabelleVersion(daten.getTextValue("LocationTabelleVersion").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LocationTabelleTyp").isState()) {
							setLocationTabelleTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelleTyp
							.getZustand(daten.getScaledValue("LocationTabelleTyp").getText()));
						} else {
						setLocationTabelleTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsLocationTabelleTyp
						(daten.
							getUnscaledValue
						("LocationTabelleTyp").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setLocationTabelleName(daten.getTextValue("LocationTabelleName").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsLocationTabelleInfo clone() {
		AtlRdsLocationTabelleInfo klon = new AtlRdsLocationTabelleInfo();
		
						klon.setLocationTabelle(getLocationTabelle());
						klon.setLocationTabelleVersion(getLocationTabelleVersion());
						klon.setLocationTabelleTyp(getLocationTabelleTyp());
						klon.setLocationTabelleName(getLocationTabelleName());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
