/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
RDS-Nachrichten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsNachrichten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten
			> _nachrichtenDaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten
			>(0, true);
			@Defaultwert(wert = "deutsch (Standard)")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
			 _nachrichtenSprache
			;
	
		/**
		Nachrichtendaten.
		<p>
		
		</p>
		
		@return der Wert von NachrichtenDaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten
			> getNachrichtenDaten() {
			return _nachrichtenDaten;
		}
	
	
		/**
		Sprachkennung der Nachrichtentexte.
		<p>
		TIC Info XML Element: MessageLangID,  spezifiziert die Sprache der Nachrichten entsprechend TIC Info Specification: Anhang 'Language Identifier'
		</p>
		
		@return der Wert von NachrichtenSprache.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
			 getNachrichtenSprache() {
			return _nachrichtenSprache;
		}
	
		/**
		Sprachkennung der Nachrichtentexte.
		<p>
		TIC Info XML Element: MessageLangID,  spezifiziert die Sprache der Nachrichten entsprechend TIC Info Specification: Anhang 'Language Identifier'
		</p>
		
		@param _nachrichtenSprache der neue Wert von NachrichtenSprache.
		*/
		public void setNachrichtenSprache(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
		 _nachrichtenSprache) {
			this._nachrichtenSprache = _nachrichtenSprache;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayNachrichtenDaten = datum.getArray("NachrichtenDaten");
					arrayNachrichtenDaten.setLength(getNachrichtenDaten().size());
					for (int i = 0; i < arrayNachrichtenDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten
						 atl = getNachrichtenDaten().get(i);
						atl.bean2Atl(arrayNachrichtenDaten.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getNachrichtenSprache() != null) {
	                if (getNachrichtenSprache().isZustand()) {
	                    datum.getUnscaledValue("NachrichtenSprache").setText(getNachrichtenSprache().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NachrichtenSprache").set(getNachrichtenSprache().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayNachrichtenDaten = daten.getArray("NachrichtenDaten");
					for (int i = 0; i < arrayNachrichtenDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichtenDaten
						 ();
						atl.atl2Bean(arrayNachrichtenDaten.getItem(i), factory);
						getNachrichtenDaten().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NachrichtenSprache").isState()) {
							setNachrichtenSprache(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
							.getZustand(daten.getScaledValue("NachrichtenSprache").getText()));
						} else {
						setNachrichtenSprache(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
						(daten.
							getUnscaledValue
						("NachrichtenSprache").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsNachrichten clone() {
		AtlRdsNachrichten klon = new AtlRdsNachrichten();
		
					klon._nachrichtenDaten = getNachrichtenDaten().clone();
						klon.setNachrichtenSprache(getNachrichtenSprache());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
