/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Nachrichtendaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRdsNachrichtenDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenKlasse
			 _nachrichtenKlasse
			;
			private String
			 _nachrichtenText
			= new String
			()
			;
	
		/**
		Klassifikation des Textes.
		<p>
		TIC Info XML Element: MessageDataClass, klassifiziert den Text.
		</p>
		
		@return der Wert von NachrichtenKlasse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenKlasse
			 getNachrichtenKlasse() {
			return _nachrichtenKlasse;
		}
	
		/**
		Klassifikation des Textes.
		<p>
		TIC Info XML Element: MessageDataClass, klassifiziert den Text.
		</p>
		
		@param _nachrichtenKlasse der neue Wert von NachrichtenKlasse.
		*/
		public void setNachrichtenKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenKlasse
		 _nachrichtenKlasse) {
			this._nachrichtenKlasse = _nachrichtenKlasse;
		}
	
		/**
		Text der Nachricht.
		<p>
		TIC Info XML Element: MessageDataText, Text.
		</p>
		
		@return der Wert von NachrichtenText.
		*/
			public String
			 getNachrichtenText() {
			return _nachrichtenText;
		}
	
		/**
		Text der Nachricht.
		<p>
		TIC Info XML Element: MessageDataText, Text.
		</p>
		
		@param _nachrichtenText der neue Wert von NachrichtenText.
		*/
		public void setNachrichtenText(String
		 _nachrichtenText) {
			if (_nachrichtenText.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._nachrichtenText = _nachrichtenText;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getNachrichtenKlasse() != null) {
	                if (getNachrichtenKlasse().isZustand()) {
	                    datum.getUnscaledValue("NachrichtenKlasse").setText(getNachrichtenKlasse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NachrichtenKlasse").set(getNachrichtenKlasse().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getNachrichtenText() != null) {
					datum.getTextValue("NachrichtenText").setText(getNachrichtenText());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NachrichtenKlasse").isState()) {
							setNachrichtenKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenKlasse
							.getZustand(daten.getScaledValue("NachrichtenKlasse").getText()));
						} else {
						setNachrichtenKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenKlasse
						(daten.
							getUnscaledValue
						("NachrichtenKlasse").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setNachrichtenText(daten.getTextValue("NachrichtenText").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsNachrichtenDaten clone() {
		AtlRdsNachrichtenDaten klon = new AtlRdsNachrichtenDaten();
		
						klon.setNachrichtenKlasse(getNachrichtenKlasse());
						klon.setNachrichtenText(getNachrichtenText());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
