/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten einer Version der RDS-Meldung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsVersion implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _versionGUID
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerwaltung
			 _verwaltungsInformationen
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerwaltung
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerkehr
			 _verkehrsInformationen
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerkehr
			()
			;
	
		/**
		Identifikator der Version.
		<p>
		TIC Info XML Element: VersionGUID, globaler eindeutiger Identifikator der Version.
		</p>
		
		@return der Wert von VersionGUID.
		*/
			public String
			 getVersionGUID() {
			return _versionGUID;
		}
	
		/**
		Identifikator der Version.
		<p>
		TIC Info XML Element: VersionGUID, globaler eindeutiger Identifikator der Version.
		</p>
		
		@param _versionGUID der neue Wert von VersionGUID.
		*/
		public void setVersionGUID(String
		 _versionGUID) {
			if (_versionGUID.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._versionGUID = _versionGUID;
		}
	
		/**
		Verwaltungsinformationen der Version.
		<p>
		TIC Info XML Element: Management, enthält alle Verwaltungsinformationen zur Version.
		</p>
		
		@return der Wert von VerwaltungsInformationen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerwaltung
			 getVerwaltungsInformationen() {
			return _verwaltungsInformationen;
		}
	
		/**
		Verwaltungsinformationen der Version.
		<p>
		TIC Info XML Element: Management, enthält alle Verwaltungsinformationen zur Version.
		</p>
		
		@param _verwaltungsInformationen der neue Wert von VerwaltungsInformationen.
		*/
		public void setVerwaltungsInformationen(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerwaltung
		 _verwaltungsInformationen) {
			this._verwaltungsInformationen = _verwaltungsInformationen;
		}
	
		/**
		Verkehrsinformationen der Version.
		<p>
		TIC Info XML Element: Traffic, enthält alle Verkehrsinformationen zur Version.
		</p>
		
		@return der Wert von VerkehrsInformationen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerkehr
			 getVerkehrsInformationen() {
			return _verkehrsInformationen;
		}
	
		/**
		Verkehrsinformationen der Version.
		<p>
		TIC Info XML Element: Traffic, enthält alle Verkehrsinformationen zur Version.
		</p>
		
		@param _verkehrsInformationen der neue Wert von VerkehrsInformationen.
		*/
		public void setVerkehrsInformationen(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerkehr
		 _verkehrsInformationen) {
			this._verkehrsInformationen = _verkehrsInformationen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVersionGUID() != null) {
					datum.getTextValue("VersionGUID").setText(getVersionGUID());
				}
				// AttributListenDefinition
					getVerwaltungsInformationen().bean2Atl(datum.getItem("VerwaltungsInformationen"), factory);
				// AttributListenDefinition
					getVerkehrsInformationen().bean2Atl(datum.getItem("VerkehrsInformationen"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setVersionGUID(daten.getTextValue("VersionGUID").getText());
				// AttributListenDefinition
					getVerwaltungsInformationen().atl2Bean(daten.getItem("VerwaltungsInformationen"), factory);
				// AttributListenDefinition
					getVerkehrsInformationen().atl2Bean(daten.getItem("VerkehrsInformationen"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsVersion clone() {
		AtlRdsVersion klon = new AtlRdsVersion();
		
						klon.setVersionGUID(getVersionGUID());
						klon._verwaltungsInformationen = getVerwaltungsInformationen().clone();
						klon._verkehrsInformationen = getVerkehrsInformationen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
