/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ereignis-Kategorie.
<p>
&lt;absatz&gt;TIC Info XML Element: EventDataCategory, numerischer Wert der Ereignis-Kategorie&lt;&#47;absatz&gt;
					 	&lt;absatz&gt;1 - 31: Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section bzw. Spalte 'C')&lt;&#47;absatz&gt;
						&lt;absatz&gt;32- 39: Vorhersage-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section bzw. Spalte 'C')&lt;&#47;absatz&gt;
						&lt;absatz&gt;40 - 49: nicht benutzt&lt;&#47;absatz&gt;
						&lt;absatz&gt;50: spezielle Kategorie, kennzeichnet dieses Ereignis als eine Empfehlung (GEWI)&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class AttRdsEreignisKategorie extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_1_VERKEHRSLAGE = new AttRdsEreignisKategorie("Verkehrslage", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_2_ERWARTETE_VERKEHRSLAGE = new AttRdsEreignisKategorie("erwartete Verkehrslage", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_3_UNFAELLE = new AttRdsEreignisKategorie("Unfälle", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_4_VORFAELLE = new AttRdsEreignisKategorie("Vorfälle", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_5_STRASSEN_UND_FAHRBAHNSPERRUNGEN = new AttRdsEreignisKategorie("Straßen- und Fahrbahnsperrungen", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_6_FAHRBAHNBESCHRAENKUNGEN = new AttRdsEreignisKategorie("Fahrbahnbeschränkungen", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_7_BESCHRAENKUNGEN_DER_AUSFAHRT = new AttRdsEreignisKategorie("Beschränkungen der Ausfahrt", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_8_BESCHRAENKUNGEN_DER_EINFAHRT = new AttRdsEreignisKategorie("Beschränkungen der Einfahrt", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_9_VERKEHRSBESCHRAENKUNGEN = new AttRdsEreignisKategorie("Verkehrsbeschränkungen", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_10_INFORMATIONEN_FUER_FAHRGEMEINSCHAFTEN = new AttRdsEreignisKategorie("Informationen für Fahrgemeinschaften", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_11_BAUARBEITEN = new AttRdsEreignisKategorie("Bauarbeiten", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_12_BEHINDERUNGEN_AUF_DER_FAHRBAHN = new AttRdsEreignisKategorie("Behinderungen auf der Fahrbahn", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_13_GEFAEHRLICHE_SITUATIONEN = new AttRdsEreignisKategorie("Gefährliche Situationen", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_14_STRASSENZUSTAND = new AttRdsEreignisKategorie("Straßenzustand", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_15_TEMPERATUREN = new AttRdsEreignisKategorie("Temperaturen", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_16_NIEDERSCHLAG_UND_SICHTBEHINDERUNGEN = new AttRdsEreignisKategorie("Niederschlag und Sichtbehinderungen", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_17_WIND_UND_LUFTQUALITAET = new AttRdsEreignisKategorie("Wind und Luftqualität", 		Byte
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_18_VERANSTALTUNGEN = new AttRdsEreignisKategorie("Veranstaltungen", 		Byte
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_19_SICHERHEITSVORFAELLE = new AttRdsEreignisKategorie("Sicherheitsvorfälle", 		Byte
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_20_ZEITVERLUSTE = new AttRdsEreignisKategorie("Zeitverluste", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_21_AUSFAELLE = new AttRdsEreignisKategorie("Ausfälle", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_22_REISEINFORMATION = new AttRdsEreignisKategorie("Reiseinformation", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_23_GEFAEHRLICHE_FAHRZEUGE = new AttRdsEreignisKategorie("Gefährliche Fahrzeuge", 		Byte
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_24_AUSSERGEWOEHNLICHE_LADUNGEN_UND_FAHRZEUGE = new AttRdsEreignisKategorie("Außergewöhnliche Ladungen und Fahrzeuge", 		Byte
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_25_STOERUNGEN_AN_LICHTSIGNALANLAGEN_UND_SONSTIGEN_STRASSENAUSRUESTUNGEN = new AttRdsEreignisKategorie("Störungen an Lichtsignalanlagen und sonstigen Straßenausrüstungen", 		Byte
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_26_BESCHRAENKUNGEN_DER_FAHRZEUGMASSE_UND_GEWICHTE = new AttRdsEreignisKategorie("Beschränkungen der Fahrzeugmaße und -gewichte", 		Byte
	.valueOf("26"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_27_PARKREGELUNGEN = new AttRdsEreignisKategorie("Parkregelungen", 		Byte
	.valueOf("27"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_28_PARKEN = new AttRdsEreignisKategorie("Parken", 		Byte
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_29_INFORMATION = new AttRdsEreignisKategorie("Information", 		Byte
	.valueOf("29"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_30_SERVICE_MELDUNG = new AttRdsEreignisKategorie("Service-Meldung", 		Byte
	.valueOf("30"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_31_SPEZIELLE_MELDUNG = new AttRdsEreignisKategorie("spezielle Meldung", 		Byte
	.valueOf("31"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_32_VORHERSAGE_VERKEHRSLAGE = new AttRdsEreignisKategorie("Vorhersage Verkehrslage", 		Byte
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_33_VORHERSAGE_WETTER = new AttRdsEreignisKategorie("Vorhersage Wetter", 		Byte
	.valueOf("33"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_34_VORHERSAGE_STRASSENZUSTAND = new AttRdsEreignisKategorie("Vorhersage Straßenzustand", 		Byte
	.valueOf("34"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_35_VORHERSAGE_LUFTQUALITAET = new AttRdsEreignisKategorie("Vorhersage Luftqualität", 		Byte
	.valueOf("35"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_36_VORHERSAGE_WIND = new AttRdsEreignisKategorie("Vorhersage Wind", 		Byte
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_37_VORHERSAGE_TEMPERATUREN = new AttRdsEreignisKategorie("Vorhersage Temperaturen", 		Byte
	.valueOf("37"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_38_VORHERSAGE_ZEITVERLUSTE = new AttRdsEreignisKategorie("Vorhersage Zeitverluste", 		Byte
	.valueOf("38"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_39_VORHERSAGE_AUSFAELLE = new AttRdsEreignisKategorie("Vorhersage Ausfälle", 		Byte
	.valueOf("39"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisKategorie ZUSTAND_50_EMPFEHLUNG = new AttRdsEreignisKategorie("Empfehlung", 		Byte
	.valueOf("50"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsEreignisKategorie getZustand(final 		Byte
	 value) {
		for (AttRdsEreignisKategorie e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsEreignisKategorie getZustand(final String value) {
		for (AttRdsEreignisKategorie e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsEreignisKategorie> getZustaende() {
		List<AttRdsEreignisKategorie> list = new ArrayList<AttRdsEreignisKategorie>();
		list.add(ZUSTAND_1_VERKEHRSLAGE);
		list.add(ZUSTAND_2_ERWARTETE_VERKEHRSLAGE);
		list.add(ZUSTAND_3_UNFAELLE);
		list.add(ZUSTAND_4_VORFAELLE);
		list.add(ZUSTAND_5_STRASSEN_UND_FAHRBAHNSPERRUNGEN);
		list.add(ZUSTAND_6_FAHRBAHNBESCHRAENKUNGEN);
		list.add(ZUSTAND_7_BESCHRAENKUNGEN_DER_AUSFAHRT);
		list.add(ZUSTAND_8_BESCHRAENKUNGEN_DER_EINFAHRT);
		list.add(ZUSTAND_9_VERKEHRSBESCHRAENKUNGEN);
		list.add(ZUSTAND_10_INFORMATIONEN_FUER_FAHRGEMEINSCHAFTEN);
		list.add(ZUSTAND_11_BAUARBEITEN);
		list.add(ZUSTAND_12_BEHINDERUNGEN_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_13_GEFAEHRLICHE_SITUATIONEN);
		list.add(ZUSTAND_14_STRASSENZUSTAND);
		list.add(ZUSTAND_15_TEMPERATUREN);
		list.add(ZUSTAND_16_NIEDERSCHLAG_UND_SICHTBEHINDERUNGEN);
		list.add(ZUSTAND_17_WIND_UND_LUFTQUALITAET);
		list.add(ZUSTAND_18_VERANSTALTUNGEN);
		list.add(ZUSTAND_19_SICHERHEITSVORFAELLE);
		list.add(ZUSTAND_20_ZEITVERLUSTE);
		list.add(ZUSTAND_21_AUSFAELLE);
		list.add(ZUSTAND_22_REISEINFORMATION);
		list.add(ZUSTAND_23_GEFAEHRLICHE_FAHRZEUGE);
		list.add(ZUSTAND_24_AUSSERGEWOEHNLICHE_LADUNGEN_UND_FAHRZEUGE);
		list.add(ZUSTAND_25_STOERUNGEN_AN_LICHTSIGNALANLAGEN_UND_SONSTIGEN_STRASSENAUSRUESTUNGEN);
		list.add(ZUSTAND_26_BESCHRAENKUNGEN_DER_FAHRZEUGMASSE_UND_GEWICHTE);
		list.add(ZUSTAND_27_PARKREGELUNGEN);
		list.add(ZUSTAND_28_PARKEN);
		list.add(ZUSTAND_29_INFORMATION);
		list.add(ZUSTAND_30_SERVICE_MELDUNG);
		list.add(ZUSTAND_31_SPEZIELLE_MELDUNG);
		list.add(ZUSTAND_32_VORHERSAGE_VERKEHRSLAGE);
		list.add(ZUSTAND_33_VORHERSAGE_WETTER);
		list.add(ZUSTAND_34_VORHERSAGE_STRASSENZUSTAND);
		list.add(ZUSTAND_35_VORHERSAGE_LUFTQUALITAET);
		list.add(ZUSTAND_36_VORHERSAGE_WIND);
		list.add(ZUSTAND_37_VORHERSAGE_TEMPERATUREN);
		list.add(ZUSTAND_38_VORHERSAGE_ZEITVERLUSTE);
		list.add(ZUSTAND_39_VORHERSAGE_AUSFAELLE);
		list.add(ZUSTAND_50_EMPFEHLUNG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsEreignisKategorie(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRdsEreignisKategorie(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
