/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der Benutzung von 'ErinnerungsZeit' und 'ErinnerungsZeitOffset'.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttRdsErinnerungsTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsErinnerungsTyp ZUSTAND_0_KEINE_ERINNERUNG_ERINNERUNGSZEIT_WIRD_IGNORIERT_ = new AttRdsErinnerungsTyp("Keine Erinnerung. ErinnerungsZeit wird ignoriert.", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsErinnerungsTyp ZUSTAND_1_ERINNERUNGSZEITOFFSET_ENTHAELT_DEN_OFFSET_SEIT_AKTIVIERUNGSZEIT_ERINNERUNGSZEIT_AKTIVIERUNGSZEIT_ERINNERUNGSZEITOFFSET_ = new AttRdsErinnerungsTyp("ErinnerungsZeitOffset enthält den Offset seit AktivierungsZeit. ErinnerungsZeit = AktivierungsZeit + ErinnerungsZeitOffset.", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsErinnerungsTyp ZUSTAND_2_ERINNERUNGSZEITOFFSET_ENTHAELT_DEN_OFFSET_BIS_ABLAUFZEIT_ERINNERUNGSZEIT_ABLAUFZEIT_ERINNERUNGSZEITOFFSET_ = new AttRdsErinnerungsTyp("ErinnerungsZeitOffset enthält den Offset bis AblaufZeit. ErinnerungsZeit = AblaufZeit - ErinnerungsZeitOffset.", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsErinnerungsTyp ZUSTAND_3_ERINNERUNGSZEIT_ENTHAELT_DEN_ABSOLUTEN_ZEITPUNKT_ERINNERUNGSZEITOFFSET_WIRD_IGNORIERT_ = new AttRdsErinnerungsTyp("ErinnerungsZeit enthält den absoluten Zeitpunkt. ErinnerungsZeitOffset wird ignoriert.", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsErinnerungsTyp getZustand(final 		Byte
	 value) {
		for (AttRdsErinnerungsTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsErinnerungsTyp getZustand(final String value) {
		for (AttRdsErinnerungsTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsErinnerungsTyp> getZustaende() {
		List<AttRdsErinnerungsTyp> list = new ArrayList<AttRdsErinnerungsTyp>();
		list.add(ZUSTAND_0_KEINE_ERINNERUNG_ERINNERUNGSZEIT_WIRD_IGNORIERT_);
		list.add(ZUSTAND_1_ERINNERUNGSZEITOFFSET_ENTHAELT_DEN_OFFSET_SEIT_AKTIVIERUNGSZEIT_ERINNERUNGSZEIT_AKTIVIERUNGSZEIT_ERINNERUNGSZEITOFFSET_);
		list.add(ZUSTAND_2_ERINNERUNGSZEITOFFSET_ENTHAELT_DEN_OFFSET_BIS_ABLAUFZEIT_ERINNERUNGSZEIT_ABLAUFZEIT_ERINNERUNGSZEITOFFSET_);
		list.add(ZUSTAND_3_ERINNERUNGSZEIT_ENTHAELT_DEN_ABSOLUTEN_ZEITPUNKT_ERINNERUNGSZEITOFFSET_WIRD_IGNORIERT_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsErinnerungsTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRdsErinnerungsTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
