/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Text zur Beschreibung der Richtung einer Strasse oder eines Segmentes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttRdsLocationRichtungTextID extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_0_UNBEKANNT = new AttRdsLocationRichtungTextID("unbekannt", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_1_STADTEINWAERTS = new AttRdsLocationRichtungTextID("stadteinwärts", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_2_STADTAUSWAERTS = new AttRdsLocationRichtungTextID("stadtauswärts", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_3_NORD = new AttRdsLocationRichtungTextID("Nord", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_4_SUED = new AttRdsLocationRichtungTextID("Süd", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_5_OST = new AttRdsLocationRichtungTextID("Ost", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_6_WEST = new AttRdsLocationRichtungTextID("West", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_7_NORDOST = new AttRdsLocationRichtungTextID("Nordost", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_8_NORDWEST = new AttRdsLocationRichtungTextID("Nordwest", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_9_SUEDOST = new AttRdsLocationRichtungTextID("Südost", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationRichtungTextID ZUSTAND_10_SUEDWEST = new AttRdsLocationRichtungTextID("Südwest", 		Byte
	.valueOf("10"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsLocationRichtungTextID getZustand(final 		Byte
	 value) {
		for (AttRdsLocationRichtungTextID e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsLocationRichtungTextID getZustand(final String value) {
		for (AttRdsLocationRichtungTextID e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsLocationRichtungTextID> getZustaende() {
		List<AttRdsLocationRichtungTextID> list = new ArrayList<AttRdsLocationRichtungTextID>();
		list.add(ZUSTAND_0_UNBEKANNT);
		list.add(ZUSTAND_1_STADTEINWAERTS);
		list.add(ZUSTAND_2_STADTAUSWAERTS);
		list.add(ZUSTAND_3_NORD);
		list.add(ZUSTAND_4_SUED);
		list.add(ZUSTAND_5_OST);
		list.add(ZUSTAND_6_WEST);
		list.add(ZUSTAND_7_NORDOST);
		list.add(ZUSTAND_8_NORDWEST);
		list.add(ZUSTAND_9_SUEDOST);
		list.add(ZUSTAND_10_SUEDWEST);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsLocationRichtungTextID(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRdsLocationRichtungTextID(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
