/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Location Tabelle.
<p>
&lt;absatz&gt;Die Elemente 'LocationTableCountryCode' und  'LocationTableNumber' der TIC-Spezifikation werden wie folgt  auf die Tabelle nach prEN ISO 14819-3 Annex B abgebildet:&lt;&#47;absatz&gt;
						&lt;absatz&gt;Der Wert dieses Aufzählungstyps ist eine sechsstellige Zahl der Form CCCTTT mit CCC gleich Landeskennung (Country) aus  TIC-Info-Element 'LocationTableCountryCode', und TTT gleich Tabelle (Table) aus TIC-Info-Element 'LocationTableNumber  jeweils mit führenden Nullen.&lt;&#47;absatz&gt;
						&lt;absatz&gt;Entsprechend prEN ISO 14819-3 Annex B sind mehrere Tabellen pro Landeskennung möglich.&lt;&#47;absatz&gt;
						&lt;absatz&gt;Beispiel für die LCL der BASt:&lt;&#47;absatz&gt;
						&lt;absatz&gt;LocationTableCountryCode = 13  -&gt; CCC=013&lt;&#47;absatz&gt;
						&lt;absatz&gt;LocationTableNumber = 01 -&gt; TTT = 001&lt;&#47;absatz&gt;
						&lt;absatz&gt;Wert: 013001&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AttRdsLocationTabelle extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_0_UNDEFINIERT = new AttRdsLocationTabelle("undefiniert", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1001_DEUTSCHLAND_1_TABELLE_01 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 01", 		Short
	.valueOf("1001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1002_DEUTSCHLAND_1_TABELLE_02 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 02", 		Short
	.valueOf("1002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1003_DEUTSCHLAND_1_TABELLE_03 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 03", 		Short
	.valueOf("1003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1004_DEUTSCHLAND_1_TABELLE_04 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 04", 		Short
	.valueOf("1004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1005_DEUTSCHLAND_1_TABELLE_05 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 05", 		Short
	.valueOf("1005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1006_DEUTSCHLAND_1_TABELLE_06 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 06", 		Short
	.valueOf("1006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1007_DEUTSCHLAND_1_TABELLE_07 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 07", 		Short
	.valueOf("1007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1008_DEUTSCHLAND_1_TABELLE_08 = new AttRdsLocationTabelle("Deutschland(1), Tabelle 08", 		Short
	.valueOf("1008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1017_GRIECHENLAND_TABELLE_17 = new AttRdsLocationTabelle("Griechenland, Tabelle 17", 		Short
	.valueOf("1017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1018_GRIECHENLAND_TABELLE_18 = new AttRdsLocationTabelle("Griechenland, Tabelle 18", 		Short
	.valueOf("1018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1019_GRIECHENLAND_TABELLE_19 = new AttRdsLocationTabelle("Griechenland, Tabelle 19", 		Short
	.valueOf("1019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1020_GRIECHENLAND_TABELLE_20 = new AttRdsLocationTabelle("Griechenland, Tabelle 20", 		Short
	.valueOf("1020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1021_GRIECHENLAND_TABELLE_21 = new AttRdsLocationTabelle("Griechenland, Tabelle 21", 		Short
	.valueOf("1021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1022_GRIECHENLAND_TABELLE_22 = new AttRdsLocationTabelle("Griechenland, Tabelle 22", 		Short
	.valueOf("1022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1023_GRIECHENLAND_TABELLE_23 = new AttRdsLocationTabelle("Griechenland, Tabelle 23", 		Short
	.valueOf("1023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1024_GRIECHENLAND_TABELLE_24 = new AttRdsLocationTabelle("Griechenland, Tabelle 24", 		Short
	.valueOf("1024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1033_MAROKKO_TABELLE_33 = new AttRdsLocationTabelle("Marokko, Tabelle 33", 		Short
	.valueOf("1033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1034_MAROKKO_TABELLE_34 = new AttRdsLocationTabelle("Marokko, Tabelle 34", 		Short
	.valueOf("1034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1035_MAROKKO_TABELLE_35 = new AttRdsLocationTabelle("Marokko, Tabelle 35", 		Short
	.valueOf("1035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1036_MAROKKO_TABELLE_36 = new AttRdsLocationTabelle("Marokko, Tabelle 36", 		Short
	.valueOf("1036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1051_MOLDAVIEN_TABELLE_51 = new AttRdsLocationTabelle("Moldavien, Tabelle 51", 		Short
	.valueOf("1051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1052_MOLDAVIEN_TABELLE_52 = new AttRdsLocationTabelle("Moldavien, Tabelle 52", 		Short
	.valueOf("1052"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1059_MONTENEGRO_TABELLE_59 = new AttRdsLocationTabelle("Montenegro, Tabelle 59", 		Short
	.valueOf("1059"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_1060_MONTENEGRO_TABELLE_60 = new AttRdsLocationTabelle("Montenegro, Tabelle 60", 		Short
	.valueOf("1060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2001_ALGERIEN_TABELLE_01 = new AttRdsLocationTabelle("Algerien, Tabelle 01", 		Short
	.valueOf("2001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2002_ALGERIEN_TABELLE_02 = new AttRdsLocationTabelle("Algerien, Tabelle 02", 		Short
	.valueOf("2002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2003_ALGERIEN_TABELLE_03 = new AttRdsLocationTabelle("Algerien, Tabelle 03", 		Short
	.valueOf("2003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2004_ALGERIEN_TABELLE_04 = new AttRdsLocationTabelle("Algerien, Tabelle 04", 		Short
	.valueOf("2004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2017_ZYPERN_TABELLE_17 = new AttRdsLocationTabelle("Zypern, Tabelle 17", 		Short
	.valueOf("2017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2018_ZYPERN_TABELLE_18 = new AttRdsLocationTabelle("Zypern, Tabelle 18", 		Short
	.valueOf("2018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2025_TSCHECHISCHE_REPUBLIK_TABELLE_25 = new AttRdsLocationTabelle("Tschechische Republik, Tabelle 25", 		Short
	.valueOf("2025"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2026_TSCHECHISCHE_REPUBLIK_TABELLE_26 = new AttRdsLocationTabelle("Tschechische Republik, Tabelle 26", 		Short
	.valueOf("2026"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2027_TSCHECHISCHE_REPUBLIK_TABELLE_27 = new AttRdsLocationTabelle("Tschechische Republik, Tabelle 27", 		Short
	.valueOf("2027"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2028_TSCHECHISCHE_REPUBLIK_TABELLE_28 = new AttRdsLocationTabelle("Tschechische Republik, Tabelle 28", 		Short
	.valueOf("2028"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2041_IRLAND_TABELLE_41 = new AttRdsLocationTabelle("Irland, Tabelle 41", 		Short
	.valueOf("2041"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2042_IRLAND_TABELLE_42 = new AttRdsLocationTabelle("Irland, Tabelle 42", 		Short
	.valueOf("2042"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2043_IRLAND_TABELLE_43 = new AttRdsLocationTabelle("Irland, Tabelle 43", 		Short
	.valueOf("2043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2044_IRLAND_TABELLE_44 = new AttRdsLocationTabelle("Irland, Tabelle 44", 		Short
	.valueOf("2044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2045_IRLAND_TABELLE_45 = new AttRdsLocationTabelle("Irland, Tabelle 45", 		Short
	.valueOf("2045"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2046_IRLAND_TABELLE_46 = new AttRdsLocationTabelle("Irland, Tabelle 46", 		Short
	.valueOf("2046"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2047_IRLAND_TABELLE_47 = new AttRdsLocationTabelle("Irland, Tabelle 47", 		Short
	.valueOf("2047"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2048_IRLAND_TABELLE_48 = new AttRdsLocationTabelle("Irland, Tabelle 48", 		Short
	.valueOf("2048"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2059_ESTLAND_TABELLE_59 = new AttRdsLocationTabelle("Estland, Tabelle 59", 		Short
	.valueOf("2059"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_2060_ESTLAND_TABELLE_60 = new AttRdsLocationTabelle("Estland, Tabelle 60", 		Short
	.valueOf("2060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3001_ANDORRA_TABELLE_01 = new AttRdsLocationTabelle("Andorra, Tabelle 01", 		Short
	.valueOf("3001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3002_ANDORRA_TABELLE_02 = new AttRdsLocationTabelle("Andorra, Tabelle 02", 		Short
	.valueOf("3002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3005_POLEN_TABELLE_05 = new AttRdsLocationTabelle("Polen, Tabelle 05", 		Short
	.valueOf("3005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3006_POLEN_TABELLE_06 = new AttRdsLocationTabelle("Polen, Tabelle 06", 		Short
	.valueOf("3006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3007_POLEN_TABELLE_07 = new AttRdsLocationTabelle("Polen, Tabelle 07", 		Short
	.valueOf("3007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3008_POLEN_TABELLE_08 = new AttRdsLocationTabelle("Polen, Tabelle 08", 		Short
	.valueOf("3008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3021_SAN_MARINO_TABELLE_21 = new AttRdsLocationTabelle("San Marino, Tabelle 21", 		Short
	.valueOf("3021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3022_SAN_MARINO_TABELLE_22 = new AttRdsLocationTabelle("San Marino, Tabelle 22", 		Short
	.valueOf("3022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3033_TUERKEI_TABELLE_33 = new AttRdsLocationTabelle("Türkei, Tabelle 33", 		Short
	.valueOf("3033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3034_TUERKEI_TABELLE_34 = new AttRdsLocationTabelle("Türkei, Tabelle 34", 		Short
	.valueOf("3034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3035_TUERKEI_TABELLE_35 = new AttRdsLocationTabelle("Türkei, Tabelle 35", 		Short
	.valueOf("3035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3036_TUERKEI_TABELLE_36 = new AttRdsLocationTabelle("Türkei, Tabelle 36", 		Short
	.valueOf("3036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3037_TUERKEI_TABELLE_37 = new AttRdsLocationTabelle("Türkei, Tabelle 37", 		Short
	.valueOf("3037"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3038_TUERKEI_TABELLE_38 = new AttRdsLocationTabelle("Türkei, Tabelle 38", 		Short
	.valueOf("3038"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3039_TUERKEI_TABELLE_39 = new AttRdsLocationTabelle("Türkei, Tabelle 39", 		Short
	.valueOf("3039"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_3040_TUERKEI_TABELLE_40 = new AttRdsLocationTabelle("Türkei, Tabelle 40", 		Short
	.valueOf("3040"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4001_MAZEDONIEN_TABELLE_01 = new AttRdsLocationTabelle("Mazedonien, Tabelle 01", 		Short
	.valueOf("4001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4002_MAZEDONIEN_TABELLE_02 = new AttRdsLocationTabelle("Mazedonien, Tabelle 02", 		Short
	.valueOf("4002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4009_SCHWEIZ_TABELLE_09 = new AttRdsLocationTabelle("Schweiz, Tabelle 09", 		Short
	.valueOf("4009"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4010_SCHWEIZ_TABELLE_10 = new AttRdsLocationTabelle("Schweiz, Tabelle 10", 		Short
	.valueOf("4010"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4011_SCHWEIZ_TABELLE_11 = new AttRdsLocationTabelle("Schweiz, Tabelle 11", 		Short
	.valueOf("4011"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4012_SCHWEIZ_TABELLE_12 = new AttRdsLocationTabelle("Schweiz, Tabelle 12", 		Short
	.valueOf("4012"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4013_SCHWEIZ_TABELLE_13 = new AttRdsLocationTabelle("Schweiz, Tabelle 13", 		Short
	.valueOf("4013"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4014_SCHWEIZ_TABELLE_14 = new AttRdsLocationTabelle("Schweiz, Tabelle 14", 		Short
	.valueOf("4014"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4015_SCHWEIZ_TABELLE_15 = new AttRdsLocationTabelle("Schweiz, Tabelle 15", 		Short
	.valueOf("4015"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4016_SCHWEIZ_TABELLE_16 = new AttRdsLocationTabelle("Schweiz, Tabelle 16", 		Short
	.valueOf("4016"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4025_VATIKAN_TABELLE_25 = new AttRdsLocationTabelle("Vatikan, Tabelle 25", 		Short
	.valueOf("4025"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4026_VATIKAN_TABELLE_26 = new AttRdsLocationTabelle("Vatikan, Tabelle 26", 		Short
	.valueOf("4026"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4033_ISRAEL_TABELLE_33 = new AttRdsLocationTabelle("Israel, Tabelle 33", 		Short
	.valueOf("4033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4034_ISRAEL_TABELLE_34 = new AttRdsLocationTabelle("Israel, Tabelle 34", 		Short
	.valueOf("4034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4035_ISRAEL_TABELLE_35 = new AttRdsLocationTabelle("Israel, Tabelle 35", 		Short
	.valueOf("4035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_4036_ISRAEL_TABELLE_36 = new AttRdsLocationTabelle("Israel, Tabelle 36", 		Short
	.valueOf("4036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5001_ITALIEN_TABELLE_01 = new AttRdsLocationTabelle("Italien, Tabelle 01", 		Short
	.valueOf("5001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5002_ITALIEN_TABELLE_02 = new AttRdsLocationTabelle("Italien, Tabelle 02", 		Short
	.valueOf("5002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5003_ITALIEN_TABELLE_03 = new AttRdsLocationTabelle("Italien, Tabelle 03", 		Short
	.valueOf("5003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5004_ITALIEN_TABELLE_04 = new AttRdsLocationTabelle("Italien, Tabelle 04", 		Short
	.valueOf("5004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5005_ITALIEN_TABELLE_05 = new AttRdsLocationTabelle("Italien, Tabelle 05", 		Short
	.valueOf("5005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5006_ITALIEN_TABELLE_06 = new AttRdsLocationTabelle("Italien, Tabelle 06", 		Short
	.valueOf("5006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5007_ITALIEN_TABELLE_07 = new AttRdsLocationTabelle("Italien, Tabelle 07", 		Short
	.valueOf("5007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5008_ITALIEN_TABELLE_08 = new AttRdsLocationTabelle("Italien, Tabelle 08", 		Short
	.valueOf("5008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5009_ITALIEN_TABELLE_09 = new AttRdsLocationTabelle("Italien, Tabelle 09", 		Short
	.valueOf("5009"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5010_ITALIEN_TABELLE_10 = new AttRdsLocationTabelle("Italien, Tabelle 10", 		Short
	.valueOf("5010"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5011_ITALIEN_TABELLE_11 = new AttRdsLocationTabelle("Italien, Tabelle 11", 		Short
	.valueOf("5011"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5012_ITALIEN_TABELLE_12 = new AttRdsLocationTabelle("Italien, Tabelle 12", 		Short
	.valueOf("5012"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5013_ITALIEN_TABELLE_13 = new AttRdsLocationTabelle("Italien, Tabelle 13", 		Short
	.valueOf("5013"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5014_ITALIEN_TABELLE_14 = new AttRdsLocationTabelle("Italien, Tabelle 14", 		Short
	.valueOf("5014"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5015_ITALIEN_TABELLE_15 = new AttRdsLocationTabelle("Italien, Tabelle 15", 		Short
	.valueOf("5015"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5016_ITALIEN_TABELLE_16 = new AttRdsLocationTabelle("Italien, Tabelle 16", 		Short
	.valueOf("5016"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5033_JORDANIEN_TABELLE_33 = new AttRdsLocationTabelle("Jordanien, Tabelle 33", 		Short
	.valueOf("5033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5034_JORDANIEN_TABELLE_34 = new AttRdsLocationTabelle("Jordanien, Tabelle 34", 		Short
	.valueOf("5034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5035_JORDANIEN_TABELLE_35 = new AttRdsLocationTabelle("Jordanien, Tabelle 35", 		Short
	.valueOf("5035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5036_JORDANIEN_TABELLE_36 = new AttRdsLocationTabelle("Jordanien, Tabelle 36", 		Short
	.valueOf("5036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5051_SLOWAKEI_TABELLE_51 = new AttRdsLocationTabelle("Slowakei, Tabelle 51", 		Short
	.valueOf("5051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5052_SLOWAKEI_TABELLE_52 = new AttRdsLocationTabelle("Slowakei, Tabelle 52", 		Short
	.valueOf("5052"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5053_SLOWAKEI_TABELLE_53 = new AttRdsLocationTabelle("Slowakei, Tabelle 53", 		Short
	.valueOf("5053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_5054_SLOWAKEI_TABELLE_54 = new AttRdsLocationTabelle("Slowakei, Tabelle 54", 		Short
	.valueOf("5054"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6001_BELGIEN_TABELLE_01 = new AttRdsLocationTabelle("Belgien, Tabelle 01", 		Short
	.valueOf("6001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6002_BELGIEN_TABELLE_02 = new AttRdsLocationTabelle("Belgien, Tabelle 02", 		Short
	.valueOf("6002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6003_BELGIEN_TABELLE_03 = new AttRdsLocationTabelle("Belgien, Tabelle 03", 		Short
	.valueOf("6003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6004_BELGIEN_TABELLE_04 = new AttRdsLocationTabelle("Belgien, Tabelle 04", 		Short
	.valueOf("6004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6005_BELGIEN_TABELLE_05 = new AttRdsLocationTabelle("Belgien, Tabelle 05", 		Short
	.valueOf("6005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6006_BELGIEN_TABELLE_06 = new AttRdsLocationTabelle("Belgien, Tabelle 06", 		Short
	.valueOf("6006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6007_BELGIEN_TABELLE_07 = new AttRdsLocationTabelle("Belgien, Tabelle 07", 		Short
	.valueOf("6007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6008_BELGIEN_TABELLE_08 = new AttRdsLocationTabelle("Belgien, Tabelle 08", 		Short
	.valueOf("6008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6017_FINNLAND_TABELLE_17 = new AttRdsLocationTabelle("Finnland, Tabelle 17", 		Short
	.valueOf("6017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6018_FINNLAND_TABELLE_18 = new AttRdsLocationTabelle("Finnland, Tabelle 18", 		Short
	.valueOf("6018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6019_FINNLAND_TABELLE_19 = new AttRdsLocationTabelle("Finnland, Tabelle 19", 		Short
	.valueOf("6019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6020_FINNLAND_TABELLE_20 = new AttRdsLocationTabelle("Finnland, Tabelle 20", 		Short
	.valueOf("6020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6021_FINNLAND_TABELLE_21 = new AttRdsLocationTabelle("Finnland, Tabelle 21", 		Short
	.valueOf("6021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6022_FINNLAND_TABELLE_22 = new AttRdsLocationTabelle("Finnland, Tabelle 22", 		Short
	.valueOf("6022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6023_FINNLAND_TABELLE_23 = new AttRdsLocationTabelle("Finnland, Tabelle 23", 		Short
	.valueOf("6023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6024_FINNLAND_TABELLE_24 = new AttRdsLocationTabelle("Finnland, Tabelle 24", 		Short
	.valueOf("6024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6033_UKRAINE_TABELLE_33 = new AttRdsLocationTabelle("Ukraine, Tabelle 33", 		Short
	.valueOf("6033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6034_UKRAINE_TABELLE_34 = new AttRdsLocationTabelle("Ukraine, Tabelle 34", 		Short
	.valueOf("6034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6035_UKRAINE_TABELLE_35 = new AttRdsLocationTabelle("Ukraine, Tabelle 35", 		Short
	.valueOf("6035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6036_UKRAINE_TABELLE_36 = new AttRdsLocationTabelle("Ukraine, Tabelle 36", 		Short
	.valueOf("6036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6037_UKRAINE_TABELLE_37 = new AttRdsLocationTabelle("Ukraine, Tabelle 37", 		Short
	.valueOf("6037"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6038_UKRAINE_TABELLE_38 = new AttRdsLocationTabelle("Ukraine, Tabelle 38", 		Short
	.valueOf("6038"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6039_UKRAINE_TABELLE_39 = new AttRdsLocationTabelle("Ukraine, Tabelle 39", 		Short
	.valueOf("6039"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6040_UKRAINE_TABELLE_40 = new AttRdsLocationTabelle("Ukraine, Tabelle 40", 		Short
	.valueOf("6040"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6053_SYRIEN_TABELLE_53 = new AttRdsLocationTabelle("Syrien, Tabelle 53", 		Short
	.valueOf("6053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6054_SYRIEN_TABELLE_54 = new AttRdsLocationTabelle("Syrien, Tabelle 54", 		Short
	.valueOf("6054"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6055_SYRIEN_TABELLE_55 = new AttRdsLocationTabelle("Syrien, Tabelle 55", 		Short
	.valueOf("6055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_6056_SYRIEN_TABELLE_56 = new AttRdsLocationTabelle("Syrien, Tabelle 56", 		Short
	.valueOf("6056"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7001_LUXEMBURG_TABELLE_01 = new AttRdsLocationTabelle("Luxemburg, Tabelle 01", 		Short
	.valueOf("7001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7002_LUXEMBURG_TABELLE_02 = new AttRdsLocationTabelle("Luxemburg, Tabelle 02", 		Short
	.valueOf("7002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7003_LUXEMBURG_TABELLE_03 = new AttRdsLocationTabelle("Luxemburg, Tabelle 03", 		Short
	.valueOf("7003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7004_LUXEMBURG_TABELLE_04 = new AttRdsLocationTabelle("Luxemburg, Tabelle 04", 		Short
	.valueOf("7004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7021_RUSSLAND_TABELLE_21 = new AttRdsLocationTabelle("Russland, Tabelle 21", 		Short
	.valueOf("7021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7022_RUSSLAND_TABELLE_22 = new AttRdsLocationTabelle("Russland, Tabelle 22", 		Short
	.valueOf("7022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7023_RUSSLAND_TABELLE_23 = new AttRdsLocationTabelle("Russland, Tabelle 23", 		Short
	.valueOf("7023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7024_RUSSLAND_TABELLE_24 = new AttRdsLocationTabelle("Russland, Tabelle 24", 		Short
	.valueOf("7024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7025_RUSSLAND_TABELLE_25 = new AttRdsLocationTabelle("Russland, Tabelle 25", 		Short
	.valueOf("7025"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7026_RUSSLAND_TABELLE_26 = new AttRdsLocationTabelle("Russland, Tabelle 26", 		Short
	.valueOf("7026"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7027_RUSSLAND_TABELLE_27 = new AttRdsLocationTabelle("Russland, Tabelle 27", 		Short
	.valueOf("7027"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7028_RUSSLAND_TABELLE_28 = new AttRdsLocationTabelle("Russland, Tabelle 28", 		Short
	.valueOf("7028"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7053_TUNESIEN_TABELLE_53 = new AttRdsLocationTabelle("Tunesien, Tabelle 53", 		Short
	.valueOf("7053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7054_TUNESIEN_TABELLE_54 = new AttRdsLocationTabelle("Tunesien, Tabelle 54", 		Short
	.valueOf("7054"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7055_TUNESIEN_TABELLE_55 = new AttRdsLocationTabelle("Tunesien, Tabelle 55", 		Short
	.valueOf("7055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_7056_TUNESIEN_TABELLE_56 = new AttRdsLocationTabelle("Tunesien, Tabelle 56", 		Short
	.valueOf("7056"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8001_BULGARIEN_TABELLE_01 = new AttRdsLocationTabelle("Bulgarien, Tabelle 01", 		Short
	.valueOf("8001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8002_BULGARIEN_TABELLE_02 = new AttRdsLocationTabelle("Bulgarien, Tabelle 02", 		Short
	.valueOf("8002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8003_BULGARIEN_TABELLE_03 = new AttRdsLocationTabelle("Bulgarien, Tabelle 03", 		Short
	.valueOf("8003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8004_BULGARIEN_TABELLE_04 = new AttRdsLocationTabelle("Bulgarien, Tabelle 04", 		Short
	.valueOf("8004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8017_NIEDERLANDE_TABELLE_17 = new AttRdsLocationTabelle("Niederlande, Tabelle 17", 		Short
	.valueOf("8017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8018_NIEDERLANDE_TABELLE_18 = new AttRdsLocationTabelle("Niederlande, Tabelle 18", 		Short
	.valueOf("8018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8019_NIEDERLANDE_TABELLE_19 = new AttRdsLocationTabelle("Niederlande, Tabelle 19", 		Short
	.valueOf("8019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8020_NIEDERLANDE_TABELLE_20 = new AttRdsLocationTabelle("Niederlande, Tabelle 20", 		Short
	.valueOf("8020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8021_NIEDERLANDE_TABELLE_21 = new AttRdsLocationTabelle("Niederlande, Tabelle 21", 		Short
	.valueOf("8021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8022_NIEDERLANDE_TABELLE_22 = new AttRdsLocationTabelle("Niederlande, Tabelle 22", 		Short
	.valueOf("8022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8023_NIEDERLANDE_TABELLE_23 = new AttRdsLocationTabelle("Niederlande, Tabelle 23", 		Short
	.valueOf("8023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8024_NIEDERLANDE_TABELLE_24 = new AttRdsLocationTabelle("Niederlande, Tabelle 24", 		Short
	.valueOf("8024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8041_PORTUGAL_TABELLE_41 = new AttRdsLocationTabelle("Portugal, Tabelle 41", 		Short
	.valueOf("8041"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8042_PORTUGAL_TABELLE_42 = new AttRdsLocationTabelle("Portugal, Tabelle 42", 		Short
	.valueOf("8042"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8043_PORTUGAL_TABELLE_43 = new AttRdsLocationTabelle("Portugal, Tabelle 43", 		Short
	.valueOf("8043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8044_PORTUGAL_TABELLE_44 = new AttRdsLocationTabelle("Portugal, Tabelle 44", 		Short
	.valueOf("8044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8045_PORTUGAL_TABELLE_45 = new AttRdsLocationTabelle("Portugal, Tabelle 45", 		Short
	.valueOf("8045"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8046_PORTUGAL_TABELLE_46 = new AttRdsLocationTabelle("Portugal, Tabelle 46", 		Short
	.valueOf("8046"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8047_PORTUGAL_TABELLE_47 = new AttRdsLocationTabelle("Portugal, Tabelle 47", 		Short
	.valueOf("8047"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_8048_PORTUGAL_TABELLE_48 = new AttRdsLocationTabelle("Portugal, Tabelle 48", 		Short
	.valueOf("8048"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9001_ALBANIEN_TABELLE_01 = new AttRdsLocationTabelle("Albanien, Tabelle 01", 		Short
	.valueOf("9001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9002_ALBANIEN_TABELLE_02 = new AttRdsLocationTabelle("Albanien, Tabelle 02", 		Short
	.valueOf("9002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9009_DAENEMARK_TABELLE_09 = new AttRdsLocationTabelle("Dänemark, Tabelle 09", 		Short
	.valueOf("9009"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9010_DAENEMARK_TABELLE_10 = new AttRdsLocationTabelle("Dänemark, Tabelle 10", 		Short
	.valueOf("9010"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9011_DAENEMARK_TABELLE_11 = new AttRdsLocationTabelle("Dänemark, Tabelle 11", 		Short
	.valueOf("9011"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9012_DAENEMARK_TABELLE_12 = new AttRdsLocationTabelle("Dänemark, Tabelle 12", 		Short
	.valueOf("9012"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9013_DAENEMARK_TABELLE_13 = new AttRdsLocationTabelle("Dänemark, Tabelle 13", 		Short
	.valueOf("9013"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9014_DAENEMARK_TABELLE_14 = new AttRdsLocationTabelle("Dänemark, Tabelle 14", 		Short
	.valueOf("9014"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9015_DAENEMARK_TABELLE_15 = new AttRdsLocationTabelle("Dänemark, Tabelle 15", 		Short
	.valueOf("9015"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9016_DAENEMARK_TABELLE_16 = new AttRdsLocationTabelle("Dänemark, Tabelle 16", 		Short
	.valueOf("9016"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9033_SLOVENIEN_TABELLE_33 = new AttRdsLocationTabelle("Slovenien, Tabelle 33", 		Short
	.valueOf("9033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9034_SLOVENIEN_TABELLE_34 = new AttRdsLocationTabelle("Slovenien, Tabelle 34", 		Short
	.valueOf("9034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9035_SLOVENIEN_TABELLE_35 = new AttRdsLocationTabelle("Slovenien, Tabelle 35", 		Short
	.valueOf("9035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9036_SLOVENIEN_TABELLE_36 = new AttRdsLocationTabelle("Slovenien, Tabelle 36", 		Short
	.valueOf("9036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9051_LETTLAND_TABELLE_51 = new AttRdsLocationTabelle("Lettland, Tabelle 51", 		Short
	.valueOf("9051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9052_LETTLAND_TABELLE_52 = new AttRdsLocationTabelle("Lettland, Tabelle 52", 		Short
	.valueOf("9052"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9059_LIECHTENSTEIN_TABELLE_59 = new AttRdsLocationTabelle("Liechtenstein, Tabelle 59", 		Short
	.valueOf("9059"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_9060_LIECHTENSTEIN_TABELLE_60 = new AttRdsLocationTabelle("Liechtenstein, Tabelle 60", 		Short
	.valueOf("9060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10001_OESTERREICH_TABELLE_01 = new AttRdsLocationTabelle("Österreich, Tabelle 01", 		Short
	.valueOf("10001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10002_OESTERREICH_TABELLE_02 = new AttRdsLocationTabelle("Österreich, Tabelle 02", 		Short
	.valueOf("10002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10003_OESTERREICH_TABELLE_03 = new AttRdsLocationTabelle("Österreich, Tabelle 03", 		Short
	.valueOf("10003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10004_OESTERREICH_TABELLE_04 = new AttRdsLocationTabelle("Österreich, Tabelle 04", 		Short
	.valueOf("10004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10005_OESTERREICH_TABELLE_05 = new AttRdsLocationTabelle("Österreich, Tabelle 05", 		Short
	.valueOf("10005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10006_OESTERREICH_TABELLE_06 = new AttRdsLocationTabelle("Österreich, Tabelle 06", 		Short
	.valueOf("10006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10007_OESTERREICH_TABELLE_07 = new AttRdsLocationTabelle("Österreich, Tabelle 07", 		Short
	.valueOf("10007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10008_OESTERREICH_TABELLE_08 = new AttRdsLocationTabelle("Österreich, Tabelle 08", 		Short
	.valueOf("10008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10021_ISLAND_TABELLE_21 = new AttRdsLocationTabelle("Island, Tabelle 21", 		Short
	.valueOf("10021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10022_ISLAND_TABELLE_22 = new AttRdsLocationTabelle("Island, Tabelle 22", 		Short
	.valueOf("10022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10023_ISLAND_TABELLE_23 = new AttRdsLocationTabelle("Island, Tabelle 23", 		Short
	.valueOf("10023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10024_ISLAND_TABELLE_24 = new AttRdsLocationTabelle("Island, Tabelle 24", 		Short
	.valueOf("10024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10033_GIBRALTAR_TABELLE_33 = new AttRdsLocationTabelle("Gibraltar, Tabelle 33", 		Short
	.valueOf("10033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10034_GIBRALTAR_TABELLE_34 = new AttRdsLocationTabelle("Gibraltar, Tabelle 34", 		Short
	.valueOf("10034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10053_LIBANON_TABELLE_53 = new AttRdsLocationTabelle("Libanon, Tabelle 53", 		Short
	.valueOf("10053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10054_LIBANON_TABELLE_54 = new AttRdsLocationTabelle("Libanon, Tabelle 54", 		Short
	.valueOf("10054"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10055_LIBANON_TABELLE_55 = new AttRdsLocationTabelle("Libanon, Tabelle 55", 		Short
	.valueOf("10055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_10056_LIBANON_TABELLE_56 = new AttRdsLocationTabelle("Libanon, Tabelle 56", 		Short
	.valueOf("10056"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11001_UNGARN_TABELLE_01 = new AttRdsLocationTabelle("Ungarn, Tabelle 01", 		Short
	.valueOf("11001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11002_UNGARN_TABELLE_02 = new AttRdsLocationTabelle("Ungarn, Tabelle 02", 		Short
	.valueOf("11002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11003_UNGARN_TABELLE_03 = new AttRdsLocationTabelle("Ungarn, Tabelle 03", 		Short
	.valueOf("11003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11004_UNGARN_TABELLE_04 = new AttRdsLocationTabelle("Ungarn, Tabelle 04", 		Short
	.valueOf("11004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11017_IRAK_TABELLE_17 = new AttRdsLocationTabelle("Irak, Tabelle 17", 		Short
	.valueOf("11017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11018_IRAK_TABELLE_18 = new AttRdsLocationTabelle("Irak, Tabelle 18", 		Short
	.valueOf("11018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11019_IRAK_TABELLE_19 = new AttRdsLocationTabelle("Irak, Tabelle 19", 		Short
	.valueOf("11019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11020_IRAK_TABELLE_20 = new AttRdsLocationTabelle("Irak, Tabelle 20", 		Short
	.valueOf("11020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11033_MONACO_TABELLE_33 = new AttRdsLocationTabelle("Monaco, Tabelle 33", 		Short
	.valueOf("11033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_11034_MONACO_TABELLE_34 = new AttRdsLocationTabelle("Monaco, Tabelle 34", 		Short
	.valueOf("11034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12005_VEREINIGTES_KOENIGREICH_TABELLE_05 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 05", 		Short
	.valueOf("12005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12006_VEREINIGTES_KOENIGREICH_TABELLE_06 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 06", 		Short
	.valueOf("12006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12007_VEREINIGTES_KOENIGREICH_TABELLE_07 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 07", 		Short
	.valueOf("12007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12008_VEREINIGTES_KOENIGREICH_TABELLE_08 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 08", 		Short
	.valueOf("12008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12009_VEREINIGTES_KOENIGREICH_TABELLE_09 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 09", 		Short
	.valueOf("12009"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12010_VEREINIGTES_KOENIGREICH_TABELLE_10 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 10", 		Short
	.valueOf("12010"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12011_VEREINIGTES_KOENIGREICH_TABELLE_11 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 11", 		Short
	.valueOf("12011"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12012_VEREINIGTES_KOENIGREICH_TABELLE_12 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 12", 		Short
	.valueOf("12012"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12013_VEREINIGTES_KOENIGREICH_TABELLE_13 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 13", 		Short
	.valueOf("12013"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12014_VEREINIGTES_KOENIGREICH_TABELLE_14 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 14", 		Short
	.valueOf("12014"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12015_VEREINIGTES_KOENIGREICH_TABELLE_15 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 15", 		Short
	.valueOf("12015"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12016_VEREINIGTES_KOENIGREICH_TABELLE_16 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 16", 		Short
	.valueOf("12016"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12017_VEREINIGTES_KOENIGREICH_TABELLE_17 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 17", 		Short
	.valueOf("12017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12018_VEREINIGTES_KOENIGREICH_TABELLE_18 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 18", 		Short
	.valueOf("12018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12019_VEREINIGTES_KOENIGREICH_TABELLE_19 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 19", 		Short
	.valueOf("12019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12020_VEREINIGTES_KOENIGREICH_TABELLE_20 = new AttRdsLocationTabelle("Vereinigtes Königreich, Tabelle 20", 		Short
	.valueOf("12020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12033_KROATIEN_TABELLE_33 = new AttRdsLocationTabelle("Kroatien, Tabelle 33", 		Short
	.valueOf("12033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12034_KROATIEN_TABELLE_34 = new AttRdsLocationTabelle("Kroatien, Tabelle 34", 		Short
	.valueOf("12034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12043_LITAUEN_TABELLE_43 = new AttRdsLocationTabelle("Litauen, Tabelle 43", 		Short
	.valueOf("12043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12044_LITAUEN_TABELLE_44 = new AttRdsLocationTabelle("Litauen, Tabelle 44", 		Short
	.valueOf("12044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12059_MALTA_TABELLE_59 = new AttRdsLocationTabelle("Malta, Tabelle 59", 		Short
	.valueOf("12059"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_12060_MALTA_TABELLE_60 = new AttRdsLocationTabelle("Malta, Tabelle 60", 		Short
	.valueOf("12060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13001_DEUTSCHLAND_13_TABELLE_01_ENTSPRICHT_LCL_DER_BAST = new AttRdsLocationTabelle("Deutschland(13), Tabelle 01, entspricht LCL der BASt", 		Short
	.valueOf("13001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13002_DEUTSCHLAND_13_TABELLE_02 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 02", 		Short
	.valueOf("13002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13003_DEUTSCHLAND_13_TABELLE_03 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 03", 		Short
	.valueOf("13003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13004_DEUTSCHLAND_13_TABELLE_04 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 04", 		Short
	.valueOf("13004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13005_DEUTSCHLAND_13_TABELLE_05 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 05", 		Short
	.valueOf("13005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13006_DEUTSCHLAND_13_TABELLE_06 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 06", 		Short
	.valueOf("13006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13007_DEUTSCHLAND_13_TABELLE_07 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 07", 		Short
	.valueOf("13007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13008_DEUTSCHLAND_13_TABELLE_08 = new AttRdsLocationTabelle("Deutschland(13), Tabelle 08", 		Short
	.valueOf("13008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13033_LIBYEN_TABELLE_33 = new AttRdsLocationTabelle("Libyen, Tabelle 33", 		Short
	.valueOf("13033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13034_LIBYEN_TABELLE_34 = new AttRdsLocationTabelle("Libyen, Tabelle 34", 		Short
	.valueOf("13034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13035_LIBYEN_TABELLE_35 = new AttRdsLocationTabelle("Libyen, Tabelle 35", 		Short
	.valueOf("13035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13036_LIBYEN_TABELLE_36 = new AttRdsLocationTabelle("Libyen, Tabelle 36", 		Short
	.valueOf("13036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13051_SERBIEN_TABELLE_51 = new AttRdsLocationTabelle("Serbien, Tabelle 51", 		Short
	.valueOf("13051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_13052_SERBIEN_TABELLE_52 = new AttRdsLocationTabelle("Serbien, Tabelle 52", 		Short
	.valueOf("13052"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14001_RUMAENIEN_TABELLE_01 = new AttRdsLocationTabelle("Rumänien, Tabelle 01", 		Short
	.valueOf("14001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14002_RUMAENIEN_TABELLE_02 = new AttRdsLocationTabelle("Rumänien, Tabelle 02", 		Short
	.valueOf("14002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14003_RUMAENIEN_TABELLE_03 = new AttRdsLocationTabelle("Rumänien, Tabelle 03", 		Short
	.valueOf("14003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14004_RUMAENIEN_TABELLE_04 = new AttRdsLocationTabelle("Rumänien, Tabelle 04", 		Short
	.valueOf("14004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14017_SPANIEN_TABELLE_17 = new AttRdsLocationTabelle("Spanien, Tabelle 17", 		Short
	.valueOf("14017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14018_SPANIEN_TABELLE_18 = new AttRdsLocationTabelle("Spanien, Tabelle 18", 		Short
	.valueOf("14018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14019_SPANIEN_TABELLE_19 = new AttRdsLocationTabelle("Spanien, Tabelle 19", 		Short
	.valueOf("14019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14020_SPANIEN_TABELLE_20 = new AttRdsLocationTabelle("Spanien, Tabelle 20", 		Short
	.valueOf("14020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14021_SPANIEN_TABELLE_21 = new AttRdsLocationTabelle("Spanien, Tabelle 21", 		Short
	.valueOf("14021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14022_SPANIEN_TABELLE_22 = new AttRdsLocationTabelle("Spanien, Tabelle 22", 		Short
	.valueOf("14022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14023_SPANIEN_TABELLE_23 = new AttRdsLocationTabelle("Spanien, Tabelle 23", 		Short
	.valueOf("14023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14024_SPANIEN_TABELLE_24 = new AttRdsLocationTabelle("Spanien, Tabelle 24", 		Short
	.valueOf("14024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14033_SCHWEDEN_TABELLE_33 = new AttRdsLocationTabelle("Schweden, Tabelle 33", 		Short
	.valueOf("14033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14034_SCHWEDEN_TABELLE_34 = new AttRdsLocationTabelle("Schweden, Tabelle 34", 		Short
	.valueOf("14034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14035_SCHWEDEN_TABELLE_35 = new AttRdsLocationTabelle("Schweden, Tabelle 35", 		Short
	.valueOf("14035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14036_SCHWEDEN_TABELLE_36 = new AttRdsLocationTabelle("Schweden, Tabelle 36", 		Short
	.valueOf("14036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14037_SCHWEDEN_TABELLE_37 = new AttRdsLocationTabelle("Schweden, Tabelle 37", 		Short
	.valueOf("14037"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14038_SCHWEDEN_TABELLE_38 = new AttRdsLocationTabelle("Schweden, Tabelle 38", 		Short
	.valueOf("14038"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14039_SCHWEDEN_TABELLE_39 = new AttRdsLocationTabelle("Schweden, Tabelle 39", 		Short
	.valueOf("14039"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_14040_SCHWEDEN_TABELLE_40 = new AttRdsLocationTabelle("Schweden, Tabelle 40", 		Short
	.valueOf("14040"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15001_BELORUSSLAND_TABELLE_01 = new AttRdsLocationTabelle("Belorussland, Tabelle 01", 		Short
	.valueOf("15001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15002_BELORUSSLAND_TABELLE_02 = new AttRdsLocationTabelle("Belorussland, Tabelle 02", 		Short
	.valueOf("15002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15003_BELORUSSLAND_TABELLE_03 = new AttRdsLocationTabelle("Belorussland, Tabelle 03", 		Short
	.valueOf("15003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15004_BELORUSSLAND_TABELLE_04 = new AttRdsLocationTabelle("Belorussland, Tabelle 04", 		Short
	.valueOf("15004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15009_AEGYPTEN_TABELLE_09 = new AttRdsLocationTabelle("Ägypten, Tabelle 09", 		Short
	.valueOf("15009"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15010_AEGYPTEN_TABELLE_10 = new AttRdsLocationTabelle("Ägypten, Tabelle 10", 		Short
	.valueOf("15010"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15011_AEGYPTEN_TABELLE_11 = new AttRdsLocationTabelle("Ägypten, Tabelle 11", 		Short
	.valueOf("15011"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15012_AEGYPTEN_TABELLE_12 = new AttRdsLocationTabelle("Ägypten, Tabelle 12", 		Short
	.valueOf("15012"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15017_FRANKREICH_TABELLE_17 = new AttRdsLocationTabelle("Frankreich, Tabelle 17", 		Short
	.valueOf("15017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15018_FRANKREICH_TABELLE_18 = new AttRdsLocationTabelle("Frankreich, Tabelle 18", 		Short
	.valueOf("15018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15019_FRANKREICH_TABELLE_19 = new AttRdsLocationTabelle("Frankreich, Tabelle 19", 		Short
	.valueOf("15019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15020_FRANKREICH_TABELLE_20 = new AttRdsLocationTabelle("Frankreich, Tabelle 20", 		Short
	.valueOf("15020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15021_FRANKREICH_TABELLE_21 = new AttRdsLocationTabelle("Frankreich, Tabelle 21", 		Short
	.valueOf("15021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15022_FRANKREICH_TABELLE_22 = new AttRdsLocationTabelle("Frankreich, Tabelle 22", 		Short
	.valueOf("15022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15023_FRANKREICH_TABELLE_23 = new AttRdsLocationTabelle("Frankreich, Tabelle 23", 		Short
	.valueOf("15023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15024_FRANKREICH_TABELLE_24 = new AttRdsLocationTabelle("Frankreich, Tabelle 24", 		Short
	.valueOf("15024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15025_FRANKREICH_TABELLE_25 = new AttRdsLocationTabelle("Frankreich, Tabelle 25", 		Short
	.valueOf("15025"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15026_FRANKREICH_TABELLE_26 = new AttRdsLocationTabelle("Frankreich, Tabelle 26", 		Short
	.valueOf("15026"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15027_FRANKREICH_TABELLE_27 = new AttRdsLocationTabelle("Frankreich, Tabelle 27", 		Short
	.valueOf("15027"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15028_FRANKREICH_TABELLE_28 = new AttRdsLocationTabelle("Frankreich, Tabelle 28", 		Short
	.valueOf("15028"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15029_FRANKREICH_TABELLE_29 = new AttRdsLocationTabelle("Frankreich, Tabelle 29", 		Short
	.valueOf("15029"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15030_FRANKREICH_TABELLE_30 = new AttRdsLocationTabelle("Frankreich, Tabelle 30", 		Short
	.valueOf("15030"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15031_FRANKREICH_TABELLE_31 = new AttRdsLocationTabelle("Frankreich, Tabelle 31", 		Short
	.valueOf("15031"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15032_FRANKREICH_TABELLE_32 = new AttRdsLocationTabelle("Frankreich, Tabelle 32", 		Short
	.valueOf("15032"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15043_BOSNIEN_HERZEGOWINA_TABELLE_43 = new AttRdsLocationTabelle("Bosnien-Herzegowina, Tabelle 43", 		Short
	.valueOf("15043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15044_BOSNIEN_HERZEGOWINA_TABELLE_44 = new AttRdsLocationTabelle("Bosnien-Herzegowina, Tabelle 44", 		Short
	.valueOf("15044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15049_NORWEGEN_TABELLE_49 = new AttRdsLocationTabelle("Norwegen, Tabelle 49", 		Short
	.valueOf("15049"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15050_NORWEGEN_TABELLE_50 = new AttRdsLocationTabelle("Norwegen, Tabelle 50", 		Short
	.valueOf("15050"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15051_NORWEGEN_TABELLE_51 = new AttRdsLocationTabelle("Norwegen, Tabelle 51", 		Short
	.valueOf("15051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15052_NORWEGEN_TABELLE_52 = new AttRdsLocationTabelle("Norwegen, Tabelle 52", 		Short
	.valueOf("15052"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15053_NORWEGEN_TABELLE_53 = new AttRdsLocationTabelle("Norwegen, Tabelle 53", 		Short
	.valueOf("15053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15054_NORWEGEN_TABELLE_54 = new AttRdsLocationTabelle("Norwegen, Tabelle 54", 		Short
	.valueOf("15054"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15055_NORWEGEN_TABELLE_55 = new AttRdsLocationTabelle("Norwegen, Tabelle 55", 		Short
	.valueOf("15055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationTabelle ZUSTAND_15056_NORWEGEN_TABELLE_56 = new AttRdsLocationTabelle("Norwegen, Tabelle 56", 		Short
	.valueOf("15056"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsLocationTabelle getZustand(final 		Short
	 value) {
		for (AttRdsLocationTabelle e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsLocationTabelle getZustand(final String value) {
		for (AttRdsLocationTabelle e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsLocationTabelle> getZustaende() {
		List<AttRdsLocationTabelle> list = new ArrayList<AttRdsLocationTabelle>();
		list.add(ZUSTAND_0_UNDEFINIERT);
		list.add(ZUSTAND_1001_DEUTSCHLAND_1_TABELLE_01);
		list.add(ZUSTAND_1002_DEUTSCHLAND_1_TABELLE_02);
		list.add(ZUSTAND_1003_DEUTSCHLAND_1_TABELLE_03);
		list.add(ZUSTAND_1004_DEUTSCHLAND_1_TABELLE_04);
		list.add(ZUSTAND_1005_DEUTSCHLAND_1_TABELLE_05);
		list.add(ZUSTAND_1006_DEUTSCHLAND_1_TABELLE_06);
		list.add(ZUSTAND_1007_DEUTSCHLAND_1_TABELLE_07);
		list.add(ZUSTAND_1008_DEUTSCHLAND_1_TABELLE_08);
		list.add(ZUSTAND_1017_GRIECHENLAND_TABELLE_17);
		list.add(ZUSTAND_1018_GRIECHENLAND_TABELLE_18);
		list.add(ZUSTAND_1019_GRIECHENLAND_TABELLE_19);
		list.add(ZUSTAND_1020_GRIECHENLAND_TABELLE_20);
		list.add(ZUSTAND_1021_GRIECHENLAND_TABELLE_21);
		list.add(ZUSTAND_1022_GRIECHENLAND_TABELLE_22);
		list.add(ZUSTAND_1023_GRIECHENLAND_TABELLE_23);
		list.add(ZUSTAND_1024_GRIECHENLAND_TABELLE_24);
		list.add(ZUSTAND_1033_MAROKKO_TABELLE_33);
		list.add(ZUSTAND_1034_MAROKKO_TABELLE_34);
		list.add(ZUSTAND_1035_MAROKKO_TABELLE_35);
		list.add(ZUSTAND_1036_MAROKKO_TABELLE_36);
		list.add(ZUSTAND_1051_MOLDAVIEN_TABELLE_51);
		list.add(ZUSTAND_1052_MOLDAVIEN_TABELLE_52);
		list.add(ZUSTAND_1059_MONTENEGRO_TABELLE_59);
		list.add(ZUSTAND_1060_MONTENEGRO_TABELLE_60);
		list.add(ZUSTAND_2001_ALGERIEN_TABELLE_01);
		list.add(ZUSTAND_2002_ALGERIEN_TABELLE_02);
		list.add(ZUSTAND_2003_ALGERIEN_TABELLE_03);
		list.add(ZUSTAND_2004_ALGERIEN_TABELLE_04);
		list.add(ZUSTAND_2017_ZYPERN_TABELLE_17);
		list.add(ZUSTAND_2018_ZYPERN_TABELLE_18);
		list.add(ZUSTAND_2025_TSCHECHISCHE_REPUBLIK_TABELLE_25);
		list.add(ZUSTAND_2026_TSCHECHISCHE_REPUBLIK_TABELLE_26);
		list.add(ZUSTAND_2027_TSCHECHISCHE_REPUBLIK_TABELLE_27);
		list.add(ZUSTAND_2028_TSCHECHISCHE_REPUBLIK_TABELLE_28);
		list.add(ZUSTAND_2041_IRLAND_TABELLE_41);
		list.add(ZUSTAND_2042_IRLAND_TABELLE_42);
		list.add(ZUSTAND_2043_IRLAND_TABELLE_43);
		list.add(ZUSTAND_2044_IRLAND_TABELLE_44);
		list.add(ZUSTAND_2045_IRLAND_TABELLE_45);
		list.add(ZUSTAND_2046_IRLAND_TABELLE_46);
		list.add(ZUSTAND_2047_IRLAND_TABELLE_47);
		list.add(ZUSTAND_2048_IRLAND_TABELLE_48);
		list.add(ZUSTAND_2059_ESTLAND_TABELLE_59);
		list.add(ZUSTAND_2060_ESTLAND_TABELLE_60);
		list.add(ZUSTAND_3001_ANDORRA_TABELLE_01);
		list.add(ZUSTAND_3002_ANDORRA_TABELLE_02);
		list.add(ZUSTAND_3005_POLEN_TABELLE_05);
		list.add(ZUSTAND_3006_POLEN_TABELLE_06);
		list.add(ZUSTAND_3007_POLEN_TABELLE_07);
		list.add(ZUSTAND_3008_POLEN_TABELLE_08);
		list.add(ZUSTAND_3021_SAN_MARINO_TABELLE_21);
		list.add(ZUSTAND_3022_SAN_MARINO_TABELLE_22);
		list.add(ZUSTAND_3033_TUERKEI_TABELLE_33);
		list.add(ZUSTAND_3034_TUERKEI_TABELLE_34);
		list.add(ZUSTAND_3035_TUERKEI_TABELLE_35);
		list.add(ZUSTAND_3036_TUERKEI_TABELLE_36);
		list.add(ZUSTAND_3037_TUERKEI_TABELLE_37);
		list.add(ZUSTAND_3038_TUERKEI_TABELLE_38);
		list.add(ZUSTAND_3039_TUERKEI_TABELLE_39);
		list.add(ZUSTAND_3040_TUERKEI_TABELLE_40);
		list.add(ZUSTAND_4001_MAZEDONIEN_TABELLE_01);
		list.add(ZUSTAND_4002_MAZEDONIEN_TABELLE_02);
		list.add(ZUSTAND_4009_SCHWEIZ_TABELLE_09);
		list.add(ZUSTAND_4010_SCHWEIZ_TABELLE_10);
		list.add(ZUSTAND_4011_SCHWEIZ_TABELLE_11);
		list.add(ZUSTAND_4012_SCHWEIZ_TABELLE_12);
		list.add(ZUSTAND_4013_SCHWEIZ_TABELLE_13);
		list.add(ZUSTAND_4014_SCHWEIZ_TABELLE_14);
		list.add(ZUSTAND_4015_SCHWEIZ_TABELLE_15);
		list.add(ZUSTAND_4016_SCHWEIZ_TABELLE_16);
		list.add(ZUSTAND_4025_VATIKAN_TABELLE_25);
		list.add(ZUSTAND_4026_VATIKAN_TABELLE_26);
		list.add(ZUSTAND_4033_ISRAEL_TABELLE_33);
		list.add(ZUSTAND_4034_ISRAEL_TABELLE_34);
		list.add(ZUSTAND_4035_ISRAEL_TABELLE_35);
		list.add(ZUSTAND_4036_ISRAEL_TABELLE_36);
		list.add(ZUSTAND_5001_ITALIEN_TABELLE_01);
		list.add(ZUSTAND_5002_ITALIEN_TABELLE_02);
		list.add(ZUSTAND_5003_ITALIEN_TABELLE_03);
		list.add(ZUSTAND_5004_ITALIEN_TABELLE_04);
		list.add(ZUSTAND_5005_ITALIEN_TABELLE_05);
		list.add(ZUSTAND_5006_ITALIEN_TABELLE_06);
		list.add(ZUSTAND_5007_ITALIEN_TABELLE_07);
		list.add(ZUSTAND_5008_ITALIEN_TABELLE_08);
		list.add(ZUSTAND_5009_ITALIEN_TABELLE_09);
		list.add(ZUSTAND_5010_ITALIEN_TABELLE_10);
		list.add(ZUSTAND_5011_ITALIEN_TABELLE_11);
		list.add(ZUSTAND_5012_ITALIEN_TABELLE_12);
		list.add(ZUSTAND_5013_ITALIEN_TABELLE_13);
		list.add(ZUSTAND_5014_ITALIEN_TABELLE_14);
		list.add(ZUSTAND_5015_ITALIEN_TABELLE_15);
		list.add(ZUSTAND_5016_ITALIEN_TABELLE_16);
		list.add(ZUSTAND_5033_JORDANIEN_TABELLE_33);
		list.add(ZUSTAND_5034_JORDANIEN_TABELLE_34);
		list.add(ZUSTAND_5035_JORDANIEN_TABELLE_35);
		list.add(ZUSTAND_5036_JORDANIEN_TABELLE_36);
		list.add(ZUSTAND_5051_SLOWAKEI_TABELLE_51);
		list.add(ZUSTAND_5052_SLOWAKEI_TABELLE_52);
		list.add(ZUSTAND_5053_SLOWAKEI_TABELLE_53);
		list.add(ZUSTAND_5054_SLOWAKEI_TABELLE_54);
		list.add(ZUSTAND_6001_BELGIEN_TABELLE_01);
		list.add(ZUSTAND_6002_BELGIEN_TABELLE_02);
		list.add(ZUSTAND_6003_BELGIEN_TABELLE_03);
		list.add(ZUSTAND_6004_BELGIEN_TABELLE_04);
		list.add(ZUSTAND_6005_BELGIEN_TABELLE_05);
		list.add(ZUSTAND_6006_BELGIEN_TABELLE_06);
		list.add(ZUSTAND_6007_BELGIEN_TABELLE_07);
		list.add(ZUSTAND_6008_BELGIEN_TABELLE_08);
		list.add(ZUSTAND_6017_FINNLAND_TABELLE_17);
		list.add(ZUSTAND_6018_FINNLAND_TABELLE_18);
		list.add(ZUSTAND_6019_FINNLAND_TABELLE_19);
		list.add(ZUSTAND_6020_FINNLAND_TABELLE_20);
		list.add(ZUSTAND_6021_FINNLAND_TABELLE_21);
		list.add(ZUSTAND_6022_FINNLAND_TABELLE_22);
		list.add(ZUSTAND_6023_FINNLAND_TABELLE_23);
		list.add(ZUSTAND_6024_FINNLAND_TABELLE_24);
		list.add(ZUSTAND_6033_UKRAINE_TABELLE_33);
		list.add(ZUSTAND_6034_UKRAINE_TABELLE_34);
		list.add(ZUSTAND_6035_UKRAINE_TABELLE_35);
		list.add(ZUSTAND_6036_UKRAINE_TABELLE_36);
		list.add(ZUSTAND_6037_UKRAINE_TABELLE_37);
		list.add(ZUSTAND_6038_UKRAINE_TABELLE_38);
		list.add(ZUSTAND_6039_UKRAINE_TABELLE_39);
		list.add(ZUSTAND_6040_UKRAINE_TABELLE_40);
		list.add(ZUSTAND_6053_SYRIEN_TABELLE_53);
		list.add(ZUSTAND_6054_SYRIEN_TABELLE_54);
		list.add(ZUSTAND_6055_SYRIEN_TABELLE_55);
		list.add(ZUSTAND_6056_SYRIEN_TABELLE_56);
		list.add(ZUSTAND_7001_LUXEMBURG_TABELLE_01);
		list.add(ZUSTAND_7002_LUXEMBURG_TABELLE_02);
		list.add(ZUSTAND_7003_LUXEMBURG_TABELLE_03);
		list.add(ZUSTAND_7004_LUXEMBURG_TABELLE_04);
		list.add(ZUSTAND_7021_RUSSLAND_TABELLE_21);
		list.add(ZUSTAND_7022_RUSSLAND_TABELLE_22);
		list.add(ZUSTAND_7023_RUSSLAND_TABELLE_23);
		list.add(ZUSTAND_7024_RUSSLAND_TABELLE_24);
		list.add(ZUSTAND_7025_RUSSLAND_TABELLE_25);
		list.add(ZUSTAND_7026_RUSSLAND_TABELLE_26);
		list.add(ZUSTAND_7027_RUSSLAND_TABELLE_27);
		list.add(ZUSTAND_7028_RUSSLAND_TABELLE_28);
		list.add(ZUSTAND_7053_TUNESIEN_TABELLE_53);
		list.add(ZUSTAND_7054_TUNESIEN_TABELLE_54);
		list.add(ZUSTAND_7055_TUNESIEN_TABELLE_55);
		list.add(ZUSTAND_7056_TUNESIEN_TABELLE_56);
		list.add(ZUSTAND_8001_BULGARIEN_TABELLE_01);
		list.add(ZUSTAND_8002_BULGARIEN_TABELLE_02);
		list.add(ZUSTAND_8003_BULGARIEN_TABELLE_03);
		list.add(ZUSTAND_8004_BULGARIEN_TABELLE_04);
		list.add(ZUSTAND_8017_NIEDERLANDE_TABELLE_17);
		list.add(ZUSTAND_8018_NIEDERLANDE_TABELLE_18);
		list.add(ZUSTAND_8019_NIEDERLANDE_TABELLE_19);
		list.add(ZUSTAND_8020_NIEDERLANDE_TABELLE_20);
		list.add(ZUSTAND_8021_NIEDERLANDE_TABELLE_21);
		list.add(ZUSTAND_8022_NIEDERLANDE_TABELLE_22);
		list.add(ZUSTAND_8023_NIEDERLANDE_TABELLE_23);
		list.add(ZUSTAND_8024_NIEDERLANDE_TABELLE_24);
		list.add(ZUSTAND_8041_PORTUGAL_TABELLE_41);
		list.add(ZUSTAND_8042_PORTUGAL_TABELLE_42);
		list.add(ZUSTAND_8043_PORTUGAL_TABELLE_43);
		list.add(ZUSTAND_8044_PORTUGAL_TABELLE_44);
		list.add(ZUSTAND_8045_PORTUGAL_TABELLE_45);
		list.add(ZUSTAND_8046_PORTUGAL_TABELLE_46);
		list.add(ZUSTAND_8047_PORTUGAL_TABELLE_47);
		list.add(ZUSTAND_8048_PORTUGAL_TABELLE_48);
		list.add(ZUSTAND_9001_ALBANIEN_TABELLE_01);
		list.add(ZUSTAND_9002_ALBANIEN_TABELLE_02);
		list.add(ZUSTAND_9009_DAENEMARK_TABELLE_09);
		list.add(ZUSTAND_9010_DAENEMARK_TABELLE_10);
		list.add(ZUSTAND_9011_DAENEMARK_TABELLE_11);
		list.add(ZUSTAND_9012_DAENEMARK_TABELLE_12);
		list.add(ZUSTAND_9013_DAENEMARK_TABELLE_13);
		list.add(ZUSTAND_9014_DAENEMARK_TABELLE_14);
		list.add(ZUSTAND_9015_DAENEMARK_TABELLE_15);
		list.add(ZUSTAND_9016_DAENEMARK_TABELLE_16);
		list.add(ZUSTAND_9033_SLOVENIEN_TABELLE_33);
		list.add(ZUSTAND_9034_SLOVENIEN_TABELLE_34);
		list.add(ZUSTAND_9035_SLOVENIEN_TABELLE_35);
		list.add(ZUSTAND_9036_SLOVENIEN_TABELLE_36);
		list.add(ZUSTAND_9051_LETTLAND_TABELLE_51);
		list.add(ZUSTAND_9052_LETTLAND_TABELLE_52);
		list.add(ZUSTAND_9059_LIECHTENSTEIN_TABELLE_59);
		list.add(ZUSTAND_9060_LIECHTENSTEIN_TABELLE_60);
		list.add(ZUSTAND_10001_OESTERREICH_TABELLE_01);
		list.add(ZUSTAND_10002_OESTERREICH_TABELLE_02);
		list.add(ZUSTAND_10003_OESTERREICH_TABELLE_03);
		list.add(ZUSTAND_10004_OESTERREICH_TABELLE_04);
		list.add(ZUSTAND_10005_OESTERREICH_TABELLE_05);
		list.add(ZUSTAND_10006_OESTERREICH_TABELLE_06);
		list.add(ZUSTAND_10007_OESTERREICH_TABELLE_07);
		list.add(ZUSTAND_10008_OESTERREICH_TABELLE_08);
		list.add(ZUSTAND_10021_ISLAND_TABELLE_21);
		list.add(ZUSTAND_10022_ISLAND_TABELLE_22);
		list.add(ZUSTAND_10023_ISLAND_TABELLE_23);
		list.add(ZUSTAND_10024_ISLAND_TABELLE_24);
		list.add(ZUSTAND_10033_GIBRALTAR_TABELLE_33);
		list.add(ZUSTAND_10034_GIBRALTAR_TABELLE_34);
		list.add(ZUSTAND_10053_LIBANON_TABELLE_53);
		list.add(ZUSTAND_10054_LIBANON_TABELLE_54);
		list.add(ZUSTAND_10055_LIBANON_TABELLE_55);
		list.add(ZUSTAND_10056_LIBANON_TABELLE_56);
		list.add(ZUSTAND_11001_UNGARN_TABELLE_01);
		list.add(ZUSTAND_11002_UNGARN_TABELLE_02);
		list.add(ZUSTAND_11003_UNGARN_TABELLE_03);
		list.add(ZUSTAND_11004_UNGARN_TABELLE_04);
		list.add(ZUSTAND_11017_IRAK_TABELLE_17);
		list.add(ZUSTAND_11018_IRAK_TABELLE_18);
		list.add(ZUSTAND_11019_IRAK_TABELLE_19);
		list.add(ZUSTAND_11020_IRAK_TABELLE_20);
		list.add(ZUSTAND_11033_MONACO_TABELLE_33);
		list.add(ZUSTAND_11034_MONACO_TABELLE_34);
		list.add(ZUSTAND_12005_VEREINIGTES_KOENIGREICH_TABELLE_05);
		list.add(ZUSTAND_12006_VEREINIGTES_KOENIGREICH_TABELLE_06);
		list.add(ZUSTAND_12007_VEREINIGTES_KOENIGREICH_TABELLE_07);
		list.add(ZUSTAND_12008_VEREINIGTES_KOENIGREICH_TABELLE_08);
		list.add(ZUSTAND_12009_VEREINIGTES_KOENIGREICH_TABELLE_09);
		list.add(ZUSTAND_12010_VEREINIGTES_KOENIGREICH_TABELLE_10);
		list.add(ZUSTAND_12011_VEREINIGTES_KOENIGREICH_TABELLE_11);
		list.add(ZUSTAND_12012_VEREINIGTES_KOENIGREICH_TABELLE_12);
		list.add(ZUSTAND_12013_VEREINIGTES_KOENIGREICH_TABELLE_13);
		list.add(ZUSTAND_12014_VEREINIGTES_KOENIGREICH_TABELLE_14);
		list.add(ZUSTAND_12015_VEREINIGTES_KOENIGREICH_TABELLE_15);
		list.add(ZUSTAND_12016_VEREINIGTES_KOENIGREICH_TABELLE_16);
		list.add(ZUSTAND_12017_VEREINIGTES_KOENIGREICH_TABELLE_17);
		list.add(ZUSTAND_12018_VEREINIGTES_KOENIGREICH_TABELLE_18);
		list.add(ZUSTAND_12019_VEREINIGTES_KOENIGREICH_TABELLE_19);
		list.add(ZUSTAND_12020_VEREINIGTES_KOENIGREICH_TABELLE_20);
		list.add(ZUSTAND_12033_KROATIEN_TABELLE_33);
		list.add(ZUSTAND_12034_KROATIEN_TABELLE_34);
		list.add(ZUSTAND_12043_LITAUEN_TABELLE_43);
		list.add(ZUSTAND_12044_LITAUEN_TABELLE_44);
		list.add(ZUSTAND_12059_MALTA_TABELLE_59);
		list.add(ZUSTAND_12060_MALTA_TABELLE_60);
		list.add(ZUSTAND_13001_DEUTSCHLAND_13_TABELLE_01_ENTSPRICHT_LCL_DER_BAST);
		list.add(ZUSTAND_13002_DEUTSCHLAND_13_TABELLE_02);
		list.add(ZUSTAND_13003_DEUTSCHLAND_13_TABELLE_03);
		list.add(ZUSTAND_13004_DEUTSCHLAND_13_TABELLE_04);
		list.add(ZUSTAND_13005_DEUTSCHLAND_13_TABELLE_05);
		list.add(ZUSTAND_13006_DEUTSCHLAND_13_TABELLE_06);
		list.add(ZUSTAND_13007_DEUTSCHLAND_13_TABELLE_07);
		list.add(ZUSTAND_13008_DEUTSCHLAND_13_TABELLE_08);
		list.add(ZUSTAND_13033_LIBYEN_TABELLE_33);
		list.add(ZUSTAND_13034_LIBYEN_TABELLE_34);
		list.add(ZUSTAND_13035_LIBYEN_TABELLE_35);
		list.add(ZUSTAND_13036_LIBYEN_TABELLE_36);
		list.add(ZUSTAND_13051_SERBIEN_TABELLE_51);
		list.add(ZUSTAND_13052_SERBIEN_TABELLE_52);
		list.add(ZUSTAND_14001_RUMAENIEN_TABELLE_01);
		list.add(ZUSTAND_14002_RUMAENIEN_TABELLE_02);
		list.add(ZUSTAND_14003_RUMAENIEN_TABELLE_03);
		list.add(ZUSTAND_14004_RUMAENIEN_TABELLE_04);
		list.add(ZUSTAND_14017_SPANIEN_TABELLE_17);
		list.add(ZUSTAND_14018_SPANIEN_TABELLE_18);
		list.add(ZUSTAND_14019_SPANIEN_TABELLE_19);
		list.add(ZUSTAND_14020_SPANIEN_TABELLE_20);
		list.add(ZUSTAND_14021_SPANIEN_TABELLE_21);
		list.add(ZUSTAND_14022_SPANIEN_TABELLE_22);
		list.add(ZUSTAND_14023_SPANIEN_TABELLE_23);
		list.add(ZUSTAND_14024_SPANIEN_TABELLE_24);
		list.add(ZUSTAND_14033_SCHWEDEN_TABELLE_33);
		list.add(ZUSTAND_14034_SCHWEDEN_TABELLE_34);
		list.add(ZUSTAND_14035_SCHWEDEN_TABELLE_35);
		list.add(ZUSTAND_14036_SCHWEDEN_TABELLE_36);
		list.add(ZUSTAND_14037_SCHWEDEN_TABELLE_37);
		list.add(ZUSTAND_14038_SCHWEDEN_TABELLE_38);
		list.add(ZUSTAND_14039_SCHWEDEN_TABELLE_39);
		list.add(ZUSTAND_14040_SCHWEDEN_TABELLE_40);
		list.add(ZUSTAND_15001_BELORUSSLAND_TABELLE_01);
		list.add(ZUSTAND_15002_BELORUSSLAND_TABELLE_02);
		list.add(ZUSTAND_15003_BELORUSSLAND_TABELLE_03);
		list.add(ZUSTAND_15004_BELORUSSLAND_TABELLE_04);
		list.add(ZUSTAND_15009_AEGYPTEN_TABELLE_09);
		list.add(ZUSTAND_15010_AEGYPTEN_TABELLE_10);
		list.add(ZUSTAND_15011_AEGYPTEN_TABELLE_11);
		list.add(ZUSTAND_15012_AEGYPTEN_TABELLE_12);
		list.add(ZUSTAND_15017_FRANKREICH_TABELLE_17);
		list.add(ZUSTAND_15018_FRANKREICH_TABELLE_18);
		list.add(ZUSTAND_15019_FRANKREICH_TABELLE_19);
		list.add(ZUSTAND_15020_FRANKREICH_TABELLE_20);
		list.add(ZUSTAND_15021_FRANKREICH_TABELLE_21);
		list.add(ZUSTAND_15022_FRANKREICH_TABELLE_22);
		list.add(ZUSTAND_15023_FRANKREICH_TABELLE_23);
		list.add(ZUSTAND_15024_FRANKREICH_TABELLE_24);
		list.add(ZUSTAND_15025_FRANKREICH_TABELLE_25);
		list.add(ZUSTAND_15026_FRANKREICH_TABELLE_26);
		list.add(ZUSTAND_15027_FRANKREICH_TABELLE_27);
		list.add(ZUSTAND_15028_FRANKREICH_TABELLE_28);
		list.add(ZUSTAND_15029_FRANKREICH_TABELLE_29);
		list.add(ZUSTAND_15030_FRANKREICH_TABELLE_30);
		list.add(ZUSTAND_15031_FRANKREICH_TABELLE_31);
		list.add(ZUSTAND_15032_FRANKREICH_TABELLE_32);
		list.add(ZUSTAND_15043_BOSNIEN_HERZEGOWINA_TABELLE_43);
		list.add(ZUSTAND_15044_BOSNIEN_HERZEGOWINA_TABELLE_44);
		list.add(ZUSTAND_15049_NORWEGEN_TABELLE_49);
		list.add(ZUSTAND_15050_NORWEGEN_TABELLE_50);
		list.add(ZUSTAND_15051_NORWEGEN_TABELLE_51);
		list.add(ZUSTAND_15052_NORWEGEN_TABELLE_52);
		list.add(ZUSTAND_15053_NORWEGEN_TABELLE_53);
		list.add(ZUSTAND_15054_NORWEGEN_TABELLE_54);
		list.add(ZUSTAND_15055_NORWEGEN_TABELLE_55);
		list.add(ZUSTAND_15056_NORWEGEN_TABELLE_56);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut LocationTabelle.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsLocationTabelle(final 		Short
	 value) {
		super(value);
	}
	
	private AttRdsLocationTabelle(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
