/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Klassifikation des Nachrichtentextes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttRdsNachrichtenKlasse extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_0_STRASSENNUMMER = new AttRdsNachrichtenKlasse("Straßennummer", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_1_SEGMENT = new AttRdsNachrichtenKlasse("Segment", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_2_INHALT = new AttRdsNachrichtenKlasse("Inhalt", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_3_FREIER_TEXT = new AttRdsNachrichtenKlasse("freier Text", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_4_ERGAENZUNG = new AttRdsNachrichtenKlasse("Ergänzung", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_20_SEGMENT_VON = new AttRdsNachrichtenKlasse("Segment von", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_21_SEGMENT_NACH = new AttRdsNachrichtenKlasse("Segment nach", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_22_BUNDESLAND = new AttRdsNachrichtenKlasse("Bundesland", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_23_STADT = new AttRdsNachrichtenKlasse("Stadt", 		Byte
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_40_NAME = new AttRdsNachrichtenKlasse("Name", 		Byte
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_41_STRASSENNAME = new AttRdsNachrichtenKlasse("Straßenname", 		Byte
	.valueOf("41"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_42__2_NAME = new AttRdsNachrichtenKlasse("2. Name", 		Byte
	.valueOf("42"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_43_GEBIETSNAME = new AttRdsNachrichtenKlasse("Gebietsname", 		Byte
	.valueOf("43"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_44_LINEARER_ERSTER_NAME = new AttRdsNachrichtenKlasse("linearer erster Name", 		Byte
	.valueOf("44"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_45_LINEARER_ZWEITER_NAME = new AttRdsNachrichtenKlasse("linearer zweiter Name", 		Byte
	.valueOf("45"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_46_KREIS = new AttRdsNachrichtenKlasse("Kreis", 		Byte
	.valueOf("46"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_47_PLZ = new AttRdsNachrichtenKlasse("PLZ", 		Byte
	.valueOf("47"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenKlasse ZUSTAND_48_HAUSNUMMER = new AttRdsNachrichtenKlasse("Hausnummer", 		Byte
	.valueOf("48"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsNachrichtenKlasse getZustand(final 		Byte
	 value) {
		for (AttRdsNachrichtenKlasse e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsNachrichtenKlasse getZustand(final String value) {
		for (AttRdsNachrichtenKlasse e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsNachrichtenKlasse> getZustaende() {
		List<AttRdsNachrichtenKlasse> list = new ArrayList<AttRdsNachrichtenKlasse>();
		list.add(ZUSTAND_0_STRASSENNUMMER);
		list.add(ZUSTAND_1_SEGMENT);
		list.add(ZUSTAND_2_INHALT);
		list.add(ZUSTAND_3_FREIER_TEXT);
		list.add(ZUSTAND_4_ERGAENZUNG);
		list.add(ZUSTAND_20_SEGMENT_VON);
		list.add(ZUSTAND_21_SEGMENT_NACH);
		list.add(ZUSTAND_22_BUNDESLAND);
		list.add(ZUSTAND_23_STADT);
		list.add(ZUSTAND_40_NAME);
		list.add(ZUSTAND_41_STRASSENNAME);
		list.add(ZUSTAND_42__2_NAME);
		list.add(ZUSTAND_43_GEBIETSNAME);
		list.add(ZUSTAND_44_LINEARER_ERSTER_NAME);
		list.add(ZUSTAND_45_LINEARER_ZWEITER_NAME);
		list.add(ZUSTAND_46_KREIS);
		list.add(ZUSTAND_47_PLZ);
		list.add(ZUSTAND_48_HAUSNUMMER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsNachrichtenKlasse(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRdsNachrichtenKlasse(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
