/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommunikationsparameter zur Kommunikation mit der Landesmeldestelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class PdRdsKommunikationsParameter extends AbstractParameterDatensatz<PdRdsKommunikationsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _lMSHostRechner
				= new String
				()
				;
				private String
				 _lMSHostNutzer
				= new String
				()
				;
				private String
				 _lMSHostPasswort
				= new String
				()
				;
				private String
				 _eigeneID
				= new String
				()
				;
				private String
				 _ausgangsverzeichnis
				= new String
				()
				;
				private String
				 _eingangsverzeichnis
				= new String
				()
				;
				private 	RelativerZeitstempel
				 _sendeWiederholung
				;
				private 	RelativerZeitstempel
				 _testIntervallKommunikation
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _laufendeNummer
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
				> _akzeptierteLocationCodes = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
				> _ignorierteLocationCodes = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Hostname oder IP-Adresse des Rechners der LMS.
			<p>
			
			</p>
			
			@return der Wert von LMSHostRechner.
			*/
				public String
				 getLMSHostRechner() {
				return _lMSHostRechner;
			}
		
			/**
			Hostname oder IP-Adresse des Rechners der LMS.
			<p>
			
			</p>
			
			@param _lMSHostRechner der neue Wert von LMSHostRechner.
			*/
			public void setLMSHostRechner(String
			 _lMSHostRechner) {
				if (_lMSHostRechner.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lMSHostRechner = _lMSHostRechner;
			}
		
			/**
			Benutzername am Rechners der LMS.
			<p>
			
			</p>
			
			@return der Wert von LMSHostNutzer.
			*/
				public String
				 getLMSHostNutzer() {
				return _lMSHostNutzer;
			}
		
			/**
			Benutzername am Rechners der LMS.
			<p>
			
			</p>
			
			@param _lMSHostNutzer der neue Wert von LMSHostNutzer.
			*/
			public void setLMSHostNutzer(String
			 _lMSHostNutzer) {
				if (_lMSHostNutzer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lMSHostNutzer = _lMSHostNutzer;
			}
		
			/**
			Passwort am Rechners der LMS.
			<p>
			
			</p>
			
			@return der Wert von LMSHostPasswort.
			*/
				public String
				 getLMSHostPasswort() {
				return _lMSHostPasswort;
			}
		
			/**
			Passwort am Rechners der LMS.
			<p>
			
			</p>
			
			@param _lMSHostPasswort der neue Wert von LMSHostPasswort.
			*/
			public void setLMSHostPasswort(String
			 _lMSHostPasswort) {
				if (_lMSHostPasswort.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lMSHostPasswort = _lMSHostPasswort;
			}
		
			/**
			Eigene ID für die zu versendenden Meldungen.
			<p>
			Vorgabe für das Element 'IDOrganisation' in der XML-Datei bei zu versendenden Meldungen.
			</p>
			
			@return der Wert von EigeneID.
			*/
				public String
				 getEigeneID() {
				return _eigeneID;
			}
		
			/**
			Eigene ID für die zu versendenden Meldungen.
			<p>
			Vorgabe für das Element 'IDOrganisation' in der XML-Datei bei zu versendenden Meldungen.
			</p>
			
			@param _eigeneID der neue Wert von EigeneID.
			*/
			public void setEigeneID(String
			 _eigeneID) {
				if (_eigeneID.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._eigeneID = _eigeneID;
			}
		
			/**
			Pfad des Ausgangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem LMS-Rechner, in dem die zu versendenden Meldungen abgelegt werden sollen.&lt;&#47;absatz&gt;
									&lt;absatz&gt; Wenn der Wert nicht gesetzt ist, werden die Dateien ohne Verzeichniswechsel transferiert, d.h. in das Verzeichnis, in dem der FTP-Client nach der Anmeldung steht.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Ausgangsverzeichnis.
			*/
				public String
				 getAusgangsverzeichnis() {
				return _ausgangsverzeichnis;
			}
		
			/**
			Pfad des Ausgangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem LMS-Rechner, in dem die zu versendenden Meldungen abgelegt werden sollen.&lt;&#47;absatz&gt;
									&lt;absatz&gt; Wenn der Wert nicht gesetzt ist, werden die Dateien ohne Verzeichniswechsel transferiert, d.h. in das Verzeichnis, in dem der FTP-Client nach der Anmeldung steht.&lt;&#47;absatz&gt;
			</p>
			
			@param _ausgangsverzeichnis der neue Wert von Ausgangsverzeichnis.
			*/
			public void setAusgangsverzeichnis(String
			 _ausgangsverzeichnis) {
				if (_ausgangsverzeichnis.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ausgangsverzeichnis = _ausgangsverzeichnis;
			}
		
			/**
			Pfad des Eingangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem lokalen Rechner, in dem die Meldungen der LMS erwartet werden.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Eingangsverzeichnis.
			*/
				public String
				 getEingangsverzeichnis() {
				return _eingangsverzeichnis;
			}
		
			/**
			Pfad des Eingangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem lokalen Rechner, in dem die Meldungen der LMS erwartet werden.&lt;&#47;absatz&gt;
			</p>
			
			@param _eingangsverzeichnis der neue Wert von Eingangsverzeichnis.
			*/
			public void setEingangsverzeichnis(String
			 _eingangsverzeichnis) {
				if (_eingangsverzeichnis.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._eingangsverzeichnis = _eingangsverzeichnis;
			}
		
			/**
			Intervall Wiederholung der Sendung.
			<p>
			Intervall für die automatische Wiederholung der Übertragung gültiger ausgehender Meldungen bis zum Ende der Gültigkeitsdauer.
			</p>
			
			@return der Wert von SendeWiederholung.
			*/
				public 	RelativerZeitstempel
				 getSendeWiederholung() {
				return _sendeWiederholung;
			}
		
			/**
			Intervall Wiederholung der Sendung.
			<p>
			Intervall für die automatische Wiederholung der Übertragung gültiger ausgehender Meldungen bis zum Ende der Gültigkeitsdauer.
			</p>
			
			@param _sendeWiederholung der neue Wert von SendeWiederholung.
			*/
			public void setSendeWiederholung(	RelativerZeitstempel
			 _sendeWiederholung) {
				this._sendeWiederholung = _sendeWiederholung;
			}
		
			/**
			Zeitintervall zur Überprüfung der Kommunikation.
			<p>
			Die Kommunikation zwischen LMS und VRZ wird mit diesem Zyklus überwacht. Der Wert gilt für die Überwachung beider Richtungen.
			</p>
			
			@return der Wert von TestIntervallKommunikation.
			*/
				public 	RelativerZeitstempel
				 getTestIntervallKommunikation() {
				return _testIntervallKommunikation;
			}
		
			/**
			Zeitintervall zur Überprüfung der Kommunikation.
			<p>
			Die Kommunikation zwischen LMS und VRZ wird mit diesem Zyklus überwacht. Der Wert gilt für die Überwachung beider Richtungen.
			</p>
			
			@param _testIntervallKommunikation der neue Wert von TestIntervallKommunikation.
			*/
			public void setTestIntervallKommunikation(	RelativerZeitstempel
			 _testIntervallKommunikation) {
				this._testIntervallKommunikation = _testIntervallKommunikation;
			}
		
			/**
			Laufende Nummer der Meldung.
			<p>
			Laufende Nummer der letzten an die LMS versendeten RDS-Meldung. 
								Die Nummer wird von der SWE 2.1 LMS unmittelbar vor dem Versand gefüllt.
			</p>
			
			@return der Wert von LaufendeNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getLaufendeNummer() {
				return _laufendeNummer;
			}
		
			/**
			Laufende Nummer der Meldung.
			<p>
			Laufende Nummer der letzten an die LMS versendeten RDS-Meldung. 
								Die Nummer wird von der SWE 2.1 LMS unmittelbar vor dem Versand gefüllt.
			</p>
			
			@param _laufendeNummer der neue Wert von LaufendeNummer.
			*/
			public void setLaufendeNummer(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _laufendeNummer) {
				this._laufendeNummer = _laufendeNummer;
			}
		
			/**
			Akzeptierte Location Codes.
			<p>
			&lt;absatz&gt;Liste von Location Codes, für die RDS-Meldungen entgegengenommen werden.&lt;&#47;absatz&gt;
									&lt;absatz&gt;Wenn die Liste leer ist, werden alle Location Codes akzeptiert.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von AkzeptierteLocationCodes.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
				> getAkzeptierteLocationCodes() {
				return _akzeptierteLocationCodes;
			}
		
		
			/**
			Ignorierte Location Codes.
			<p>
			&lt;absatz&gt;Liste von Location Codes, für die RDS-Meldungen ignoriert werden.&lt;&#47;absatz&gt;
									&lt;absatz&gt;Wenn die Liste leer ist, werden alle Location Codes akzeptiert.&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von IgnorierteLocationCodes.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
				> getIgnorierteLocationCodes() {
				return _ignorierteLocationCodes;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getLMSHostRechner() != null) {
						datum.getTextValue("LMSHostRechner").setText(getLMSHostRechner());
					}
					// ZeichenkettenAttributTyp
					if (getLMSHostNutzer() != null) {
						datum.getTextValue("LMSHostNutzer").setText(getLMSHostNutzer());
					}
					// ZeichenkettenAttributTyp
					if (getLMSHostPasswort() != null) {
						datum.getTextValue("LMSHostPasswort").setText(getLMSHostPasswort());
					}
					// ZeichenkettenAttributTyp
					if (getEigeneID() != null) {
						datum.getTextValue("EigeneID").setText(getEigeneID());
					}
					// ZeichenkettenAttributTyp
					if (getAusgangsverzeichnis() != null) {
						datum.getTextValue("Ausgangsverzeichnis").setText(getAusgangsverzeichnis());
					}
					// ZeichenkettenAttributTyp
					if (getEingangsverzeichnis() != null) {
						datum.getTextValue("Eingangsverzeichnis").setText(getEingangsverzeichnis());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("SendeWiederholung").setMillis(getSendeWiederholung().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("TestIntervallKommunikation").setMillis(getTestIntervallKommunikation().getTime());
					// GanzzahlAttributTyp
					if (getLaufendeNummer() != null) {
		                if (getLaufendeNummer().isZustand()) {
		                    datum.getUnscaledValue("LaufendeNummer").setText(getLaufendeNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LaufendeNummer").set(getLaufendeNummer().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAkzeptierteLocationCodes = datum.getReferenceArray("AkzeptierteLocationCodes");
						arrayAkzeptierteLocationCodes.setLength(getAkzeptierteLocationCodes().size());
						for (int i = 0; i < arrayAkzeptierteLocationCodes.getLength(); ++i) {
							final Object soAkzeptierteLocationCodes = getAkzeptierteLocationCodes().get(i);
							final SystemObject tmpAkzeptierteLocationCodes;
							if (soAkzeptierteLocationCodes instanceof SystemObject) {
								tmpAkzeptierteLocationCodes = (SystemObject)soAkzeptierteLocationCodes;
							} else if(soAkzeptierteLocationCodes instanceof SystemObjekt){
								tmpAkzeptierteLocationCodes = ((SystemObjekt)soAkzeptierteLocationCodes).getSystemObject();
							} else{
								tmpAkzeptierteLocationCodes = null;
							}
							arrayAkzeptierteLocationCodes.getReferenceValue(i).setSystemObject(tmpAkzeptierteLocationCodes);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayIgnorierteLocationCodes = datum.getReferenceArray("IgnorierteLocationCodes");
						arrayIgnorierteLocationCodes.setLength(getIgnorierteLocationCodes().size());
						for (int i = 0; i < arrayIgnorierteLocationCodes.getLength(); ++i) {
							final Object soIgnorierteLocationCodes = getIgnorierteLocationCodes().get(i);
							final SystemObject tmpIgnorierteLocationCodes;
							if (soIgnorierteLocationCodes instanceof SystemObject) {
								tmpIgnorierteLocationCodes = (SystemObject)soIgnorierteLocationCodes;
							} else if(soIgnorierteLocationCodes instanceof SystemObjekt){
								tmpIgnorierteLocationCodes = ((SystemObjekt)soIgnorierteLocationCodes).getSystemObject();
							} else{
								tmpIgnorierteLocationCodes = null;
							}
							arrayIgnorierteLocationCodes.getReferenceValue(i).setSystemObject(tmpIgnorierteLocationCodes);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setLMSHostRechner(daten.getTextValue("LMSHostRechner").getText());
					// ZeichenkettenAttributTyp
						setLMSHostNutzer(daten.getTextValue("LMSHostNutzer").getText());
					// ZeichenkettenAttributTyp
						setLMSHostPasswort(daten.getTextValue("LMSHostPasswort").getText());
					// ZeichenkettenAttributTyp
						setEigeneID(daten.getTextValue("EigeneID").getText());
					// ZeichenkettenAttributTyp
						setAusgangsverzeichnis(daten.getTextValue("Ausgangsverzeichnis").getText());
					// ZeichenkettenAttributTyp
						setEingangsverzeichnis(daten.getTextValue("Eingangsverzeichnis").getText());
					// ZeitstempelAttributTyp
						setSendeWiederholung(new
							RelativerZeitstempel
							(daten.getTimeValue("SendeWiederholung").getMillis()));
					// ZeitstempelAttributTyp
						setTestIntervallKommunikation(new
							RelativerZeitstempel
							(daten.getTimeValue("TestIntervallKommunikation").getMillis()));
					// GanzzahlAttributTyp
							setLaufendeNummer(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("LaufendeNummer").
									longValue
							()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAkzeptierteLocationCodes = daten.getReferenceArray("AkzeptierteLocationCodes");
						for (int i = 0; i < arrayAkzeptierteLocationCodes.getLength(); ++i) {
							final long idAkzeptierteLocationCodes = daten.getReferenceArray("AkzeptierteLocationCodes").getReferenceValue(i).getId();
							final SystemObjekt tmpAkzeptierteLocationCodes;
							if (idAkzeptierteLocationCodes == 0) {
								tmpAkzeptierteLocationCodes = null;
							} else {
								final SystemObject soAkzeptierteLocationCodes = factory.getDav().getDataModel().getObject(idAkzeptierteLocationCodes);
								if (soAkzeptierteLocationCodes == null) {
										tmpAkzeptierteLocationCodes = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.impl.TmcLocationCodeUngueltig(idAkzeptierteLocationCodes);
								} else {
									tmpAkzeptierteLocationCodes = factory.getModellobjekt(soAkzeptierteLocationCodes);
								}
							}
								getAkzeptierteLocationCodes().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
								) tmpAkzeptierteLocationCodes);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayIgnorierteLocationCodes = daten.getReferenceArray("IgnorierteLocationCodes");
						for (int i = 0; i < arrayIgnorierteLocationCodes.getLength(); ++i) {
							final long idIgnorierteLocationCodes = daten.getReferenceArray("IgnorierteLocationCodes").getReferenceValue(i).getId();
							final SystemObjekt tmpIgnorierteLocationCodes;
							if (idIgnorierteLocationCodes == 0) {
								tmpIgnorierteLocationCodes = null;
							} else {
								final SystemObject soIgnorierteLocationCodes = factory.getDav().getDataModel().getObject(idIgnorierteLocationCodes);
								if (soIgnorierteLocationCodes == null) {
										tmpIgnorierteLocationCodes = new de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.impl.TmcLocationCodeUngueltig(idIgnorierteLocationCodes);
								} else {
									tmpIgnorierteLocationCodes = factory.getModellobjekt(soIgnorierteLocationCodes);
								}
							}
								getIgnorierteLocationCodes().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLocationCode
								) tmpIgnorierteLocationCodes);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setLMSHostRechner(getLMSHostRechner());
							klon.setLMSHostNutzer(getLMSHostNutzer());
							klon.setLMSHostPasswort(getLMSHostPasswort());
							klon.setEigeneID(getEigeneID());
							klon.setAusgangsverzeichnis(getAusgangsverzeichnis());
							klon.setEingangsverzeichnis(getEingangsverzeichnis());
							klon.setSendeWiederholung(getSendeWiederholung());
							klon.setTestIntervallKommunikation(getTestIntervallKommunikation());
							klon.setLaufendeNummer(getLaufendeNummer());
						klon._akzeptierteLocationCodes = getAkzeptierteLocationCodes().clone();
						klon._ignorierteLocationCodes = getIgnorierteLocationCodes().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.rdsKommunikationsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdRdsKommunikationsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
