/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Modellparameter für die RDS-Meldungserstellung.
<p>
&lt;absatz&gt;RDSSIVerfahren = Liste: Liste der Verfahren, deren Störfallindikatoren berücksichtigt werden sollen.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSBerücksichtigeStauverlaufsanalyse = Wert: Gibt an, ob die Stauobjekte aus der Stauverlaufsanalyse als Störfallindikatoren mit der Güte Wert interpretiert werden sollen.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSPlausibStauverlaufsanalyse: Gibt an, ob eine Plausibilisierung der Störfallindikatoren mit den Ergebnissen der Stauverlaufsanalyse erfolgen soll.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSLSIAusdehnung = Wert: Angenommene Ausdehnung einer Störung, die durch einen lokalen Störfallindikator detektiert wurde. Der Parameter wird in Länge pro Minute des Erfassungszyklus angegeben. Beispielsweise führt ein Parameterwert von 60 Meter pro Minute bei einer Zykluszeit der Erfassung von 5 Minuten zu einer angenommenen Ausdehnung von 300 Meter.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSVerzögerungsmatrix: Gibt die Mindestzeitspanne für Verkehrssituationsänderungen an.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSPrioritätenmatrix: Gibt die Prioritäten der Störfallsituationen in Abhängigkeit der ermittelten Güte an.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSAbbildungsmatrix: Gibt die Abbildung der Störfallsituationen auf RDS-Ereignisse an.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSDMax = Wert: Maximaler Abstand zwischen zwei Störfallgrenzen in Meter, die zu einer Zusammenfassung als ein Störfall führen kann. Wenn der Wert größer ist, werden die Störfälle als voneinander unabhängig angesehen.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSDStoerfallAnfang = Wert: Maximaler Abstand einer Störfallgrenze (z.B. Stauwurzel) in Meter zum nächsten Knoten, der dazu führt, dass der	Störfall bis zum Ende des Straßensegmentes erweitert wird.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSDStoerfallEnde = Wert: Maximaler Abstand einer Störfallgrenze (z.B. Stauende) in Meter zum nächsten Knoten, der dazu führt, dass der Störfall bis zum Anfang des Straßensegmentes erweitert wird.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSMindestLaenge = Wert: Mindestlänge in Meter eines Ereignisses, die zu einer Meldung führen kann.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSDMaxEinzelStoerfall = Wert: Maximale Längenangabe für eine Störfallsituation, die durch einen einzelnen lokalen Störfallindikator ermittelt wurde.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSNichtAddieren: Unterbindet die Addition der Längenangaben von zwei oder mehreren Störfallindikatoren innerhalb eines RDS-Abschnitts,	die nicht zu einem Ereignis zusammengefasst werden konnten.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSBaustelleSuchbereichVor = Wert: Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromaufwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSBaustelleSuchbereichNach = Wert: Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromabwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.&lt;&#47;absatz&gt;
					&lt;absatz&gt;RDSMaxOhneDaten = Wert: Zeitspanne in Minuten, in der neue Daten vorliegen müssen, damit die Meldung aufrecht erhalten bleibt.&lt;&#47;absatz&gt;
					
					
					
					&lt;absatz&gt;RDSBerücksichtigeBaustellen = Wert: Gibt an, ob als Erklärungskomponente bestehende Baustellen berücksichtigt werden sollen.&lt;&#47;absatz&gt;
					
					
					&lt;absatz&gt;RDSAusdehnungProLSI = Wert: Für (lokale) Störfallindikatoren können hier für ihre angenommenen Ausdehnung individuelle Werte angegeben werden.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class PdRdsModell extends AbstractParameterDatensatz<PdRdsModell.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				> _rDSSIVerfahren = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				>(0, true);
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _rDSBeruecksichtigeStauverlaufsanalyse
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _rDSPlausibStauverlaufsanalyse
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _rDSLSIAusdehnung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSDMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSDStoerfallAnfang
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSDStoerfallEnde
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSMindestLaenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSDMaxEinzelStoerfall
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _rDSNichtAddieren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSBaustelleSuchbereichVor
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 _rDSBaustelleSuchbereichNach
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
				 _rDSMaxOhneDaten
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerzoegerungsmatrix
				> _rDSVerzoegerungsmatrix = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerzoegerungsmatrix
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsPrioritaetenmatrix
				 _rDSPrioritaetenmatrix
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsPrioritaetenmatrix
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAbbildungsmatrix
				> _rDSAbbildungsmatrix = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAbbildungsmatrix
				>(0, true);
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _rDSBeruecksichtigeBaustellen
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAusdehnungProLSI
				> _rDSAusdehnungProLSI = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAusdehnungProLSI
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
		
			/**
			Liste der Verfahren - implementiert als Aspekte -, deren Störfallindikatoren berücksichtigt werden sollen.
			<p>
			
			</p>
			
			@return der Wert von RDSSIVerfahren.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				> getRDSSIVerfahren() {
				return _rDSSIVerfahren;
			}
		
		
			/**
			Gibt an, ob die Stauobjekte aus der Stauverlaufsanalyse als Störfallindikatoren mit der Güte Wert interpretiert werden sollen.
			<p>
			
			</p>
			
			@return der Wert von RDSBeruecksichtigeStauverlaufsanalyse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getRDSBeruecksichtigeStauverlaufsanalyse() {
				return _rDSBeruecksichtigeStauverlaufsanalyse;
			}
		
			/**
			Gibt an, ob die Stauobjekte aus der Stauverlaufsanalyse als Störfallindikatoren mit der Güte Wert interpretiert werden sollen.
			<p>
			
			</p>
			
			@param _rDSBeruecksichtigeStauverlaufsanalyse der neue Wert von RDSBeruecksichtigeStauverlaufsanalyse.
			*/
			public void setRDSBeruecksichtigeStauverlaufsanalyse(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _rDSBeruecksichtigeStauverlaufsanalyse) {
				this._rDSBeruecksichtigeStauverlaufsanalyse = _rDSBeruecksichtigeStauverlaufsanalyse;
			}
		
			/**
			Gibt an, ob eine Plausibilisierung der Störfallindikatoren mit den Ergebnissen der Stauverlaufsanalyse erfolgen soll.
			<p>
			
			</p>
			
			@return der Wert von RDSPlausibStauverlaufsanalyse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getRDSPlausibStauverlaufsanalyse() {
				return _rDSPlausibStauverlaufsanalyse;
			}
		
			/**
			Gibt an, ob eine Plausibilisierung der Störfallindikatoren mit den Ergebnissen der Stauverlaufsanalyse erfolgen soll.
			<p>
			
			</p>
			
			@param _rDSPlausibStauverlaufsanalyse der neue Wert von RDSPlausibStauverlaufsanalyse.
			*/
			public void setRDSPlausibStauverlaufsanalyse(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _rDSPlausibStauverlaufsanalyse) {
				this._rDSPlausibStauverlaufsanalyse = _rDSPlausibStauverlaufsanalyse;
			}
		
			/**
			Angenommene Ausdehnung einer Störung, die durch einen lokalen Störfallindikator detektiert wurde. Der Parameter wird in Länge pro Minute des Erfassungszyklus angegeben. Beispielsweise führt ein Parameterwert von 60 Meter pro Minute bei einer Zykluszeit der Erfassung von 5 Minuten zu einer angenommenen Ausdehnung von 300 Meter.
			<p>
			
			</p>
			
			@return der Wert von RDSLSIAusdehnung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getRDSLSIAusdehnung() {
				return _rDSLSIAusdehnung;
			}
		
			/**
			Angenommene Ausdehnung einer Störung, die durch einen lokalen Störfallindikator detektiert wurde. Der Parameter wird in Länge pro Minute des Erfassungszyklus angegeben. Beispielsweise führt ein Parameterwert von 60 Meter pro Minute bei einer Zykluszeit der Erfassung von 5 Minuten zu einer angenommenen Ausdehnung von 300 Meter.
			<p>
			
			</p>
			
			@param _rDSLSIAusdehnung der neue Wert von RDSLSIAusdehnung.
			*/
			public void setRDSLSIAusdehnung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _rDSLSIAusdehnung) {
				this._rDSLSIAusdehnung = _rDSLSIAusdehnung;
			}
		
			/**
			Maximaler Abstand zwischen zwei Störfallgrenzen in Meter, die zu einer Zusammenfassung als ein Störfall führen kann. Wenn der Wert größer ist, werden die Störfälle als voneinander unabhängig angesehen.
			<p>
			
			</p>
			
			@return der Wert von RDSDMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSDMax() {
				return _rDSDMax;
			}
		
			/**
			Maximaler Abstand zwischen zwei Störfallgrenzen in Meter, die zu einer Zusammenfassung als ein Störfall führen kann. Wenn der Wert größer ist, werden die Störfälle als voneinander unabhängig angesehen.
			<p>
			
			</p>
			
			@param _rDSDMax der neue Wert von RDSDMax.
			*/
			public void setRDSDMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSDMax) {
				this._rDSDMax = _rDSDMax;
			}
		
			/**
			Maximaler Abstand einer Störfallgrenze (z.B. Stauwurzel) in Meter zum nächsten Knoten, der dazu führt, dass der	Störfall bis zum Ende des Straßensegmentes erweitert wird.
			<p>
			
			</p>
			
			@return der Wert von RDSDStoerfallAnfang.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSDStoerfallAnfang() {
				return _rDSDStoerfallAnfang;
			}
		
			/**
			Maximaler Abstand einer Störfallgrenze (z.B. Stauwurzel) in Meter zum nächsten Knoten, der dazu führt, dass der	Störfall bis zum Ende des Straßensegmentes erweitert wird.
			<p>
			
			</p>
			
			@param _rDSDStoerfallAnfang der neue Wert von RDSDStoerfallAnfang.
			*/
			public void setRDSDStoerfallAnfang(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSDStoerfallAnfang) {
				this._rDSDStoerfallAnfang = _rDSDStoerfallAnfang;
			}
		
			/**
			Maximaler Abstand einer Störfallgrenze (z.B. Stauende) in Meter zum nächsten Knoten, der dazu führt, dass der Störfall bis zum Anfang des Straßensegmentes erweitert wird.
			<p>
			
			</p>
			
			@return der Wert von RDSDStoerfallEnde.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSDStoerfallEnde() {
				return _rDSDStoerfallEnde;
			}
		
			/**
			Maximaler Abstand einer Störfallgrenze (z.B. Stauende) in Meter zum nächsten Knoten, der dazu führt, dass der Störfall bis zum Anfang des Straßensegmentes erweitert wird.
			<p>
			
			</p>
			
			@param _rDSDStoerfallEnde der neue Wert von RDSDStoerfallEnde.
			*/
			public void setRDSDStoerfallEnde(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSDStoerfallEnde) {
				this._rDSDStoerfallEnde = _rDSDStoerfallEnde;
			}
		
			/**
			Mindestlänge in Meter eines Ereignisses, die zu einer Meldung führen kann.
			<p>
			
			</p>
			
			@return der Wert von RDSMindestLaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSMindestLaenge() {
				return _rDSMindestLaenge;
			}
		
			/**
			Mindestlänge in Meter eines Ereignisses, die zu einer Meldung führen kann.
			<p>
			
			</p>
			
			@param _rDSMindestLaenge der neue Wert von RDSMindestLaenge.
			*/
			public void setRDSMindestLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSMindestLaenge) {
				this._rDSMindestLaenge = _rDSMindestLaenge;
			}
		
			/**
			Maximale Längenangabe für eine Störfallsituation, die durch einen einzelnen lokalen Störfallindikator ermittelt wurde.
			<p>
			
			</p>
			
			@return der Wert von RDSDMaxEinzelStoerfall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSDMaxEinzelStoerfall() {
				return _rDSDMaxEinzelStoerfall;
			}
		
			/**
			Maximale Längenangabe für eine Störfallsituation, die durch einen einzelnen lokalen Störfallindikator ermittelt wurde.
			<p>
			
			</p>
			
			@param _rDSDMaxEinzelStoerfall der neue Wert von RDSDMaxEinzelStoerfall.
			*/
			public void setRDSDMaxEinzelStoerfall(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSDMaxEinzelStoerfall) {
				this._rDSDMaxEinzelStoerfall = _rDSDMaxEinzelStoerfall;
			}
		
			/**
			Unterbindet die Addition der Längenangaben von zwei oder mehreren Störfallindikatoren innerhalb eines RDS-Abschnitts,	die nicht zu einem Ereignis zusammengefasst werden konnten.
			<p>
			
			</p>
			
			@return der Wert von RDSNichtAddieren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getRDSNichtAddieren() {
				return _rDSNichtAddieren;
			}
		
			/**
			Unterbindet die Addition der Längenangaben von zwei oder mehreren Störfallindikatoren innerhalb eines RDS-Abschnitts,	die nicht zu einem Ereignis zusammengefasst werden konnten.
			<p>
			
			</p>
			
			@param _rDSNichtAddieren der neue Wert von RDSNichtAddieren.
			*/
			public void setRDSNichtAddieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _rDSNichtAddieren) {
				this._rDSNichtAddieren = _rDSNichtAddieren;
			}
		
			/**
			Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromaufwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.
			<p>
			
			</p>
			
			@return der Wert von RDSBaustelleSuchbereichVor.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSBaustelleSuchbereichVor() {
				return _rDSBaustelleSuchbereichVor;
			}
		
			/**
			Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromaufwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.
			<p>
			
			</p>
			
			@param _rDSBaustelleSuchbereichVor der neue Wert von RDSBaustelleSuchbereichVor.
			*/
			public void setRDSBaustelleSuchbereichVor(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSBaustelleSuchbereichVor) {
				this._rDSBaustelleSuchbereichVor = _rDSBaustelleSuchbereichVor;
			}
		
			/**
			Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromabwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.
			<p>
			
			</p>
			
			@return der Wert von RDSBaustelleSuchbereichNach.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
				 getRDSBaustelleSuchbereichNach() {
				return _rDSBaustelleSuchbereichNach;
			}
		
			/**
			Erweiterung des Suchbereichs für Baustellen als Erklärungskomponente stromabwärts. Die Erweiterung wird durch Autobahnkreuze oder Dreiecke beschränkt; d.h. eventuelle Baustellen hinter einem Autobahnkreuz oder Dreieck werden nicht als Erklärungskomponente bei der Meldungserstellung berücksichtigt.
			<p>
			
			</p>
			
			@param _rDSBaustelleSuchbereichNach der neue Wert von RDSBaustelleSuchbereichNach.
			*/
			public void setRDSBaustelleSuchbereichNach(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
			 _rDSBaustelleSuchbereichNach) {
				this._rDSBaustelleSuchbereichNach = _rDSBaustelleSuchbereichNach;
			}
		
			/**
			Zeitspanne in Minuten, in der neue Daten vorliegen müssen, damit die Meldung aufrecht erhalten bleibt.
			<p>
			
			</p>
			
			@return der Wert von RDSMaxOhneDaten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
				 getRDSMaxOhneDaten() {
				return _rDSMaxOhneDaten;
			}
		
			/**
			Zeitspanne in Minuten, in der neue Daten vorliegen müssen, damit die Meldung aufrecht erhalten bleibt.
			<p>
			
			</p>
			
			@param _rDSMaxOhneDaten der neue Wert von RDSMaxOhneDaten.
			*/
			public void setRDSMaxOhneDaten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 _rDSMaxOhneDaten) {
				this._rDSMaxOhneDaten = _rDSMaxOhneDaten;
			}
		
			/**
			Gibt die Mindestzeitspanne für Verkehrssituationsänderungen an.
			<p>
			
			</p>
			
			@return der Wert von RDSVerzoegerungsmatrix.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerzoegerungsmatrix
				> getRDSVerzoegerungsmatrix() {
				return _rDSVerzoegerungsmatrix;
			}
		
		
			/**
			Gibt die Prioritäten der Störfallsituationen in Abhängigkeit der ermittelten Güte an.
			<p>
			
			</p>
			
			@return der Wert von RDSPrioritaetenmatrix.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsPrioritaetenmatrix
				 getRDSPrioritaetenmatrix() {
				return _rDSPrioritaetenmatrix;
			}
		
			/**
			Gibt die Prioritäten der Störfallsituationen in Abhängigkeit der ermittelten Güte an.
			<p>
			
			</p>
			
			@param _rDSPrioritaetenmatrix der neue Wert von RDSPrioritaetenmatrix.
			*/
			public void setRDSPrioritaetenmatrix(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsPrioritaetenmatrix
			 _rDSPrioritaetenmatrix) {
				this._rDSPrioritaetenmatrix = _rDSPrioritaetenmatrix;
			}
		
			/**
			Gibt die Abbildung der Störfallsituationen auf RDS-Ereignisse an.
			<p>
			
			</p>
			
			@return der Wert von RDSAbbildungsmatrix.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAbbildungsmatrix
				> getRDSAbbildungsmatrix() {
				return _rDSAbbildungsmatrix;
			}
		
		
			/**
			Gibt an, ob als Erklärungskomponente bestehende Baustellen berücksichtigt werden sollen.
			<p>
			
			</p>
			
			@return der Wert von RDSBeruecksichtigeBaustellen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getRDSBeruecksichtigeBaustellen() {
				return _rDSBeruecksichtigeBaustellen;
			}
		
			/**
			Gibt an, ob als Erklärungskomponente bestehende Baustellen berücksichtigt werden sollen.
			<p>
			
			</p>
			
			@param _rDSBeruecksichtigeBaustellen der neue Wert von RDSBeruecksichtigeBaustellen.
			*/
			public void setRDSBeruecksichtigeBaustellen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _rDSBeruecksichtigeBaustellen) {
				this._rDSBeruecksichtigeBaustellen = _rDSBeruecksichtigeBaustellen;
			}
		
			/**
			Für (lokale) Störfallindikatoren können hier für ihre angenommenen Ausdehnung individuelle Werte angegeben werden.
			<p>
			
			</p>
			
			@return der Wert von RDSAusdehnungProLSI.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAusdehnungProLSI
				> getRDSAusdehnungProLSI() {
				return _rDSAusdehnungProLSI;
			}
		
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRDSSIVerfahren = datum.getReferenceArray("RDSSIVerfahren");
						arrayRDSSIVerfahren.setLength(getRDSSIVerfahren().size());
						for (int i = 0; i < arrayRDSSIVerfahren.getLength(); ++i) {
							final Object soRDSSIVerfahren = getRDSSIVerfahren().get(i);
							final SystemObject tmpRDSSIVerfahren;
							if (soRDSSIVerfahren instanceof SystemObject) {
								tmpRDSSIVerfahren = (SystemObject)soRDSSIVerfahren;
							} else if(soRDSSIVerfahren instanceof SystemObjekt){
								tmpRDSSIVerfahren = ((SystemObjekt)soRDSSIVerfahren).getSystemObject();
							} else{
								tmpRDSSIVerfahren = null;
							}
							arrayRDSSIVerfahren.getReferenceValue(i).setSystemObject(tmpRDSSIVerfahren);
						}
					// GanzzahlAttributTyp
					if (getRDSBeruecksichtigeStauverlaufsanalyse() != null) {
		                if (getRDSBeruecksichtigeStauverlaufsanalyse().isZustand()) {
		                    datum.getUnscaledValue("RDSBerücksichtigeStauverlaufsanalyse").setText(getRDSBeruecksichtigeStauverlaufsanalyse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSBerücksichtigeStauverlaufsanalyse").set(getRDSBeruecksichtigeStauverlaufsanalyse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSPlausibStauverlaufsanalyse() != null) {
		                if (getRDSPlausibStauverlaufsanalyse().isZustand()) {
		                    datum.getUnscaledValue("RDSPlausibStauverlaufsanalyse").setText(getRDSPlausibStauverlaufsanalyse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSPlausibStauverlaufsanalyse").set(getRDSPlausibStauverlaufsanalyse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSLSIAusdehnung() != null) {
		                if (getRDSLSIAusdehnung().isZustand()) {
		                    datum.getUnscaledValue("RDSLSIAusdehnung").setText(getRDSLSIAusdehnung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSLSIAusdehnung").set(getRDSLSIAusdehnung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSDMax() != null) {
		                if (getRDSDMax().isZustand()) {
		                    datum.getUnscaledValue("RDSDMax").setText(getRDSDMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSDMax").set(getRDSDMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSDStoerfallAnfang() != null) {
		                if (getRDSDStoerfallAnfang().isZustand()) {
		                    datum.getUnscaledValue("RDSDStoerfallAnfang").setText(getRDSDStoerfallAnfang().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSDStoerfallAnfang").set(getRDSDStoerfallAnfang().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSDStoerfallEnde() != null) {
		                if (getRDSDStoerfallEnde().isZustand()) {
		                    datum.getUnscaledValue("RDSDStoerfallEnde").setText(getRDSDStoerfallEnde().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSDStoerfallEnde").set(getRDSDStoerfallEnde().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSMindestLaenge() != null) {
		                if (getRDSMindestLaenge().isZustand()) {
		                    datum.getUnscaledValue("RDSMindestLaenge").setText(getRDSMindestLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSMindestLaenge").set(getRDSMindestLaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSDMaxEinzelStoerfall() != null) {
		                if (getRDSDMaxEinzelStoerfall().isZustand()) {
		                    datum.getUnscaledValue("RDSDMaxEinzelStoerfall").setText(getRDSDMaxEinzelStoerfall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSDMaxEinzelStoerfall").set(getRDSDMaxEinzelStoerfall().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSNichtAddieren() != null) {
		                if (getRDSNichtAddieren().isZustand()) {
		                    datum.getUnscaledValue("RDSNichtAddieren").setText(getRDSNichtAddieren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSNichtAddieren").set(getRDSNichtAddieren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSBaustelleSuchbereichVor() != null) {
		                if (getRDSBaustelleSuchbereichVor().isZustand()) {
		                    datum.getUnscaledValue("RDSBaustelleSuchbereichVor").setText(getRDSBaustelleSuchbereichVor().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSBaustelleSuchbereichVor").set(getRDSBaustelleSuchbereichVor().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSBaustelleSuchbereichNach() != null) {
		                if (getRDSBaustelleSuchbereichNach().isZustand()) {
		                    datum.getUnscaledValue("RDSBaustelleSuchbereichNach").setText(getRDSBaustelleSuchbereichNach().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSBaustelleSuchbereichNach").set(getRDSBaustelleSuchbereichNach().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getRDSMaxOhneDaten() != null) {
		                if (getRDSMaxOhneDaten().isZustand()) {
		                    datum.getUnscaledValue("RDSMaxOhneDaten").setText(getRDSMaxOhneDaten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSMaxOhneDaten").set(getRDSMaxOhneDaten().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayRDSVerzoegerungsmatrix = datum.getArray("RDSVerzögerungsmatrix");
						arrayRDSVerzoegerungsmatrix.setLength(getRDSVerzoegerungsmatrix().size());
						for (int i = 0; i < arrayRDSVerzoegerungsmatrix.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerzoegerungsmatrix
							 atl = getRDSVerzoegerungsmatrix().get(i);
							atl.bean2Atl(arrayRDSVerzoegerungsmatrix.getItem(i), factory);
		
						}
					// AttributListenDefinition
						getRDSPrioritaetenmatrix().bean2Atl(datum.getItem("RDSPrioritätenmatrix"), factory);
					// AttributListenDefinition
						final Data.Array arrayRDSAbbildungsmatrix = datum.getArray("RDSAbbildungsmatrix");
						arrayRDSAbbildungsmatrix.setLength(getRDSAbbildungsmatrix().size());
						for (int i = 0; i < arrayRDSAbbildungsmatrix.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAbbildungsmatrix
							 atl = getRDSAbbildungsmatrix().get(i);
							atl.bean2Atl(arrayRDSAbbildungsmatrix.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getRDSBeruecksichtigeBaustellen() != null) {
		                if (getRDSBeruecksichtigeBaustellen().isZustand()) {
		                    datum.getUnscaledValue("RDSBerücksichtigeBaustellen").setText(getRDSBeruecksichtigeBaustellen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("RDSBerücksichtigeBaustellen").set(getRDSBeruecksichtigeBaustellen().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayRDSAusdehnungProLSI = datum.getArray("RDSAusdehnungProLSI");
						arrayRDSAusdehnungProLSI.setLength(getRDSAusdehnungProLSI().size());
						for (int i = 0; i < arrayRDSAusdehnungProLSI.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAusdehnungProLSI
							 atl = getRDSAusdehnungProLSI().get(i);
							atl.bean2Atl(arrayRDSAusdehnungProLSI.getItem(i), factory);
		
						}
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayRDSSIVerfahren = daten.getReferenceArray("RDSSIVerfahren");
						for (int i = 0; i < arrayRDSSIVerfahren.getLength(); ++i) {
							final long idRDSSIVerfahren = daten.getReferenceArray("RDSSIVerfahren").getReferenceValue(i).getId();
							final SystemObjekt tmpRDSSIVerfahren;
							if (idRDSSIVerfahren == 0) {
								tmpRDSSIVerfahren = null;
							} else {
								final SystemObject soRDSSIVerfahren = factory.getDav().getDataModel().getObject(idRDSSIVerfahren);
								if (soRDSSIVerfahren == null) {
										tmpRDSSIVerfahren = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idRDSSIVerfahren);
								} else {
									tmpRDSSIVerfahren = factory.getModellobjekt(soRDSSIVerfahren);
								}
							}
								getRDSSIVerfahren().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
								) tmpRDSSIVerfahren);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSBerücksichtigeStauverlaufsanalyse").isState()) {
								setRDSBeruecksichtigeStauverlaufsanalyse(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("RDSBerücksichtigeStauverlaufsanalyse").getText()));
							} else {
							setRDSBeruecksichtigeStauverlaufsanalyse(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("RDSBerücksichtigeStauverlaufsanalyse").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSPlausibStauverlaufsanalyse").isState()) {
								setRDSPlausibStauverlaufsanalyse(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("RDSPlausibStauverlaufsanalyse").getText()));
							} else {
							setRDSPlausibStauverlaufsanalyse(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("RDSPlausibStauverlaufsanalyse").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setRDSLSIAusdehnung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("RDSLSIAusdehnung").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSDMax").isState()) {
								setRDSDMax(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSDMax").getText()));
							} else {
							setRDSDMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSDMax").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSDStoerfallAnfang").isState()) {
								setRDSDStoerfallAnfang(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSDStoerfallAnfang").getText()));
							} else {
							setRDSDStoerfallAnfang(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSDStoerfallAnfang").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSDStoerfallEnde").isState()) {
								setRDSDStoerfallEnde(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSDStoerfallEnde").getText()));
							} else {
							setRDSDStoerfallEnde(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSDStoerfallEnde").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSMindestLaenge").isState()) {
								setRDSMindestLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSMindestLaenge").getText()));
							} else {
							setRDSMindestLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSMindestLaenge").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSDMaxEinzelStoerfall").isState()) {
								setRDSDMaxEinzelStoerfall(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSDMaxEinzelStoerfall").getText()));
							} else {
							setRDSDMaxEinzelStoerfall(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSDMaxEinzelStoerfall").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSNichtAddieren").isState()) {
								setRDSNichtAddieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("RDSNichtAddieren").getText()));
							} else {
							setRDSNichtAddieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("RDSNichtAddieren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSBaustelleSuchbereichVor").isState()) {
								setRDSBaustelleSuchbereichVor(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSBaustelleSuchbereichVor").getText()));
							} else {
							setRDSBaustelleSuchbereichVor(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSBaustelleSuchbereichVor").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSBaustelleSuchbereichNach").isState()) {
								setRDSBaustelleSuchbereichNach(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
								.getZustand(daten.getScaledValue("RDSBaustelleSuchbereichNach").getText()));
							} else {
							setRDSBaustelleSuchbereichNach(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern
							(daten.
								getUnscaledValue
							("RDSBaustelleSuchbereichNach").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSMaxOhneDaten").isState()) {
								setRDSMaxOhneDaten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
								.getZustand(daten.getScaledValue("RDSMaxOhneDaten").getText()));
							} else {
							setRDSMaxOhneDaten(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
							(daten.
								getUnscaledValue
							("RDSMaxOhneDaten").
									longValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayRDSVerzoegerungsmatrix = daten.getArray("RDSVerzögerungsmatrix");
						for (int i = 0; i < arrayRDSVerzoegerungsmatrix.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerzoegerungsmatrix
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsVerzoegerungsmatrix
							 ();
							atl.atl2Bean(arrayRDSVerzoegerungsmatrix.getItem(i), factory);
							getRDSVerzoegerungsmatrix().add(atl);
						}
					// AttributListenDefinition
						getRDSPrioritaetenmatrix().atl2Bean(daten.getItem("RDSPrioritätenmatrix"), factory);
					// AttributListenDefinition
						final Data.Array arrayRDSAbbildungsmatrix = daten.getArray("RDSAbbildungsmatrix");
						for (int i = 0; i < arrayRDSAbbildungsmatrix.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAbbildungsmatrix
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAbbildungsmatrix
							 ();
							atl.atl2Bean(arrayRDSAbbildungsmatrix.getItem(i), factory);
							getRDSAbbildungsmatrix().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("RDSBerücksichtigeBaustellen").isState()) {
								setRDSBeruecksichtigeBaustellen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("RDSBerücksichtigeBaustellen").getText()));
							} else {
							setRDSBeruecksichtigeBaustellen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("RDSBerücksichtigeBaustellen").
									byteValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayRDSAusdehnungProLSI = daten.getArray("RDSAusdehnungProLSI");
						for (int i = 0; i < arrayRDSAusdehnungProLSI.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAusdehnungProLSI
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAusdehnungProLSI
							 ();
							atl.atl2Bean(arrayRDSAusdehnungProLSI.getItem(i), factory);
							getRDSAusdehnungProLSI().add(atl);
						}
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._rDSSIVerfahren = getRDSSIVerfahren().clone();
							klon.setRDSBeruecksichtigeStauverlaufsanalyse(getRDSBeruecksichtigeStauverlaufsanalyse());
							klon.setRDSPlausibStauverlaufsanalyse(getRDSPlausibStauverlaufsanalyse());
							klon.setRDSLSIAusdehnung(getRDSLSIAusdehnung());
							klon.setRDSDMax(getRDSDMax());
							klon.setRDSDStoerfallAnfang(getRDSDStoerfallAnfang());
							klon.setRDSDStoerfallEnde(getRDSDStoerfallEnde());
							klon.setRDSMindestLaenge(getRDSMindestLaenge());
							klon.setRDSDMaxEinzelStoerfall(getRDSDMaxEinzelStoerfall());
							klon.setRDSNichtAddieren(getRDSNichtAddieren());
							klon.setRDSBaustelleSuchbereichVor(getRDSBaustelleSuchbereichVor());
							klon.setRDSBaustelleSuchbereichNach(getRDSBaustelleSuchbereichNach());
							klon.setRDSMaxOhneDaten(getRDSMaxOhneDaten());
						klon._rDSVerzoegerungsmatrix = getRDSVerzoegerungsmatrix().clone();
							klon._rDSPrioritaetenmatrix = getRDSPrioritaetenmatrix().clone();
						klon._rDSAbbildungsmatrix = getRDSAbbildungsmatrix().clone();
							klon.setRDSBeruecksichtigeBaustellen(getRDSBeruecksichtigeBaustellen());
						klon._rDSAusdehnungProLSI = getRDSAusdehnungProLSI().clone();
							klon._urlasser = getUrlasser().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.rdsModell";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdRdsModell(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
