/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung des Ereignisses.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3Description implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _kultur
			= new String
			()
			;
			private String
			 _text
			= new String
			()
			;
	
		/**
		Kultur.
		<p>
		TIC Info XML Element: Culture (CUL), The culture as defined by Microsoft .NET. The culture is a combination of an ISO	639 two-letter lowercase culture code associated with a language and an ISO 3166 two-letter uppercase subculture code associated with a country or region.
		</p>
		
		@return der Wert von Kultur.
		*/
			public String
			 getKultur() {
			return _kultur;
		}
	
		/**
		Kultur.
		<p>
		TIC Info XML Element: Culture (CUL), The culture as defined by Microsoft .NET. The culture is a combination of an ISO	639 two-letter lowercase culture code associated with a language and an ISO 3166 two-letter uppercase subculture code associated with a country or region.
		</p>
		
		@param _kultur der neue Wert von Kultur.
		*/
		public void setKultur(String
		 _kultur) {
			if (_kultur.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kultur = _kultur;
		}
	
		/**
		Ereignistext.
		<p>
		TIC Info XML Element: Text (TEX), The culture-dependent text.
		</p>
		
		@return der Wert von Text.
		*/
			public String
			 getText() {
			return _text;
		}
	
		/**
		Ereignistext.
		<p>
		TIC Info XML Element: Text (TEX), The culture-dependent text.
		</p>
		
		@param _text der neue Wert von Text.
		*/
		public void setText(String
		 _text) {
			if (_text.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._text = _text;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getKultur() != null) {
					datum.getTextValue("Kultur").setText(getKultur());
				}
				// ZeichenkettenAttributTyp
				if (getText() != null) {
					datum.getTextValue("Text").setText(getText());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setKultur(daten.getTextValue("Kultur").getText());
				// ZeichenkettenAttributTyp
					setText(daten.getTextValue("Text").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Description clone() {
		AtlTic3Description klon = new AtlTic3Description();
		
						klon.setKultur(getKultur());
						klon.setText(getText());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
