/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Lokationsinformationen mit WGS-Koordinaten.
<p>
Entspricht TIC3 Info Typ 'ShapeType'.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3KoordinatenLocation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationKoordinaten
			> _tIC3Koordinaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationKoordinaten
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3LocationTypeEnum
			 _tIC3LocationType
			;
	
		/**
		TIC3-Lokationkoordinaten.
		<p>
		&gt;Entspricht TIC3 XML Element: Coordinate (COR), TIC3 Info Typ 'CoordinateType'.
		</p>
		
		@return der Wert von TIC3Koordinaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationKoordinaten
			> getTIC3Koordinaten() {
			return _tIC3Koordinaten;
		}
	
	
		/**
		TIC3-Lokationtyp.
		<p>
		Entspricht TIC3 XML Element: Type (TYP), TIC3 Info Typ 'LocationTypEnum'.
		</p>
		
		@return der Wert von TIC3LocationType.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3LocationTypeEnum
			 getTIC3LocationType() {
			return _tIC3LocationType;
		}
	
		/**
		TIC3-Lokationtyp.
		<p>
		Entspricht TIC3 XML Element: Type (TYP), TIC3 Info Typ 'LocationTypEnum'.
		</p>
		
		@param _tIC3LocationType der neue Wert von TIC3LocationType.
		*/
		public void setTIC3LocationType(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3LocationTypeEnum
		 _tIC3LocationType) {
			this._tIC3LocationType = _tIC3LocationType;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayTIC3Koordinaten = datum.getArray("TIC3Koordinaten");
					arrayTIC3Koordinaten.setLength(getTIC3Koordinaten().size());
					for (int i = 0; i < arrayTIC3Koordinaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationKoordinaten
						 atl = getTIC3Koordinaten().get(i);
						atl.bean2Atl(arrayTIC3Koordinaten.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getTIC3LocationType() != null) {
	                if (getTIC3LocationType().isZustand()) {
	                    datum.getUnscaledValue("TIC3LocationType").setText(getTIC3LocationType().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TIC3LocationType").set(getTIC3LocationType().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayTIC3Koordinaten = daten.getArray("TIC3Koordinaten");
					for (int i = 0; i < arrayTIC3Koordinaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationKoordinaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationKoordinaten
						 ();
						atl.atl2Bean(arrayTIC3Koordinaten.getItem(i), factory);
						getTIC3Koordinaten().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TIC3LocationType").isState()) {
							setTIC3LocationType(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3LocationTypeEnum
							.getZustand(daten.getScaledValue("TIC3LocationType").getText()));
						} else {
						setTIC3LocationType(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3LocationTypeEnum
						(daten.
							getUnscaledValue
						("TIC3LocationType").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3KoordinatenLocation clone() {
		AtlTic3KoordinatenLocation klon = new AtlTic3KoordinatenLocation();
		
					klon._tIC3Koordinaten = getTIC3Koordinaten().clone();
						klon.setTIC3LocationType(getTIC3LocationType());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
