/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Entspricht TIC3 Typ 'NetworkAreaType'.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3NetworkArea implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private String
			 _gebietskennung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkAreaDescriptionType
			> _gebietsBeschreibung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkAreaDescriptionType
			>(1, true);
	
		/**
		Beschreibung des Gebietes.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element NetworkArea.
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung des Gebietes.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element NetworkArea.
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		TIC3 Gebietskennung.
		<p>
		TIC Info XML Element: NetworkAreaIdentifier (NAI),  A reference to "Area".
		</p>
		
		@return der Wert von Gebietskennung.
		*/
			public String
			 getGebietskennung() {
			return _gebietskennung;
		}
	
		/**
		TIC3 Gebietskennung.
		<p>
		TIC Info XML Element: NetworkAreaIdentifier (NAI),  A reference to "Area".
		</p>
		
		@param _gebietskennung der neue Wert von Gebietskennung.
		*/
		public void setGebietskennung(String
		 _gebietskennung) {
			if (_gebietskennung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._gebietskennung = _gebietskennung;
		}
	
		/**
		TIC3 Netzgebietbeschreibung.
		<p>
		TIC Info XML Element: Description (DES), Descriptive information about the area such as the name and category, normally as a copy of the referenced "Area" data.
		</p>
		
		@return der Wert von GebietsBeschreibung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkAreaDescriptionType
			> getGebietsBeschreibung() {
			return _gebietsBeschreibung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeichenkettenAttributTyp
				if (getGebietskennung() != null) {
					datum.getTextValue("Gebietskennung").setText(getGebietskennung());
				}
				// AttributListenDefinition
					final Data.Array arrayGebietsBeschreibung = datum.getArray("GebietsBeschreibung");
					arrayGebietsBeschreibung.setLength(getGebietsBeschreibung().size());
					for (int i = 0; i < arrayGebietsBeschreibung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkAreaDescriptionType
						 atl = getGebietsBeschreibung().get(i);
						atl.bean2Atl(arrayGebietsBeschreibung.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeichenkettenAttributTyp
					setGebietskennung(daten.getTextValue("Gebietskennung").getText());
				// AttributListenDefinition
					final Data.Array arrayGebietsBeschreibung = daten.getArray("GebietsBeschreibung");
					for (int i = 0; i < arrayGebietsBeschreibung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkAreaDescriptionType
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkAreaDescriptionType
						 ();
						atl.atl2Bean(arrayGebietsBeschreibung.getItem(i), factory);
						getGebietsBeschreibung().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3NetworkArea clone() {
		AtlTic3NetworkArea klon = new AtlTic3NetworkArea();
		
						klon.setBeschreibung(getBeschreibung());
						klon.setGebietskennung(getGebietskennung());
					klon._gebietsBeschreibung = getGebietsBeschreibung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
