/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Quelle.
<p>
TIC3 UnspecificVersionReferenceExtendedType.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3Quelle implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private String
			 _objektTyp
			= new String
			()
			;
			private String
			 _ticId
			= new String
			()
			;
			private Feld<	Zeitstempel
			> _tIC3DatenErzeugungsZeit = new Feld<	Zeitstempel
			>(1, true);
			private String
			 _tIC3Quelldatenproduzent
			= new String
			()
			;
			private String
			 _tIC3QuelldatenBeschreibung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugung
			> _tIC3ErgebnisErzeugung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugung
			>(1, true);
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Objekttyp.
		<p>
		TIC3 Info XML Element: ObjectType (OTY), The Identifier of the object type.
		</p>
		
		@return der Wert von ObjektTyp.
		*/
			public String
			 getObjektTyp() {
			return _objektTyp;
		}
	
		/**
		Objekttyp.
		<p>
		TIC3 Info XML Element: ObjectType (OTY), The Identifier of the object type.
		</p>
		
		@param _objektTyp der neue Wert von ObjektTyp.
		*/
		public void setObjektTyp(String
		 _objektTyp) {
			if (_objektTyp.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._objektTyp = _objektTyp;
		}
	
		/**
		Identifikator.
		<p>
		TIC3 Info XML Element: TicId (TID), An identifier which is unique across all systems using TIC for this object type.
		</p>
		
		@return der Wert von TicId.
		*/
			public String
			 getTicId() {
			return _ticId;
		}
	
		/**
		Identifikator.
		<p>
		TIC3 Info XML Element: TicId (TID), An identifier which is unique across all systems using TIC for this object type.
		</p>
		
		@param _ticId der neue Wert von TicId.
		*/
		public void setTicId(String
		 _ticId) {
			if (_ticId.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ticId = _ticId;
		}
	
		/**
		TIC3 Datenerzeugungszeit.
		<p>
		TIC Info XML Element: CreateTime (CRT), The date and time when the data contained in this object version was created.
		</p>
		
		@return der Wert von TIC3DatenErzeugungsZeit.
		*/
			public Feld<	Zeitstempel
			> getTIC3DatenErzeugungsZeit() {
			return _tIC3DatenErzeugungsZeit;
		}
	
	
		/**
		Quelldatenproduzent.
		<p>
		TIC3 Info XML Element: SourceDataProducer (SDP), The data producer of the source data. A reference to "Organization".
		</p>
		
		@return der Wert von TIC3Quelldatenproduzent.
		*/
			public String
			 getTIC3Quelldatenproduzent() {
			return _tIC3Quelldatenproduzent;
		}
	
		/**
		Quelldatenproduzent.
		<p>
		TIC3 Info XML Element: SourceDataProducer (SDP), The data producer of the source data. A reference to "Organization".
		</p>
		
		@param _tIC3Quelldatenproduzent der neue Wert von TIC3Quelldatenproduzent.
		*/
		public void setTIC3Quelldatenproduzent(String
		 _tIC3Quelldatenproduzent) {
			if (_tIC3Quelldatenproduzent.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3Quelldatenproduzent = _tIC3Quelldatenproduzent;
		}
	
		/**
		Quelldaten-Beschreibung.
		<p>
		TIC3 Info XML Element: SourceDescription (SDS), A culture-dependent description of the source data.
		</p>
		
		@return der Wert von TIC3QuelldatenBeschreibung.
		*/
			public String
			 getTIC3QuelldatenBeschreibung() {
			return _tIC3QuelldatenBeschreibung;
		}
	
		/**
		Quelldaten-Beschreibung.
		<p>
		TIC3 Info XML Element: SourceDescription (SDS), A culture-dependent description of the source data.
		</p>
		
		@param _tIC3QuelldatenBeschreibung der neue Wert von TIC3QuelldatenBeschreibung.
		*/
		public void setTIC3QuelldatenBeschreibung(String
		 _tIC3QuelldatenBeschreibung) {
			if (_tIC3QuelldatenBeschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3QuelldatenBeschreibung = _tIC3QuelldatenBeschreibung;
		}
	
		/**
		Ergebnis erzeugen.
		<p>
		TIC3 Info XML Element: CreateResult (CRE), Settings used to create the data contained in this object.
		</p>
		
		@return der Wert von TIC3ErgebnisErzeugung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugung
			> getTIC3ErgebnisErzeugung() {
			return _tIC3ErgebnisErzeugung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeichenkettenAttributTyp
				if (getObjektTyp() != null) {
					datum.getTextValue("ObjektTyp").setText(getObjektTyp());
				}
				// ZeichenkettenAttributTyp
				if (getTicId() != null) {
					datum.getTextValue("TicId").setText(getTicId());
				}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayTIC3DatenErzeugungsZeit = datum.getTimeArray("TIC3DatenErzeugungsZeit");
					arrayTIC3DatenErzeugungsZeit.setLength(getTIC3DatenErzeugungsZeit().size());
					for (int i = 0; i < arrayTIC3DatenErzeugungsZeit.getLength(); ++i) {
						arrayTIC3DatenErzeugungsZeit.getTimeValue(i).setMillis(getTIC3DatenErzeugungsZeit().get(i).getTime());
					}
				// ZeichenkettenAttributTyp
				if (getTIC3Quelldatenproduzent() != null) {
					datum.getTextValue("TIC3Quelldatenproduzent").setText(getTIC3Quelldatenproduzent());
				}
				// ZeichenkettenAttributTyp
				if (getTIC3QuelldatenBeschreibung() != null) {
					datum.getTextValue("TIC3QuelldatenBeschreibung").setText(getTIC3QuelldatenBeschreibung());
				}
				// AttributListenDefinition
					final Data.Array arrayTIC3ErgebnisErzeugung = datum.getArray("TIC3ErgebnisErzeugung");
					arrayTIC3ErgebnisErzeugung.setLength(getTIC3ErgebnisErzeugung().size());
					for (int i = 0; i < arrayTIC3ErgebnisErzeugung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugung
						 atl = getTIC3ErgebnisErzeugung().get(i);
						atl.bean2Atl(arrayTIC3ErgebnisErzeugung.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeichenkettenAttributTyp
					setObjektTyp(daten.getTextValue("ObjektTyp").getText());
				// ZeichenkettenAttributTyp
					setTicId(daten.getTextValue("TicId").getText());
				// ZeitstempelAttributTyp
					final Data.Array arrayTIC3DatenErzeugungsZeit = daten.getArray("TIC3DatenErzeugungsZeit");
					for (int i = 0; i < arrayTIC3DatenErzeugungsZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayTIC3DatenErzeugungsZeit.getItem(i).asTimeValue().getMillis());
						getTIC3DatenErzeugungsZeit().add(atl);
					}
				// ZeichenkettenAttributTyp
					setTIC3Quelldatenproduzent(daten.getTextValue("TIC3Quelldatenproduzent").getText());
				// ZeichenkettenAttributTyp
					setTIC3QuelldatenBeschreibung(daten.getTextValue("TIC3QuelldatenBeschreibung").getText());
				// AttributListenDefinition
					final Data.Array arrayTIC3ErgebnisErzeugung = daten.getArray("TIC3ErgebnisErzeugung");
					for (int i = 0; i < arrayTIC3ErgebnisErzeugung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugung
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugung
						 ();
						atl.atl2Bean(arrayTIC3ErgebnisErzeugung.getItem(i), factory);
						getTIC3ErgebnisErzeugung().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Quelle clone() {
		AtlTic3Quelle klon = new AtlTic3Quelle();
		
						klon.setBeschreibung(getBeschreibung());
						klon.setObjektTyp(getObjektTyp());
						klon.setTicId(getTicId());
					klon._tIC3DatenErzeugungsZeit = getTIC3DatenErzeugungsZeit().clone();
						klon.setTIC3Quelldatenproduzent(getTIC3Quelldatenproduzent());
						klon.setTIC3QuelldatenBeschreibung(getTIC3QuelldatenBeschreibung());
					klon._tIC3ErgebnisErzeugung = getTIC3ErgebnisErzeugung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
