/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 RecurrenceType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3RecurrenceType implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Wochentag
			> _wochentage = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Wochentag
			>(0, true);
			private String
			 _startzeit
			= new String
			()
			;
			private String
			 _endzeit
			= new String
			()
			;
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Wochentage.
		<p>
		TIC3 Info XML Element: DayOfWeek (DOW), A list of days of the week such as Monday and Tuesday.
		</p>
		
		@return der Wert von Wochentage.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Wochentag
			> getWochentage() {
			return _wochentage;
		}
	
	
		/**
		Startzeit.
		<p>
		TIC3 Info XML Element: StartTime (STA), The start time on each of the specified days of week.
		</p>
		
		@return der Wert von Startzeit.
		*/
			public String
			 getStartzeit() {
			return _startzeit;
		}
	
		/**
		Startzeit.
		<p>
		TIC3 Info XML Element: StartTime (STA), The start time on each of the specified days of week.
		</p>
		
		@param _startzeit der neue Wert von Startzeit.
		*/
		public void setStartzeit(String
		 _startzeit) {
			if (_startzeit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._startzeit = _startzeit;
		}
	
		/**
		Endzeit.
		<p>
		TIC3 Info XML Element: EndTime (END), The end time on each of the specified days of week. When the end time is less than the start time, the end time is on the next day.
		</p>
		
		@return der Wert von Endzeit.
		*/
			public String
			 getEndzeit() {
			return _endzeit;
		}
	
		/**
		Endzeit.
		<p>
		TIC3 Info XML Element: EndTime (END), The end time on each of the specified days of week. When the end time is less than the start time, the end time is on the next day.
		</p>
		
		@param _endzeit der neue Wert von Endzeit.
		*/
		public void setEndzeit(String
		 _endzeit) {
			if (_endzeit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._endzeit = _endzeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// GanzzahlAttributTyp
				if (getWochentage() != null) {
					final Data.NumberArray arrayWochentage = datum.
						getUnscaledArray
						("Wochentage");
					arrayWochentage.setLength(getWochentage().size());
					for (int i = 0; i < arrayWochentage.getLength(); ++i) {
						arrayWochentage.getValue(i).set(getWochentage().get(i).getValue());
					}
				}
				// ZeichenkettenAttributTyp
				if (getStartzeit() != null) {
					datum.getTextValue("Startzeit").setText(getStartzeit());
				}
				// ZeichenkettenAttributTyp
				if (getEndzeit() != null) {
					datum.getTextValue("Endzeit").setText(getEndzeit());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWochentage = daten.
						getUnscaledArray
					("Wochentage");
	
					for (int i = 0; i < arrayWochentage.getLength(); ++i) {
	                    if (arrayWochentage.getValue(i).isState()) {
	                        getWochentage().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Wochentag
	                        .getZustand(arrayWochentage.getValue(i).getState().getName()));
	                    } else {
	                    getWochentage().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Wochentag
	                    (arrayWochentage.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// ZeichenkettenAttributTyp
					setStartzeit(daten.getTextValue("Startzeit").getText());
				// ZeichenkettenAttributTyp
					setEndzeit(daten.getTextValue("Endzeit").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3RecurrenceType clone() {
		AtlTic3RecurrenceType klon = new AtlTic3RecurrenceType();
		
						klon.setBeschreibung(getBeschreibung());
					klon._wochentage = getWochentage().clone();
						klon.setStartzeit(getStartzeit());
						klon.setEndzeit(getEndzeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
