/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 TmcEventQuantifierType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlTic3tmcQuantifier implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _label
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _number
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _code
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _value
			;
	
		/**
		The label as defined in the TMC standard ISO 14819-1.
		<p>
		
		</p>
		
		@return der Wert von Label.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getLabel() {
			return _label;
		}
	
		/**
		The label as defined in the TMC standard ISO 14819-1.
		<p>
		
		</p>
		
		@param _label der neue Wert von Label.
		*/
		public void setLabel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _label) {
			this._label = _label;
		}
	
		/**
		The number of the quantifier.
		<p>
		
		</p>
		
		@return der Wert von Number.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getNumber() {
			return _number;
		}
	
		/**
		The number of the quantifier.
		<p>
		
		</p>
		
		@param _number der neue Wert von Number.
		*/
		public void setNumber(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _number) {
			this._number = _number;
		}
	
		/**
		The quantifier code as defined in the TMC standard ISO 14819-2.
		<p>
		
		</p>
		
		@return der Wert von Code.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getCode() {
			return _code;
		}
	
		/**
		The quantifier code as defined in the TMC standard ISO 14819-2.
		<p>
		
		</p>
		
		@param _code der neue Wert von Code.
		*/
		public void setCode(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _code) {
			this._code = _code;
		}
	
		/**
		The decoded quantifier value.
		<p>
		
		</p>
		
		@return der Wert von Value.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getValue() {
			return _value;
		}
	
		/**
		The decoded quantifier value.
		<p>
		
		</p>
		
		@param _value der neue Wert von Value.
		*/
		public void setValue(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _value) {
			this._value = _value;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLabel() != null) {
	                if (getLabel().isZustand()) {
	                    datum.getUnscaledValue("Label").setText(getLabel().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Label").set(getLabel().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getNumber() != null) {
	                if (getNumber().isZustand()) {
	                    datum.getUnscaledValue("Number").setText(getNumber().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Number").set(getNumber().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getCode() != null) {
	                if (getCode().isZustand()) {
	                    datum.getUnscaledValue("Code").setText(getCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Code").set(getCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getValue() != null) {
	                if (getValue().isZustand()) {
	                    datum.getUnscaledValue("Value").setText(getValue().toString());
	                } else {
						datum.
						getScaledValue
	                	("Value").set(getValue().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setLabel(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Label").
								longValue
						()));
				// GanzzahlAttributTyp
						setNumber(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Number").
								longValue
						()));
				// GanzzahlAttributTyp
						setCode(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Code").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Value").isState()) {
							setValue(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("Value").getText()));
						} else {
						setValue(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("Value").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3tmcQuantifier clone() {
		AtlTic3tmcQuantifier klon = new AtlTic3tmcQuantifier();
		
						klon.setLabel(getLabel());
						klon.setNumber(getNumber());
						klon.setCode(getCode());
						klon.setValue(getValue());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
