/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 VehicleTypeEnum.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTic3FahrzeugTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_1N_NICHTVERSORGT = new AttTic3FahrzeugTyp("NichtVersorgt", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_0_ALLE = new AttTic3FahrzeugTyp("Alle", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_1_PKW = new AttTic3FahrzeugTyp("PKW", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_2_LKW = new AttTic3FahrzeugTyp("LKW", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_3_BUS = new AttTic3FahrzeugTyp("Bus", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_20_SATTELKFZ = new AttTic3FahrzeugTyp("SattelKfz", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_21_FAHRZEUG_MIT_ANHAENGER = new AttTic3FahrzeugTyp("Fahrzeug mit Anhänger", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_22_LKW_MIT_ANHAENGER = new AttTic3FahrzeugTyp("LKW mit Anhänger", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3FahrzeugTyp ZUSTAND_23_PKW_MIT_ANHAENGER = new AttTic3FahrzeugTyp("PKW mit Anhänger", 		Byte
	.valueOf("23"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTic3FahrzeugTyp getZustand(final 		Byte
	 value) {
		for (AttTic3FahrzeugTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTic3FahrzeugTyp getZustand(final String value) {
		for (AttTic3FahrzeugTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTic3FahrzeugTyp> getZustaende() {
		List<AttTic3FahrzeugTyp> list = new ArrayList<AttTic3FahrzeugTyp>();
		list.add(ZUSTAND_1N_NICHTVERSORGT);
		list.add(ZUSTAND_0_ALLE);
		list.add(ZUSTAND_1_PKW);
		list.add(ZUSTAND_2_LKW);
		list.add(ZUSTAND_3_BUS);
		list.add(ZUSTAND_20_SATTELKFZ);
		list.add(ZUSTAND_21_FAHRZEUG_MIT_ANHAENGER);
		list.add(ZUSTAND_22_LKW_MIT_ANHAENGER);
		list.add(ZUSTAND_23_PKW_MIT_ANHAENGER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TIC3Fahrzeugtyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTic3FahrzeugTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTic3FahrzeugTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
