/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Empfehlungs-Code.
<p>
Empfehlungs-Code entsprechend DIN EN ISO 14819-2 (Tabelle 'SUPPLEMENTARY INFORMATION LIST', Spalte 'Code')
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
@Wertebereich(
	minimum = 0L,
	maximum = 65535L,
	einheit = ""
)
public class AttRdsEmpfehlungsCode extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("65535");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_0_NICHT_DEFINIERT = new AttRdsEmpfehlungsCode("nicht definiert", 		Integer
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_2_FOLGEN_SIE_DEN_SCHILDERN = new AttRdsEmpfehlungsCode("folgen Sie den Schildern", 		Integer
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_3_DER_UMLEITUNGSBESCHILDERUNG_FOLGEN = new AttRdsEmpfehlungsCode("der Umleitungsbeschilderung folgen", 		Integer
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_61_FOLGEN_SIE_DEN_SCHILDERN_MIT_DEN_ORANGEN_PFEILEN = new AttRdsEmpfehlungsCode("folgen Sie den Schildern mit den orangen Pfeilen", 		Integer
	.valueOf("61"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_62_NICHT_DER_UMLEITUNGSBESCHILDERUNG_FOLGEN = new AttRdsEmpfehlungsCode("nicht der Umleitungsbeschilderung folgen", 		Integer
	.valueOf("62"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_4_EINE_UMLEITUNG_IST_EINGERICHTET = new AttRdsEmpfehlungsCode("eine Umleitung ist eingerichtet", 		Integer
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_64_OBLIGATORISCHE_UMLEITUNG_EINGERICHTET = new AttRdsEmpfehlungsCode("obligatorische Umleitung eingerichtet", 		Integer
	.valueOf("64"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_63_EINE_OERTLICHE_UMLEITUNG_IST_EINGERICHTET = new AttRdsEmpfehlungsCode("eine örtliche Umleitung ist eingerichtet", 		Integer
	.valueOf("63"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_5_KEINE_UMLEITUNGSEMPFEHLUNG = new AttRdsEmpfehlungsCode("keine Umleitungsempfehlung", 		Integer
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_6_UMLEITUNG_WIRD_NICHT_MEHR_EMPFOHLEN = new AttRdsEmpfehlungsCode("Umleitung wird nicht mehr empfohlen", 		Integer
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_68_ORTSKUNDIGE_AUTOFAHRER_WERDEN_GEBETEN_DAS_GEBIET_WEITRAEUMIG_ZU_UMFAHREN = new AttRdsEmpfehlungsCode("ortskundige Autofahrer werden gebeten, das Gebiet weiträumig zu umfahren", 		Integer
	.valueOf("68"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_1_LKW_WIRD_EMPFOHLEN_DAS_GEBIET_WEITRAEUMIG_ZU_UMFAHREN = new AttRdsEmpfehlungsCode("LKW wird empfohlen, das Gebiet weiträumig zu umfahren", 		Integer
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_71_FUER_PKW = new AttRdsEmpfehlungsCode("für PKW", 		Integer
	.valueOf("71"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_72_FUER_LEICHTE_LKW = new AttRdsEmpfehlungsCode("für leichte LKW", 		Integer
	.valueOf("72"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_9_FUER_PKW_UND_LEICHTE_LKW = new AttRdsEmpfehlungsCode("für PKW und leichte LKW", 		Integer
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_73_FUER_FAHRZEUGE_MIT_KATALYSATOREN = new AttRdsEmpfehlungsCode("für Fahrzeuge mit Katalysatoren", 		Integer
	.valueOf("73"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_74_FUER_FAHRZEUGE_OHNE_KATALYSATOREN = new AttRdsEmpfehlungsCode("für Fahrzeuge ohne Katalysatoren", 		Integer
	.valueOf("74"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_65_FUER_FAHRZEUGE_MIT_VERBRENNUNGSMOTOREN = new AttRdsEmpfehlungsCode("für Fahrzeuge mit Verbrennungsmotoren", 		Integer
	.valueOf("65"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_66_FUER_FAHRZEUGE_MIT_DIESELMOTOREN = new AttRdsEmpfehlungsCode("für Fahrzeuge mit Dieselmotoren", 		Integer
	.valueOf("66"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_67_FUER_FAHRZEUGE_MIT_GASMOTOREN = new AttRdsEmpfehlungsCode("für Fahrzeuge mit Gasmotoren", 		Integer
	.valueOf("67"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_69_FUER_ALLRADFAHRZEUGE_MIT_WINTERREIFEN_ODER_SCHNEEKETTEN = new AttRdsEmpfehlungsCode("für Allradfahrzeuge mit Winterreifen oder Schneeketten", 		Integer
	.valueOf("69"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_75_FUER_PKW_MIT_ANHAENGER = new AttRdsEmpfehlungsCode("für PKW mit Anhänger", 		Integer
	.valueOf("75"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_76_FUER_FAHRZEUGE_MIT_WOHNANHAENGER = new AttRdsEmpfehlungsCode("für Fahrzeuge mit Wohnanhänger", 		Integer
	.valueOf("76"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_77_FUER_FAHRZEUGE_MIT_ANHAENGER = new AttRdsEmpfehlungsCode("für Fahrzeuge mit Anhänger", 		Integer
	.valueOf("77"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_8_FUER_LKW = new AttRdsEmpfehlungsCode("für LKW", 		Integer
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_78_FUER_SCHWERLASTVERKEHR = new AttRdsEmpfehlungsCode("für Schwerlastverkehr", 		Integer
	.valueOf("78"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_79_FUER_BUSSE = new AttRdsEmpfehlungsCode("für Busse", 		Integer
	.valueOf("79"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_80_FUER_SPEZIALFAHRZEUGE = new AttRdsEmpfehlungsCode("für Spezialfahrzeuge", 		Integer
	.valueOf("80"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_81_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN = new AttRdsEmpfehlungsCode("für Fahrzeuge mit hohen Aufbauten", 		Integer
	.valueOf("81"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_82_FUER_GEFAHRGUTTRANSPORTE = new AttRdsEmpfehlungsCode("für Gefahrguttransporte", 		Integer
	.valueOf("82"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_7_FUER_GROSSRAUM_UND_SCHWERTRANSPORTE = new AttRdsEmpfehlungsCode("für Großraum- und Schwertransporte", 		Integer
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_83_FUER_GROSSRAUM_SCHWER_UND_GEFAHRGUTTRANSPORTE = new AttRdsEmpfehlungsCode("für Großraum-, Schwer- und Gefahrguttransporte", 		Integer
	.valueOf("83"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_84_FUER_KFZ_MIT_GERADZAHLIGEN_KENNZEICHEN = new AttRdsEmpfehlungsCode("für KFZ mit geradzahligen Kennzeichen", 		Integer
	.valueOf("84"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_85_FUER_KFZ_MIT_UNGERADZAHLIGEN_KENNZEICHEN = new AttRdsEmpfehlungsCode("für KFZ mit ungeradzahligen Kennzeichen", 		Integer
	.valueOf("85"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_88_FUER_DURCHGANGSVERKEHR = new AttRdsEmpfehlungsCode("für Durchgangsverkehr", 		Integer
	.valueOf("88"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_86_FUER_ALLE_FAHRZEUGE = new AttRdsEmpfehlungsCode("für alle Fahrzeuge", 		Integer
	.valueOf("86"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_153_FUER_FAEHRBETRIEB = new AttRdsEmpfehlungsCode("für Fährbetrieb", 		Integer
	.valueOf("153"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_89_FUER_SCHIENENVERKEHR = new AttRdsEmpfehlungsCode("für Schienenverkehr", 		Integer
	.valueOf("89"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_90_IM_U_BAHN_VERKEHR = new AttRdsEmpfehlungsCode("im U-Bahn-Verkehr", 		Integer
	.valueOf("90"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_91_GEFAHR = new AttRdsEmpfehlungsCode("Gefahr", 		Integer
	.valueOf("91"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_98_STRAHLUNGSGEFAHR = new AttRdsEmpfehlungsCode("Strahlungsgefahr", 		Integer
	.valueOf("98"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_99_GASAUSTRITT = new AttRdsEmpfehlungsCode("Gasaustritt", 		Integer
	.valueOf("99"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_92_REPARATURARBEITEN = new AttRdsEmpfehlungsCode("Reparaturarbeiten", 		Integer
	.valueOf("92"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_43_AUF_SICHERUNGSPOSTEN_ACHTEN = new AttRdsEmpfehlungsCode("auf Sicherungsposten achten", 		Integer
	.valueOf("43"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_93_LOTSENDIENST_IM_EINSATZ = new AttRdsEmpfehlungsCode("Lotsendienst im Einsatz", 		Integer
	.valueOf("93"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_109_RETTUNGSHUBSCHRAUBER_IM_EINSATZ = new AttRdsEmpfehlungsCode("Rettungshubschrauber im Einsatz", 		Integer
	.valueOf("109"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_47_ERHOEHTE_UNFALLGEFAHR = new AttRdsEmpfehlungsCode("erhöhte Unfallgefahr", 		Integer
	.valueOf("47"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_110_ES_HABEN_SICH_BEREITS_MEHRERE_UNFAELLE_EREIGNET = new AttRdsEmpfehlungsCode("es haben sich bereits mehrere Unfälle ereignet", 		Integer
	.valueOf("110"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_42_WEGEN_BERGUNGSARBEITEN = new AttRdsEmpfehlungsCode("wegen Bergungsarbeiten", 		Integer
	.valueOf("42"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_94_RETTUNGSFAHRZEUGE_IM_EINSATZ = new AttRdsEmpfehlungsCode("Rettungsfahrzeuge im Einsatz", 		Integer
	.valueOf("94"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_95_VERKEHR_WIRD_AN_DER_UNFALLSTELLE_VORBEIGEFUEHRT = new AttRdsEmpfehlungsCode("Verkehr wird an der Unfallstelle vorbeigeführt", 		Integer
	.valueOf("95"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_96_EXPLOSIONSGEFAHR = new AttRdsEmpfehlungsCode("Explosionsgefahr", 		Integer
	.valueOf("96"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_97_BRANDGEFAHR = new AttRdsEmpfehlungsCode("Brandgefahr", 		Integer
	.valueOf("97"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_100_FEUERWEHR_REGELT_DEN_VERKEHR = new AttRdsEmpfehlungsCode("Feuerwehr regelt den Verkehr", 		Integer
	.valueOf("100"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_39_POLIZEI_REGELT_DEN_VERKEHR = new AttRdsEmpfehlungsCode("Polizei regelt den Verkehr", 		Integer
	.valueOf("39"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_181_VERKEHRSHELFER_REGELN_DEN_VERKEHR = new AttRdsEmpfehlungsCode("Verkehrshelfer regeln den Verkehr", 		Integer
	.valueOf("181"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_40_UNFALLAUFNAHME = new AttRdsEmpfehlungsCode("Unfallaufnahme", 		Integer
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_41_POLIZEI_FAEHRT_VERSTAERKT_STREIFE = new AttRdsEmpfehlungsCode("Polizei fährt verstärkt Streife", 		Integer
	.valueOf("41"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_101_GESCHWINDIGKEITSKONTROLLEN = new AttRdsEmpfehlungsCode("Geschwindigkeitskontrollen", 		Integer
	.valueOf("101"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_102_DIE_GESCHWINDIGKEIT_IST_BEGRENZT = new AttRdsEmpfehlungsCode("die Geschwindigkeit ist begrenzt", 		Integer
	.valueOf("102"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_103_GESCHWINDIGKEITSBESCHRAENKUNG_FUER_LKW = new AttRdsEmpfehlungsCode("Geschwindigkeitsbeschränkung für LKW", 		Integer
	.valueOf("103"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_104_LANGSAM_FAHREN = new AttRdsEmpfehlungsCode("langsam fahren", 		Integer
	.valueOf("104"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_105_AUF_GESCHWINDIGKEITSBESCHRAENKUNG_ACHTEN = new AttRdsEmpfehlungsCode("auf Geschwindigkeitsbeschränkung achten", 		Integer
	.valueOf("105"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_106_DIE_EMPFOHLENE_GESCHWINDIGKEIT_BEACHTEN = new AttRdsEmpfehlungsCode("die empfohlene Geschwindigkeit beachten", 		Integer
	.valueOf("106"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_12_BITTE_VORSICHTIG_FAHREN = new AttRdsEmpfehlungsCode("bitte vorsichtig fahren", 		Integer
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_111_FAHREN_SIE_BITTE_BESONDERS_VORSICHTIG = new AttRdsEmpfehlungsCode("fahren Sie bitte besonders vorsichtig", 		Integer
	.valueOf("111"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_112_VORSICHTIG_AN_DAS_STAUENDE_HERANFAHREN = new AttRdsEmpfehlungsCode("vorsichtig an das Stauende heranfahren", 		Integer
	.valueOf("112"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_13_ABSTAND_HALTEN = new AttRdsEmpfehlungsCode("Abstand halten", 		Integer
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_113_SICHERHEITSABSTAND_VERGROESSERN = new AttRdsEmpfehlungsCode("Sicherheitsabstand vergrößern", 		Integer
	.valueOf("113"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_23_BREMSEN_UEBERPRUEFEN = new AttRdsEmpfehlungsCode("Bremsen überprüfen", 		Integer
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_114_KEINE_UNNOETIGEN_LUECKEN_LASSEN = new AttRdsEmpfehlungsCode("keine unnötigen Lücken lassen", 		Integer
	.valueOf("114"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_115_FAHREN_SIE_ZUEGIG_AN_DER_UNFALLSTELLE_VORBEI = new AttRdsEmpfehlungsCode("fahren Sie zügig an der Unfallstelle vorbei", 		Integer
	.valueOf("115"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_116_NICHT_UNNOETIG_ABBREMSEN = new AttRdsEmpfehlungsCode("nicht unnötig abbremsen", 		Integer
	.valueOf("116"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_14_AUF_SIGNALREGELUNG_ACHTEN = new AttRdsEmpfehlungsCode("auf Signalregelung achten", 		Integer
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_117_AUF_BESCHILDERUNG_ACHTEN = new AttRdsEmpfehlungsCode("auf Beschilderung achten", 		Integer
	.valueOf("117"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_129_GASSE_FUER_RAEUM_UND_STREUFAHRZEUGE_FREI_HALTEN = new AttRdsEmpfehlungsCode("Gasse für Räum- und Streufahrzeuge frei halten", 		Integer
	.valueOf("129"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_16_VORSICHT_AN_DER_KREUZUNG = new AttRdsEmpfehlungsCode("Vorsicht an der Kreuzung", 		Integer
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_17_UEBERHOLEN_VERBOTEN = new AttRdsEmpfehlungsCode("Überholen verboten", 		Integer
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_15_VORSICHT_BEIM_UEBERHOLEN = new AttRdsEmpfehlungsCode("Vorsicht beim Überholen", 		Integer
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_18_LICHT_EINSCHALTEN = new AttRdsEmpfehlungsCode("Licht einschalten", 		Integer
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_19_NEBELSCHEINWERFER_EINSCHALTEN = new AttRdsEmpfehlungsCode("Nebelscheinwerfer einschalten", 		Integer
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_118_WARNBLINKANLAGE_EINSCHALTEN = new AttRdsEmpfehlungsCode("Warnblinkanlage einschalten", 		Integer
	.valueOf("118"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_20_BITTE_DAS_FAHRZEUG_NICHT_VERLASSEN = new AttRdsEmpfehlungsCode("bitte das Fahrzeug nicht verlassen", 		Integer
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_239_BITTE_DAS_FAHRZEUG_VERLASSEN_UND_DEN_NAECHSTEN_SICHEREN_PLATZ_AUFSUCHEN = new AttRdsEmpfehlungsCode("bitte das Fahrzeug verlassen und den nächsten sicheren Platz aufsuchen", 		Integer
	.valueOf("239"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_21_MOTOR_ABSTELLEN = new AttRdsEmpfehlungsCode("Motor abstellen", 		Integer
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_22_FENSTER_SCHLIESSEN_UND_LUEFTUNG_ABSTELLEN = new AttRdsEmpfehlungsCode("Fenster schließen und Lüftung abstellen", 		Integer
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_180_NICHTS_BRENNENDES_AUS_DEM_FAHRZEUG_WERFEN = new AttRdsEmpfehlungsCode("nichts Brennendes aus dem Fahrzeug werfen", 		Integer
	.valueOf("180"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_119_NICHT_RAUCHEN = new AttRdsEmpfehlungsCode("nicht rauchen", 		Integer
	.valueOf("119"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_120_KEIN_OFFENES_FEUER = new AttRdsEmpfehlungsCode("kein offenes Feuer", 		Integer
	.valueOf("120"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_121_MOBILTELEFONE_UND_FUNKGERAETE_AUSSCHALTEN = new AttRdsEmpfehlungsCode("Mobiltelefone und Funkgeräte ausschalten", 		Integer
	.valueOf("121"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_29_STANDSTREIFEN_MITBENUTZEN = new AttRdsEmpfehlungsCode("Standstreifen mitbenutzen", 		Integer
	.valueOf("29"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_30_STANDSTREIFEN_NICHT_BEFAHREN = new AttRdsEmpfehlungsCode("Standstreifen nicht befahren", 		Integer
	.valueOf("30"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_122_RETTUNGSFAHRZEUGE_UEBERHOLEN_LASSEN = new AttRdsEmpfehlungsCode("Rettungsfahrzeuge überholen lassen", 		Integer
	.valueOf("122"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_123_GASSE_FUER_RETTUNGSFAHRZEUGE_BILDEN = new AttRdsEmpfehlungsCode("Gasse für Rettungsfahrzeuge bilden", 		Integer
	.valueOf("123"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_124_AN_DEN_RAND_DER_STRASSE_HERANFAHREN = new AttRdsEmpfehlungsCode("an den Rand der Straße heranfahren", 		Integer
	.valueOf("124"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_125_WARTEN_SIE_AUF_FUEHRUNGSFAHRZEUG = new AttRdsEmpfehlungsCode("warten Sie auf Führungsfahrzeug", 		Integer
	.valueOf("125"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_126_AUF_LAUTSPRECHERDURCHSAGEN_DER_POLIZEI_UND_DER_RETTUNGSDIENSTE_ACHTEN = new AttRdsEmpfehlungsCode("auf Lautsprecherdurchsagen der Polizei und der Rettungsdienste achten", 		Integer
	.valueOf("126"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_136_NAECHSTEN_RAST_ODER_PARKPLATZ_ANFAHREN = new AttRdsEmpfehlungsCode("nächsten Rast- oder Parkplatz anfahren", 		Integer
	.valueOf("136"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_128_AN_DER_NAECHSTEN_SICHEREN_STELLE_HALTEN = new AttRdsEmpfehlungsCode("an der nächsten sicheren Stelle halten", 		Integer
	.valueOf("128"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_46_NUR_IM_NOTFALL_FAHREN = new AttRdsEmpfehlungsCode("nur im Notfall fahren", 		Integer
	.valueOf("46"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_205_BITTE_DIE_U_BAHN_BENUTZEN = new AttRdsEmpfehlungsCode("bitte die U-Bahn benutzen", 		Integer
	.valueOf("205"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_206_BITTE_DIE_STRASSENBAHN_BENUTZEN = new AttRdsEmpfehlungsCode("bitte die Straßenbahn benutzen", 		Integer
	.valueOf("206"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_207_BITTE_DEN_BUS_BENUTZEN = new AttRdsEmpfehlungsCode("bitte den Bus benutzen", 		Integer
	.valueOf("207"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_204_BITTE_DIE_BAHN_BENUTZEN = new AttRdsEmpfehlungsCode("bitte die Bahn benutzen", 		Integer
	.valueOf("204"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_28_RECHTS_FAHREN = new AttRdsEmpfehlungsCode("rechts fahren", 		Integer
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_27_LINKS_FAHREN = new AttRdsEmpfehlungsCode("links fahren", 		Integer
	.valueOf("27"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_131_BENUTZEN_SIE_DEN_RECHTEN_FAHRSTREIFEN = new AttRdsEmpfehlungsCode("benutzen Sie den rechten Fahrstreifen", 		Integer
	.valueOf("131"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_132_BENUTZEN_SIE_DEN_LINKEN_FAHRSTREIFEN = new AttRdsEmpfehlungsCode("benutzen Sie den linken Fahrstreifen", 		Integer
	.valueOf("132"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_133_LKW_DEN_RECHTEN_FAHRSTREIFEN_BENUTZEN = new AttRdsEmpfehlungsCode("LKW den rechten Fahrstreifen benutzen", 		Integer
	.valueOf("133"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_134_LKW_DEN_LINKEN_FAHRSTREIFEN_BENUTZEN = new AttRdsEmpfehlungsCode("LKW den linken Fahrstreifen benutzen", 		Integer
	.valueOf("134"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_195_BENUTZEN_SIE_DIE_FERNVERKEHRSSPUR = new AttRdsEmpfehlungsCode("benutzen Sie die Fernverkehrsspur", 		Integer
	.valueOf("195"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_196_BENUTZEN_SIE_DIE_NAHVERKEHRSSPUR = new AttRdsEmpfehlungsCode("benutzen Sie die Nahverkehrsspur", 		Integer
	.valueOf("196"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_197_BENUTZEN_SIE_DIE_LINKE_PARALLELFAHRBAHN = new AttRdsEmpfehlungsCode("benutzen Sie die linke Parallelfahrbahn", 		Integer
	.valueOf("197"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_198_BENUTZEN_SIE_DIE_RECHTE_PARALLELFAHRBAHN = new AttRdsEmpfehlungsCode("benutzen Sie die rechte Parallelfahrbahn", 		Integer
	.valueOf("198"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_199_BENUTZEN_SIE_DIE_LKW_SPUR = new AttRdsEmpfehlungsCode("benutzen Sie die LKW-Spur", 		Integer
	.valueOf("199"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_35_AUF_DEM_RECHTEN_FAHRSTREIFEN = new AttRdsEmpfehlungsCode("auf dem rechten Fahrstreifen", 		Integer
	.valueOf("35"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_36_AUF_DEM_MITTLEREN_FAHRSTREIFEN = new AttRdsEmpfehlungsCode("auf dem mittleren Fahrstreifen", 		Integer
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_37_AUF_DEM_LINKEN_FAHRSTREIFEN = new AttRdsEmpfehlungsCode("auf dem linken Fahrstreifen", 		Integer
	.valueOf("37"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_141_AUF_DER_RECHTEN_SEITE = new AttRdsEmpfehlungsCode("auf der rechten Seite", 		Integer
	.valueOf("141"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_142_IN_DER_MITTE = new AttRdsEmpfehlungsCode("in der Mitte", 		Integer
	.valueOf("142"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_143_AUF_DER_LINKEN_SEITE = new AttRdsEmpfehlungsCode("auf der linken Seite", 		Integer
	.valueOf("143"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_144_AUF_DER_BUSSPUR = new AttRdsEmpfehlungsCode("auf der Busspur", 		Integer
	.valueOf("144"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_145_AUF_DER_SPUR_FUER_FAHRGEMEINSCHAFTEN = new AttRdsEmpfehlungsCode("auf der Spur für Fahrgemeinschaften", 		Integer
	.valueOf("145"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_146_AUF_DEM_STANDSTREIFEN = new AttRdsEmpfehlungsCode("auf dem Standstreifen", 		Integer
	.valueOf("146"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_147_AUF_DER_NOTFALLSPUR = new AttRdsEmpfehlungsCode("auf der Notfallspur", 		Integer
	.valueOf("147"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_149_AUF_DER_SCHWERVERKEHRSSPUR_ = new AttRdsEmpfehlungsCode("auf der Schwerverkehrsspur ", 		Integer
	.valueOf("149"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_150_AUF_DER_NAHVERKEHRSSPUR = new AttRdsEmpfehlungsCode("auf der Nahverkehrsspur", 		Integer
	.valueOf("150"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_155_AUF_DER_FERNVERKEHRSSPUR = new AttRdsEmpfehlungsCode("auf der Fernverkehrsspur", 		Integer
	.valueOf("155"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_156_AUF_DER_SCHNELLSPUR = new AttRdsEmpfehlungsCode("auf der Schnellspur", 		Integer
	.valueOf("156"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_169_AUF_DEM_LANGSAMFAHRSTREIFEN = new AttRdsEmpfehlungsCode("auf dem Langsamfahrstreifen", 		Integer
	.valueOf("169"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_170_AUF_DER_WENDESPUR = new AttRdsEmpfehlungsCode("auf der Wendespur", 		Integer
	.valueOf("170"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_33_AUF_DEM_UEBERHOLSTREIFEN = new AttRdsEmpfehlungsCode("auf dem Überholstreifen", 		Integer
	.valueOf("33"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_34_AUF_DER_KRIECHSPUR = new AttRdsEmpfehlungsCode("auf der Kriechspur", 		Integer
	.valueOf("34"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_38_AUF_DER_FAHRBAHN = new AttRdsEmpfehlungsCode("auf der Fahrbahn", 		Integer
	.valueOf("38"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_70_AM_MITTELSTREIFEN = new AttRdsEmpfehlungsCode("am Mittelstreifen", 		Integer
	.valueOf("70"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_31_IN_DER_GEGENRICHTUNG = new AttRdsEmpfehlungsCode("in der Gegenrichtung", 		Integer
	.valueOf("31"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_32_AUF_DER_GEGENFAHRSPUR = new AttRdsEmpfehlungsCode("auf der Gegenfahrspur", 		Integer
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_148_AUF_DER_GEGENFAHRBAHN = new AttRdsEmpfehlungsCode("auf der Gegenfahrbahn", 		Integer
	.valueOf("148"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_157_AUF_DER_VERBINDUNGSFAHRBAHN = new AttRdsEmpfehlungsCode("auf der Verbindungsfahrbahn", 		Integer
	.valueOf("157"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_158_AUF_DER_PARALLELFAHRBAHN = new AttRdsEmpfehlungsCode("auf der Parallelfahrbahn", 		Integer
	.valueOf("158"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_159_AUF_DER_RECHTEN_PARALLELFAHRBAHN = new AttRdsEmpfehlungsCode("auf der rechten Parallelfahrbahn", 		Integer
	.valueOf("159"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_160_AUF_DER_LINKEN_PARALLELFAHRBAHN = new AttRdsEmpfehlungsCode("auf der linken Parallelfahrbahn", 		Integer
	.valueOf("160"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_48_AUF_BRUECKEN = new AttRdsEmpfehlungsCode("auf Brücken", 		Integer
	.valueOf("48"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_161_IN_TUNNELS = new AttRdsEmpfehlungsCode("in Tunnels", 		Integer
	.valueOf("161"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_50_AN_TUNNELEIN_ODER_AUSGAENGEN = new AttRdsEmpfehlungsCode("an Tunnelein- oder -ausgängen", 		Integer
	.valueOf("50"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_49_IN_SCHATTIGEN_BEREICHEN = new AttRdsEmpfehlungsCode("in schattigen Bereichen", 		Integer
	.valueOf("49"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_162_IN_ANSCHLUSSSTELLEN = new AttRdsEmpfehlungsCode("in Anschlussstellen", 		Integer
	.valueOf("162"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_241_IM_BAUSTELLENBEREICH = new AttRdsEmpfehlungsCode("im Baustellenbereich", 		Integer
	.valueOf("241"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_163_IN_HOEHENLAGEN = new AttRdsEmpfehlungsCode("in Höhenlagen", 		Integer
	.valueOf("163"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_164_IN_TIEFER_GELEGENEN_GEBIETEN = new AttRdsEmpfehlungsCode("in tiefer gelegenen Gebieten", 		Integer
	.valueOf("164"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_165_IM_KURVENBEREICH = new AttRdsEmpfehlungsCode("im Kurvenbereich", 		Integer
	.valueOf("165"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_166_HINTER_EINER_KUPPE = new AttRdsEmpfehlungsCode("hinter einer Kuppe", 		Integer
	.valueOf("166"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_167_IN_DER_INNENSTADT = new AttRdsEmpfehlungsCode("in der Innenstadt", 		Integer
	.valueOf("167"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_168_IM_INNENSTADTBEREICH = new AttRdsEmpfehlungsCode("im Innenstadtbereich", 		Integer
	.valueOf("168"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_171_WEGEN_EINES_VORAUSGEGANGENEN_UNFALLS = new AttRdsEmpfehlungsCode("wegen eines vorausgegangenen Unfalls", 		Integer
	.valueOf("171"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_200_WEGEN_EINES_VORAUSGEGANGENEN_VORFALLS = new AttRdsEmpfehlungsCode("wegen eines  vorausgegangenen Vorfalls", 		Integer
	.valueOf("200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_203_WEGEN_EINES_VORAUSGEGANGENEN_EREIGNISSES = new AttRdsEmpfehlungsCode("wegen eines vorausgegangenen Ereignisses", 		Integer
	.valueOf("203"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_172_WEGEN_ZU_HOHER_VERKEHRSBELASTUNG = new AttRdsEmpfehlungsCode("wegen zu hoher Verkehrsbelastung", 		Integer
	.valueOf("172"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_173_WEGEN_HOHER_BESUCHERZAHLEN = new AttRdsEmpfehlungsCode("wegen hoher Besucherzahlen", 		Integer
	.valueOf("173"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_52_BLOCKABFERTIGUNG = new AttRdsEmpfehlungsCode("Blockabfertigung", 		Integer
	.valueOf("52"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_174_WEGEN_URLAUBSVERKEHRS = new AttRdsEmpfehlungsCode("wegen Urlaubsverkehrs", 		Integer
	.valueOf("174"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_175_WEGEN_TECHNISCHER_PROBLEME = new AttRdsEmpfehlungsCode("wegen technischer Probleme", 		Integer
	.valueOf("175"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_185_AUFGRUND_VON_HERABFALLENDEM_EIS = new AttRdsEmpfehlungsCode("aufgrund von herabfallendem Eis", 		Integer
	.valueOf("185"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_151_WEGEN_HITZE = new AttRdsEmpfehlungsCode("wegen Hitze", 		Integer
	.valueOf("151"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_152_WEGEN_FROST = new AttRdsEmpfehlungsCode("wegen Frost", 		Integer
	.valueOf("152"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_10_SCHNEERAEUMFAHRZEUGE_IM_EINSATZ = new AttRdsEmpfehlungsCode("Schneeräumfahrzeuge im Einsatz", 		Integer
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_11_STREUFAHRZEUGE_IM_EINSATZ = new AttRdsEmpfehlungsCode("Streufahrzeuge im Einsatz", 		Integer
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_24_WINTERAUSRUESTUNG_EMPFOHLEN = new AttRdsEmpfehlungsCode("Winterausrüstung empfohlen", 		Integer
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_107_SCHNEEKETTEN_ERFORDERLICH = new AttRdsEmpfehlungsCode("Schneeketten erforderlich", 		Integer
	.valueOf("107"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_51_WINTERSPERRE = new AttRdsEmpfehlungsCode("Wintersperre", 		Integer
	.valueOf("51"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_25_SCHNEEKETTEN_EMPFOHLEN = new AttRdsEmpfehlungsCode("Schneeketten empfohlen", 		Integer
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_26_SCHNEEKETTENPFLICHT = new AttRdsEmpfehlungsCode("Schneekettenpflicht", 		Integer
	.valueOf("26"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_191_WINTERREIFEN_EMPFOHLEN = new AttRdsEmpfehlungsCode("Winterreifen empfohlen", 		Integer
	.valueOf("191"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_192_WINTERREIFEN_VORGESCHRIEBEN = new AttRdsEmpfehlungsCode("Winterreifen vorgeschrieben", 		Integer
	.valueOf("192"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_108_WINTERREIFEN_ODER_SCHNEEKETTEN_ERFORDERLICH = new AttRdsEmpfehlungsCode("Winterreifen oder Schneeketten erforderlich", 		Integer
	.valueOf("108"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_201_BILDEN_SIE_BITTE_FAHRGEMEINSCHAFTEN = new AttRdsEmpfehlungsCode("bilden Sie bitte Fahrgemeinschaften", 		Integer
	.valueOf("201"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_202_IST_HEUTE_IHR_AUTOFREIER_TAG_ = new AttRdsEmpfehlungsCode("Ist heute Ihr autofreier Tag?", 		Integer
	.valueOf("202"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_178_BEI_DER_EINREISE = new AttRdsEmpfehlungsCode("bei der Einreise", 		Integer
	.valueOf("178"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_45_NUTZEN_SIE_DIE_OEFFENTLICHEN_VERKEHRSMITTEL = new AttRdsEmpfehlungsCode("nutzen Sie die öffentlichen Verkehrsmittel", 		Integer
	.valueOf("45"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_179_BEI_DER_AUSREISE = new AttRdsEmpfehlungsCode("bei der Ausreise", 		Integer
	.valueOf("179"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_44_P_R_ANFAHREN_UND_OEFFENTLICHE_VERKEHRSMITTEL_BENUTZEN = new AttRdsEmpfehlungsCode("P+R anfahren und öffentliche Verkehrsmittel benutzen", 		Integer
	.valueOf("44"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_209_FAHRPREIS_FUER_OEFFENTLICHE_VERKEHRSMITTEL_IST_IM_PARKTICKET_ENTHALTEN = new AttRdsEmpfehlungsCode("Fahrpreis für öffentliche Verkehrsmittel ist im Parkticket enthalten", 		Integer
	.valueOf("209"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_210_VERMEIDEN_SIE_DIE_HAUPTVERKEHRSZEITEN = new AttRdsEmpfehlungsCode("vermeiden Sie die Hauptverkehrszeiten", 		Integer
	.valueOf("210"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_211_FUER_URLAUBSVERKEHR = new AttRdsEmpfehlungsCode("für Urlaubsverkehr", 		Integer
	.valueOf("211"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_212_FUER_ANWOHNER = new AttRdsEmpfehlungsCode("für Anwohner", 		Integer
	.valueOf("212"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_240_FUER_BESUCHER = new AttRdsEmpfehlungsCode("für Besucher", 		Integer
	.valueOf("240"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_223_FUER_FERNVERKEHR = new AttRdsEmpfehlungsCode("für Fernverkehr", 		Integer
	.valueOf("223"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_224_FUER_NAHVERKEHR = new AttRdsEmpfehlungsCode("für Nahverkehr", 		Integer
	.valueOf("224"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_225_FUER_REGIONALVERKEHR = new AttRdsEmpfehlungsCode("für Regionalverkehr", 		Integer
	.valueOf("225"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_208_VORUEBERGEHEND = new AttRdsEmpfehlungsCode("vorübergehend", 		Integer
	.valueOf("208"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_213_MEHRFACH = new AttRdsEmpfehlungsCode("mehrfach", 		Integer
	.valueOf("213"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_214_AM_TAGE = new AttRdsEmpfehlungsCode("am Tage", 		Integer
	.valueOf("214"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_215_IN_VERKEHRSARMEN_ZEITEN = new AttRdsEmpfehlungsCode("in verkehrsarmen Zeiten", 		Integer
	.valueOf("215"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_216_IN_DER_NACHT = new AttRdsEmpfehlungsCode("in der Nacht", 		Integer
	.valueOf("216"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_217_BIS_AUF_WEITERES = new AttRdsEmpfehlungsCode("bis auf weiteres", 		Integer
	.valueOf("217"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_218_FUER_ANKUNFT = new AttRdsEmpfehlungsCode("für Ankunft", 		Integer
	.valueOf("218"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_219_FUER_ABFAHRT = new AttRdsEmpfehlungsCode("für Abfahrt", 		Integer
	.valueOf("219"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_220_NUR_ZUGANG = new AttRdsEmpfehlungsCode("nur Zugang", 		Integer
	.valueOf("220"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_221_NUR = new AttRdsEmpfehlungsCode("nur", 		Integer
	.valueOf("221"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_222_AUSSER = new AttRdsEmpfehlungsCode("außer", 		Integer
	.valueOf("222"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_226_UNBESTAETIGTER_BERICHT = new AttRdsEmpfehlungsCode("unbestätigter Bericht", 		Integer
	.valueOf("226"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_250_SEHR_KURZER_FAHRTAKT = new AttRdsEmpfehlungsCode("sehr kurzer Fahrtakt", 		Integer
	.valueOf("250"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_251_REGELMAESSIGER_FAHRTAKT = new AttRdsEmpfehlungsCode("regelmäßiger Fahrtakt", 		Integer
	.valueOf("251"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_252_RECHT_KURZER_FAHRTAKT = new AttRdsEmpfehlungsCode("recht kurzer Fahrtakt", 		Integer
	.valueOf("252"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_253_FAHRPLANMAESSIGER_FAHRTAKT = new AttRdsEmpfehlungsCode("fahrplanmäßiger Fahrtakt", 		Integer
	.valueOf("253"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_53_IN_NOERDLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in nördlicher Richtung", 		Integer
	.valueOf("53"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_54_IN_NORDOESTLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in nordöstlicher Richtung", 		Integer
	.valueOf("54"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_55_IN_OESTLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in östlicher Richtung", 		Integer
	.valueOf("55"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_56_IN_SUEDOESTLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in südöstlicher Richtung", 		Integer
	.valueOf("56"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_57_IN_SUEDLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in südlicher Richtung", 		Integer
	.valueOf("57"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_58_IN_SUEDWESTLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in südwestlicher Richtung", 		Integer
	.valueOf("58"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_59_IN_WESTLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in westlicher Richtung", 		Integer
	.valueOf("59"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_60_IN_NORDWESTLICHER_RICHTUNG = new AttRdsEmpfehlungsCode("in nordwestlicher Richtung", 		Integer
	.valueOf("60"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_232_FUER_STRASSEN_NACH = new AttRdsEmpfehlungsCode("für Straßen nach", 		Integer
	.valueOf("232"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_233_FUER_STRASSEN_AUS = new AttRdsEmpfehlungsCode("für Straßen aus", 		Integer
	.valueOf("233"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_154_FUER_STRASSEN_IN = new AttRdsEmpfehlungsCode("für Straßen in", 		Integer
	.valueOf("154"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_176_STADTEINWAERTS = new AttRdsEmpfehlungsCode("stadteinwärts", 		Integer
	.valueOf("176"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_242_AUS = new AttRdsEmpfehlungsCode("aus", 		Integer
	.valueOf("242"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_243_NACH = new AttRdsEmpfehlungsCode("nach", 		Integer
	.valueOf("243"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_244_IN = new AttRdsEmpfehlungsCode("in", 		Integer
	.valueOf("244"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_177_STADTAUSWAERTS = new AttRdsEmpfehlungsCode("stadtauswärts", 		Integer
	.valueOf("177"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_231_ENTSCHULDIGEN_SIE_ETWAIGE_VERZOEGERUNGEN = new AttRdsEmpfehlungsCode("entschuldigen Sie etwaige Verzögerungen", 		Integer
	.valueOf("231"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_234_WIR_DANKEN_IHNEN_FUER_IHRE_MITARBEIT = new AttRdsEmpfehlungsCode("wir danken Ihnen für Ihre Mitarbeit", 		Integer
	.valueOf("234"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_245_STAULAENGE_ZUNEHMEND = new AttRdsEmpfehlungsCode("Staulänge zunehmend", 		Integer
	.valueOf("245"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_246_STAULAENGE_SEHR_LANGSAM_ZUNEHMEND = new AttRdsEmpfehlungsCode("Staulänge sehr langsam zunehmend", 		Integer
	.valueOf("246"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_247_STAULAENGE_LANGSAM_ZUNEHMEND = new AttRdsEmpfehlungsCode("Staulänge langsam zunehmend", 		Integer
	.valueOf("247"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_248_STAULAENGE_SCHNELL_ZUNEHMEND = new AttRdsEmpfehlungsCode("Staulänge schnell zunehmend", 		Integer
	.valueOf("248"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_249_STAULAENGE_SEHR_SCHNELL_ZUNEHMEND = new AttRdsEmpfehlungsCode("Staulänge sehr schnell zunehmend", 		Integer
	.valueOf("249"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_255_STAULAENGE_ABNEHMEND = new AttRdsEmpfehlungsCode("Staulänge abnehmend", 		Integer
	.valueOf("255"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_235_STAULAENGE_SEHR_LANGSAM_ABNEHMEND = new AttRdsEmpfehlungsCode("Staulänge sehr langsam abnehmend", 		Integer
	.valueOf("235"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_236_STAULAENGE_LANGSAM_ABNEHMEND = new AttRdsEmpfehlungsCode("Staulänge langsam abnehmend", 		Integer
	.valueOf("236"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_237_STAULAENGE_SCHNELL_ABNEHMEND = new AttRdsEmpfehlungsCode("Staulänge schnell abnehmend", 		Integer
	.valueOf("237"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEmpfehlungsCode ZUSTAND_238_STAULAENGE_SEHR_SCHNELL_ABNEHMEND = new AttRdsEmpfehlungsCode("Staulänge sehr schnell abnehmend", 		Integer
	.valueOf("238"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsEmpfehlungsCode getZustand(final 		Integer
	 value) {
		for (AttRdsEmpfehlungsCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsEmpfehlungsCode getZustand(final String value) {
		for (AttRdsEmpfehlungsCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsEmpfehlungsCode> getZustaende() {
		List<AttRdsEmpfehlungsCode> list = new ArrayList<AttRdsEmpfehlungsCode>();
		list.add(ZUSTAND_0_NICHT_DEFINIERT);
		list.add(ZUSTAND_2_FOLGEN_SIE_DEN_SCHILDERN);
		list.add(ZUSTAND_3_DER_UMLEITUNGSBESCHILDERUNG_FOLGEN);
		list.add(ZUSTAND_61_FOLGEN_SIE_DEN_SCHILDERN_MIT_DEN_ORANGEN_PFEILEN);
		list.add(ZUSTAND_62_NICHT_DER_UMLEITUNGSBESCHILDERUNG_FOLGEN);
		list.add(ZUSTAND_4_EINE_UMLEITUNG_IST_EINGERICHTET);
		list.add(ZUSTAND_64_OBLIGATORISCHE_UMLEITUNG_EINGERICHTET);
		list.add(ZUSTAND_63_EINE_OERTLICHE_UMLEITUNG_IST_EINGERICHTET);
		list.add(ZUSTAND_5_KEINE_UMLEITUNGSEMPFEHLUNG);
		list.add(ZUSTAND_6_UMLEITUNG_WIRD_NICHT_MEHR_EMPFOHLEN);
		list.add(ZUSTAND_68_ORTSKUNDIGE_AUTOFAHRER_WERDEN_GEBETEN_DAS_GEBIET_WEITRAEUMIG_ZU_UMFAHREN);
		list.add(ZUSTAND_1_LKW_WIRD_EMPFOHLEN_DAS_GEBIET_WEITRAEUMIG_ZU_UMFAHREN);
		list.add(ZUSTAND_71_FUER_PKW);
		list.add(ZUSTAND_72_FUER_LEICHTE_LKW);
		list.add(ZUSTAND_9_FUER_PKW_UND_LEICHTE_LKW);
		list.add(ZUSTAND_73_FUER_FAHRZEUGE_MIT_KATALYSATOREN);
		list.add(ZUSTAND_74_FUER_FAHRZEUGE_OHNE_KATALYSATOREN);
		list.add(ZUSTAND_65_FUER_FAHRZEUGE_MIT_VERBRENNUNGSMOTOREN);
		list.add(ZUSTAND_66_FUER_FAHRZEUGE_MIT_DIESELMOTOREN);
		list.add(ZUSTAND_67_FUER_FAHRZEUGE_MIT_GASMOTOREN);
		list.add(ZUSTAND_69_FUER_ALLRADFAHRZEUGE_MIT_WINTERREIFEN_ODER_SCHNEEKETTEN);
		list.add(ZUSTAND_75_FUER_PKW_MIT_ANHAENGER);
		list.add(ZUSTAND_76_FUER_FAHRZEUGE_MIT_WOHNANHAENGER);
		list.add(ZUSTAND_77_FUER_FAHRZEUGE_MIT_ANHAENGER);
		list.add(ZUSTAND_8_FUER_LKW);
		list.add(ZUSTAND_78_FUER_SCHWERLASTVERKEHR);
		list.add(ZUSTAND_79_FUER_BUSSE);
		list.add(ZUSTAND_80_FUER_SPEZIALFAHRZEUGE);
		list.add(ZUSTAND_81_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN);
		list.add(ZUSTAND_82_FUER_GEFAHRGUTTRANSPORTE);
		list.add(ZUSTAND_7_FUER_GROSSRAUM_UND_SCHWERTRANSPORTE);
		list.add(ZUSTAND_83_FUER_GROSSRAUM_SCHWER_UND_GEFAHRGUTTRANSPORTE);
		list.add(ZUSTAND_84_FUER_KFZ_MIT_GERADZAHLIGEN_KENNZEICHEN);
		list.add(ZUSTAND_85_FUER_KFZ_MIT_UNGERADZAHLIGEN_KENNZEICHEN);
		list.add(ZUSTAND_88_FUER_DURCHGANGSVERKEHR);
		list.add(ZUSTAND_86_FUER_ALLE_FAHRZEUGE);
		list.add(ZUSTAND_153_FUER_FAEHRBETRIEB);
		list.add(ZUSTAND_89_FUER_SCHIENENVERKEHR);
		list.add(ZUSTAND_90_IM_U_BAHN_VERKEHR);
		list.add(ZUSTAND_91_GEFAHR);
		list.add(ZUSTAND_98_STRAHLUNGSGEFAHR);
		list.add(ZUSTAND_99_GASAUSTRITT);
		list.add(ZUSTAND_92_REPARATURARBEITEN);
		list.add(ZUSTAND_43_AUF_SICHERUNGSPOSTEN_ACHTEN);
		list.add(ZUSTAND_93_LOTSENDIENST_IM_EINSATZ);
		list.add(ZUSTAND_109_RETTUNGSHUBSCHRAUBER_IM_EINSATZ);
		list.add(ZUSTAND_47_ERHOEHTE_UNFALLGEFAHR);
		list.add(ZUSTAND_110_ES_HABEN_SICH_BEREITS_MEHRERE_UNFAELLE_EREIGNET);
		list.add(ZUSTAND_42_WEGEN_BERGUNGSARBEITEN);
		list.add(ZUSTAND_94_RETTUNGSFAHRZEUGE_IM_EINSATZ);
		list.add(ZUSTAND_95_VERKEHR_WIRD_AN_DER_UNFALLSTELLE_VORBEIGEFUEHRT);
		list.add(ZUSTAND_96_EXPLOSIONSGEFAHR);
		list.add(ZUSTAND_97_BRANDGEFAHR);
		list.add(ZUSTAND_100_FEUERWEHR_REGELT_DEN_VERKEHR);
		list.add(ZUSTAND_39_POLIZEI_REGELT_DEN_VERKEHR);
		list.add(ZUSTAND_181_VERKEHRSHELFER_REGELN_DEN_VERKEHR);
		list.add(ZUSTAND_40_UNFALLAUFNAHME);
		list.add(ZUSTAND_41_POLIZEI_FAEHRT_VERSTAERKT_STREIFE);
		list.add(ZUSTAND_101_GESCHWINDIGKEITSKONTROLLEN);
		list.add(ZUSTAND_102_DIE_GESCHWINDIGKEIT_IST_BEGRENZT);
		list.add(ZUSTAND_103_GESCHWINDIGKEITSBESCHRAENKUNG_FUER_LKW);
		list.add(ZUSTAND_104_LANGSAM_FAHREN);
		list.add(ZUSTAND_105_AUF_GESCHWINDIGKEITSBESCHRAENKUNG_ACHTEN);
		list.add(ZUSTAND_106_DIE_EMPFOHLENE_GESCHWINDIGKEIT_BEACHTEN);
		list.add(ZUSTAND_12_BITTE_VORSICHTIG_FAHREN);
		list.add(ZUSTAND_111_FAHREN_SIE_BITTE_BESONDERS_VORSICHTIG);
		list.add(ZUSTAND_112_VORSICHTIG_AN_DAS_STAUENDE_HERANFAHREN);
		list.add(ZUSTAND_13_ABSTAND_HALTEN);
		list.add(ZUSTAND_113_SICHERHEITSABSTAND_VERGROESSERN);
		list.add(ZUSTAND_23_BREMSEN_UEBERPRUEFEN);
		list.add(ZUSTAND_114_KEINE_UNNOETIGEN_LUECKEN_LASSEN);
		list.add(ZUSTAND_115_FAHREN_SIE_ZUEGIG_AN_DER_UNFALLSTELLE_VORBEI);
		list.add(ZUSTAND_116_NICHT_UNNOETIG_ABBREMSEN);
		list.add(ZUSTAND_14_AUF_SIGNALREGELUNG_ACHTEN);
		list.add(ZUSTAND_117_AUF_BESCHILDERUNG_ACHTEN);
		list.add(ZUSTAND_129_GASSE_FUER_RAEUM_UND_STREUFAHRZEUGE_FREI_HALTEN);
		list.add(ZUSTAND_16_VORSICHT_AN_DER_KREUZUNG);
		list.add(ZUSTAND_17_UEBERHOLEN_VERBOTEN);
		list.add(ZUSTAND_15_VORSICHT_BEIM_UEBERHOLEN);
		list.add(ZUSTAND_18_LICHT_EINSCHALTEN);
		list.add(ZUSTAND_19_NEBELSCHEINWERFER_EINSCHALTEN);
		list.add(ZUSTAND_118_WARNBLINKANLAGE_EINSCHALTEN);
		list.add(ZUSTAND_20_BITTE_DAS_FAHRZEUG_NICHT_VERLASSEN);
		list.add(ZUSTAND_239_BITTE_DAS_FAHRZEUG_VERLASSEN_UND_DEN_NAECHSTEN_SICHEREN_PLATZ_AUFSUCHEN);
		list.add(ZUSTAND_21_MOTOR_ABSTELLEN);
		list.add(ZUSTAND_22_FENSTER_SCHLIESSEN_UND_LUEFTUNG_ABSTELLEN);
		list.add(ZUSTAND_180_NICHTS_BRENNENDES_AUS_DEM_FAHRZEUG_WERFEN);
		list.add(ZUSTAND_119_NICHT_RAUCHEN);
		list.add(ZUSTAND_120_KEIN_OFFENES_FEUER);
		list.add(ZUSTAND_121_MOBILTELEFONE_UND_FUNKGERAETE_AUSSCHALTEN);
		list.add(ZUSTAND_29_STANDSTREIFEN_MITBENUTZEN);
		list.add(ZUSTAND_30_STANDSTREIFEN_NICHT_BEFAHREN);
		list.add(ZUSTAND_122_RETTUNGSFAHRZEUGE_UEBERHOLEN_LASSEN);
		list.add(ZUSTAND_123_GASSE_FUER_RETTUNGSFAHRZEUGE_BILDEN);
		list.add(ZUSTAND_124_AN_DEN_RAND_DER_STRASSE_HERANFAHREN);
		list.add(ZUSTAND_125_WARTEN_SIE_AUF_FUEHRUNGSFAHRZEUG);
		list.add(ZUSTAND_126_AUF_LAUTSPRECHERDURCHSAGEN_DER_POLIZEI_UND_DER_RETTUNGSDIENSTE_ACHTEN);
		list.add(ZUSTAND_136_NAECHSTEN_RAST_ODER_PARKPLATZ_ANFAHREN);
		list.add(ZUSTAND_128_AN_DER_NAECHSTEN_SICHEREN_STELLE_HALTEN);
		list.add(ZUSTAND_46_NUR_IM_NOTFALL_FAHREN);
		list.add(ZUSTAND_205_BITTE_DIE_U_BAHN_BENUTZEN);
		list.add(ZUSTAND_206_BITTE_DIE_STRASSENBAHN_BENUTZEN);
		list.add(ZUSTAND_207_BITTE_DEN_BUS_BENUTZEN);
		list.add(ZUSTAND_204_BITTE_DIE_BAHN_BENUTZEN);
		list.add(ZUSTAND_28_RECHTS_FAHREN);
		list.add(ZUSTAND_27_LINKS_FAHREN);
		list.add(ZUSTAND_131_BENUTZEN_SIE_DEN_RECHTEN_FAHRSTREIFEN);
		list.add(ZUSTAND_132_BENUTZEN_SIE_DEN_LINKEN_FAHRSTREIFEN);
		list.add(ZUSTAND_133_LKW_DEN_RECHTEN_FAHRSTREIFEN_BENUTZEN);
		list.add(ZUSTAND_134_LKW_DEN_LINKEN_FAHRSTREIFEN_BENUTZEN);
		list.add(ZUSTAND_195_BENUTZEN_SIE_DIE_FERNVERKEHRSSPUR);
		list.add(ZUSTAND_196_BENUTZEN_SIE_DIE_NAHVERKEHRSSPUR);
		list.add(ZUSTAND_197_BENUTZEN_SIE_DIE_LINKE_PARALLELFAHRBAHN);
		list.add(ZUSTAND_198_BENUTZEN_SIE_DIE_RECHTE_PARALLELFAHRBAHN);
		list.add(ZUSTAND_199_BENUTZEN_SIE_DIE_LKW_SPUR);
		list.add(ZUSTAND_35_AUF_DEM_RECHTEN_FAHRSTREIFEN);
		list.add(ZUSTAND_36_AUF_DEM_MITTLEREN_FAHRSTREIFEN);
		list.add(ZUSTAND_37_AUF_DEM_LINKEN_FAHRSTREIFEN);
		list.add(ZUSTAND_141_AUF_DER_RECHTEN_SEITE);
		list.add(ZUSTAND_142_IN_DER_MITTE);
		list.add(ZUSTAND_143_AUF_DER_LINKEN_SEITE);
		list.add(ZUSTAND_144_AUF_DER_BUSSPUR);
		list.add(ZUSTAND_145_AUF_DER_SPUR_FUER_FAHRGEMEINSCHAFTEN);
		list.add(ZUSTAND_146_AUF_DEM_STANDSTREIFEN);
		list.add(ZUSTAND_147_AUF_DER_NOTFALLSPUR);
		list.add(ZUSTAND_149_AUF_DER_SCHWERVERKEHRSSPUR_);
		list.add(ZUSTAND_150_AUF_DER_NAHVERKEHRSSPUR);
		list.add(ZUSTAND_155_AUF_DER_FERNVERKEHRSSPUR);
		list.add(ZUSTAND_156_AUF_DER_SCHNELLSPUR);
		list.add(ZUSTAND_169_AUF_DEM_LANGSAMFAHRSTREIFEN);
		list.add(ZUSTAND_170_AUF_DER_WENDESPUR);
		list.add(ZUSTAND_33_AUF_DEM_UEBERHOLSTREIFEN);
		list.add(ZUSTAND_34_AUF_DER_KRIECHSPUR);
		list.add(ZUSTAND_38_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_70_AM_MITTELSTREIFEN);
		list.add(ZUSTAND_31_IN_DER_GEGENRICHTUNG);
		list.add(ZUSTAND_32_AUF_DER_GEGENFAHRSPUR);
		list.add(ZUSTAND_148_AUF_DER_GEGENFAHRBAHN);
		list.add(ZUSTAND_157_AUF_DER_VERBINDUNGSFAHRBAHN);
		list.add(ZUSTAND_158_AUF_DER_PARALLELFAHRBAHN);
		list.add(ZUSTAND_159_AUF_DER_RECHTEN_PARALLELFAHRBAHN);
		list.add(ZUSTAND_160_AUF_DER_LINKEN_PARALLELFAHRBAHN);
		list.add(ZUSTAND_48_AUF_BRUECKEN);
		list.add(ZUSTAND_161_IN_TUNNELS);
		list.add(ZUSTAND_50_AN_TUNNELEIN_ODER_AUSGAENGEN);
		list.add(ZUSTAND_49_IN_SCHATTIGEN_BEREICHEN);
		list.add(ZUSTAND_162_IN_ANSCHLUSSSTELLEN);
		list.add(ZUSTAND_241_IM_BAUSTELLENBEREICH);
		list.add(ZUSTAND_163_IN_HOEHENLAGEN);
		list.add(ZUSTAND_164_IN_TIEFER_GELEGENEN_GEBIETEN);
		list.add(ZUSTAND_165_IM_KURVENBEREICH);
		list.add(ZUSTAND_166_HINTER_EINER_KUPPE);
		list.add(ZUSTAND_167_IN_DER_INNENSTADT);
		list.add(ZUSTAND_168_IM_INNENSTADTBEREICH);
		list.add(ZUSTAND_171_WEGEN_EINES_VORAUSGEGANGENEN_UNFALLS);
		list.add(ZUSTAND_200_WEGEN_EINES_VORAUSGEGANGENEN_VORFALLS);
		list.add(ZUSTAND_203_WEGEN_EINES_VORAUSGEGANGENEN_EREIGNISSES);
		list.add(ZUSTAND_172_WEGEN_ZU_HOHER_VERKEHRSBELASTUNG);
		list.add(ZUSTAND_173_WEGEN_HOHER_BESUCHERZAHLEN);
		list.add(ZUSTAND_52_BLOCKABFERTIGUNG);
		list.add(ZUSTAND_174_WEGEN_URLAUBSVERKEHRS);
		list.add(ZUSTAND_175_WEGEN_TECHNISCHER_PROBLEME);
		list.add(ZUSTAND_185_AUFGRUND_VON_HERABFALLENDEM_EIS);
		list.add(ZUSTAND_151_WEGEN_HITZE);
		list.add(ZUSTAND_152_WEGEN_FROST);
		list.add(ZUSTAND_10_SCHNEERAEUMFAHRZEUGE_IM_EINSATZ);
		list.add(ZUSTAND_11_STREUFAHRZEUGE_IM_EINSATZ);
		list.add(ZUSTAND_24_WINTERAUSRUESTUNG_EMPFOHLEN);
		list.add(ZUSTAND_107_SCHNEEKETTEN_ERFORDERLICH);
		list.add(ZUSTAND_51_WINTERSPERRE);
		list.add(ZUSTAND_25_SCHNEEKETTEN_EMPFOHLEN);
		list.add(ZUSTAND_26_SCHNEEKETTENPFLICHT);
		list.add(ZUSTAND_191_WINTERREIFEN_EMPFOHLEN);
		list.add(ZUSTAND_192_WINTERREIFEN_VORGESCHRIEBEN);
		list.add(ZUSTAND_108_WINTERREIFEN_ODER_SCHNEEKETTEN_ERFORDERLICH);
		list.add(ZUSTAND_201_BILDEN_SIE_BITTE_FAHRGEMEINSCHAFTEN);
		list.add(ZUSTAND_202_IST_HEUTE_IHR_AUTOFREIER_TAG_);
		list.add(ZUSTAND_178_BEI_DER_EINREISE);
		list.add(ZUSTAND_45_NUTZEN_SIE_DIE_OEFFENTLICHEN_VERKEHRSMITTEL);
		list.add(ZUSTAND_179_BEI_DER_AUSREISE);
		list.add(ZUSTAND_44_P_R_ANFAHREN_UND_OEFFENTLICHE_VERKEHRSMITTEL_BENUTZEN);
		list.add(ZUSTAND_209_FAHRPREIS_FUER_OEFFENTLICHE_VERKEHRSMITTEL_IST_IM_PARKTICKET_ENTHALTEN);
		list.add(ZUSTAND_210_VERMEIDEN_SIE_DIE_HAUPTVERKEHRSZEITEN);
		list.add(ZUSTAND_211_FUER_URLAUBSVERKEHR);
		list.add(ZUSTAND_212_FUER_ANWOHNER);
		list.add(ZUSTAND_240_FUER_BESUCHER);
		list.add(ZUSTAND_223_FUER_FERNVERKEHR);
		list.add(ZUSTAND_224_FUER_NAHVERKEHR);
		list.add(ZUSTAND_225_FUER_REGIONALVERKEHR);
		list.add(ZUSTAND_208_VORUEBERGEHEND);
		list.add(ZUSTAND_213_MEHRFACH);
		list.add(ZUSTAND_214_AM_TAGE);
		list.add(ZUSTAND_215_IN_VERKEHRSARMEN_ZEITEN);
		list.add(ZUSTAND_216_IN_DER_NACHT);
		list.add(ZUSTAND_217_BIS_AUF_WEITERES);
		list.add(ZUSTAND_218_FUER_ANKUNFT);
		list.add(ZUSTAND_219_FUER_ABFAHRT);
		list.add(ZUSTAND_220_NUR_ZUGANG);
		list.add(ZUSTAND_221_NUR);
		list.add(ZUSTAND_222_AUSSER);
		list.add(ZUSTAND_226_UNBESTAETIGTER_BERICHT);
		list.add(ZUSTAND_250_SEHR_KURZER_FAHRTAKT);
		list.add(ZUSTAND_251_REGELMAESSIGER_FAHRTAKT);
		list.add(ZUSTAND_252_RECHT_KURZER_FAHRTAKT);
		list.add(ZUSTAND_253_FAHRPLANMAESSIGER_FAHRTAKT);
		list.add(ZUSTAND_53_IN_NOERDLICHER_RICHTUNG);
		list.add(ZUSTAND_54_IN_NORDOESTLICHER_RICHTUNG);
		list.add(ZUSTAND_55_IN_OESTLICHER_RICHTUNG);
		list.add(ZUSTAND_56_IN_SUEDOESTLICHER_RICHTUNG);
		list.add(ZUSTAND_57_IN_SUEDLICHER_RICHTUNG);
		list.add(ZUSTAND_58_IN_SUEDWESTLICHER_RICHTUNG);
		list.add(ZUSTAND_59_IN_WESTLICHER_RICHTUNG);
		list.add(ZUSTAND_60_IN_NORDWESTLICHER_RICHTUNG);
		list.add(ZUSTAND_232_FUER_STRASSEN_NACH);
		list.add(ZUSTAND_233_FUER_STRASSEN_AUS);
		list.add(ZUSTAND_154_FUER_STRASSEN_IN);
		list.add(ZUSTAND_176_STADTEINWAERTS);
		list.add(ZUSTAND_242_AUS);
		list.add(ZUSTAND_243_NACH);
		list.add(ZUSTAND_244_IN);
		list.add(ZUSTAND_177_STADTAUSWAERTS);
		list.add(ZUSTAND_231_ENTSCHULDIGEN_SIE_ETWAIGE_VERZOEGERUNGEN);
		list.add(ZUSTAND_234_WIR_DANKEN_IHNEN_FUER_IHRE_MITARBEIT);
		list.add(ZUSTAND_245_STAULAENGE_ZUNEHMEND);
		list.add(ZUSTAND_246_STAULAENGE_SEHR_LANGSAM_ZUNEHMEND);
		list.add(ZUSTAND_247_STAULAENGE_LANGSAM_ZUNEHMEND);
		list.add(ZUSTAND_248_STAULAENGE_SCHNELL_ZUNEHMEND);
		list.add(ZUSTAND_249_STAULAENGE_SEHR_SCHNELL_ZUNEHMEND);
		list.add(ZUSTAND_255_STAULAENGE_ABNEHMEND);
		list.add(ZUSTAND_235_STAULAENGE_SEHR_LANGSAM_ABNEHMEND);
		list.add(ZUSTAND_236_STAULAENGE_LANGSAM_ABNEHMEND);
		list.add(ZUSTAND_237_STAULAENGE_SCHNELL_ABNEHMEND);
		list.add(ZUSTAND_238_STAULAENGE_SEHR_SCHNELL_ABNEHMEND);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsEmpfehlungsCode(final 		Integer
	 value) {
		super(value);
	}
	
	private AttRdsEmpfehlungsCode(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
