/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ereignis-Code.
<p>
Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section, Spalte 'C')
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
@Wertebereich(
	minimum = 0L,
	maximum = 65535L,
	einheit = ""
)
public class AttRdsEreignisCode extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("65535");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_0_NICHT_DEFINIERT = new AttRdsEreignisCode("nicht definiert", 		Integer
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1_VERKEHRSBEHINDERUNG = new AttRdsEreignisCode("Verkehrsbehinderung", 		Integer
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_101__L_STAU = new AttRdsEreignisCode("(L) Stau", 		Integer
	.valueOf("101"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_102__1_KM_STAU = new AttRdsEreignisCode("1 km Stau", 		Integer
	.valueOf("102"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_103__2_KM_STAU = new AttRdsEreignisCode("2 km Stau", 		Integer
	.valueOf("103"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_129__3_KM_STAU = new AttRdsEreignisCode("3 km Stau", 		Integer
	.valueOf("129"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_104__4_KM_STAU = new AttRdsEreignisCode("4 km Stau", 		Integer
	.valueOf("104"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_105__6_KM_STAU = new AttRdsEreignisCode("6 km Stau", 		Integer
	.valueOf("105"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_106__10_KM_STAU = new AttRdsEreignisCode("10 km Stau", 		Integer
	.valueOf("106"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_130_STAUGEFAHR = new AttRdsEreignisCode("Staugefahr", 		Integer
	.valueOf("130"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_108__L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("(L) stockender Verkehr", 		Integer
	.valueOf("108"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_109__1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("1 km stockender Verkehr", 		Integer
	.valueOf("109"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_110__2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("2 km stockender Verkehr", 		Integer
	.valueOf("110"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_131__3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("3 km stockender Verkehr", 		Integer
	.valueOf("131"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_111__4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("4 km stockender Verkehr", 		Integer
	.valueOf("111"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_112__6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("6 km stockender Verkehr", 		Integer
	.valueOf("112"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_113__10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("10 km stockender Verkehr", 		Integer
	.valueOf("113"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_132_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Gefahr von stockendem Verkehr", 		Integer
	.valueOf("132"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_133_LANGE_STAUS = new AttRdsEreignisCode("lange Staus", 		Integer
	.valueOf("133"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_115__L_DICHTER_VERKEHR = new AttRdsEreignisCode("(L) dichter Verkehr", 		Integer
	.valueOf("115"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_116__1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("1 km dichter Verkehr", 		Integer
	.valueOf("116"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_117__2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("2 km dichter Verkehr", 		Integer
	.valueOf("117"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_134__3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("3 km dichter Verkehr", 		Integer
	.valueOf("134"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_118__4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("4 km dichter Verkehr", 		Integer
	.valueOf("118"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_119__6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("6 km dichter Verkehr", 		Integer
	.valueOf("119"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_120__10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("10 km dichter Verkehr", 		Integer
	.valueOf("120"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_122__L_REGER_VERKEHR = new AttRdsEreignisCode("(L) reger Verkehr", 		Integer
	.valueOf("122"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_142_DICHTERER_VERKEHR_ALS_NORMAL = new AttRdsEreignisCode("dichterer Verkehr als normal", 		Integer
	.valueOf("142"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_143_SEHR_VIEL_DICHTERER_VERKEHR_ALS_NORMAL = new AttRdsEreignisCode("sehr viel dichterer Verkehr als normal", 		Integer
	.valueOf("143"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_124_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("störungsfreier Verkehr", 		Integer
	.valueOf("124"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_125__L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("(L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("125"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_135__L_DICHTER_VERKEHR_MIT_ABNEHMENDER_TENDENZ = new AttRdsEreignisCode("(L) dichter Verkehr mit abnehmender Tendenz", 		Integer
	.valueOf("135"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_136_VERKEHRSSTOERUNG = new AttRdsEreignisCode("Verkehrsstörung", 		Integer
	.valueOf("136"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_70_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_10_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 10 km/h", 		Integer
	.valueOf("70"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_71_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_20_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 20 km/h", 		Integer
	.valueOf("71"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_72_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_30_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 30 km/h", 		Integer
	.valueOf("72"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_73_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_40_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 40 km/h", 		Integer
	.valueOf("73"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_74_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_50_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 50 km/h", 		Integer
	.valueOf("74"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_75_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_60_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 60 km/h", 		Integer
	.valueOf("75"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_76_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_70_KM_H = new AttRdsEreignisCode("Verkehrsstörung, mittlere Geschwindigkeit 70 km/h", 		Integer
	.valueOf("76"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_137__L_SCHWACHER_VERKEHR = new AttRdsEreignisCode("(L) schwacher Verkehr", 		Integer
	.valueOf("137"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_138__L_STOCKENDER_VERKEHR_VORSICHTIG_AN_DAS_STAUENDE_HERANFAHREN = new AttRdsEreignisCode("(L) stockender Verkehr, vorsichtig an das Stauende heranfahren", 		Integer
	.valueOf("138"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_139__L_STOCKENDER_VERKEHR_STAUENDE_LIEGT_IM_KURVENBEREICH = new AttRdsEreignisCode("(L) stockender Verkehr, Stauende liegt im Kurvenbereich", 		Integer
	.valueOf("139"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_140__L_STOCKENDER_VERKEHR_STAUENDE_LIEGT_HINTER_EINER_KUPPE = new AttRdsEreignisCode("(L) stockender Verkehr, Stauende liegt hinter einer Kuppe", 		Integer
	.valueOf("140"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2__L_STOCKENDER_VERKEHR_STAUGEFAHR = new AttRdsEreignisCode("(L) stockender Verkehr, Staugefahr", 		Integer
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_215_UNFALL_L_STAU = new AttRdsEreignisCode("Unfall, (L) Stau", 		Integer
	.valueOf("215"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_216_UNFALL_1_KM_STAU = new AttRdsEreignisCode("Unfall, 1 km Stau", 		Integer
	.valueOf("216"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_217_UNFALL_2_KM_STAU = new AttRdsEreignisCode("Unfall, 2 km Stau", 		Integer
	.valueOf("217"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_348_UNFALL_3_KM_STAU = new AttRdsEreignisCode("Unfall, 3 km Stau", 		Integer
	.valueOf("348"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_218_UNFALL_4_KM_STAU = new AttRdsEreignisCode("Unfall, 4 km Stau", 		Integer
	.valueOf("218"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_219_UNFALL_6_KM_STAU = new AttRdsEreignisCode("Unfall, 6 km Stau", 		Integer
	.valueOf("219"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_220_UNFALL_10_KM_STAU = new AttRdsEreignisCode("Unfall, 10 km Stau", 		Integer
	.valueOf("220"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_221_UNFALL_STAUGEFAHR = new AttRdsEreignisCode("Unfall, Staugefahr", 		Integer
	.valueOf("221"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_222_UNFALL_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, (L) stockender Verkehr", 		Integer
	.valueOf("222"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_223_UNFALL_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, 1 km stockender Verkehr", 		Integer
	.valueOf("223"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_224_UNFALL_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, 2 km stockender Verkehr", 		Integer
	.valueOf("224"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_349_UNFALL_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, 3 km stockender Verkehr", 		Integer
	.valueOf("349"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_225_UNFALL_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, 4 km stockender Verkehr", 		Integer
	.valueOf("225"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_226_UNFALL_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, 6 km stockender Verkehr", 		Integer
	.valueOf("226"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_227_UNFALL_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Unfall, 10 km stockender Verkehr", 		Integer
	.valueOf("227"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_228_UNFALL_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Unfall, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("228"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_229_UNFALL_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, (L) dichter Verkehr", 		Integer
	.valueOf("229"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_230_UNFALL_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, 1 km dichter Verkehr", 		Integer
	.valueOf("230"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_231_UNFALL_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, 2 km dichter Verkehr", 		Integer
	.valueOf("231"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_350_UNFALL_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, 3 km dichter Verkehr", 		Integer
	.valueOf("350"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_232_UNFALL_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, 4 km dichter Verkehr", 		Integer
	.valueOf("232"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_233_UNFALL_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, 6 km dichter Verkehr", 		Integer
	.valueOf("233"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_234_UNFALL_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Unfall, 10 km dichter Verkehr", 		Integer
	.valueOf("234"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_236_UNFALL_L_REGER_VERKEHR = new AttRdsEreignisCode("Unfall, (L) reger Verkehr", 		Integer
	.valueOf("236"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_238_UNFALL_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Unfall, störungsfreier Verkehr", 		Integer
	.valueOf("238"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_239_UNFALL_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Unfall, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("239"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_250_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, (L) Stau", 		Integer
	.valueOf("250"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_251_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_1_KM_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 1 km Stau", 		Integer
	.valueOf("251"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_252_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_2_KM_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 2 km Stau", 		Integer
	.valueOf("252"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_352_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_3_KM_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 3 km Stau", 		Integer
	.valueOf("352"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_253_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_4_KM_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 4 km Stau", 		Integer
	.valueOf("253"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_254_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_6_KM_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 6 km Stau", 		Integer
	.valueOf("254"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_255_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_10_KM_STAU = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 10 km Stau", 		Integer
	.valueOf("255"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_256_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_STAUGEFAHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, Staugefahr", 		Integer
	.valueOf("256"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_257_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, (L) stockender Verkehr", 		Integer
	.valueOf("257"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_258_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 1 km stockender Verkehr", 		Integer
	.valueOf("258"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_259_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 2 km stockender Verkehr", 		Integer
	.valueOf("259"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_353_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 3 km stockender Verkehr", 		Integer
	.valueOf("353"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_260_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 4 km stockender Verkehr", 		Integer
	.valueOf("260"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_261_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 6 km stockender Verkehr", 		Integer
	.valueOf("261"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_262_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 10 km stockender Verkehr", 		Integer
	.valueOf("262"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_263_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("263"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_208_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle", 		Integer
	.valueOf("208"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_264_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, (L) dichter Verkehr", 		Integer
	.valueOf("264"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_265_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 1 km dichter Verkehr", 		Integer
	.valueOf("265"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_266_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 2 km dichter Verkehr", 		Integer
	.valueOf("266"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_354_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 3 km dichter Verkehr", 		Integer
	.valueOf("354"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_267_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 4 km dichter Verkehr", 		Integer
	.valueOf("267"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_268_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 6 km dichter Verkehr", 		Integer
	.valueOf("268"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_269_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, 10 km dichter Verkehr", 		Integer
	.valueOf("269"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_271_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_REGER_VERKEHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, (L) reger Verkehr", 		Integer
	.valueOf("271"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_274_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("274"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_355_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_GEFAHR = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, Gefahr", 		Integer
	.valueOf("355"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_278_VERLORENE_LADUNG_L_STAU = new AttRdsEreignisCode("verlorene Ladung, (L) Stau", 		Integer
	.valueOf("278"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_279_VERLORENE_LADUNG_1_KM_STAU = new AttRdsEreignisCode("verlorene Ladung, 1 km Stau", 		Integer
	.valueOf("279"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_280_VERLORENE_LADUNG_2_KM_STAU = new AttRdsEreignisCode("verlorene Ladung, 2 km Stau", 		Integer
	.valueOf("280"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_356_VERLORENE_LADUNG_3_KM_STAU = new AttRdsEreignisCode("verlorene Ladung, 3 km Stau", 		Integer
	.valueOf("356"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_281_VERLORENE_LADUNG_4_KM_STAU = new AttRdsEreignisCode("verlorene Ladung, 4 km Stau", 		Integer
	.valueOf("281"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_282_VERLORENE_LADUNG_6_KM_STAU = new AttRdsEreignisCode("verlorene Ladung, 6 km Stau", 		Integer
	.valueOf("282"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_283_VERLORENE_LADUNG_10_KM_STAU = new AttRdsEreignisCode("verlorene Ladung, 10 km Stau", 		Integer
	.valueOf("283"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_284_VERLORENE_LADUNG_STAUGEFAHR = new AttRdsEreignisCode("verlorene Ladung, Staugefahr", 		Integer
	.valueOf("284"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_285_VERLORENE_LADUNG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, (L) stockender Verkehr", 		Integer
	.valueOf("285"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_286_VERLORENE_LADUNG_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 1 km stockender Verkehr", 		Integer
	.valueOf("286"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_287_VERLORENE_LADUNG_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 2 km stockender Verkehr", 		Integer
	.valueOf("287"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_357_VERLORENE_LADUNG_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 3 km stockender Verkehr", 		Integer
	.valueOf("357"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_288_VERLORENE_LADUNG_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 4 km stockender Verkehr", 		Integer
	.valueOf("288"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_289_VERLORENE_LADUNG_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 6 km stockender Verkehr", 		Integer
	.valueOf("289"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_290_VERLORENE_LADUNG_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 10 km stockender Verkehr", 		Integer
	.valueOf("290"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_291_VERLORENE_LADUNG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("291"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_292_VERLORENE_LADUNG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, (L) dichter Verkehr", 		Integer
	.valueOf("292"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_293_VERLORENE_LADUNG_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 1 km dichter Verkehr", 		Integer
	.valueOf("293"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_294_VERLORENE_LADUNG_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 2 km dichter Verkehr", 		Integer
	.valueOf("294"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_358_VERLORENE_LADUNG_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 3 km dichter Verkehr", 		Integer
	.valueOf("358"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_295_VERLORENE_LADUNG_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 4 km dichter Verkehr", 		Integer
	.valueOf("295"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_296_VERLORENE_LADUNG_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 6 km dichter Verkehr", 		Integer
	.valueOf("296"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_297_VERLORENE_LADUNG_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, 10 km dichter Verkehr", 		Integer
	.valueOf("297"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_299_VERLORENE_LADUNG_L_REGER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, (L) reger Verkehr", 		Integer
	.valueOf("299"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_301_VERLORENE_LADUNG_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("verlorene Ladung, störungsfreier Verkehr", 		Integer
	.valueOf("301"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_302_VERLORENE_LADUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("verlorene Ladung, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("302"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_360_UMGESTUERZTES_FAHRZEUG_L_STAU = new AttRdsEreignisCode("umgestürztes Fahrzeug, (L) Stau", 		Integer
	.valueOf("360"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_361_UMGESTUERZTES_FAHRZEUG_STAUGEFAHR = new AttRdsEreignisCode("umgestürztes Fahrzeug, Staugefahr", 		Integer
	.valueOf("361"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_362_UMGESTUERZTES_FAHRZEUG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("umgestürztes Fahrzeug, (L) stockender Verkehr", 		Integer
	.valueOf("362"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_363_UMGESTUERZTES_FAHRZEUG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("umgestürztes Fahrzeug, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("363"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_364_UMGESTUERZTES_FAHRZEUG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("umgestürztes Fahrzeug, (L) dichter Verkehr", 		Integer
	.valueOf("364"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_366_UMGESTUERZTES_FAHRZEUG_L_REGER_VERKEHR = new AttRdsEreignisCode("umgestürztes Fahrzeug, (L) reger Verkehr", 		Integer
	.valueOf("366"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_368_UMGESTUERZTES_FAHRZEUG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("umgestürztes Fahrzeug, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("368"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_379__L_STAU_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("(L) Stau nach vorausgegangenem Unfall", 		Integer
	.valueOf("379"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_380_STAUGEFAHR_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("Staugefahr nach vorausgegangenem Unfall", 		Integer
	.valueOf("380"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_381__L_STOCKENDER_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("(L) stockender Verkehr nach vorausgegangenem Unfall", 		Integer
	.valueOf("381"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_382_GEFAHR_VON_STOCKENDEM_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("Gefahr von stockendem Verkehr nach vorausgegangenem Unfall", 		Integer
	.valueOf("382"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_383__L_DICHTER_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("(L) dichter Verkehr nach vorausgegangenem Unfall", 		Integer
	.valueOf("383"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_385__L_REGER_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("(L) reger Verkehr nach vorausgegangenem Unfall", 		Integer
	.valueOf("385"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_387__L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ_NACH_VORAUSGEGANGENEM_UNFALL = new AttRdsEreignisCode("(L) dichter Verkehr mit zunehmender Tendenz nach vorausgegangenem Unfall", 		Integer
	.valueOf("387"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_313_DEFEKTES_FAHRZEUG_L_STAU = new AttRdsEreignisCode("defektes Fahrzeug, (L) Stau", 		Integer
	.valueOf("313"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_314_DEFEKTES_FAHRZEUG_STAUGEFAHR = new AttRdsEreignisCode("defektes Fahrzeug, Staugefahr", 		Integer
	.valueOf("314"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_315_DEFEKTES_FAHRZEUG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("defektes Fahrzeug, (L) stockender Verkehr", 		Integer
	.valueOf("315"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_316_DEFEKTES_FAHRZEUG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("defektes Fahrzeug, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("316"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_317_DEFEKTES_FAHRZEUG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("defektes Fahrzeug, (L) dichter Verkehr", 		Integer
	.valueOf("317"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_319_DEFEKTES_FAHRZEUG_L_REGER_VERKEHR = new AttRdsEreignisCode("defektes Fahrzeug, (L) reger Verkehr", 		Integer
	.valueOf("319"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_321_DEFEKTES_FAHRZEUG_STOERUNGSFREIER_VERKEHRSFLUSS = new AttRdsEreignisCode("defektes Fahrzeug, störungsfreier Verkehrsfluss", 		Integer
	.valueOf("321"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_322_DEFEKTES_FAHRZEUG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("defektes Fahrzeug, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("322"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_410_GESPERRT_L_STAU = new AttRdsEreignisCode("gesperrt, (L) Stau", 		Integer
	.valueOf("410"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_411_GESPERRT_1_KM_STAU = new AttRdsEreignisCode("gesperrt, 1 km Stau", 		Integer
	.valueOf("411"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_412_GESPERRT_2_KM_STAU = new AttRdsEreignisCode("gesperrt, 2 km Stau", 		Integer
	.valueOf("412"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_495_GESPERRT_3_KM_STAU = new AttRdsEreignisCode("gesperrt, 3 km Stau", 		Integer
	.valueOf("495"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_413_GESPERRT_4_KM_STAU = new AttRdsEreignisCode("gesperrt, 4 km Stau", 		Integer
	.valueOf("413"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_414_GESPERRT_6_KM_STAU = new AttRdsEreignisCode("gesperrt, 6 km Stau", 		Integer
	.valueOf("414"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_415_GESPERRT_10_KM_STAU = new AttRdsEreignisCode("gesperrt, 10 km Stau", 		Integer
	.valueOf("415"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_416_GESPERRT_STAUGEFAHR = new AttRdsEreignisCode("gesperrt, Staugefahr", 		Integer
	.valueOf("416"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_417_GESPERRT_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, (L) stockender Verkehr", 		Integer
	.valueOf("417"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_418_GESPERRT_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, 1 km stockender Verkehr", 		Integer
	.valueOf("418"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_419_GESPERRT_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, 2 km stockender Verkehr", 		Integer
	.valueOf("419"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_496_GESPERRT_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, 3 km stockender Verkehr", 		Integer
	.valueOf("496"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_420_GESPERRT_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, 4 km stockender Verkehr", 		Integer
	.valueOf("420"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_421_GESPERRT_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, 6 km stockender Verkehr", 		Integer
	.valueOf("421"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_422_GESPERRT_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("gesperrt, 10 km stockender Verkehr", 		Integer
	.valueOf("422"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_423_GESPERRT_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("gesperrt, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("423"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_424_GESPERRT_L_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, (L) dichter Verkehr", 		Integer
	.valueOf("424"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_425_GESPERRT_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, 1 km dichter Verkehr", 		Integer
	.valueOf("425"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_426_GESPERRT_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, 2 km dichter Verkehr", 		Integer
	.valueOf("426"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_497_GESPERRT_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, 3 km dichter Verkehr", 		Integer
	.valueOf("497"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_427_GESPERRT_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, 4 km dichter Verkehr", 		Integer
	.valueOf("427"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_428_GESPERRT_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, 6 km dichter Verkehr", 		Integer
	.valueOf("428"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_429_GESPERRT_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("gesperrt, 10 km dichter Verkehr", 		Integer
	.valueOf("429"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_431_GESPERRT_L_REGER_VERKEHR = new AttRdsEreignisCode("gesperrt, (L) reger Verkehr", 		Integer
	.valueOf("431"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_433_GESPERRT_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("gesperrt, störungsfreier Verkehr", 		Integer
	.valueOf("433"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_434_GESPERRT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("gesperrt, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("434"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_438_BLOCKIERT_L_STAU = new AttRdsEreignisCode("blockiert, (L) Stau", 		Integer
	.valueOf("438"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_439_BLOCKIERT_1_KM_STAU = new AttRdsEreignisCode("blockiert, 1 km Stau", 		Integer
	.valueOf("439"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_440_BLOCKIERT_2_KM_STAU = new AttRdsEreignisCode("blockiert, 2 km Stau", 		Integer
	.valueOf("440"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_498_BLOCKIERT_3_KM_STAU = new AttRdsEreignisCode("blockiert, 3 km Stau", 		Integer
	.valueOf("498"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_441_BLOCKIERT_4_KM_STAU = new AttRdsEreignisCode("blockiert, 4 km Stau", 		Integer
	.valueOf("441"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_442_BLOCKIERT_6_KM_STAU = new AttRdsEreignisCode("blockiert, 6 km Stau", 		Integer
	.valueOf("442"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_443_BLOCKIERT_10_KM_STAU = new AttRdsEreignisCode("blockiert, 10 km Stau", 		Integer
	.valueOf("443"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_444_BLOCKIERT_STAUGEFAHR = new AttRdsEreignisCode("blockiert, Staugefahr", 		Integer
	.valueOf("444"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_445_BLOCKIERT_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, (L) stockender Verkehr", 		Integer
	.valueOf("445"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_446_BLOCKIERT_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, 1 km stockender Verkehr", 		Integer
	.valueOf("446"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_447_BLOCKIERT_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, 2 km stockender Verkehr", 		Integer
	.valueOf("447"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_499_BLOCKIERT_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, 3 km stockender Verkehr", 		Integer
	.valueOf("499"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_448_BLOCKIERT_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, 4 km stockender Verkehr", 		Integer
	.valueOf("448"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_449_BLOCKIERT_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, 6 km stockender Verkehr", 		Integer
	.valueOf("449"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_450_BLOCKIERT_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("blockiert, 10 km stockender Verkehr", 		Integer
	.valueOf("450"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_451_BLOCKIERT_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("blockiert, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("451"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_452_BLOCKIERT_L_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, (L) dichter Verkehr", 		Integer
	.valueOf("452"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_453_BLOCKIERT_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, 1 km dichter Verkehr", 		Integer
	.valueOf("453"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_454_BLOCKIERT_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, 2 km dichter Verkehr", 		Integer
	.valueOf("454"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_626_BLOCKIERT_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, 3 km dichter Verkehr", 		Integer
	.valueOf("626"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_455_BLOCKIERT_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, 4 km dichter Verkehr", 		Integer
	.valueOf("455"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_456_BLOCKIERT_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, 6 km dichter Verkehr", 		Integer
	.valueOf("456"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_457_BLOCKIERT_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("blockiert, 10 km dichter Verkehr", 		Integer
	.valueOf("457"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_459_BLOCKIERT_L_REGER_VERKEHR = new AttRdsEreignisCode("blockiert, (L) reger Verkehr", 		Integer
	.valueOf("459"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_461_BLOCKIERT_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("blockiert, störungsfreier Verkehr", 		Integer
	.valueOf("461"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_462_BLOCKIERT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("blockiert, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("462"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_521_FAHRSTREIFEN_GESPERRT_L_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, (L) Stau", 		Integer
	.valueOf("521"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_522_FAHRSTREIFEN_GESPERRT_1_KM_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, 1 km Stau", 		Integer
	.valueOf("522"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_523_FAHRSTREIFEN_GESPERRT_2_KM_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, 2 km Stau", 		Integer
	.valueOf("523"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_651_FAHRSTREIFEN_GESPERRT_3_KM_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, 3 km Stau", 		Integer
	.valueOf("651"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_524_FAHRSTREIFEN_GESPERRT_4_KM_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, 4 km Stau", 		Integer
	.valueOf("524"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_525_FAHRSTREIFEN_GESPERRT_6_KM_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, 6 km Stau", 		Integer
	.valueOf("525"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_526_FAHRSTREIFEN_GESPERRT_10_KM_STAU = new AttRdsEreignisCode("Fahrstreifen gesperrt, 10 km Stau", 		Integer
	.valueOf("526"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_527_FAHRSTREIFEN_GESPERRT_STAUGEFAHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, Staugefahr", 		Integer
	.valueOf("527"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_528_FAHRSTREIFEN_GESPERRT_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, (L) stockender Verkehr", 		Integer
	.valueOf("528"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_529_FAHRSTREIFEN_GESPERRT_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 1 km stockender Verkehr", 		Integer
	.valueOf("529"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_530_FAHRSTREIFEN_GESPERRT_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 2 km stockender Verkehr", 		Integer
	.valueOf("530"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_652_FAHRSTREIFEN_GESPERRT_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 3 km stockender Verkehr", 		Integer
	.valueOf("652"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_531_FAHRSTREIFEN_GESPERRT_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 4 km stockender Verkehr", 		Integer
	.valueOf("531"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_532_FAHRSTREIFEN_GESPERRT_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 6 km stockender Verkehr", 		Integer
	.valueOf("532"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_533_FAHRSTREIFEN_GESPERRT_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 10 km stockender Verkehr", 		Integer
	.valueOf("533"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_534_FAHRSTREIFEN_GESPERRT_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("534"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_535_FAHRSTREIFEN_GESPERRT_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, (L) dichter Verkehr", 		Integer
	.valueOf("535"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_536_FAHRSTREIFEN_GESPERRT_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 1 km dichter Verkehr", 		Integer
	.valueOf("536"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_537_FAHRSTREIFEN_GESPERRT_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 2 km dichter Verkehr", 		Integer
	.valueOf("537"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_653_FAHRSTREIFEN_GESPERRT_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 3 km dichter Verkehr", 		Integer
	.valueOf("653"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_538_FAHRSTREIFEN_GESPERRT_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 4 km dichter Verkehr", 		Integer
	.valueOf("538"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_539_FAHRSTREIFEN_GESPERRT_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 6 km dichter Verkehr", 		Integer
	.valueOf("539"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_540_FAHRSTREIFEN_GESPERRT_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, 10 km dichter Verkehr", 		Integer
	.valueOf("540"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_542_FAHRSTREIFEN_GESPERRT_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, (L) reger Verkehr", 		Integer
	.valueOf("542"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_544_FAHRSTREIFEN_GESPERRT_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrstreifen gesperrt, störungsfreier Verkehr", 		Integer
	.valueOf("544"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_545_FAHRSTREIFEN_GESPERRT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrstreifen gesperrt, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("545"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_546_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_STAU = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, (L) Stau", 		Integer
	.valueOf("546"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_547_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_STAUGEFAHR = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, Staugefahr", 		Integer
	.valueOf("547"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_548_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, (L) stockender Verkehr", 		Integer
	.valueOf("548"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_549_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("549"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_550_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, (L) dichter Verkehr", 		Integer
	.valueOf("550"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_552_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, (L) reger Verkehr", 		Integer
	.valueOf("552"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_554_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, störungsfreier Verkehr", 		Integer
	.valueOf("554"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_555_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("555"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_556_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_STAU = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, (L) Stau", 		Integer
	.valueOf("556"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_557_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_STAUGEFAHR = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, Staugefahr", 		Integer
	.valueOf("557"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_558_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, (L) stockender Verkehr", 		Integer
	.valueOf("558"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_559_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("559"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_560_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, (L) dichter Verkehr", 		Integer
	.valueOf("560"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_562_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, (L) reger Verkehr", 		Integer
	.valueOf("562"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_564_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, störungsfreier Verkehr", 		Integer
	.valueOf("564"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_565_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("565"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_566_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_STAU = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, (L) Stau", 		Integer
	.valueOf("566"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_567_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_STAUGEFAHR = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, Staugefahr", 		Integer
	.valueOf("567"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_568_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, (L) stockender Verkehr", 		Integer
	.valueOf("568"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_569_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("569"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_570_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, (L) dichter Verkehr", 		Integer
	.valueOf("570"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_572_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, (L) reger Verkehr", 		Integer
	.valueOf("572"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_574_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, störungsfreier Verkehr", 		Integer
	.valueOf("574"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_575_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("575"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_576_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STAU = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, (L) Stau", 		Integer
	.valueOf("576"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_577_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_1_KM_STAU_ = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 1 km Stau ", 		Integer
	.valueOf("577"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_578_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_2_KM_STAU = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 2 km Stau", 		Integer
	.valueOf("578"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_654_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_3_KM_STAU = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 3 km Stau", 		Integer
	.valueOf("654"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_579_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_4_KM_STAU = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 4 km Stau", 		Integer
	.valueOf("579"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_580_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_6_KM_STAU = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 6 km Stau", 		Integer
	.valueOf("580"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_581_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_10_KM_STAU = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 10 km Stau", 		Integer
	.valueOf("581"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_582_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STAUGEFAHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, Staugefahr", 		Integer
	.valueOf("582"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_583_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, (L) stockender Verkehr", 		Integer
	.valueOf("583"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_584_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 1 km stockender Verkehr", 		Integer
	.valueOf("584"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_585_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 2 km stockender Verkehr", 		Integer
	.valueOf("585"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_655_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 3 km stockender Verkehr", 		Integer
	.valueOf("655"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_586_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 4 km stockender Verkehr", 		Integer
	.valueOf("586"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_587_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 6 km stockender Verkehr", 		Integer
	.valueOf("587"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_588_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 10 km stockender Verkehr", 		Integer
	.valueOf("588"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_589_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("589"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_590_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, (L) dichter Verkehr", 		Integer
	.valueOf("590"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_591_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 1 km dichter Verkehr", 		Integer
	.valueOf("591"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_592_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 2 km dichter Verkehr", 		Integer
	.valueOf("592"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_656_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 3 km dichter Verkehr", 		Integer
	.valueOf("656"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_593_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 4 km dichter Verkehr", 		Integer
	.valueOf("593"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_594_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 6 km dichter Verkehr", 		Integer
	.valueOf("594"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_595_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, 10 km dichter Verkehr", 		Integer
	.valueOf("595"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_597_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_REGER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, (L) reger Verkehr", 		Integer
	.valueOf("597"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_599_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, störungsfreier Verkehr", 		Integer
	.valueOf("599"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_600_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_604_FAHRBAHNVERENGUNG_L_STAU = new AttRdsEreignisCode("Fahrbahnverengung, (L) Stau", 		Integer
	.valueOf("604"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_605_FAHRBAHNVERENGUNG_STAUGEFAHR = new AttRdsEreignisCode("Fahrbahnverengung, Staugefahr", 		Integer
	.valueOf("605"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_606_FAHRBAHNVERENGUNG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, (L) stockender Verkehr", 		Integer
	.valueOf("606"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_607_FAHRBAHNVERENGUNG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("607"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_608_FAHRBAHNVERENGUNG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, (L) dichter Verkehr", 		Integer
	.valueOf("608"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_610_FAHRBAHNVERENGUNG_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, (L) reger Verkehr", 		Integer
	.valueOf("610"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_612_FAHRBAHNVERENGUNG_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, störungsfreier Verkehr", 		Integer
	.valueOf("612"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_613_FAHRBAHNVERENGUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrbahnverengung, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("613"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_614_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STAU = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, (L) Stau", 		Integer
	.valueOf("614"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_615_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STAUGEFAHR = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, Staugefahr", 		Integer
	.valueOf("615"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_616_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, (L) stockender Verkehr", 		Integer
	.valueOf("616"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_617_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("617"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_618_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, (L) dichter Verkehr", 		Integer
	.valueOf("618"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_620_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, (L) reger Verkehr", 		Integer
	.valueOf("620"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_622_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, störungsfreier Verkehr", 		Integer
	.valueOf("622"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_623_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("623"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_710_BAUSTELLE_L_STAU = new AttRdsEreignisCode("Baustelle, (L) Stau", 		Integer
	.valueOf("710"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_711_BAUSTELLE_1_KM_STAU = new AttRdsEreignisCode("Baustelle, 1 km Stau", 		Integer
	.valueOf("711"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_712_BAUSTELLE_2_KM_STAU = new AttRdsEreignisCode("Baustelle, 2 km Stau", 		Integer
	.valueOf("712"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_812_BAUSTELLE_3_KM_STAU = new AttRdsEreignisCode("Baustelle, 3 km Stau", 		Integer
	.valueOf("812"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_713_BAUSTELLE_4_KM_STAU = new AttRdsEreignisCode("Baustelle, 4 km Stau", 		Integer
	.valueOf("713"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_714_BAUSTELLE_6_KM_STAU = new AttRdsEreignisCode("Baustelle, 6 km Stau", 		Integer
	.valueOf("714"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_715_BAUSTELLE_10_KM_STAU = new AttRdsEreignisCode("Baustelle, 10 km Stau", 		Integer
	.valueOf("715"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_716_BAUSTELLE_STAUGEFAHR = new AttRdsEreignisCode("Baustelle, Staugefahr", 		Integer
	.valueOf("716"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_717_BAUSTELLE_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, (L) stockender Verkehr", 		Integer
	.valueOf("717"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_718_BAUSTELLE_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, 1 km stockender Verkehr", 		Integer
	.valueOf("718"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_719_BAUSTELLE_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, 2 km stockender Verkehr", 		Integer
	.valueOf("719"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_813_BAUSTELLE_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, 3 km stockender Verkehr", 		Integer
	.valueOf("813"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_720_BAUSTELLE_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, 4 km stockender Verkehr", 		Integer
	.valueOf("720"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_721_BAUSTELLE_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, 6 km stockender Verkehr", 		Integer
	.valueOf("721"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_722_BAUSTELLE_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Baustelle, 10 km stockender Verkehr", 		Integer
	.valueOf("722"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_723_BAUSTELLE_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Baustelle, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("723"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_724_BAUSTELLE_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, (L) dichter Verkehr", 		Integer
	.valueOf("724"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_725_BAUSTELLE_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, 1 km dichter Verkehr", 		Integer
	.valueOf("725"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_726_BAUSTELLE_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, 2 km dichter Verkehr", 		Integer
	.valueOf("726"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_814_BAUSTELLE_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, 3 km dichter Verkehr", 		Integer
	.valueOf("814"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_727_BAUSTELLE_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, 4 km dichter Verkehr", 		Integer
	.valueOf("727"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_728_BAUSTELLE_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, 6 km dichter Verkehr", 		Integer
	.valueOf("728"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_729_BAUSTELLE_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Baustelle, 10 km dichter Verkehr", 		Integer
	.valueOf("729"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_731_BAUSTELLE_L_REGER_VERKEHR = new AttRdsEreignisCode("Baustelle, (L) reger Verkehr", 		Integer
	.valueOf("731"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_733_BAUSTELLE_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Baustelle, störungsfreier Verkehr", 		Integer
	.valueOf("733"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_734_BAUSTELLE_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Baustelle, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("734"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_750_FAHRBAHNERNEUERUNG_L_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, (L) Stau", 		Integer
	.valueOf("750"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_751_FAHRBAHNERNEUERUNG_1_KM_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, 1 km Stau", 		Integer
	.valueOf("751"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_752_FAHRBAHNERNEUERUNG_2_KM_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, 2 km Stau", 		Integer
	.valueOf("752"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_818_FAHRBAHNERNEUERUNG_3_KM_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, 3 km Stau", 		Integer
	.valueOf("818"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_753_FAHRBAHNERNEUERUNG_4_KM_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, 4 km Stau", 		Integer
	.valueOf("753"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_754_FAHRBAHNERNEUERUNG_6_KM_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, 6 km Stau", 		Integer
	.valueOf("754"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_755_FAHRBAHNERNEUERUNG_10_KM_STAU = new AttRdsEreignisCode("Fahrbahnerneuerung, 10 km Stau", 		Integer
	.valueOf("755"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_756_FAHRBAHNERNEUERUNG_STAUGEFAHR = new AttRdsEreignisCode("Fahrbahnerneuerung, Staugefahr", 		Integer
	.valueOf("756"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_757_FAHRBAHNERNEUERUNG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, (L) stockender Verkehr", 		Integer
	.valueOf("757"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_758_FAHRBAHNERNEUERUNG_1_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 1 km stockender Verkehr", 		Integer
	.valueOf("758"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_759_FAHRBAHNERNEUERUNG_2_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 2 km stockender Verkehr", 		Integer
	.valueOf("759"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_819_FAHRBAHNERNEUERUNG_3_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 3 km stockender Verkehr", 		Integer
	.valueOf("819"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_760_FAHRBAHNERNEUERUNG_4_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 4 km stockender Verkehr", 		Integer
	.valueOf("760"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_761_FAHRBAHNERNEUERUNG_6_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 6 km stockender Verkehr", 		Integer
	.valueOf("761"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_762_FAHRBAHNERNEUERUNG_10_KM_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 10 km stockender Verkehr", 		Integer
	.valueOf("762"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_763_FAHRBAHNERNEUERUNG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("763"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_764_FAHRBAHNERNEUERUNG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, (L) dichter Verkehr", 		Integer
	.valueOf("764"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_765_FAHRBAHNERNEUERUNG_1_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 1 km dichter Verkehr", 		Integer
	.valueOf("765"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_766_FAHRBAHNERNEUERUNG_2_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 2 km dichter Verkehr", 		Integer
	.valueOf("766"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_820_FAHRBAHNERNEUERUNG_3_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 3 km dichter Verkehr", 		Integer
	.valueOf("820"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_767_FAHRBAHNERNEUERUNG_4_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 4 km dichter Verkehr", 		Integer
	.valueOf("767"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_768_FAHRBAHNERNEUERUNG_6_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 6 km dichter Verkehr", 		Integer
	.valueOf("768"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_769_FAHRBAHNERNEUERUNG_10_KM_DICHTER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, 10 km dichter Verkehr", 		Integer
	.valueOf("769"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_771_FAHRBAHNERNEUERUNG_L_REGER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, (L) reger Verkehr", 		Integer
	.valueOf("771"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_773_FAHRBAHNERNEUERUNG_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Fahrbahnerneuerung, störungsfreier Verkehr", 		Integer
	.valueOf("773"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_774_FAHRBAHNERNEUERUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Fahrbahnerneuerung, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("774"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_783_MARKIERUNGSARBEITEN_L_STAU = new AttRdsEreignisCode("Markierungsarbeiten, (L) Stau", 		Integer
	.valueOf("783"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_784_MARKIERUNGSARBEITEN_STAUGEFAHR = new AttRdsEreignisCode("Markierungsarbeiten, Staugefahr", 		Integer
	.valueOf("784"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_785_MARKIERUNGSARBEITEN_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Markierungsarbeiten, (L) stockender Verkehr", 		Integer
	.valueOf("785"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_786_MARKIERUNGSARBEITEN_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Markierungsarbeiten, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("786"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_787_MARKIERUNGSARBEITEN_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Markierungsarbeiten, (L) dichter Verkehr", 		Integer
	.valueOf("787"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_789_MARKIERUNGSARBEITEN_L_REGER_VERKEHR = new AttRdsEreignisCode("Markierungsarbeiten, (L) reger Verkehr", 		Integer
	.valueOf("789"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_791_MARKIERUNGSARBEITEN_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Markierungsarbeiten, störungsfreier Verkehr", 		Integer
	.valueOf("791"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_792_MARKIERUNGSARBEITEN_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Markierungsarbeiten, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("792"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_825_WANDERBAUSTELLE_L_STAU = new AttRdsEreignisCode("Wanderbaustelle, (L) Stau", 		Integer
	.valueOf("825"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_826_WANDERBAUSTELLE_STAUGEFAHR = new AttRdsEreignisCode("Wanderbaustelle, Staugefahr", 		Integer
	.valueOf("826"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_827_WANDERBAUSTELLE_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Wanderbaustelle, (L) stockender Verkehr", 		Integer
	.valueOf("827"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_828_WANDERBAUSTELLE_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Wanderbaustelle, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("828"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_829_WANDERBAUSTELLE_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Wanderbaustelle, (L) dichter Verkehr", 		Integer
	.valueOf("829"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_831_WANDERBAUSTELLE_L_REGER_VERKEHR = new AttRdsEreignisCode("Wanderbaustelle, (L) reger Verkehr", 		Integer
	.valueOf("831"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_833_WANDERBAUSTELLE_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Wanderbaustelle, störungsfreier Verkehr", 		Integer
	.valueOf("833"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_834_WANDERBAUSTELLE_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Wanderbaustelle, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("834"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_928_HOCHWASSER_L_STAU = new AttRdsEreignisCode("Hochwasser, (L) Stau", 		Integer
	.valueOf("928"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_929_HOCHWASSER_STAUGEFAHR = new AttRdsEreignisCode("Hochwasser, Staugefahr", 		Integer
	.valueOf("929"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_930_HOCHWASSER_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Hochwasser, (L) stockender Verkehr", 		Integer
	.valueOf("930"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_931_HOCHWASSER_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Hochwasser, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("931"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_932_HOCHWASSER_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Hochwasser, (L) dichter Verkehr", 		Integer
	.valueOf("932"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_934_HOCHWASSER_L_REGER_VERKEHR = new AttRdsEreignisCode("Hochwasser, (L) reger Verkehr", 		Integer
	.valueOf("934"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_936_HOCHWASSER_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Hochwasser, störungsfreier Verkehr", 		Integer
	.valueOf("936"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_937_HOCHWASSER_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Hochwasser, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("937"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1517_VERANSTALTUNG_L_STAU = new AttRdsEreignisCode("Veranstaltung, (L) Stau", 		Integer
	.valueOf("1517"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1518_VERANSTALTUNG_STAUGEFAHR = new AttRdsEreignisCode("Veranstaltung, Staugefahr", 		Integer
	.valueOf("1518"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1519_VERANSTALTUNG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Veranstaltung, (L) stockender Verkehr", 		Integer
	.valueOf("1519"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1520_VERANSTALTUNG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Veranstaltung, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("1520"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1521_VERANSTALTUNG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Veranstaltung, (L) dichter Verkehr", 		Integer
	.valueOf("1521"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1523_VERANSTALTUNG_L_REGER_VERKEHR = new AttRdsEreignisCode("Veranstaltung, (L) reger Verkehr", 		Integer
	.valueOf("1523"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1525_VERANSTALTUNG_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Veranstaltung, störungsfreier Verkehr", 		Integer
	.valueOf("1525"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1526_VERANSTALTUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Veranstaltung, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("1526"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1531_SPORTVERANSTALTUNG_L_STAU = new AttRdsEreignisCode("Sportveranstaltung, (L) Stau", 		Integer
	.valueOf("1531"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1532_SPORTVERANSTALTUNG_STAUGEFAHR = new AttRdsEreignisCode("Sportveranstaltung, Staugefahr", 		Integer
	.valueOf("1532"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1533_SPORTVERANSTALTUNG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Sportveranstaltung, (L) stockender Verkehr", 		Integer
	.valueOf("1533"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1534_SPORTVERANSTALTUNG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Sportveranstaltung, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("1534"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1535_SPORTVERANSTALTUNG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Sportveranstaltung, (L) dichter Verkehr", 		Integer
	.valueOf("1535"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1537_SPORTVERANSTALTUNG_L_REGER_VERKEHR = new AttRdsEreignisCode("Sportveranstaltung, (L) reger Verkehr", 		Integer
	.valueOf("1537"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1539_SPORTVERANSTALTUNG_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Sportveranstaltung, störungsfreier Verkehr", 		Integer
	.valueOf("1539"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1540_SPORTVERANSTALTUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Sportveranstaltung, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("1540"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1545_VOLKSFEST_L_STAU = new AttRdsEreignisCode("Volksfest, (L) Stau", 		Integer
	.valueOf("1545"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1546_VOLKSFEST_STAUGEFAHR = new AttRdsEreignisCode("Volksfest, Staugefahr", 		Integer
	.valueOf("1546"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1547_VOLKSFEST_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Volksfest, (L) stockender Verkehr", 		Integer
	.valueOf("1547"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1548_VOLKSFEST_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Volksfest, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("1548"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1549_VOLKSFEST_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Volksfest, (L) dichter Verkehr", 		Integer
	.valueOf("1549"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1551_VOKSFEST_L_REGER_VERKEHR = new AttRdsEreignisCode("Voksfest, (L) reger Verkehr", 		Integer
	.valueOf("1551"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1553_VOLKSFEST_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Volksfest, störungsfreier Verkehr", 		Integer
	.valueOf("1553"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1554_VOLKSFEST_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Volksfest, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("1554"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1571_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_STAU = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, (L) Stau", 		Integer
	.valueOf("1571"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1572_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_STAUGEFAHR = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, Staugefahr", 		Integer
	.valueOf("1572"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1573_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, (L) stockender Verkehr", 		Integer
	.valueOf("1573"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1574_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("1574"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1575_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, (L) dichter Verkehr", 		Integer
	.valueOf("1575"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1577_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_REGER_VERKEHR = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, (L) reger Verkehr", 		Integer
	.valueOf("1577"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1495_EVAKUIERUNG_REGER_VERKEHR = new AttRdsEreignisCode("Evakuierung, reger Verkehr", 		Integer
	.valueOf("1495"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1586_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, störungsfreier Verkehr", 		Integer
	.valueOf("1586"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1579_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("1579"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1807_AMPELANLAGEN_AUSSER_BETRIEB_L_STAU = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, (L) Stau", 		Integer
	.valueOf("1807"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1808_AMPELANLAGEN_AUSSER_BETRIEB_STAUGEFAHR = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, Staugefahr", 		Integer
	.valueOf("1808"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1809_AMPELANLAGEN_AUSSER_BETRIEB_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, (L) stockender Verkehr", 		Integer
	.valueOf("1809"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1810_AMPELANLAGEN_AUSSER_BETRIEB_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("1810"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1811_AMPELANLAGEN_AUSSER_BETRIEB_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, (L) dichter Verkehr", 		Integer
	.valueOf("1811"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1813_AMPELANLAGEN_AUSSER_BETRIEB_L_REGER_VERKEHR = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, (L) reger Verkehr", 		Integer
	.valueOf("1813"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1815_AMPELANLAGEN_AUSSER_BETRIEB_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, störungsfreier Verkehr", 		Integer
	.valueOf("1815"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1816_AMPELANLAGEN_AUSSER_BETRIEB_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("1816"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1820_STOERUNG_AM_BAHNUEBERGANG_L_STAU = new AttRdsEreignisCode("Störung am Bahnübergang, (L) Stau", 		Integer
	.valueOf("1820"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1821_STOERUNG_AM_BAHNUEBERGANG_STAUGEFAHR = new AttRdsEreignisCode("Störung am Bahnübergang, Staugefahr", 		Integer
	.valueOf("1821"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1822_STOERUNG_AM_BAHNUEBERGANG_L_STOCKENDER_VERKEHR = new AttRdsEreignisCode("Störung am Bahnübergang, (L) stockender Verkehr", 		Integer
	.valueOf("1822"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1823_STOERUNG_AM_BAHNUEBERGANG_GEFAHR_VON_STOCKENDEM_VERKEHR = new AttRdsEreignisCode("Störung am Bahnübergang, Gefahr von stockendem Verkehr", 		Integer
	.valueOf("1823"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1824_STOERUNG_AM_BAHNUEBERGANG_L_DICHTER_VERKEHR = new AttRdsEreignisCode("Störung am Bahnübergang, (L) dichter Verkehr", 		Integer
	.valueOf("1824"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1826_STOERUNG_AM_BAHNUEBERGANG_L_REGER_VERKEHR = new AttRdsEreignisCode("Störung am Bahnübergang, (L) reger Verkehr", 		Integer
	.valueOf("1826"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1828_STOERUNG_AM_BAHNUEBERGANG_STOERUNGSFREIER_VERKEHR = new AttRdsEreignisCode("Störung am Bahnübergang, störungsfreier Verkehr", 		Integer
	.valueOf("1828"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1829_STOERUNG_AM_BAHNUEBERGANG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ = new AttRdsEreignisCode("Störung am Bahnübergang, (L) dichter Verkehr mit zunehmender Tendenz", 		Integer
	.valueOf("1829"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_126_MELDUNGEN_UEBER_STOERUNGEN_LIEGEN_NICHT_VOR = new AttRdsEreignisCode("Meldungen über Störungen liegen nicht vor", 		Integer
	.valueOf("126"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_127_DIE_GEMELDETE_VERKEHRSSTOERUNG_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("die gemeldete Verkehrsstörung besteht nicht mehr", 		Integer
	.valueOf("127"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1584_VERKEHR_HAT_SICH_NORMALISIERT = new AttRdsEreignisCode("Verkehr hat sich normalisiert", 		Integer
	.valueOf("1584"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_128_MELDUNG_AUFGEHOBEN = new AttRdsEreignisCode("Meldung aufgehoben", 		Integer
	.valueOf("128"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_55_VERKEHRSBEHINDERUNG_ZU_ERWARTEN = new AttRdsEreignisCode("Verkehrsbehinderung zu erwarten", 		Integer
	.valueOf("55"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_107_STAU_ZU_ERWARTEN = new AttRdsEreignisCode("Stau zu erwarten", 		Integer
	.valueOf("107"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_114_STOCKENDER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("stockender Verkehr zu erwarten", 		Integer
	.valueOf("114"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_121_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("dichter Verkehr zu erwarten", 		Integer
	.valueOf("121"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_123_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("reger Verkehr zu erwarten", 		Integer
	.valueOf("123"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_56_VERKEHRSSTOERUNG_ZU_ERWARTEN = new AttRdsEreignisCode("Verkehrsstörung zu erwarten", 		Integer
	.valueOf("56"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_235_UNFALL_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Unfall, dichter Verkehr zu erwarten", 		Integer
	.valueOf("235"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_237_UNFALL_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Unfall, reger Verkehr zu erwarten", 		Integer
	.valueOf("237"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_270_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, dichter Verkehr zu erwarten", 		Integer
	.valueOf("270"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_272_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige an einer Unfallstelle, reger Verkehr zu erwarten", 		Integer
	.valueOf("272"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_298_VERLORENE_LADUNG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("verlorene Ladung, dichter Verkehr zu erwarten", 		Integer
	.valueOf("298"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_300_VERLORENE_LADUNG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("verlorene Ladung, reger Verkehr zu erwarten", 		Integer
	.valueOf("300"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_365_UMGESTUERZTES_FAHRZEUG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("umgestürztes Fahrzeug, dichter Verkehr zu erwarten", 		Integer
	.valueOf("365"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_367_UMGESTUERZTES_FAHRZEUG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("umgestürztes Fahrzeug, reger Verkehr zu erwarten", 		Integer
	.valueOf("367"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_318_DEFEKTES_FAHRZEUG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("defektes Fahrzeug, dichter Verkehr zu erwarten", 		Integer
	.valueOf("318"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_320_DEFEKTES_FAHRZEUG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("defektes Fahrzeug, reger Verkehr zu erwarten", 		Integer
	.valueOf("320"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_430_GESPERRT_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("gesperrt, dichter Verkehr zu erwarten", 		Integer
	.valueOf("430"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_432_GESPERRT_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("gesperrt, reger Verkehr zu erwarten", 		Integer
	.valueOf("432"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_458_BLOCKIERT_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("blockiert, dichter Verkehr zu erwarten", 		Integer
	.valueOf("458"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_460_BLOCKIERT_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("blockiert, reger Verkehr zu erwarten", 		Integer
	.valueOf("460"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_541_FAHRSTREIFEN_GESPERRT_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrstreifen gesperrt, dichter Verkehr zu erwarten", 		Integer
	.valueOf("541"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_543_FAHRSTREIFEN_GESPERRT_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrstreifen gesperrt, reger Verkehr zu erwarten", 		Integer
	.valueOf("543"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_551_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, dichter Verkehr zu erwarten", 		Integer
	.valueOf("551"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_553_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, reger Verkehr zu erwarten", 		Integer
	.valueOf("553"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_561_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, dichter Verkehr zu erwarten", 		Integer
	.valueOf("561"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_563_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, reger Verkehr zu erwarten", 		Integer
	.valueOf("563"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_571_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, dichter Verkehr zu erwarten", 		Integer
	.valueOf("571"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_573_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, reger Verkehr zu erwarten", 		Integer
	.valueOf("573"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_596_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, dichter Verkehr zu erwarten", 		Integer
	.valueOf("596"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_598_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet, reger Verkehr zu erwarten", 		Integer
	.valueOf("598"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_609_FAHRBAHNVERENGUNG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahnverengung, dichter Verkehr zu erwarten", 		Integer
	.valueOf("609"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_611_FAHRBAHNVERENGUNG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahnverengung, reger Verkehr zu erwarten", 		Integer
	.valueOf("611"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_619_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, dichter Verkehr zu erwarten", 		Integer
	.valueOf("619"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_621_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet, reger Verkehr zu erwarten", 		Integer
	.valueOf("621"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_730_BAUSTELLE_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Baustelle, dichter Verkehr zu erwarten", 		Integer
	.valueOf("730"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_732_BAUSTELLE_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Baustelle, reger Verkehr zu erwarten", 		Integer
	.valueOf("732"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_770_FAHRBAHNERNEUERUNG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahnerneuerung, dichter Verkehr zu erwarten", 		Integer
	.valueOf("770"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_772_FAHRBAHNERNEUERUNG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Fahrbahnerneuerung, reger Verkehr zu erwarten", 		Integer
	.valueOf("772"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_788_MARKIERUNGSARBEITEN_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Markierungsarbeiten, dichter Verkehr zu erwarten", 		Integer
	.valueOf("788"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_790_MARKIERUNGSARBEITEN_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Markierungsarbeiten, reger Verkehr zu erwarten", 		Integer
	.valueOf("790"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_830_WANDERBAUSTELLE_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Wanderbaustelle, dichter Verkehr zu erwarten", 		Integer
	.valueOf("830"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_832_WANDERBAUSTELLE_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Wanderbaustelle, reger Verkehr zu erwarten", 		Integer
	.valueOf("832"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_933_HOCHWASSER_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Hochwasser, dichter Verkehr zu erwarten", 		Integer
	.valueOf("933"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_935_HOCHWASSER_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Hochwasser, reger Verkehr zu erwarten", 		Integer
	.valueOf("935"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1522_VERANSTALTUNG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Veranstaltung, dichter Verkehr zu erwarten", 		Integer
	.valueOf("1522"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1524_VERANSTALTUNG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Veranstaltung, reger Verkehr zu erwarten", 		Integer
	.valueOf("1524"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1536_SPORTVERANSTALTUNG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Sportveranstaltung, dichter Verkehr zu erwarten", 		Integer
	.valueOf("1536"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1538_SPORTVERANSTALTUNG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Sportveranstaltung, reger Verkehr zu erwarten", 		Integer
	.valueOf("1538"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1550_VOLKSFEST_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Volksfest, dichter Verkehr zu erwarten", 		Integer
	.valueOf("1550"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1552_VOLKSFEST_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Volksfest, reger Verkehr zu erwarten", 		Integer
	.valueOf("1552"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1576_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, dichter Verkehr zu erwarten", 		Integer
	.valueOf("1576"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1578_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, reger Verkehr zu erwarten", 		Integer
	.valueOf("1578"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1812_AMPELANLAGEN_AUSSER_BETRIEB_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, dichter Verkehr zu erwarten", 		Integer
	.valueOf("1812"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1814_AMPELANLAGEN_AUSSER_BETRIEB_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, reger Verkehr zu erwarten", 		Integer
	.valueOf("1814"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1825_STOERUNG_AM_BAHNUEBERGANG_DICHTER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Störung am Bahnübergang, dichter Verkehr zu erwarten", 		Integer
	.valueOf("1825"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1827_STOERUNG_AM_BAHNUEBERGANG_REGER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("Störung am Bahnübergang, reger Verkehr zu erwarten", 		Integer
	.valueOf("1827"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_57_NORMALER_VERKEHR_ZU_ERWARTEN = new AttRdsEreignisCode("normaler Verkehr zu erwarten", 		Integer
	.valueOf("57"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1589_MELDUNG_AUFGEHOBEN_ERWARTETE_VERKEHRSLAGE_ = new AttRdsEreignisCode("Meldung aufgehoben (erwartete Verkehrslage)", 		Integer
	.valueOf("1589"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_201_UNFALL = new AttRdsEreignisCode("Unfall", 		Integer
	.valueOf("201"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_202_SCHWERER_UNFALL = new AttRdsEreignisCode("schwerer Unfall", 		Integer
	.valueOf("202"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_203_UNFALL_MIT_MEHREREN_FAHRZEUGEN = new AttRdsEreignisCode("Unfall mit mehreren Fahrzeugen", 		Integer
	.valueOf("203"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_204_UNFALL_MIT_LKW = new AttRdsEreignisCode("Unfall mit LKW", 		Integer
	.valueOf("204"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_335_UNFALL_MIT_BUS = new AttRdsEreignisCode("Unfall mit Bus", 		Integer
	.valueOf("335"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_205_UNFALL_MIT_GEFAHRGUTTRANSPORTER = new AttRdsEreignisCode("Unfall mit Gefahrguttransporter", 		Integer
	.valueOf("205"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_206_UNFALL_GEFAHR_DURCH_AUSLAUFENDEN_KRAFTSTOFF = new AttRdsEreignisCode("Unfall, Gefahr durch auslaufenden Kraftstoff", 		Integer
	.valueOf("206"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_207_UNFALL_GEFAHR_DURCH_AUSLAUFENDE_CHEMIKALIEN = new AttRdsEreignisCode("Unfall, Gefahr durch auslaufende Chemikalien", 		Integer
	.valueOf("207"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_336_UNFALL_GEFAHR_DURCH_AUSLAUFENDES_OEL = new AttRdsEreignisCode("Unfall, Gefahr durch auslaufendes Öl", 		Integer
	.valueOf("336"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_337_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTES_FAHRZEUG = new AttRdsEreignisCode("Verkehrsbehinderung durch umgestürztes Fahrzeug", 		Integer
	.valueOf("337"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_338_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTEN_LKW = new AttRdsEreignisCode("Verkehrsbehinderung durch umgestürzten LKW", 		Integer
	.valueOf("338"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_339_VERKEHRSBEHINDERUNG_DURCH_QUERSTEHENDEN_ANHAENGER = new AttRdsEreignisCode("Verkehrsbehinderung durch querstehenden Anhänger", 		Integer
	.valueOf("339"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_340_VERKEHRSBEHINDERUNG_DURCH_QUERSTEHENDEN_WOHNWAGEN = new AttRdsEreignisCode("Verkehrsbehinderung durch querstehenden Wohnwagen", 		Integer
	.valueOf("340"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_341_VERKEHRSBEHINDERUNG_DURCH_QUERSTEHENDEN_LKW = new AttRdsEreignisCode("Verkehrsbehinderung durch querstehenden LKW", 		Integer
	.valueOf("341"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_213_BRENNENDES_FAHRZEUG = new AttRdsEreignisCode("brennendes Fahrzeug", 		Integer
	.valueOf("213"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_342_FAHRZEUG_VERUNGLUECKT = new AttRdsEreignisCode("Fahrzeug verunglückt", 		Integer
	.valueOf("342"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_378_GEFAHR_DURCH_UMGESTUERZTES_FAHRZEUG = new AttRdsEreignisCode("Gefahr durch umgestürztes Fahrzeug", 		Integer
	.valueOf("378"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_343_VORAUSGEGANGENER_UNFALL = new AttRdsEreignisCode("vorausgegangener Unfall", 		Integer
	.valueOf("343"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_344_VERKEHRSBEHINDERUNG_DURCH_UNFALLAUFNAHME = new AttRdsEreignisCode("Verkehrsbehinderung durch Unfallaufnahme", 		Integer
	.valueOf("344"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_391_UNFALLAUFNAHME_GEFAHR = new AttRdsEreignisCode("Unfallaufnahme, Gefahr", 		Integer
	.valueOf("391"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_351_UNFALL_IM_BAUSTELLENBEREICH = new AttRdsEreignisCode("Unfall im Baustellenbereich", 		Integer
	.valueOf("351"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_12_UNFALL_VERKEHR_WIRD_AN_DER_UNFALLSTELLE_VORBEIGEFUEHRT = new AttRdsEreignisCode("Unfall, Verkehr wird an der Unfallstelle vorbeigeführt", 		Integer
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_345_FOLGEUNFALL = new AttRdsEreignisCode("Folgeunfall", 		Integer
	.valueOf("345"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_392_FOLGEUNFALL_GEFAHR = new AttRdsEreignisCode("Folgeunfall, Gefahr", 		Integer
	.valueOf("392"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_209_UNFALL_IN_DER_GEGENRICHTUNG = new AttRdsEreignisCode("Unfall in der Gegenrichtung", 		Integer
	.valueOf("209"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_141_ALLE_UNFALLSTELLEN_GERAEUMT_KEINE_VERKEHRSBEHINDERUNG_MEHR = new AttRdsEreignisCode("alle Unfallstellen geräumt, keine Verkehrsbehinderung mehr", 		Integer
	.valueOf("141"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_333_UNFALLSTELLE_GERAEUMT = new AttRdsEreignisCode("Unfallstelle geräumt", 		Integer
	.valueOf("333"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_334_MELDUNG_AUFGEHOBEN_UNFAELLE_ = new AttRdsEreignisCode("Meldung aufgehoben (Unfälle)", 		Integer
	.valueOf("334"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_214_VERKEHRSBEHINDERUNG_VORFAELLE_ = new AttRdsEreignisCode("Verkehrsbehinderung (Vorfälle)", 		Integer
	.valueOf("214"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_211_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug", 		Integer
	.valueOf("211"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_393_GEFAHR_DURCH_DEFEKTES_FAHRZEUG = new AttRdsEreignisCode("Gefahr durch defektes Fahrzeug", 		Integer
	.valueOf("393"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_212_VERKEHRSBEHINDERUNG_DURCH_DEFEKTEN_LKW = new AttRdsEreignisCode("Verkehrsbehinderung durch defekten LKW", 		Integer
	.valueOf("212"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_394_GEFAHR_DURCH_DEFEKTEN_LKW = new AttRdsEreignisCode("Gefahr durch defekten LKW", 		Integer
	.valueOf("394"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_346_VERKEHRSBEHINDERUNG_DURCH_DEFEKTEN_BUS = new AttRdsEreignisCode("Verkehrsbehinderung durch defekten Bus", 		Integer
	.valueOf("346"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_11_HOEHENKONTROLLE_WURDE_AUSGELOEST = new AttRdsEreignisCode("Höhenkontrolle wurde ausgelöst", 		Integer
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_924_VERKEHRSBEHINDERUNG_DURCH_AUFRAEUMARBEITEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Aufräumarbeiten", 		Integer
	.valueOf("924"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1034_GEFAHR_DURCH_AUFRAEUMARBEITEN = new AttRdsEreignisCode("Gefahr durch Aufräumarbeiten", 		Integer
	.valueOf("1034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_397_VERKEHRSBEHINDERUNG_DURCH_BERGUNGSARBEITEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Bergungsarbeiten", 		Integer
	.valueOf("397"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1066_GEFAHR_DURCH_BERGUNGSARBEITEN = new AttRdsEreignisCode("Gefahr durch Bergungsarbeiten", 		Integer
	.valueOf("1066"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_396_DIE_GEMELDETE_STOERUNG_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("die gemeldete Störung besteht nicht mehr", 		Integer
	.valueOf("396"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_395_STRASSE_GERAEUMT = new AttRdsEreignisCode("Straße geräumt", 		Integer
	.valueOf("395"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2028_MELDUNG_AUFGEHOBEN_VORFAELLE_ = new AttRdsEreignisCode("Meldung aufgehoben (Vorfälle)", 		Integer
	.valueOf("2028"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_666_MEHRFACH_KURZFRISTIGE_SPERRUNGEN = new AttRdsEreignisCode("mehrfach kurzfristige Sperrungen", 		Integer
	.valueOf("666"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_401_GESPERRT = new AttRdsEreignisCode("gesperrt", 		Integer
	.valueOf("401"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_240_UNFALL_STRASSE_GESPERRT = new AttRdsEreignisCode("Unfall, Straße gesperrt", 		Integer
	.valueOf("240"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_16_WEGEN_BERGUNGSARBEITEN_GESPERRT = new AttRdsEreignisCode("wegen Bergungsarbeiten gesperrt", 		Integer
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_500_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Fahrstreifen gesperrt", 		Integer
	.valueOf("500"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_501_RECHTER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("rechter Fahrstreifen gesperrt", 		Integer
	.valueOf("501"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_502_MITTLERER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("mittlerer Fahrstreifen gesperrt", 		Integer
	.valueOf("502"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_503_LINKER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("linker Fahrstreifen gesperrt", 		Integer
	.valueOf("503"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_504_STANDSTREIFEN_GESPERRT = new AttRdsEreignisCode("Standstreifen gesperrt", 		Integer
	.valueOf("504"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_637_SEITENSTREIFEN_GESPERRT = new AttRdsEreignisCode("Seitenstreifen gesperrt", 		Integer
	.valueOf("637"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_41_UEBERHOLSTREIFEN_GESPERRT = new AttRdsEreignisCode("Überholstreifen gesperrt", 		Integer
	.valueOf("41"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_641_EIN_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("ein Fahrstreifen gesperrt", 		Integer
	.valueOf("641"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_505_ZWEI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("zwei Fahrstreifen gesperrt", 		Integer
	.valueOf("505"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_506_DREI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("drei Fahrstreifen gesperrt", 		Integer
	.valueOf("506"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_514_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt", 		Integer
	.valueOf("514"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_515_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt", 		Integer
	.valueOf("515"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_516_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt", 		Integer
	.valueOf("516"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_601_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Fahrbahn auf einen Fahrstreifen verengt, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("601"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_602_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Fahrbahn auf zwei Fahrstreifen verengt, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("602"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_603_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Fahrbahn auf drei Fahrstreifen verengt, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("603"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_735_WEGEN_BAUSTELLE_GESPERRT = new AttRdsEreignisCode("wegen Baustelle gesperrt", 		Integer
	.valueOf("735"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_736_BAUSTELLE_RECHTER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, rechter Fahrstreifen gesperrt", 		Integer
	.valueOf("736"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_737_BAUSTELLE_MITTLERER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, mittlerer Fahrstreifen gesperrt", 		Integer
	.valueOf("737"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_738_BAUSTELLE_LINKER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, linker Fahrstreifen gesperrt", 		Integer
	.valueOf("738"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_739_BAUSTELLE_STANDSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, Standstreifen gesperrt", 		Integer
	.valueOf("739"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_740_BAUSTELLE_ZWEI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, zwei Fahrstreifen gesperrt", 		Integer
	.valueOf("740"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_741_BAUSTELLE_DREI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, drei Fahrstreifen gesperrt", 		Integer
	.valueOf("741"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_51_BAUSTELLE_UEBERHOLSTREIFEN_GESPERRT = new AttRdsEreignisCode("Baustelle, Überholstreifen gesperrt", 		Integer
	.valueOf("51"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_743_BAUSTELLE_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Baustelle, Fahrbahn auf einen Fahrstreifen verengt", 		Integer
	.valueOf("743"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_744_BAUSTELLE_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Baustelle, Fahrbahn auf zwei Fahrstreifen verengt", 		Integer
	.valueOf("744"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_745_BAUSTELLE_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Baustelle, Fahrbahn auf drei Fahrstreifen verengt", 		Integer
	.valueOf("745"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_776_FAHRBAHNERNEUERUNG_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Fahrbahnerneuerung, Fahrbahn auf einen Fahrstreifen verengt", 		Integer
	.valueOf("776"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_777_FAHRBAHNERNEUERUNG_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Fahrbahnerneuerung, Fahrbahn auf zwei Fahrstreifen verengt", 		Integer
	.valueOf("777"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_778_FAHRBAHNERNEUERUNG_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Fahrbahnerneuerung, Fahrbahn auf drei Fahrstreifen verengt", 		Integer
	.valueOf("778"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_793_MARKIERUNGSARBEITEN_RECHTER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Markierungsarbeiten, rechter Fahrstreifen gesperrt", 		Integer
	.valueOf("793"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_794_MARKIERUNGSARBEITEN_MITTLERER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Markierungsarbeiten, mittlerer Fahrstreifen gesperrt", 		Integer
	.valueOf("794"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_795_MARKIERUNGSARBEITEN_LINKER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Markierungsarbeiten, linker Fahrstreifen gesperrt", 		Integer
	.valueOf("795"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_796_MARKIERUNGSARBEITEN_STANDSTREIFEN_GESPERRT = new AttRdsEreignisCode("Markierungsarbeiten, Standstreifen gesperrt", 		Integer
	.valueOf("796"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_797_MARKIERUNGSARBEITEN_ZWEI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Markierungsarbeiten, zwei Fahrstreifen gesperrt", 		Integer
	.valueOf("797"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_798_MARKIERUNGSARBEITEN_DREI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Markierungsarbeiten, drei Fahrstreifen gesperrt", 		Integer
	.valueOf("798"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_835_WANDERBAUSTELLE_RECHTER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Wanderbaustelle, rechter Fahrstreifen gesperrt", 		Integer
	.valueOf("835"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_836_WANDERBAUSTELLE_MITTLERER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Wanderbaustelle, mittlerer Fahrstreifen gesperrt", 		Integer
	.valueOf("836"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_837_WANDERBAUSTELLE_LINKER_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Wanderbaustelle, linker Fahrstreifen gesperrt", 		Integer
	.valueOf("837"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_838_WANDERBAUSTELLE_ZWEI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Wanderbaustelle, zwei Fahrstreifen gesperrt", 		Integer
	.valueOf("838"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_839_WANDERBAUSTELLE_DREI_FAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Wanderbaustelle, drei Fahrstreifen gesperrt", 		Integer
	.valueOf("839"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_799_BRUECKENABRISS_STRASSE_GESPERRT = new AttRdsEreignisCode("Brückenabriss, Straße gesperrt", 		Integer
	.valueOf("799"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_947_ERDRUTSCH_STRASSE_GESPERRT = new AttRdsEreignisCode("Erdrutsch, Straße gesperrt", 		Integer
	.valueOf("947"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_957_GEPLATZTE_WASSERLEITUNG_STRASSE_GESPERRT = new AttRdsEreignisCode("geplatzte Wasserleitung, Straße gesperrt", 		Integer
	.valueOf("957"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_965_FEUER_STRASSE_GESPERRT = new AttRdsEreignisCode("Feuer, Straße gesperrt", 		Integer
	.valueOf("965"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_951_ABSENKUNG_DER_FAHRBAHN_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Absenkung der Fahrbahn, Fahrbahn auf einen Fahrstreifen verengt", 		Integer
	.valueOf("951"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_952_ABSENKUNG_DER_FAHRBAHN_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Absenkung der Fahrbahn, Fahrbahn auf zwei Fahrstreifen verengt", 		Integer
	.valueOf("952"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_953_ABSENKUNG_DER_FAHRBAHN_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Absenkung der Fahrbahn, Fahrbahn auf drei Fahrstreifen verengt", 		Integer
	.valueOf("953"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_956_STOERUNG_IN_DER_KANALISATION_STRASSE_GESPERRT = new AttRdsEreignisCode("Störung in der Kanalisation, Straße gesperrt", 		Integer
	.valueOf("956"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_961_AUSSTROEMENDES_GAS_STRASSE_GESPERRT = new AttRdsEreignisCode("ausströmendes Gas, Straße gesperrt", 		Integer
	.valueOf("961"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_969_AUFRAEUMARBEITEN_STRASSE_GESPERRT = new AttRdsEreignisCode("Aufräumarbeiten, Straße gesperrt", 		Integer
	.valueOf("969"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1021_SCHNEEGLAETTE_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Schneeglätte, Fahrbahn auf einen Fahrstreifen verengt", 		Integer
	.valueOf("1021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1022_SCHNEEGLAETTE_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Schneeglätte, Fahrbahn auf zwei Fahrstreifen verengt", 		Integer
	.valueOf("1022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1023_SCHNEEGLAETTE_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT = new AttRdsEreignisCode("Schneeglätte, Fahrbahn auf drei Fahrstreifen verengt", 		Integer
	.valueOf("1023"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_241_UNFALL_RECHTER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Unfall, rechter Fahrstreifen blockiert", 		Integer
	.valueOf("241"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_242_UNFALL_MITTLERER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Unfall, mittlerer Fahrstreifen blockiert", 		Integer
	.valueOf("242"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_243_UNFALL_LINKER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Unfall, linker Fahrstreifen blockiert", 		Integer
	.valueOf("243"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_244_UNFALL_STANDSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Unfall, Standstreifen blockiert", 		Integer
	.valueOf("244"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_245_UNFALL_ZWEI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Unfall, zwei Fahrstreifen blockiert", 		Integer
	.valueOf("245"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_246_UNFALL_DREI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Unfall, drei Fahrstreifen blockiert", 		Integer
	.valueOf("246"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_303_DURCH_VERLORENE_LADUNG_BLOCKIERT = new AttRdsEreignisCode("durch verlorene Ladung blockiert", 		Integer
	.valueOf("303"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_304_VERLORENE_LADUNG_RECHTER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("verlorene Ladung, rechter Fahrstreifen blockiert", 		Integer
	.valueOf("304"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_305_VERLORENE_LADUNG_MITTLERER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("verlorene Ladung, mittlerer Fahrstreifen blockiert", 		Integer
	.valueOf("305"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_306_VERLORENE_LADUNG_LINKER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("verlorene Ladung, linker Fahrstreifen blockiert", 		Integer
	.valueOf("306"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_307_VERLORENE_LADUNG_STANDSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("verlorene Ladung, Standstreifen blockiert", 		Integer
	.valueOf("307"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_308_VERLORENE_LADUNG_ZWEI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("verlorene Ladung, zwei Fahrstreifen blockiert", 		Integer
	.valueOf("308"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_309_VERLORENE_LADUNG_DREI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("verlorene Ladung, drei Fahrstreifen blockiert", 		Integer
	.valueOf("309"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_369_DURCH_UMGESTUERZTES_FAHRZEUG_BLOCKIERT = new AttRdsEreignisCode("durch umgestürztes Fahrzeug blockiert", 		Integer
	.valueOf("369"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_370_UMGESTUERZTES_FAHRZEUG_RECHTER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("umgestürztes Fahrzeug, rechter Fahrstreifen blockiert", 		Integer
	.valueOf("370"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_371_UMGESTUERZTES_FAHRZEUG_MITTLERER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("umgestürztes Fahrzeug, mittlerer Fahrstreifen blockiert", 		Integer
	.valueOf("371"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_372_UMGESTUERZTES_FAHRZEUG_LINKER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("umgestürztes Fahrzeug, linker Fahrstreifen blockiert", 		Integer
	.valueOf("372"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_373_UMGESTUERZTES_FAHRZEUG_ZWEI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("umgestürztes Fahrzeug, zwei Fahrstreifen blockiert", 		Integer
	.valueOf("373"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_374_UMGESTUERZTES_FAHRZEUG_DREI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("umgestürztes Fahrzeug, drei Fahrstreifen blockiert", 		Integer
	.valueOf("374"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_323_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_STRASSE_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, Straße blockiert", 		Integer
	.valueOf("323"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_324_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_RECHTER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, rechter Fahrstreifen blockiert", 		Integer
	.valueOf("324"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_325_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_MITTLERER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, mittlerer Fahrstreifen blockiert", 		Integer
	.valueOf("325"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_326_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_LINKER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, linker Fahrstreifen blockiert", 		Integer
	.valueOf("326"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_327_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_STANDSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, Standstreifen blockiert", 		Integer
	.valueOf("327"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_328_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_ZWEI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, zwei Fahrstreifen blockiert", 		Integer
	.valueOf("328"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_329_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_DREI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, drei Fahrstreifen blockiert", 		Integer
	.valueOf("329"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_402_BLOCKIERT = new AttRdsEreignisCode("blockiert", 		Integer
	.valueOf("402"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_520_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Fahrstreifen blockiert", 		Integer
	.valueOf("520"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_507_RECHTER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("rechter Fahrstreifen blockiert", 		Integer
	.valueOf("507"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_508_MITTLERER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("mittlerer Fahrstreifen blockiert", 		Integer
	.valueOf("508"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_509_LINKER_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("linker Fahrstreifen blockiert", 		Integer
	.valueOf("509"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_510_STANDSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Standstreifen blockiert", 		Integer
	.valueOf("510"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_642_NOTFALLSPUR_BLOCKIERT = new AttRdsEreignisCode("Notfallspur blockiert", 		Integer
	.valueOf("642"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_42_UEBERHOLSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Überholstreifen blockiert", 		Integer
	.valueOf("42"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_646_EIN_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("ein Fahrstreifen blockiert", 		Integer
	.valueOf("646"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_511_ZWEI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("zwei Fahrstreifen blockiert", 		Integer
	.valueOf("511"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_512_DREI_FAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("drei Fahrstreifen blockiert", 		Integer
	.valueOf("512"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_980_STRASSE_DURCH_HINDERNISSE_BLOCKIERT = new AttRdsEreignisCode("Straße durch Hindernisse blockiert", 		Integer
	.valueOf("980"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_982_STRASSE_DURCH_AUSGELAUFENE_FLUESSIGKEITEN_BLOCKIERT = new AttRdsEreignisCode("Straße durch ausgelaufene Flüssigkeiten blockiert", 		Integer
	.valueOf("982"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_925_WEGEN_STURMSCHAEDEN_BLOCKIERT = new AttRdsEreignisCode("wegen Sturmschäden blockiert", 		Integer
	.valueOf("925"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_926_DURCH_UMGESTUERZTE_BAEUME_BLOCKIERT = new AttRdsEreignisCode("durch umgestürzte Bäume blockiert", 		Integer
	.valueOf("926"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_987_BLOCKIERT_DURCH_HERUNTERHAENGENDE_STROMKABEL = new AttRdsEreignisCode("blockiert durch herunterhängende Stromkabel", 		Integer
	.valueOf("987"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_517_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("517"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_518_FAHRBAHNVERENGUNG = new AttRdsEreignisCode("Fahrbahnverengung", 		Integer
	.valueOf("518"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_519_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Fahrbahnverengung, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("519"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_513_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI = new AttRdsEreignisCode("für beide Richtungen nur ein Fahrstreifen abwechselnd frei", 		Integer
	.valueOf("513"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_746_BAUSTELLE_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Baustelle, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("746"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_742_BAUSTELLE_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI = new AttRdsEreignisCode("Baustelle, für beide Richtungen nur ein Fahrstreifen abwechselnd frei", 		Integer
	.valueOf("742"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_779_FAHRBAHNERNEUERUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Fahrbahnerneuerung, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("779"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_775_FAHRBAHNERNEUERUNG_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI = new AttRdsEreignisCode("Fahrbahnerneuerung, für beide Richtungen nur ein Fahrstreifen abwechselnd frei", 		Integer
	.valueOf("775"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_954_VERKEHRSBEHINDERUNG_DURCH_ABSENKUNG_DER_FAHRBAHN_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET = new AttRdsEreignisCode("Verkehrsbehinderung durch Absenkung der Fahrbahn, Verkehr wird über die Gegenfahrbahn geleitet", 		Integer
	.valueOf("954"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_638_WENDESPUR_GESPERRT = new AttRdsEreignisCode("Wendespur gesperrt", 		Integer
	.valueOf("638"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_643_WENDESPUR_BLOCKIERT = new AttRdsEreignisCode("Wendespur blockiert", 		Integer
	.valueOf("643"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_639_KRIECHSPUR_GESPERRT = new AttRdsEreignisCode("Kriechspur gesperrt", 		Integer
	.valueOf("639"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_640_LANGSAMFAHRSTREIFEN_GESPERRT = new AttRdsEreignisCode("Langsamfahrstreifen gesperrt", 		Integer
	.valueOf("640"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_678_SCHWERVERKEHRSSPUR_GESPERRT = new AttRdsEreignisCode("Schwerverkehrsspur  gesperrt", 		Integer
	.valueOf("678"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_644_KRIECHSPUR_BLOCKIERT = new AttRdsEreignisCode("Kriechspur blockiert", 		Integer
	.valueOf("644"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_645_LANGSAMFAHRSTREIFEN_BLOCKIERT = new AttRdsEreignisCode("Langsamfahrstreifen blockiert", 		Integer
	.valueOf("645"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_679_SCHWERVERKEHRSSPUR_BLOCKIERT = new AttRdsEreignisCode("Schwerverkehrsspur  blockiert", 		Integer
	.valueOf("679"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_657_FAHRSTREIFENBLOCKIERUNG_BESEITIGT = new AttRdsEreignisCode("Fahrstreifenblockierung beseitigt", 		Integer
	.valueOf("657"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_631_STRASSE_GERAEUMT_STRASSEN_UND_FAHRBAHNSPERRUNGEN_ = new AttRdsEreignisCode("Straße geräumt (Straßen- und Fahrbahnsperrungen)", 		Integer
	.valueOf("631"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_658_UMLEITUNG_UEBER_DIE_GEGENFAHRBAHN_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("Umleitung über die Gegenfahrbahn besteht nicht mehr", 		Integer
	.valueOf("658"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_467_WIEDER_FREI = new AttRdsEreignisCode("wieder frei", 		Integer
	.valueOf("467"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_630_FREI = new AttRdsEreignisCode("frei", 		Integer
	.valueOf("630"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_624_FAHRSTREIFENSPERRUNG_WIEDER_AUFGEHOBEN = new AttRdsEreignisCode("Fahrstreifensperrung wieder aufgehoben", 		Integer
	.valueOf("624"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_664_RICHTUNGSFAHRBAHN_GESPERRT = new AttRdsEreignisCode("Richtungsfahrbahn gesperrt", 		Integer
	.valueOf("664"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_665_BEIDE_FAHRTRICHTUNGEN_GESPERRT = new AttRdsEreignisCode("beide Fahrtrichtungen gesperrt", 		Integer
	.valueOf("665"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_625_MELDUNG_AUFGEHOBEN_STRASSEN_UND_FAHRBAHNSPERRUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Straßen- und Fahrbahnsperrungen)", 		Integer
	.valueOf("625"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_479_PARALLELFAHRBAHN_GESPERRT = new AttRdsEreignisCode("Parallelfahrbahn gesperrt", 		Integer
	.valueOf("479"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_480_RECHTE_PARALLELFAHRBAHN_GESPERRT = new AttRdsEreignisCode("rechte Parallelfahrbahn gesperrt", 		Integer
	.valueOf("480"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_481_LINKE_PARALLELFAHRBAHN_GESPERRT = new AttRdsEreignisCode("linke Parallelfahrbahn gesperrt", 		Integer
	.valueOf("481"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_482_SCHNELLSPUR_GESPERRT = new AttRdsEreignisCode("Schnellspur gesperrt", 		Integer
	.valueOf("482"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_483_FERNVERKEHRSSPUR_GESPERRT = new AttRdsEreignisCode("Fernverkehrsspur gesperrt", 		Integer
	.valueOf("483"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_484_NAHVERKEHRSSPUR_GESPERRT = new AttRdsEreignisCode("Nahverkehrsspur gesperrt", 		Integer
	.valueOf("484"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_486_PARALLELFAHRBAHN_BLOCKIERT = new AttRdsEreignisCode("Parallelfahrbahn blockiert", 		Integer
	.valueOf("486"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_487_RECHTE_PARALLELFAHRBAHN_BLOCKIERT = new AttRdsEreignisCode("rechte Parallelfahrbahn blockiert", 		Integer
	.valueOf("487"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_488_LINKE_PARALLELFAHRBAHN_BLOCKIERT = new AttRdsEreignisCode("linke Parallelfahrbahn blockiert", 		Integer
	.valueOf("488"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_489_SCHNELLSPUR_BLOCKIERT = new AttRdsEreignisCode("Schnellspur blockiert", 		Integer
	.valueOf("489"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_490_FERNVERKEHRSSPUR_BLOCKIERT = new AttRdsEreignisCode("Fernverkehrsspur blockiert", 		Integer
	.valueOf("490"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_491_NAHVERKEHRSSPUR_BLOCKIERT = new AttRdsEreignisCode("Nahverkehrsspur blockiert", 		Integer
	.valueOf("491"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1982_BUSSPUR_GESPERRT = new AttRdsEreignisCode("Busspur gesperrt", 		Integer
	.valueOf("1982"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_676_BUSSPUR_BLOCKIERT = new AttRdsEreignisCode("Busspur blockiert", 		Integer
	.valueOf("676"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_26_BRUECKE_BLOCKIERT = new AttRdsEreignisCode("Brücke blockiert", 		Integer
	.valueOf("26"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_27_TUNNEL_BLOCKIERT = new AttRdsEreignisCode("Tunnel blockiert", 		Integer
	.valueOf("27"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_663_ALLE_FAHRBAHNEN_GERAEUMT = new AttRdsEreignisCode("alle Fahrbahnen geräumt", 		Integer
	.valueOf("663"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_634_ALLE_FAHRBAHNEN_WIEDER_FREI = new AttRdsEreignisCode("alle Fahrbahnen wieder frei", 		Integer
	.valueOf("634"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_672_MELDUNG_AUFGEHOBEN_FAHRBAHNBESCHRAENKUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Fahrbahnbeschränkungen)", 		Integer
	.valueOf("672"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_407_AUSFAHRT_GESPERRT = new AttRdsEreignisCode("Ausfahrt gesperrt", 		Integer
	.valueOf("407"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_474_AUSFAHRT_GESPERRT_BESCHRAENKUNGEN_DER_AUSFAHRT_ = new AttRdsEreignisCode("Ausfahrt gesperrt (Beschränkungen der Ausfahrt)", 		Integer
	.valueOf("474"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_475_AUSFAHRT_BLOCKIERT = new AttRdsEreignisCode("Ausfahrt blockiert", 		Integer
	.valueOf("475"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_476_AUSFAHRT_BLOCKIERT_BESCHRAENKUNGEN_DER_AUSFAHRT_ = new AttRdsEreignisCode("Ausfahrt blockiert (Beschränkungen der Ausfahrt)", 		Integer
	.valueOf("476"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_408_ANSCHLUSSSTELLE_GESPERRT = new AttRdsEreignisCode("Anschlussstelle gesperrt", 		Integer
	.valueOf("408"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_477_ANSCHLUSSSTELLE_BLOCKIERT = new AttRdsEreignisCode("Anschlussstelle blockiert", 		Integer
	.valueOf("477"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_409_BESCHRAENKUNG_DER_ANSCHLUSSSTELLE = new AttRdsEreignisCode("Beschränkung der Anschlussstelle", 		Integer
	.valueOf("409"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_478_VERBINDUNGSFAHRBAHN_GESPERRT = new AttRdsEreignisCode("Verbindungsfahrbahn gesperrt", 		Integer
	.valueOf("478"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_485_VERBINDUNGSFAHRBAHN_BLOCKIERT = new AttRdsEreignisCode("Verbindungsfahrbahn blockiert", 		Integer
	.valueOf("485"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1998_GEFAEHRLICHE_SITUATION_IN_DER_AUSFAHRT = new AttRdsEreignisCode("gefährliche Situation in der Ausfahrt", 		Integer
	.valueOf("1998"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_633_AUSFAHRT_WIEDER_FREI = new AttRdsEreignisCode("Ausfahrt wieder frei", 		Integer
	.valueOf("633"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_466_ANSCHLUSSSTELLE_WIEDER_FREI = new AttRdsEreignisCode("Anschlussstelle wieder frei", 		Integer
	.valueOf("466"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_673_MELDUNG_AUFGEHOBEN_BESCHRAENKUNGEN_DER_AUSFAHRT_ = new AttRdsEreignisCode("Meldung aufgehoben (Beschränkungen der Ausfahrt)", 		Integer
	.valueOf("673"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_406_EINFAHRT_GESPERRT = new AttRdsEreignisCode("Einfahrt gesperrt", 		Integer
	.valueOf("406"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_471_EINFAHRT_GESPERRT_BESCHRAENKUNGEN_DER_EINFAHRT_ = new AttRdsEreignisCode("Einfahrt gesperrt (Beschränkungen der Einfahrt)", 		Integer
	.valueOf("471"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_472_EINFAHRT_BLOCKIERT = new AttRdsEreignisCode("Einfahrt blockiert", 		Integer
	.valueOf("472"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_473_EINFAHRT_BLOCKIERT_BESCHRAENKUNGEN_DER_EINFAHRT_ = new AttRdsEreignisCode("Einfahrt blockiert (Beschränkungen der Einfahrt)", 		Integer
	.valueOf("473"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1999_GEFAEHRLICHE_SITUATION_IN_DER_EINFAHRT = new AttRdsEreignisCode("gefährliche Situation in der Einfahrt", 		Integer
	.valueOf("1999"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_632_EINFAHRT_WIEDER_FREI = new AttRdsEreignisCode("Einfahrt wieder frei", 		Integer
	.valueOf("632"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_399_MELDUNG_AUFGEHOBEN_BESCHRAENKUNGEN_DER_EINFAHRT_ = new AttRdsEreignisCode("Meldung aufgehoben (Beschränkungen der Einfahrt)", 		Integer
	.valueOf("399"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_492_FAHRVERBOT_FUER_KRAFTFAHRZEUGE = new AttRdsEreignisCode("Fahrverbot für Kraftfahrzeuge", 		Integer
	.valueOf("492"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_493_BESCHRAENKUNGEN = new AttRdsEreignisCode("Beschränkungen", 		Integer
	.valueOf("493"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_627_FAHRVERBOT_FUER_KRAFTFAHRZEUGE_OHNE_KATALYSATOR = new AttRdsEreignisCode("Fahrverbot für Kraftfahrzeuge ohne Katalysator", 		Integer
	.valueOf("627"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_628_GESPERRT_FUER_KRAFTFAHRZEUGE_MIT_GERADZAHLIGEN_KENNZEICHEN = new AttRdsEreignisCode("gesperrt für Kraftfahrzeuge mit geradzahligen Kennzeichen", 		Integer
	.valueOf("628"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_629_GESPERRT_FUER_KRAFTFAHRZEUGE_MIT_UNGERADZAHLIGEN_KENNZEICHEN = new AttRdsEreignisCode("gesperrt für Kraftfahrzeuge mit ungeradzahligen Kennzeichen", 		Integer
	.valueOf("629"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_405_GESPERRT_FUER_DURCHGANGSVERKEHR = new AttRdsEreignisCode("gesperrt für Durchgangsverkehr", 		Integer
	.valueOf("405"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_404_DURCHFAHRT_GESPERRT_FUER_LKW = new AttRdsEreignisCode("Durchfahrt gesperrt für LKW", 		Integer
	.valueOf("404"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1332_SMOG_ALARM = new AttRdsEreignisCode("Smog-Alarm", 		Integer
	.valueOf("1332"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1338_SMOG_ALARM_FAHRVERBOT_FUER_KRAFTFAHRZEUGE = new AttRdsEreignisCode("Smog-Alarm, Fahrverbot für Kraftfahrzeuge", 		Integer
	.valueOf("1338"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_469_GESPERRT_VERKEHRSBESCHRAENKUNGEN_ = new AttRdsEreignisCode("gesperrt (Verkehrsbeschränkungen)", 		Integer
	.valueOf("469"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_470_BLOCKIERT_VERKEHRSBESCHRAENKUNGEN_ = new AttRdsEreignisCode("blockiert (Verkehrsbeschränkungen)", 		Integer
	.valueOf("470"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2000_WEGEN_SMOG_ALARMS_GESPERRT = new AttRdsEreignisCode("wegen Smog-Alarms gesperrt", 		Integer
	.valueOf("2000"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1527_WEGEN_VERANSTALTUNG_GESPERRT = new AttRdsEreignisCode("wegen Veranstaltung gesperrt", 		Integer
	.valueOf("1527"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1541_WEGEN_SPORTVERANSTALTUNG_GESPERRT = new AttRdsEreignisCode("wegen Sportveranstaltung gesperrt", 		Integer
	.valueOf("1541"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1555_WEGEN_VOLKSFEST_GESPERRT = new AttRdsEreignisCode("wegen Volksfest gesperrt", 		Integer
	.valueOf("1555"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1559_WEGEN_PARADE_GESPERRT = new AttRdsEreignisCode("wegen Parade gesperrt", 		Integer
	.valueOf("1559"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1563_WEGEN_STREIKS_GESPERRT = new AttRdsEreignisCode("wegen Streiks gesperrt", 		Integer
	.valueOf("1563"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1567_WEGEN_DEMONSTRATION_GESPERRT = new AttRdsEreignisCode("wegen Demonstration gesperrt", 		Integer
	.valueOf("1567"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1580_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_STRASSE_GESPERRT = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, Straße gesperrt", 		Integer
	.valueOf("1580"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1485_SICHERHEITSVORFALL_STRASSE_GESPERRT = new AttRdsEreignisCode("Sicherheitsvorfall, Straße gesperrt", 		Integer
	.valueOf("1485"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_938_WEGEN_HOCHWASSERS_GESPERRT = new AttRdsEreignisCode("wegen Hochwassers gesperrt", 		Integer
	.valueOf("938"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_943_WEGEN_LAWINEN_GESPERRT = new AttRdsEreignisCode("wegen Lawinen gesperrt", 		Integer
	.valueOf("943"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_993_WEGEN_LAWINENGEFAHR_GESPERRT = new AttRdsEreignisCode("wegen Lawinengefahr gesperrt", 		Integer
	.valueOf("993"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_995_WEGEN_GLATTEISBILDUNG_GESPERRT = new AttRdsEreignisCode("wegen Glatteisbildung gesperrt", 		Integer
	.valueOf("995"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_945_WEGEN_STEINSCHLAGS_GESPERRT = new AttRdsEreignisCode("wegen Steinschlags gesperrt", 		Integer
	.valueOf("945"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_949_WEGEN_FAHRBAHNABSENKUNG_GESPERRT = new AttRdsEreignisCode("wegen Fahrbahnabsenkung gesperrt", 		Integer
	.valueOf("949"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2013_TANK_UND_RASTANLAGE_AUSGELASTET = new AttRdsEreignisCode("Tank- und Rastanlage ausgelastet", 		Integer
	.valueOf("2013"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_20_TANK_UND_RASTANLAGE_UEBERFUELLT_FAHREN_SIE_EINE_ANDERE_TANK_ODER_RASTANLAGE_AN = new AttRdsEreignisCode("Tank- und Rastanlage überfüllt, fahren Sie eine andere Tank- oder Rastanlage an", 		Integer
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_22_TANK_UND_RASTANLAGE_TANKSTELLE_GESCHLOSSEN = new AttRdsEreignisCode("Tank- und Rastanlage, Tankstelle geschlossen", 		Integer
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_23_TANK_UND_RASTANLAGE_RASTSTAETTE_GESCHLOSSEN = new AttRdsEreignisCode("Tank- und Rastanlage, Raststätte geschlossen", 		Integer
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_24_BRUECKE_GESPERRT = new AttRdsEreignisCode("Brücke gesperrt", 		Integer
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_25_TUNNEL_GESPERRT = new AttRdsEreignisCode("Tunnel gesperrt", 		Integer
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_403_GESPERRT_FUER_SCHWERVERKEHR = new AttRdsEreignisCode("gesperrt für Schwerverkehr", 		Integer
	.valueOf("403"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_494_GESPERRT_FUER_LKW_ = new AttRdsEreignisCode("gesperrt für LKW ", 		Integer
	.valueOf("494"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_661_BENUTZUNG_DER_STANDSPUR_ERLAUBT = new AttRdsEreignisCode("Benutzung der Standspur erlaubt", 		Integer
	.valueOf("661"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1854_GEAENDERTE_VERKEHRSREGELUNG = new AttRdsEreignisCode("geänderte Verkehrsregelung", 		Integer
	.valueOf("1854"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_28_STRASSE_WIRD_MEHRFACH_GESPERRT = new AttRdsEreignisCode("Straße wird mehrfach gesperrt", 		Integer
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1971_POLIZEI_REGELT_DEN_VERKEHR = new AttRdsEreignisCode("Polizei regelt den Verkehr", 		Integer
	.valueOf("1971"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1972_BUSSPUR_OFFEN_FUER_ALLE_FAHRZEUGE = new AttRdsEreignisCode("Busspur offen für alle Fahrzeuge", 		Integer
	.valueOf("1972"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1973_POLIZEI_FUEHRT_DEN_VERKEHR_UEBER_BUSSPUR = new AttRdsEreignisCode("Polizei führt den Verkehr über Busspur", 		Integer
	.valueOf("1973"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1978_SCHWERVERKEHRSSPUR_OFFEN_FUER_ALLE_FAHRZEUGE = new AttRdsEreignisCode("Schwerverkehrsspur offen für alle Fahrzeuge", 		Integer
	.valueOf("1978"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1979_POLIZEI_FUEHRT_DEN_VERKEHR_UEBER_SCHWERVERKEHRSSPUR_ = new AttRdsEreignisCode("Polizei führt den Verkehr über Schwerverkehrsspur ", 		Integer
	.valueOf("1979"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_662_NORMALE_FAHRSPURREGELUNG_WIEDER_IN_KRAFT = new AttRdsEreignisCode("normale Fahrspurregelung wieder in Kraft", 		Integer
	.valueOf("662"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1974_GASSE_FUER_RETTUNGS_UND_EINSATZFAHRZEUGE_BILDEN = new AttRdsEreignisCode("Gasse für Rettungs- und Einsatzfahrzeuge bilden", 		Integer
	.valueOf("1974"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1977_RETTUNGS_UND_EINSATZFAHRZEUGE_AUF_SCHWERVERKEHRSSPUR_UEBERHOLEN_LASSEN = new AttRdsEreignisCode("Rettungs- und Einsatzfahrzeuge auf Schwerverkehrsspur überholen lassen", 		Integer
	.valueOf("1977"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1961_RETTUNGS_UND_EINSATZFAHRZEUGE_AUF_FAHRGEMEINSCHAFTSSPUR_UEBERHOLEN_LASSEN = new AttRdsEreignisCode("Rettungs- und Einsatzfahrzeuge auf Fahrgemeinschaftsspur überholen lassen", 		Integer
	.valueOf("1961"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1212_STARKER_WIND_STRASSE_GESPERRT_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN = new AttRdsEreignisCode("starker Wind, Straße gesperrt für Fahrzeuge mit hohen Aufbauten", 		Integer
	.valueOf("1212"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1976_UEBERHOLVERBOT = new AttRdsEreignisCode("Überholverbot", 		Integer
	.valueOf("1976"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1985_UEBERHOLVERBOT_AUFGEHOBEN = new AttRdsEreignisCode("Überholverbot aufgehoben", 		Integer
	.valueOf("1985"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1981_LKW_WIRD_EMPFOHLEN_DIE_NAECHSTE_GEEIGNETE_HALTEMOEGLICHKEIT_ANZUFAHREN = new AttRdsEreignisCode("LKW  wird empfohlen, die nächste geeignete Haltemöglichkeit anzufahren", 		Integer
	.valueOf("1981"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1975_UEBERHOLVERBOT_FUER_SCHWERVERKEHR = new AttRdsEreignisCode("Überholverbot für Schwerverkehr", 		Integer
	.valueOf("1975"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_660_FAHRBAHNBESCHRAENKUNG_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("Fahrbahnbeschränkung besteht nicht mehr", 		Integer
	.valueOf("660"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1215_BESCHRAENKUNGEN_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN_BESTEHEN_NICHT_MEHR = new AttRdsEreignisCode("Beschränkungen für Fahrzeuge mit hohen Aufbauten bestehen nicht mehr", 		Integer
	.valueOf("1215"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_680_SPERRUNG_FUER_DURCHGANGSVERKEHR_IST_AUFGEHOBEN = new AttRdsEreignisCode("Sperrung für Durchgangsverkehr ist aufgehoben", 		Integer
	.valueOf("680"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_36_TANKSTELLE_WIEDER_GEOEFFNET = new AttRdsEreignisCode("Tankstelle wieder geöffnet", 		Integer
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_37_RASTSTAETTE_WIEDER_GEOEFFNET = new AttRdsEreignisCode("Raststätte wieder geöffnet", 		Integer
	.valueOf("37"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_635_FAHRVERBOT_FUER_KRAFTFAHRZEUGE_AUFGEHOBEN = new AttRdsEreignisCode("Fahrverbot für Kraftfahrzeuge aufgehoben", 		Integer
	.valueOf("635"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_40_FAHRVERBOT_WEGEN_SMOG_ALARM_AUFGEHOBEN = new AttRdsEreignisCode("Fahrverbot wegen Smog-Alarm aufgehoben", 		Integer
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_636_FAHRVERBOT_AUFGEHOBEN = new AttRdsEreignisCode("Fahrverbot aufgehoben", 		Integer
	.valueOf("636"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2046_AUFGRUND_SCHLECHTEN_WETTERS_FAHREN_IM_KOLONNENVERBAND_VORGESCHRIEBEN = new AttRdsEreignisCode("aufgrund schlechten Wetters Fahren im Kolonnenverband vorgeschrieben", 		Integer
	.valueOf("2046"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_468_MELDUNG_AUFGEHOBEN_VERKEHRSBESCHRAENKUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Verkehrsbeschränkungen)", 		Integer
	.valueOf("468"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_647_SONDERSPUR_FUER_FAHRGEMEINSCHAFTEN_OFFEN = new AttRdsEreignisCode("Sonderspur für Fahrgemeinschaften offen", 		Integer
	.valueOf("647"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_648_SONDERSPUR_FUER_FAHRGEMEINSCHAFTEN_GESPERRT = new AttRdsEreignisCode("Sonderspur für Fahrgemeinschaften gesperrt", 		Integer
	.valueOf("648"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_649_SONDERSPUR_FUER_FAHRGEMEINSCHAFTEN_BLOCKIERT = new AttRdsEreignisCode("Sonderspur für Fahrgemeinschaften blockiert", 		Integer
	.valueOf("649"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_671_NUTZUNG_DER_BUSSPUR_FUER_FAHRGEMEINSCHAFTEN_ERLAUBT = new AttRdsEreignisCode("Nutzung der Busspur für Fahrgemeinschaften erlaubt", 		Integer
	.valueOf("671"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_650_BEDINGUNGEN_FUER_FAHRGEMEINSCHAFTEN_GEAENDERT = new AttRdsEreignisCode("Bedingungen für Fahrgemeinschaften geändert", 		Integer
	.valueOf("650"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1962_FAHRGEMEINSCHAFTSSPUR_OFFEN_FUER_ALLE_FAHRZEUGE = new AttRdsEreignisCode("Fahrgemeinschaftsspur offen für alle Fahrzeuge", 		Integer
	.valueOf("1962"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1963_POLIZEI_FUEHRT_DEN_VERKEHR_UEBER_FAHRGEMEINSCHAFTSSPUR = new AttRdsEreignisCode("Polizei führt den Verkehr über Fahrgemeinschaftsspur", 		Integer
	.valueOf("1963"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2006_GESPERRT_FUER_FAHRZEUGE_MIT_WENIGER_ALS_3_INSASSEN = new AttRdsEreignisCode("gesperrt für Fahrzeuge mit weniger als 3 Insassen", 		Integer
	.valueOf("2006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2007_GESPERRT_FUER_FAHRZEUGE_MIT_NUR_EINEM_INSASSEN = new AttRdsEreignisCode("gesperrt für Fahrzeuge mit nur einem Insassen", 		Integer
	.valueOf("2007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_659_BESCHRAENKUNG_DER_FAHRGEMEINSCHAFTEN_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("Beschränkung der Fahrgemeinschaften besteht nicht mehr", 		Integer
	.valueOf("659"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2029_MELDUNG_AUFGEHOBEN_INFORMATIONEN_FUER_FAHRGEMEINSCHAFTEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Informationen für Fahrgemeinschaften)", 		Integer
	.valueOf("2029"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_701_BAUSTELLE = new AttRdsEreignisCode("Baustelle", 		Integer
	.valueOf("701"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_702_GROSSBAUSTELLE = new AttRdsEreignisCode("Großbaustelle", 		Integer
	.valueOf("702"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_802_DAUERBAUSTELLE = new AttRdsEreignisCode("Dauerbaustelle", 		Integer
	.valueOf("802"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_803_BAUARBEITEN = new AttRdsEreignisCode("Bauarbeiten", 		Integer
	.valueOf("803"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_704_FAHRBAHNERNEUERUNG = new AttRdsEreignisCode("Fahrbahnerneuerung", 		Integer
	.valueOf("704"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_705_ARBEITEN_AM_MITTELSTREIFEN = new AttRdsEreignisCode("Arbeiten am Mittelstreifen", 		Integer
	.valueOf("705"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_703_WARTUNGSARBEITEN = new AttRdsEreignisCode("Wartungsarbeiten", 		Integer
	.valueOf("703"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_853_VERKEHRSBEHINDERUNG_DURCH_ABBAU_DER_BAUSTELLE = new AttRdsEreignisCode("Verkehrsbehinderung durch Abbau der Baustelle", 		Integer
	.valueOf("853"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_707_BRUECKENARBEITEN = new AttRdsEreignisCode("Brückenarbeiten", 		Integer
	.valueOf("707"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_805_BRUECKENABRISS = new AttRdsEreignisCode("Brückenabriss", 		Integer
	.valueOf("805"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_709_SPRENGARBEITEN = new AttRdsEreignisCode("Sprengarbeiten", 		Integer
	.valueOf("709"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_52_ARBEITEN_AM_STANDSTREIFEN = new AttRdsEreignisCode("Arbeiten am Standstreifen", 		Integer
	.valueOf("52"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_53_ARBEITEN_AUF_DER_NOTFALLSPUR = new AttRdsEreignisCode("Arbeiten auf der Notfallspur", 		Integer
	.valueOf("53"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_815_TAGESBAUSTELLE = new AttRdsEreignisCode("Tagesbaustelle", 		Integer
	.valueOf("815"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_816_BAUSTELLE_IN_VERKEHRSARMEN_ZEITEN = new AttRdsEreignisCode("Baustelle in verkehrsarmen Zeiten", 		Integer
	.valueOf("816"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_817_NACHTBAUSTELLE = new AttRdsEreignisCode("Nachtbaustelle", 		Integer
	.valueOf("817"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_821_FAHRBAHNERNEUERUNG_AM_TAGE = new AttRdsEreignisCode("Fahrbahnerneuerung am Tage", 		Integer
	.valueOf("821"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_822_FAHRBAHNERNEUERUNG_IN_VERKEHRSARMEN_ZEITEN = new AttRdsEreignisCode("Fahrbahnerneuerung in verkehrsarmen Zeiten", 		Integer
	.valueOf("822"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_823_FAHRBAHNERNEUERUNG_IN_DER_NACHT = new AttRdsEreignisCode("Fahrbahnerneuerung in der Nacht", 		Integer
	.valueOf("823"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_708_VORUEBERGEHENDE_REGELUNG_MIT_PROVISORISCHEN_AMPELANLAGEN = new AttRdsEreignisCode("vorübergehende Regelung mit provisorischen Ampelanlagen", 		Integer
	.valueOf("708"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_806_ARBEITEN_AN_WASSERLEITUNGEN = new AttRdsEreignisCode("Arbeiten an Wasserleitungen", 		Integer
	.valueOf("806"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_807_ARBEITEN_AN_GASLEITUNGEN = new AttRdsEreignisCode("Arbeiten an Gasleitungen", 		Integer
	.valueOf("807"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_808_ARBEITEN_AN_ERDKABELN = new AttRdsEreignisCode("Arbeiten an Erdkabeln", 		Integer
	.valueOf("808"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_809_TIEFBAUARBEITEN = new AttRdsEreignisCode("Tiefbauarbeiten", 		Integer
	.valueOf("809"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_810_GEAENDERTE_VERKEHRSFUEHRUNG_IM_BAUSTELLENBEREICH = new AttRdsEreignisCode("geänderte Verkehrsführung im Baustellenbereich", 		Integer
	.valueOf("810"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_855_KEINE_GEAENDERTE_VERKEHRSFUEHRUNG = new AttRdsEreignisCode("keine geänderte Verkehrsführung", 		Integer
	.valueOf("855"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_811_GEAENDERTE_VERKEHRSFUEHRUNG = new AttRdsEreignisCode("geänderte Verkehrsführung", 		Integer
	.valueOf("811"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_854_WARTUNGSARBEITEN_BEENDET_ = new AttRdsEreignisCode("Wartungsarbeiten beendet ", 		Integer
	.valueOf("854"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_800_BAUSTELLE_BESEITIGT = new AttRdsEreignisCode("Baustelle beseitigt", 		Integer
	.valueOf("800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_801_MELDUNG_AUFGEHOBEN_BAUARBEITEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Bauarbeiten)", 		Integer
	.valueOf("801"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_901_VERKEHRSBEHINDERUNG_DURCH_HINDERNISSE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Hindernisse auf der Fahrbahn", 		Integer
	.valueOf("901"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_902_GEFAHR_DURCH_HINDERNISSE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Hindernisse auf der Fahrbahn", 		Integer
	.valueOf("902"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_981_VERKEHRSBEHINDERUNG_DURCH_HINDERNISSE_AUF_DER_FAHRBAHN_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Hindernisse auf der Fahrbahn, mit Vorsicht passierbar", 		Integer
	.valueOf("981"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_61_VERKEHRSBEHINDERUNG_DURCH_GEGENSTAENDE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Gegenstände auf der Fahrbahn", 		Integer
	.valueOf("61"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_63_GEFAHR_DURCH_GEGENSTAENDE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Gegenstände auf der Fahrbahn", 		Integer
	.valueOf("63"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_210_VERKEHRSBEHINDERUNG_DURCH_VERLORENE_LADUNG = new AttRdsEreignisCode("Verkehrsbehinderung durch verlorene Ladung", 		Integer
	.valueOf("210"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_359_GEFAHR_DURCH_VERLORENE_LADUNG = new AttRdsEreignisCode("Gefahr durch verlorene Ladung", 		Integer
	.valueOf("359"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_903_VERKEHRSBEHINDERUNG_DURCH_AUSGELAUFENE_FLUESSIGKEITEN_AUF_DER_STRASSE = new AttRdsEreignisCode("Verkehrsbehinderung durch ausgelaufene Flüssigkeiten auf der Straße", 		Integer
	.valueOf("903"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_984_GEFAHR_DURCH_AUSGELAUFENE_FLUESSIGKEITEN_AUF_DER_STRASSE = new AttRdsEreignisCode("Gefahr durch ausgelaufene Flüssigkeiten auf der Straße", 		Integer
	.valueOf("984"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_904_VERKEHRSBEHINDERUNG_DURCH_STURMSCHAEDEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Sturmschäden", 		Integer
	.valueOf("904"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_986_GEFAHR_DURCH_STURMSCHAEDEN = new AttRdsEreignisCode("Gefahr durch Sturmschäden", 		Integer
	.valueOf("986"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_972_MIT_STURMSCHAEDEN_IST_ZU_RECHNEN = new AttRdsEreignisCode("mit Sturmschäden ist zu rechnen", 		Integer
	.valueOf("972"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_905_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTE_BAEUME = new AttRdsEreignisCode("Verkehrsbehinderung durch umgestürzte Bäume", 		Integer
	.valueOf("905"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_906_GEFAHR_DURCH_UMGESTUERZTE_BAEUME = new AttRdsEreignisCode("Gefahr durch umgestürzte Bäume", 		Integer
	.valueOf("906"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_973_VERKEHRSBEHINDERUNG_DURCH_HERUNTERHAENGENDE_STROMKABEL = new AttRdsEreignisCode("Verkehrsbehinderung durch herunterhängende Stromkabel", 		Integer
	.valueOf("973"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_989_GEFAHR_DURCH_HERUNTERHAENGENDE_STROMKABEL = new AttRdsEreignisCode("Gefahr durch herunterhängende Stromkabel", 		Integer
	.valueOf("989"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_907_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER = new AttRdsEreignisCode("Verkehrsbehinderung durch Hochwasser", 		Integer
	.valueOf("907"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_900_MIT_HOCHWASSER_IST_ZU_RECHNEN = new AttRdsEreignisCode("mit Hochwasser ist zu rechnen", 		Integer
	.valueOf("900"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_908_GEFAHR_DURCH_HOCHWASSER = new AttRdsEreignisCode("Gefahr durch Hochwasser", 		Integer
	.valueOf("908"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_974_VERKEHRSBEHINDERUNG_DURCH_UEBERLASTETE_ABFLUSSKANAELE = new AttRdsEreignisCode("Verkehrsbehinderung durch überlastete Abflusskanäle", 		Integer
	.valueOf("974"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_990_GEFAHR_DURCH_UEBERLASTETE_ABFLUSSKANAELE = new AttRdsEreignisCode("Gefahr durch überlastete Abflusskanäle", 		Integer
	.valueOf("990"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_909_VERKEHRSBEHINDERUNG_DURCH_UEBERFLUTUNG = new AttRdsEreignisCode("Verkehrsbehinderung durch Überflutung", 		Integer
	.valueOf("909"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_910_UEBERFLUTUNGSGEFAHR = new AttRdsEreignisCode("Überflutungsgefahr", 		Integer
	.valueOf("910"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_991_GEFAHR_DURCH_UEBERFLUTUNG = new AttRdsEreignisCode("Gefahr durch Überflutung", 		Integer
	.valueOf("991"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_911_VERKEHRSBEHINDERUNG_DURCH_LAWINEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Lawinen", 		Integer
	.valueOf("911"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_992_GEFAHR_DURCH_LAWINEN = new AttRdsEreignisCode("Gefahr durch Lawinen", 		Integer
	.valueOf("992"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_912_VERKEHRSBEHINDERUNG_DURCH_DROHENDE_LAWINEN = new AttRdsEreignisCode("Verkehrsbehinderung durch drohende Lawinen", 		Integer
	.valueOf("912"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_994_LAWINENGEFAHR = new AttRdsEreignisCode("Lawinengefahr", 		Integer
	.valueOf("994"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_975_VERKEHRSBEHINDERUNG_DURCH_EISGLAETTE = new AttRdsEreignisCode("Verkehrsbehinderung durch Eisglätte", 		Integer
	.valueOf("975"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_913_VERKEHRSBEHINDERUNG_DURCH_STEINSCHLAG = new AttRdsEreignisCode("Verkehrsbehinderung durch Steinschlag", 		Integer
	.valueOf("913"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_998_GEFAHR_DURCH_STEINSCHLAG = new AttRdsEreignisCode("Gefahr durch Steinschlag", 		Integer
	.valueOf("998"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_914_VERKEHRSBEHINDERUNG_DURCH_ERDRUTSCH = new AttRdsEreignisCode("Verkehrsbehinderung durch Erdrutsch", 		Integer
	.valueOf("914"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_999_GEFAHR_DURCH_ERDRUTSCH = new AttRdsEreignisCode("Gefahr durch Erdrutsch", 		Integer
	.valueOf("999"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_976_VERKEHRSBEHINDERUNG_DURCH_SCHLAMMLAWINE = new AttRdsEreignisCode("Verkehrsbehinderung durch Schlammlawine", 		Integer
	.valueOf("976"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_915_VERKEHRSBEHINDERUNG_DURCH_ERDBEBENSCHAEDEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Erdbebenschäden", 		Integer
	.valueOf("915"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1000_GEFAHR_DURCH_ERDBEBENSCHAEDEN = new AttRdsEreignisCode("Gefahr durch Erdbebenschäden", 		Integer
	.valueOf("1000"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_917_VERKEHRSBEHINDERUNG_DURCH_ABSENKUNG_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Absenkung der Fahrbahn", 		Integer
	.valueOf("917"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1026_GEFAHR_DURCH_ABSENKUNG_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Absenkung der Fahrbahn", 		Integer
	.valueOf("1026"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_918_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Unterspülung der Fahrbahn", 		Integer
	.valueOf("918"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1030_GEFAHR_DURCH_UNTERSPUELUNG_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Unterspülung der Fahrbahn", 		Integer
	.valueOf("1030"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_919_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG = new AttRdsEreignisCode("Verkehrsbehinderung durch geplatzte Wasserleitung", 		Integer
	.valueOf("919"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1031_GEFAHR_DURCH_GEPLATZTE_WASSERLEITUNG = new AttRdsEreignisCode("Gefahr durch geplatzte Wasserleitung", 		Integer
	.valueOf("1031"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_62_VERKEHRSBEHINDERUNG_DURCH_ROHRBRUCH = new AttRdsEreignisCode("Verkehrsbehinderung durch Rohrbruch", 		Integer
	.valueOf("62"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_64_GEFAHR_DURCH_ROHRBRUCH = new AttRdsEreignisCode("Gefahr durch Rohrbruch", 		Integer
	.valueOf("64"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_920_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS = new AttRdsEreignisCode("Verkehrsbehinderung durch ausströmendes Gas", 		Integer
	.valueOf("920"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1032_GEFAHR_DURCH_AUSSTROEMENDES_GAS = new AttRdsEreignisCode("Gefahr durch ausströmendes Gas", 		Integer
	.valueOf("1032"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_977_VERKEHRSBEHINDERUNG_DURCH_GRASBRAND = new AttRdsEreignisCode("Verkehrsbehinderung durch Grasbrand", 		Integer
	.valueOf("977"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_921_VERKEHRSBEHINDERUNG_DURCH_GROSSBRAND = new AttRdsEreignisCode("Verkehrsbehinderung durch Großbrand", 		Integer
	.valueOf("921"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1033_GEFAHR_DURCH_GROSSBRAND = new AttRdsEreignisCode("Gefahr durch Großbrand", 		Integer
	.valueOf("1033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_978_FLUGZEUGABSTURZ = new AttRdsEreignisCode("Flugzeugabsturz", 		Integer
	.valueOf("978"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_979_ZUGUNGLUECK = new AttRdsEreignisCode("Zugunglück", 		Integer
	.valueOf("979"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_983_VERKEHRSBEHINDERUNG_DURCH_VERLORENE_LADUNG_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch verlorene Ladung, mit Vorsicht passierbar", 		Integer
	.valueOf("983"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_985_VERKEHRSBEHINDERUNG_DURCH_STURMSCHAEDEN_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Sturmschäden, mit Vorsicht passierbar", 		Integer
	.valueOf("985"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_927_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTE_BAEUME_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch umgestürzte Bäume, mit Vorsicht passierbar", 		Integer
	.valueOf("927"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_988_VERKEHRSBEHINDERUNG_DURCH_HERUNTERHAENGENDE_STROMKABEL_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch herunterhängende Stromkabel, mit Vorsicht passierbar", 		Integer
	.valueOf("988"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_942_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Hochwasser, mit Vorsicht passierbar", 		Integer
	.valueOf("942"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_944_VERKEHRSBEHINDERUNG_DURCH_LAWINEN_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Lawinen, mit Vorsicht passierbar", 		Integer
	.valueOf("944"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_996_GLATTEISGEFAHR_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Glatteisgefahr, mit Vorsicht passierbar", 		Integer
	.valueOf("996"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_946_VERKEHRSBEHINDERUNG_DURCH_STEINSCHLAG_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Steinschlag, mit Vorsicht passierbar", 		Integer
	.valueOf("946"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_948_VERKEHRSBEHINDERUNG_DURCH_ERDRUTSCH_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Erdrutsch, mit Vorsicht passierbar", 		Integer
	.valueOf("948"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_955_VERKEHRSBEHINDERUNG_DURCH_ABSENKUNG_DER_FAHRBAHN_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("Verkehrsbehinderung durch Absenkung der Fahrbahn, mit Vorsicht passierbar", 		Integer
	.valueOf("955"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_950_ABSENKUNG_DER_FAHRBAHN_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI = new AttRdsEreignisCode("Absenkung der Fahrbahn, für beide Richtungen nur ein Fahrstreifen abwechselnd frei", 		Integer
	.valueOf("950"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_997_EISGLAETTE_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI = new AttRdsEreignisCode("Eisglätte, für beide Richtungen nur ein Fahrstreifen abwechselnd frei", 		Integer
	.valueOf("997"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1709_VERSCHMUTZUNG_DURCH_EIN_FAHRENDES_FAHRZEUG = new AttRdsEreignisCode("Verschmutzung durch ein fahrendes Fahrzeug", 		Integer
	.valueOf("1709"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1700_VERKEHRSBEHINDERUNG_DURCH_LANGSAM_FAHRENDES_WARTUNGSFAHRZEUG = new AttRdsEreignisCode("Verkehrsbehinderung durch langsam fahrendes Wartungsfahrzeug", 		Integer
	.valueOf("1700"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_898_HINDERNISSE_BESEITIGT_ = new AttRdsEreignisCode("Hindernisse beseitigt ", 		Integer
	.valueOf("898"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_899_VERKEHRSBEHINDERUNG_DURCH_AUFRAEUMARBEITEN_STRASSE_WIEDER_FREI = new AttRdsEreignisCode("Verkehrsbehinderung durch Aufräumarbeiten, Straße wieder frei", 		Integer
	.valueOf("899"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_970_STRASSE_WIEDER_FREI = new AttRdsEreignisCode("Straße wieder frei", 		Integer
	.valueOf("970"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1712_STRASSE_GERAEUMT_BEHINDERUNGEN_AUF_DER_FAHRBAHN_ = new AttRdsEreignisCode("Straße geräumt (Behinderungen auf der Fahrbahn)", 		Integer
	.valueOf("1712"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1084_VERKEHRSBEHINDERUNG_DURCH_FEUER = new AttRdsEreignisCode("Verkehrsbehinderung durch Feuer", 		Integer
	.valueOf("1084"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1085_WALDBRAND = new AttRdsEreignisCode("Waldbrand", 		Integer
	.valueOf("1085"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1086_FAHRZEUG_UNTER_EINER_BRUECKE_EINGEKLEMMT = new AttRdsEreignisCode("Fahrzeug unter einer Brücke eingeklemmt", 		Integer
	.valueOf("1086"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_971_MELDUNG_AUFGEHOBEN_BEHINDERUNGEN_AUF_DER_FAHRBAHN_ = new AttRdsEreignisCode("Meldung aufgehoben (Behinderungen auf der Fahrbahn)", 		Integer
	.valueOf("971"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_922_VERKEHRSBEHINDERUNG_DURCH_TIERE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Tiere auf der Fahrbahn", 		Integer
	.valueOf("922"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1471_SCHAULUSTIGE_BEHINDERN_ZUGANG = new AttRdsEreignisCode("Schaulustige behindern Zugang", 		Integer
	.valueOf("1471"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1472_VERKEHRSBEHINDERUNG_DURCH_PERSONEN_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Personen auf der Fahrbahn", 		Integer
	.valueOf("1472"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1473_VERKEHRSBEHINDERUNG_DURCH_KINDER_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Kinder auf der Fahrbahn", 		Integer
	.valueOf("1473"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1474_VERKEHRSBEHINDERUNG_DURCH_FAHRRADFAHRER_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Fahrradfahrer auf der Fahrbahn", 		Integer
	.valueOf("1474"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_923_GEFAHR_DURCH_TIERE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Tiere auf der Fahrbahn", 		Integer
	.valueOf("923"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1482_GEFAHR_DURCH_PERSONEN_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Personen auf der Fahrbahn", 		Integer
	.valueOf("1482"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1483_KINDER_AUF_DER_FAHRBAHN_GEFAHR = new AttRdsEreignisCode("Kinder auf der Fahrbahn, Gefahr", 		Integer
	.valueOf("1483"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1484_GEFAHR_DURCH_FAHRRADFAHRER_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch Fahrradfahrer auf der Fahrbahn", 		Integer
	.valueOf("1484"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1067_VERKEHRSBEHINDERUNG_DURCH_GROESSERE_TIERE_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch größere Tiere auf der Fahrbahn", 		Integer
	.valueOf("1067"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1068_VERKEHRSBEHINDERUNG_DURCH_TIERHERDEN_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Tierherden auf der Fahrbahn", 		Integer
	.valueOf("1068"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_852_VERKEHRSBEHINDERUNG_DURCH_BAUSTELLENFAHRZEUGE = new AttRdsEreignisCode("Verkehrsbehinderung durch Baustellenfahrzeuge", 		Integer
	.valueOf("852"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_856_GEFAHR_DURCH_BAUSTELLENFAHRZEUGE = new AttRdsEreignisCode("Gefahr durch Baustellenfahrzeuge", 		Integer
	.valueOf("856"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_706_MARKIERUNGSARBEITEN = new AttRdsEreignisCode("Markierungsarbeiten", 		Integer
	.valueOf("706"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_824_GEFAHR_DURCH_MARKIERUNGSARBEITEN = new AttRdsEreignisCode("Gefahr durch Markierungsarbeiten", 		Integer
	.valueOf("824"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1771_GEFAHR_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("Gefahr besteht nicht mehr", 		Integer
	.valueOf("1771"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_857_UNGESICHERTE_UNFALLSTELLE = new AttRdsEreignisCode("ungesicherte Unfallstelle", 		Integer
	.valueOf("857"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_858_GEFAHR_DURCH_UNGESICHERTE_UNFALLSTELLE = new AttRdsEreignisCode("Gefahr durch ungesicherte Unfallstelle", 		Integer
	.valueOf("858"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_859_UNBELEUCHTETES_FAHRZEUG_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("unbeleuchtetes Fahrzeug auf der Fahrbahn", 		Integer
	.valueOf("859"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_860_GEFAHR_DURCH_UNBELEUCHTETES_FAHRZEUG_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch unbeleuchtetes Fahrzeug auf der Fahrbahn", 		Integer
	.valueOf("860"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_861_SCHNEEBRUCH = new AttRdsEreignisCode("Schneebruch", 		Integer
	.valueOf("861"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_862_GEFAHR_DURCH_SCHNEEBRUCH = new AttRdsEreignisCode("Gefahr durch Schneebruch", 		Integer
	.valueOf("862"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_897_ACHTUNG_PERSONEN_WERFEN_GEGENSTAENDE_AUF_DIE_FAHRBAHN = new AttRdsEreignisCode("Achtung! Personen werfen Gegenstände auf die Fahrbahn", 		Integer
	.valueOf("897"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1991_GEFAHR_DURCH_AUF_DER_FAHRBAHN_ABGESTELLTE_FAHRZEUGE = new AttRdsEreignisCode("Gefahr durch auf der Fahrbahn abgestellte Fahrzeuge", 		Integer
	.valueOf("1991"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1498_POLIZEIEINSATZ = new AttRdsEreignisCode("Polizeieinsatz", 		Integer
	.valueOf("1498"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1499_NOTARZTTEAM_IM_EINSATZ = new AttRdsEreignisCode("Notarztteam im Einsatz", 		Integer
	.valueOf("1499"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2030_MELDUNG_AUFGEHOBEN_GEFAEHRLICHE_SITUATIONEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Gefährliche Situationen)", 		Integer
	.valueOf("2030"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1035_NICHT_PASSIERBAR = new AttRdsEreignisCode("nicht passierbar", 		Integer
	.valueOf("1035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1036_FAST_NICHT_PASSIERBAR = new AttRdsEreignisCode("fast nicht passierbar", 		Integer
	.valueOf("1036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1037_SEHR_GEFAEHRLICHE_FAHRBEDINGUNGEN = new AttRdsEreignisCode("sehr gefährliche Fahrbedingungen", 		Integer
	.valueOf("1037"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1073_MIT_SEHR_GEFAEHRLICHEN_FAHRBEDINGUNGEN_IST_ZU_RECHNEN = new AttRdsEreignisCode("mit sehr gefährlichen Fahrbedingungen ist zu rechnen", 		Integer
	.valueOf("1073"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1001_GEFAEHRLICHE_FAHRBEDINGUNGEN = new AttRdsEreignisCode("gefährliche Fahrbedingungen", 		Integer
	.valueOf("1001"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1038_SCHWIERIGE_FAHRBEDINGUNGEN = new AttRdsEreignisCode("schwierige Fahrbedingungen", 		Integer
	.valueOf("1038"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1039_MIT_VORSICHT_PASSIERBAR = new AttRdsEreignisCode("mit Vorsicht passierbar", 		Integer
	.valueOf("1039"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1040_PASSIERBAR = new AttRdsEreignisCode("passierbar", 		Integer
	.valueOf("1040"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1063_FUER_SCHWERVERKEHR_NICHT_PASSIERBAR = new AttRdsEreignisCode("für Schwerverkehr nicht passierbar", 		Integer
	.valueOf("1063"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1064_NICHT_PASSIERBAR_FUER_FAHRZEUGE_MIT_ANHAENGER = new AttRdsEreignisCode("nicht passierbar für Fahrzeuge mit Anhänger", 		Integer
	.valueOf("1064"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1041_VERKEHRSBEHINDERUNG_DURCH_WASSER_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch Wasser auf der Fahrbahn", 		Integer
	.valueOf("1041"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1002_AQUAPLANINGGEFAHR = new AttRdsEreignisCode("Aquaplaninggefahr", 		Integer
	.valueOf("1002"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1003_STRASSENGLAETTE = new AttRdsEreignisCode("Straßenglätte", 		Integer
	.valueOf("1003"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1004_VERKEHRSBEHINDERUNG_DURCH_VERSCHMUTZTE_FAHRBAHN = new AttRdsEreignisCode("Verkehrsbehinderung durch verschmutzte Fahrbahn", 		Integer
	.valueOf("1004"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1055_GEFAHR_DURCH_VERSCHMUTZTE_FAHRBAHN = new AttRdsEreignisCode("Gefahr durch verschmutzte Fahrbahn", 		Integer
	.valueOf("1055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1005_RUTSCHGEFAHR_DURCH_LAUB = new AttRdsEreignisCode("Rutschgefahr durch Laub", 		Integer
	.valueOf("1005"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1042_VERKEHRSBEHINDERUNG_DURCH_SAND = new AttRdsEreignisCode("Verkehrsbehinderung durch Sand", 		Integer
	.valueOf("1042"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1043_VERKEHRSBEHINDERUNG_DURCH_ROLLSPLITT = new AttRdsEreignisCode("Verkehrsbehinderung durch Rollsplitt", 		Integer
	.valueOf("1043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1056_GEFAHR_DURCH_ROLLSPLITT = new AttRdsEreignisCode("Gefahr durch Rollsplitt", 		Integer
	.valueOf("1056"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1044_VERKEHRSBEHINDERUNG_DURCH_OELSPUR = new AttRdsEreignisCode("Verkehrsbehinderung durch Ölspur", 		Integer
	.valueOf("1044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1057_GEFAHR_DURCH_OELSPUR = new AttRdsEreignisCode("Gefahr durch Ölspur", 		Integer
	.valueOf("1057"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1045_VERKEHRSBEHINDERUNG_DURCH_AUSLAUFENDEN_KRAFTSTOFF = new AttRdsEreignisCode("Verkehrsbehinderung durch auslaufenden Kraftstoff", 		Integer
	.valueOf("1045"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1058_GEFAHR_DURCH_AUSLAUFENDEN_KRAFTSTOFF = new AttRdsEreignisCode("Gefahr durch auslaufenden Kraftstoff", 		Integer
	.valueOf("1058"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_916_STRASSENSCHAEDEN = new AttRdsEreignisCode("Straßenschäden", 		Integer
	.valueOf("916"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1059_GEFAHR_DURCH_STRASSENSCHAEDEN = new AttRdsEreignisCode("Gefahr durch Straßenschäden", 		Integer
	.valueOf("1059"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1006_GLATTEIS = new AttRdsEreignisCode("Glatteis", 		Integer
	.valueOf("1006"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1007_GLATTEISGEFAHR = new AttRdsEreignisCode("Glatteisgefahr", 		Integer
	.valueOf("1007"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1047_TEILWEISE_VEREISTE_FAHRBAHN = new AttRdsEreignisCode("teilweise vereiste Fahrbahn", 		Integer
	.valueOf("1047"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1048_GEFAHR_DURCH_STRASSENGLAETTE = new AttRdsEreignisCode("Gefahr durch Straßenglätte", 		Integer
	.valueOf("1048"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1008_BLITZEIS = new AttRdsEreignisCode("Blitzeis", 		Integer
	.valueOf("1008"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1050_GEFAHR_DURCH_BLITZEIS = new AttRdsEreignisCode("Gefahr durch Blitzeis", 		Integer
	.valueOf("1050"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1009_UEBERFRIERENDE_NAESSE = new AttRdsEreignisCode("überfrierende Nässe", 		Integer
	.valueOf("1009"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1074_MIT_UEBERFRIERENDER_NAESSE_IST_ZU_RECHNEN = new AttRdsEreignisCode("mit überfrierender Nässe ist zu rechnen", 		Integer
	.valueOf("1074"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1010_TEILWEISE_NASSE_UND_VEREISTE_FAHRBAHN = new AttRdsEreignisCode("teilweise nasse und vereiste Fahrbahn", 		Integer
	.valueOf("1010"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1011_SCHNEEMATSCH = new AttRdsEreignisCode("Schneematsch", 		Integer
	.valueOf("1011"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1012_SCHNEEBEDECKTE_FAHRBAHN = new AttRdsEreignisCode("schneebedeckte Fahrbahn", 		Integer
	.valueOf("1012"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1013_SCHNEEGLAETTE = new AttRdsEreignisCode("Schneeglätte", 		Integer
	.valueOf("1013"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1014_NEUSCHNEE = new AttRdsEreignisCode("Neuschnee", 		Integer
	.valueOf("1014"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1015_TIEFER_SCHNEE = new AttRdsEreignisCode("tiefer Schnee", 		Integer
	.valueOf("1015"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1016_SCHNEEVERWEHUNGEN = new AttRdsEreignisCode("Schneeverwehungen", 		Integer
	.valueOf("1016"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1018_RUTSCHGEFAHR_DURCH_SCHNEEGLAETTE = new AttRdsEreignisCode("Rutschgefahr durch Schneeglätte", 		Integer
	.valueOf("1018"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1019_REIFGLAETTE = new AttRdsEreignisCode("Reifglätte", 		Integer
	.valueOf("1019"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1017_RUTSCHGEFAHR_DURCH_AUSGELAUFENE_FLUESSIGKEITEN = new AttRdsEreignisCode("Rutschgefahr durch ausgelaufene Flüssigkeiten", 		Integer
	.valueOf("1017"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1054_RUTSCHGEFAHR_DURCH_SAND_AUF_DER_FAHRBAHN = new AttRdsEreignisCode("Rutschgefahr durch Sand auf der Fahrbahn", 		Integer
	.valueOf("1054"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1060_TEILWEISE_VEREISTE_FAHRBAHN_AUF_BRUECKEN = new AttRdsEreignisCode("teilweise vereiste Fahrbahn auf Brücken", 		Integer
	.valueOf("1060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1061_GEFAHR_DURCH_STRASSENGLAETTE_AUF_BRUECKEN = new AttRdsEreignisCode("Gefahr durch Straßenglätte auf Brücken", 		Integer
	.valueOf("1061"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1062_TEILWEISE_VEREISTE_FAHRBAHN_AUF_BRUECKEN_IN_SCHATTIGEN_BEREICHEN_UND_IN_ANSCHLUSSSTELLEN = new AttRdsEreignisCode("teilweise vereiste Fahrbahn auf Brücken, in schattigen Bereichen und in Anschlussstellen", 		Integer
	.valueOf("1062"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1020_SCHNEE_STRASSE_BLOCKIERT = new AttRdsEreignisCode("Schnee, Straße blockiert", 		Integer
	.valueOf("1020"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1075_SCHNEE_GEFAHR_VON_BLOCKIERTEN_STRASSEN = new AttRdsEreignisCode("Schnee, Gefahr von blockierten Straßen", 		Integer
	.valueOf("1075"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1024_STRASSENVERHAELTNISSE_HABEN_SICH_WIEDER_GEBESSERT = new AttRdsEreignisCode("Straßenverhältnisse haben sich wieder gebessert", 		Integer
	.valueOf("1024"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1070_SCHNEE_GERAEUMT = new AttRdsEreignisCode("Schnee geräumt", 		Integer
	.valueOf("1070"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1065_FAHRBEDINGUNGEN_HABEN_SICH_GEBESSERT = new AttRdsEreignisCode("Fahrbedingungen haben sich gebessert", 		Integer
	.valueOf("1065"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1069_RUTSCHGEFAHR_HAT_ABGENOMMEN = new AttRdsEreignisCode("Rutschgefahr hat abgenommen", 		Integer
	.valueOf("1069"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1165_REGEN_GEHT_IN_SCHNEE_UEBER = new AttRdsEreignisCode("Regen geht in Schnee über", 		Integer
	.valueOf("1165"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1166_SCHNEE_GEHT_IN_REGEN_UEBER = new AttRdsEreignisCode("Schnee geht in Regen über", 		Integer
	.valueOf("1166"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1025_MELDUNG_AUFGEHOBEN_STRASSENZUSTAND_ = new AttRdsEreignisCode("Meldung aufgehoben (Straßenzustand)", 		Integer
	.valueOf("1025"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2043_STRASSE_GESTREUT = new AttRdsEreignisCode("Straße gestreut", 		Integer
	.valueOf("2043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2044_GEFAHR_DURCH_SCHNEERESTE = new AttRdsEreignisCode("Gefahr durch Schneereste", 		Integer
	.valueOf("2044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2045_SCHNEERESTE = new AttRdsEreignisCode("Schneereste", 		Integer
	.valueOf("2045"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1083_AKTUELLE_TEMPERATUR = new AttRdsEreignisCode("aktuelle Temperatur", 		Integer
	.valueOf("1083"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1115_STARKER_FROST = new AttRdsEreignisCode("starker Frost", 		Integer
	.valueOf("1115"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1116_FROST = new AttRdsEreignisCode("Frost", 		Integer
	.valueOf("1116"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1079_SCHNELL_FALLENDE_TEMPERATUR = new AttRdsEreignisCode("schnell fallende Temperatur", 		Integer
	.valueOf("1079"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1080_EXTREME_HITZE = new AttRdsEreignisCode("extreme Hitze", 		Integer
	.valueOf("1080"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1081_EXTREME_KAELTE = new AttRdsEreignisCode("extreme Kälte", 		Integer
	.valueOf("1081"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1082_TEMPERATUREN_HABEN_SICH_NORMALISIERT = new AttRdsEreignisCode("Temperaturen haben sich normalisiert", 		Integer
	.valueOf("1082"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1127_MELDUNG_AUFGEHOBEN_TEMPERATUREN_ = new AttRdsEreignisCode("Meldung aufgehoben (Temperaturen)", 		Integer
	.valueOf("1127"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1132_STARKER_HAGEL = new AttRdsEreignisCode("starker Hagel", 		Integer
	.valueOf("1132"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1174_STARKER_HAGEL_ZU_ERWARTEN = new AttRdsEreignisCode("starker Hagel zu erwarten", 		Integer
	.valueOf("1174"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1106_HAGEL = new AttRdsEreignisCode("Hagel", 		Integer
	.valueOf("1106"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1107_SCHNEEREGEN = new AttRdsEreignisCode("Schneeregen", 		Integer
	.valueOf("1107"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1108_GEWITTER = new AttRdsEreignisCode("Gewitter", 		Integer
	.valueOf("1108"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1128_SCHNEESTURM = new AttRdsEreignisCode("Schneesturm", 		Integer
	.valueOf("1128"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1130_BLIZZARD = new AttRdsEreignisCode("Blizzard", 		Integer
	.valueOf("1130"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1173_BLIZZARD_ZU_ERWARTEN = new AttRdsEreignisCode("Blizzard zu erwarten", 		Integer
	.valueOf("1173"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1101_STARKER_SCHNEEFALL = new AttRdsEreignisCode("starker Schneefall", 		Integer
	.valueOf("1101"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1170_STARKER_SCHNEEFALL_ZU_ERWARTEN = new AttRdsEreignisCode("starker Schneefall zu erwarten", 		Integer
	.valueOf("1170"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1134_STARKER_SCHNEEFALL_SICHTBEHINDERUNG = new AttRdsEreignisCode("starker Schneefall, Sichtbehinderung", 		Integer
	.valueOf("1134"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1102_STARKER_SCHNEEFALL_SICHTWEITEN_UNTER_30_M = new AttRdsEreignisCode("starker Schneefall, Sichtweiten unter 30 m", 		Integer
	.valueOf("1102"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1103_STARKER_SCHNEEFALL_SICHTWEITEN_UNTER_50_M = new AttRdsEreignisCode("starker Schneefall, Sichtweiten unter 50 m", 		Integer
	.valueOf("1103"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1104_SCHNEEFALL = new AttRdsEreignisCode("Schneefall", 		Integer
	.valueOf("1104"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1135_SICHTBEHINDERUNG_DURCH_SCHNEEFALL = new AttRdsEreignisCode("Sichtbehinderung durch Schneefall", 		Integer
	.valueOf("1135"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1105_SCHNEEFALL_SICHTWEITEN_UNTER_100_M = new AttRdsEreignisCode("Schneefall, Sichtweiten unter 100 m", 		Integer
	.valueOf("1105"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1109_STARKER_REGEN = new AttRdsEreignisCode("starker Regen", 		Integer
	.valueOf("1109"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1171_STARKER_REGEN_ZU_ERWARTEN = new AttRdsEreignisCode("starker Regen zu erwarten", 		Integer
	.valueOf("1171"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1136_SICHTBEHINDERUNG_DURCH_STARKEN_REGEN = new AttRdsEreignisCode("Sichtbehinderung durch starken Regen", 		Integer
	.valueOf("1136"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1110_STARKER_REGEN_SICHTWEITEN_UNTER_30_M = new AttRdsEreignisCode("starker Regen, Sichtweiten unter 30 m", 		Integer
	.valueOf("1110"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1111_STARKER_REGEN_SICHTWEITEN_UNTER_50_M = new AttRdsEreignisCode("starker Regen, Sichtweiten unter 50 m", 		Integer
	.valueOf("1111"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1112_REGEN = new AttRdsEreignisCode("Regen", 		Integer
	.valueOf("1112"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1137_SICHTBEHINDERUNG_DURCH_REGEN = new AttRdsEreignisCode("Sichtbehinderung durch Regen", 		Integer
	.valueOf("1137"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1113_REGEN_SICHTWEITEN_UNTER_100_M = new AttRdsEreignisCode("Regen, Sichtweiten unter 100 m", 		Integer
	.valueOf("1113"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1114_REGENSCHAUER = new AttRdsEreignisCode("Regenschauer", 		Integer
	.valueOf("1114"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1318_SICHTBEHINDERUNG = new AttRdsEreignisCode("Sichtbehinderung", 		Integer
	.valueOf("1318"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1319_SICHTWEITEN_UNTER_30_M = new AttRdsEreignisCode("Sichtweiten unter 30 m", 		Integer
	.valueOf("1319"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1320_SICHTWEITEN_UNTER_50_M = new AttRdsEreignisCode("Sichtweiten unter 50 m", 		Integer
	.valueOf("1320"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1321_SICHTWEITEN_UNTER_100_M = new AttRdsEreignisCode("Sichtweiten unter 100 m", 		Integer
	.valueOf("1321"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1175_SICHTBEHINDERUNGEN_ZU_ERWARTEN = new AttRdsEreignisCode("Sichtbehinderungen zu erwarten", 		Integer
	.valueOf("1175"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1322_NEBEL = new AttRdsEreignisCode("Nebel", 		Integer
	.valueOf("1322"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1323_SCHNEETREIBEN = new AttRdsEreignisCode("Schneetreiben", 		Integer
	.valueOf("1323"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1309_SICHTBEHINDERUNG_DURCH_RAUCH = new AttRdsEreignisCode("Sichtbehinderung durch Rauch", 		Integer
	.valueOf("1309"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1324_GEFAHR_DURCH_SPRITZWASSER = new AttRdsEreignisCode("Gefahr durch Spritzwasser", 		Integer
	.valueOf("1324"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1325_SICHTBEHINDERUNG_DURCH_TIEFSTEHENDE_SONNE = new AttRdsEreignisCode("Sichtbehinderung durch tiefstehende Sonne", 		Integer
	.valueOf("1325"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1310_SICHTBEHINDERUNG_DURCH_STAUB = new AttRdsEreignisCode("Sichtbehinderung durch Staub", 		Integer
	.valueOf("1310"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1326_SICHTBEHINDERUNG_DURCH_SANDSTURM = new AttRdsEreignisCode("Sichtbehinderung durch Sandsturm", 		Integer
	.valueOf("1326"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1340_SICHTBEHINDERUNG_DURCH_INSEKTENSCHWAERME = new AttRdsEreignisCode("Sichtbehinderung durch Insektenschwärme", 		Integer
	.valueOf("1340"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1301_SICHTBEHINDERUNG_DURCH_DICHTEN_NEBEL = new AttRdsEreignisCode("Sichtbehinderung durch dichten Nebel", 		Integer
	.valueOf("1301"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1177_SICHTBEHINDERUNG_DURCH_DICHTEN_NEBEL_ZU_ERWARTEN = new AttRdsEreignisCode("Sichtbehinderung durch dichten Nebel zu erwarten", 		Integer
	.valueOf("1177"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1304_SICHTBEHINDERUNG_DURCH_NEBEL = new AttRdsEreignisCode("Sichtbehinderung durch Nebel", 		Integer
	.valueOf("1304"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1307_SICHTBEHINDERUNG_DURCH_NEBELBAENKE = new AttRdsEreignisCode("Sichtbehinderung durch Nebelbänke", 		Integer
	.valueOf("1307"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1178_SICHTBEHINDERUNG_DURCH_NEBELBAENKE_ZU_ERWARTEN = new AttRdsEreignisCode("Sichtbehinderung durch Nebelbänke zu erwarten", 		Integer
	.valueOf("1178"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1308_SICHTBEHINDERUNG_DURCH_GEFRIERENDEN_NEBEL = new AttRdsEreignisCode("Sichtbehinderung durch gefrierenden Nebel", 		Integer
	.valueOf("1308"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1337_SICHTBEHINDERUNG_DURCH_GEFRIERENDEN_NEBEL_STRASSENGLAETTE = new AttRdsEreignisCode("Sichtbehinderung durch gefrierenden Nebel, Straßenglätte", 		Integer
	.valueOf("1337"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1176_SICHTBEHINDERUNG_DURCH_GEFRIERENDEN_NEBEL_ZU_ERWARTEN_GEFAHR_VON_STRASSENGLAETTE = new AttRdsEreignisCode("Sichtbehinderung durch gefrierenden Nebel zu erwarten, Gefahr von Straßenglätte", 		Integer
	.valueOf("1176"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1302_DICHTER_NEBEL_SICHTWEITEN_UNTER_30_M = new AttRdsEreignisCode("dichter Nebel, Sichtweiten unter 30 m", 		Integer
	.valueOf("1302"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1303_DICHTER_NEBEL_SICHTWEITEN_UNTER_50_M = new AttRdsEreignisCode("dichter Nebel, Sichtweiten unter 50 m", 		Integer
	.valueOf("1303"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1305_NEBEL_SICHTWEITEN_UNTER_100_M = new AttRdsEreignisCode("Nebel, Sichtweiten unter 100 m", 		Integer
	.valueOf("1305"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1312_SICHTBEHINDERUNG_DURCH_SCHNEEFALL_UND_NEBEL = new AttRdsEreignisCode("Sichtbehinderung durch Schneefall und Nebel", 		Integer
	.valueOf("1312"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1346_NEBELWARNUNG_AUFGEHOBEN = new AttRdsEreignisCode("Nebelwarnung aufgehoben", 		Integer
	.valueOf("1346"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1345_NEBEL_LOEST_SICH_AUF = new AttRdsEreignisCode("Nebel löst sich auf", 		Integer
	.valueOf("1345"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1313_DIE_SICHT_HAT_SICH_VERBESSERT = new AttRdsEreignisCode("die Sicht hat sich verbessert", 		Integer
	.valueOf("1313"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1179_VERBESSERTE_SICHTBEDINGUNGEN_ZU_ERWARTEN = new AttRdsEreignisCode("verbesserte Sichtbedingungen zu erwarten", 		Integer
	.valueOf("1179"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1172_WETTERBESSERUNG_ZU_ERWARTEN = new AttRdsEreignisCode("Wetterbesserung zu erwarten", 		Integer
	.valueOf("1172"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1126_WETTERSITUATION_HAT_SICH_GEBESSERT = new AttRdsEreignisCode("Wettersituation hat sich gebessert", 		Integer
	.valueOf("1126"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1180_SCHLECHTWETTERWARNUNG_AUFGEHOBEN = new AttRdsEreignisCode("Schlechtwetterwarnung aufgehoben", 		Integer
	.valueOf("1180"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1314_MELDUNG_AUFGEHOBEN_NIEDERSCHLAG_UND_SICHTBEHINDERUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Niederschlag und Sichtbehinderungen)", 		Integer
	.valueOf("1314"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1201_WIRBELSTURM = new AttRdsEreignisCode("Wirbelsturm", 		Integer
	.valueOf("1201"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1202_ORKAN = new AttRdsEreignisCode("Orkan", 		Integer
	.valueOf("1202"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1203_ORKANARTIGE_STUERME = new AttRdsEreignisCode("orkanartige Stürme", 		Integer
	.valueOf("1203"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1204_STURM = new AttRdsEreignisCode("Sturm", 		Integer
	.valueOf("1204"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1205_STARKER_WIND = new AttRdsEreignisCode("starker Wind", 		Integer
	.valueOf("1205"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1209_WINDBOEEN = new AttRdsEreignisCode("Windböen", 		Integer
	.valueOf("1209"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1210_SEITENWIND = new AttRdsEreignisCode("Seitenwind", 		Integer
	.valueOf("1210"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1211_STARKER_WIND_BEHINDERUNG_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN = new AttRdsEreignisCode("starker Wind, Behinderung für Fahrzeuge mit hohen Aufbauten", 		Integer
	.valueOf("1211"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1190_STARKER_SMOG = new AttRdsEreignisCode("starker Smog", 		Integer
	.valueOf("1190"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1191_STARKE_LUFTVERSCHMUTZUNG = new AttRdsEreignisCode("starke Luftverschmutzung", 		Integer
	.valueOf("1191"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1217_WIRBELSTURMWARNUNG_AUFGEHOBEN = new AttRdsEreignisCode("Wirbelsturmwarnung aufgehoben", 		Integer
	.valueOf("1217"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1213_STARKE_WINDE_HABEN_NACHGELASSEN = new AttRdsEreignisCode("starke Winde haben nachgelassen", 		Integer
	.valueOf("1213"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1214_MELDUNG_AUFGEHOBEN_WIND_UND_LUFTQUALITAET_ = new AttRdsEreignisCode("Meldung aufgehoben (Wind und Luftqualität)", 		Integer
	.valueOf("1214"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1664_FAHRZEUGKORSO = new AttRdsEreignisCode("Fahrzeugkorso", 		Integer
	.valueOf("1664"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1497_MANOEVER = new AttRdsEreignisCode("Manöver", 		Integer
	.valueOf("1497"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1449_SICHERHEITSUEBUNG = new AttRdsEreignisCode("Sicherheitsübung", 		Integer
	.valueOf("1449"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1501_VERANSTALTUNG = new AttRdsEreignisCode("Veranstaltung", 		Integer
	.valueOf("1501"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1590_MEHRERE_VERANSTALTUNGEN = new AttRdsEreignisCode("mehrere Veranstaltungen", 		Integer
	.valueOf("1590"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1502_SPORTVERANSTALTUNG = new AttRdsEreignisCode("Sportveranstaltung", 		Integer
	.valueOf("1502"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1450_INTERNATIONALE_SPORTVERANSTALTUNG = new AttRdsEreignisCode("internationale Sportveranstaltung", 		Integer
	.valueOf("1450"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1451_SPIEL = new AttRdsEreignisCode("Spiel", 		Integer
	.valueOf("1451"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1452_TURNIER = new AttRdsEreignisCode("Turnier", 		Integer
	.valueOf("1452"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1453_LEICHTATHLETIKVERANSTALTUNG = new AttRdsEreignisCode("Leichtathletikveranstaltung", 		Integer
	.valueOf("1453"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1454_BALLSPIEL = new AttRdsEreignisCode("Ballspiel", 		Integer
	.valueOf("1454"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1455_BOXTURNIER = new AttRdsEreignisCode("Boxturnier", 		Integer
	.valueOf("1455"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1456_STIERKAMPF = new AttRdsEreignisCode("Stierkampf", 		Integer
	.valueOf("1456"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1457_CRICKET_SPIEL = new AttRdsEreignisCode("Cricket-Spiel", 		Integer
	.valueOf("1457"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1458_RADRENNEN = new AttRdsEreignisCode("Radrennen", 		Integer
	.valueOf("1458"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1459_FUSSBALLSPIEL = new AttRdsEreignisCode("Fußballspiel", 		Integer
	.valueOf("1459"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1460_GOLFTURNIER = new AttRdsEreignisCode("Golfturnier", 		Integer
	.valueOf("1460"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1461_MARATHONLAUF = new AttRdsEreignisCode("Marathonlauf", 		Integer
	.valueOf("1461"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1462_PFERDERENNEN = new AttRdsEreignisCode("Pferderennen", 		Integer
	.valueOf("1462"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1463_RUGBYSPIEL = new AttRdsEreignisCode("Rugbyspiel", 		Integer
	.valueOf("1463"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1464_SPRINGREITEN = new AttRdsEreignisCode("Springreiten", 		Integer
	.valueOf("1464"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1465_TENNISTURNIER = new AttRdsEreignisCode("Tennisturnier", 		Integer
	.valueOf("1465"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1466_WASSERSPORTVERANSTALTUNG = new AttRdsEreignisCode("Wassersportveranstaltung", 		Integer
	.valueOf("1466"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1467_WINTERSPORTVERANSTALTUNG = new AttRdsEreignisCode("Wintersportveranstaltung", 		Integer
	.valueOf("1467"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1503_AUFFUEHRUNG = new AttRdsEreignisCode("Aufführung", 		Integer
	.valueOf("1503"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1504_FESTSPIELE = new AttRdsEreignisCode("Festspiele", 		Integer
	.valueOf("1504"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1505_AUSSTELLUNG = new AttRdsEreignisCode("Ausstellung", 		Integer
	.valueOf("1505"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1507_MARKT = new AttRdsEreignisCode("Markt", 		Integer
	.valueOf("1507"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1506_VOLKSFEST = new AttRdsEreignisCode("Volksfest", 		Integer
	.valueOf("1506"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1468_JAHRMARKT = new AttRdsEreignisCode("Jahrmarkt", 		Integer
	.valueOf("1468"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1469_MESSE = new AttRdsEreignisCode("Messe", 		Integer
	.valueOf("1469"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1508_FEIERLICHE_VERANSTALTUNG = new AttRdsEreignisCode("feierliche Veranstaltung", 		Integer
	.valueOf("1508"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1509_STAATSBESUCH = new AttRdsEreignisCode("Staatsbesuch", 		Integer
	.valueOf("1509"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1510_PARADE = new AttRdsEreignisCode("Parade", 		Integer
	.valueOf("1510"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1470_PROZESSION = new AttRdsEreignisCode("Prozession", 		Integer
	.valueOf("1470"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1511_MENSCHENANSAMMLUNG = new AttRdsEreignisCode("Menschenansammlung", 		Integer
	.valueOf("1511"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1475_STREIK = new AttRdsEreignisCode("Streik", 		Integer
	.valueOf("1475"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1512_UMZUG = new AttRdsEreignisCode("Umzug", 		Integer
	.valueOf("1512"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1513_DEMONSTRATION = new AttRdsEreignisCode("Demonstration", 		Integer
	.valueOf("1513"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1514_STOERUNG_DER_OEFFENTLICHEN_SICHERHEIT = new AttRdsEreignisCode("Störung der öffentlichen Sicherheit", 		Integer
	.valueOf("1514"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1591_INFORMATION_UEBER_VERANSTALTUNG_AUFGEHOBEN = new AttRdsEreignisCode("Information über Veranstaltung aufgehoben", 		Integer
	.valueOf("1591"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1493_DIE_DURCH_EINE_SPORTVERANSTALTUNG_BEDINGTE_VERKEHRSBELASTUNG_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("die durch eine Sportveranstaltung bedingte Verkehrsbelastung besteht nicht mehr", 		Integer
	.valueOf("1493"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1496_VERKEHRSBEHINDERUNG_BESEITIGT = new AttRdsEreignisCode("Verkehrsbehinderung beseitigt", 		Integer
	.valueOf("1496"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1592_MOTORSPORTVERANSTALTUNG = new AttRdsEreignisCode("Motorsportveranstaltung", 		Integer
	.valueOf("1592"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1593_BASEBALLSPIEL = new AttRdsEreignisCode("Baseballspiel", 		Integer
	.valueOf("1593"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1594_BASKETBALLSPIEL = new AttRdsEreignisCode("Basketballspiel", 		Integer
	.valueOf("1594"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1595_BOOTSRENNEN = new AttRdsEreignisCode("Bootsrennen", 		Integer
	.valueOf("1595"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1596_KONZERTVERANSTALTUNG = new AttRdsEreignisCode("Konzertveranstaltung", 		Integer
	.valueOf("1596"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1597_HOCKEYSPIEL = new AttRdsEreignisCode("Hockeyspiel", 		Integer
	.valueOf("1597"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1585_MELDUNG_AUFGEHOBEN_VERANSTALTUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Veranstaltungen)", 		Integer
	.valueOf("1585"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1515_SICHERHEITSMASSNAHMEN = new AttRdsEreignisCode("Sicherheitsmaßnahmen", 		Integer
	.valueOf("1515"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1476_SICHERHEITSVORFALL = new AttRdsEreignisCode("Sicherheitsvorfall", 		Integer
	.valueOf("1476"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1477_POLIZEIKONTROLLE = new AttRdsEreignisCode("Polizeikontrolle", 		Integer
	.valueOf("1477"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1516_BOMBENENTSCHAERFUNG = new AttRdsEreignisCode("Bombenentschärfung", 		Integer
	.valueOf("1516"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1478_TERRORANSCHLAG = new AttRdsEreignisCode("Terroranschlag", 		Integer
	.valueOf("1478"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1479_GEFAHR_DURCH_SCHUSSWECHSEL = new AttRdsEreignisCode("Gefahr durch Schusswechsel", 		Integer
	.valueOf("1479"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1480_KATASTROPHENALARM = new AttRdsEreignisCode("Katastrophenalarm", 		Integer
	.valueOf("1480"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1481_GEFAHR_DURCH_LUFTANGRIFF = new AttRdsEreignisCode("Gefahr durch Luftangriff", 		Integer
	.valueOf("1481"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1494_EVAKUIERUNG = new AttRdsEreignisCode("Evakuierung", 		Integer
	.valueOf("1494"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1500_KINDESENTFUEHRUNG = new AttRdsEreignisCode("Kindesentführung", 		Integer
	.valueOf("1500"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1587_LUFTALARM_AUFGEHOBEN = new AttRdsEreignisCode("Luftalarm aufgehoben", 		Integer
	.valueOf("1587"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1492_KEINE_BEEINTRAECHTIGUNGEN_DURCH_SICHERHEITSMASSNAHMEN_MEHR = new AttRdsEreignisCode("keine Beeinträchtigungen durch Sicherheitsmaßnahmen mehr", 		Integer
	.valueOf("1492"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1588_KATASTROPHENALARM_AUFGEHOBEN = new AttRdsEreignisCode("Katastrophenalarm aufgehoben", 		Integer
	.valueOf("1588"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2033_MELDUNG_AUFGEHOBEN_SICHERHEITSVORFAELLE_ = new AttRdsEreignisCode("Meldung aufgehoben (Sicherheitsvorfälle)", 		Integer
	.valueOf("2033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1601_ZEITVERLUST = new AttRdsEreignisCode("Zeitverlust", 		Integer
	.valueOf("1601"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1607_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1607"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1650_ES_KANN_ZU_VERZOEGERUNGEN_KOMMEN = new AttRdsEreignisCode("es kann zu Verzögerungen kommen", 		Integer
	.valueOf("1650"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1621_ZEITVERLUST_BIS_ZU_5_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 5 min", 		Integer
	.valueOf("1621"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1622_ZEITVERLUST_BIS_ZU_10_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 10 min", 		Integer
	.valueOf("1622"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1602_ZEITVERLUST_BIS_ZU_15_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 15 min", 		Integer
	.valueOf("1602"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1623_ZEITVERLUST_BIS_ZU_20_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 20 min", 		Integer
	.valueOf("1623"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1624_ZEITVERLUST_BIS_ZU_25_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 25 min", 		Integer
	.valueOf("1624"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1603_ZEITVERLUST_BIS_ZU_30_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 30 min", 		Integer
	.valueOf("1603"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1625_ZEITVERLUST_BIS_ZU_40_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 40 min", 		Integer
	.valueOf("1625"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1626_ZEITVERLUST_BIS_ZU_50_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 50 min", 		Integer
	.valueOf("1626"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1604_ZEITVERLUST_BIS_ZU_1_STUNDE = new AttRdsEreignisCode("Zeitverlust bis zu 1 Stunde", 		Integer
	.valueOf("1604"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1627_ZEITVERLUST_BIS_ZU_90_MIN = new AttRdsEreignisCode("Zeitverlust bis zu 90 min", 		Integer
	.valueOf("1627"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1605_ZEITVERLUST_BIS_ZU_2_STUNDEN = new AttRdsEreignisCode("Zeitverlust bis zu 2 Stunden", 		Integer
	.valueOf("1605"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1628_ZEITVERLUST_BIS_ZU_3_STUNDEN = new AttRdsEreignisCode("Zeitverlust bis zu 3 Stunden", 		Integer
	.valueOf("1628"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1629_ZEITVERLUST_BIS_ZU_4_STUNDEN = new AttRdsEreignisCode("Zeitverlust bis zu 4 Stunden", 		Integer
	.valueOf("1629"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1630_ZEITVERLUST_BIS_ZU_5_STUNDEN = new AttRdsEreignisCode("Zeitverlust bis zu 5 Stunden", 		Integer
	.valueOf("1630"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1606_ZEITVERLUST_MEHRERE_STUNDEN = new AttRdsEreignisCode("Zeitverlust mehrere Stunden", 		Integer
	.valueOf("1606"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1608_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("großer Zeitverlust", 		Integer
	.valueOf("1608"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1631_SEHR_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("sehr großer Zeitverlust", 		Integer
	.valueOf("1631"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1632_ZEITVERLUST_UNBESTIMMTER_DAUER = new AttRdsEreignisCode("Zeitverlust unbestimmter Dauer", 		Integer
	.valueOf("1632"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_247_UNFALL_ZEITVERLUST = new AttRdsEreignisCode("Unfall, Zeitverlust", 		Integer
	.valueOf("247"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_248_UNFALL_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Unfall, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("248"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_249_UNFALL_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Unfall, großer Zeitverlust", 		Integer
	.valueOf("249"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_200_UNFALL_MIT_MEHREREN_FAHRZEUGEN_ZEITVERLUST = new AttRdsEreignisCode("Unfall mit mehreren Fahrzeugen, Zeitverlust", 		Integer
	.valueOf("200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_275_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige, Zeitverlust", 		Integer
	.valueOf("275"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_276_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("276"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_277_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Neugierige, großer Zeitverlust", 		Integer
	.valueOf("277"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_310_VERLORENE_LADUNG_ZEITVERLUST = new AttRdsEreignisCode("verlorene Ladung, Zeitverlust", 		Integer
	.valueOf("310"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_311_VERLORENE_LADUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("verlorene Ladung, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("311"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_312_VERLORENE_LADUNG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("verlorene Ladung, großer Zeitverlust", 		Integer
	.valueOf("312"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_375_UMGESTUERZTES_FAHRZEUG_ZEITVERLUST = new AttRdsEreignisCode("umgestürztes Fahrzeug, Zeitverlust", 		Integer
	.valueOf("375"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_376_UMGESTUERZTES_FAHRZEUG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("umgestürztes Fahrzeug, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("376"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_377_UMGESTUERZTES_FAHRZEUG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("umgestürztes Fahrzeug, großer Zeitverlust", 		Integer
	.valueOf("377"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_388_VORAUSGEGANGENER_UNFALL_ZEITVERLUST = new AttRdsEreignisCode("vorausgegangener Unfall, Zeitverlust", 		Integer
	.valueOf("388"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_390_VORAUSGEGANGENER_UNFALL_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("vorausgegangener Unfall, großer Zeitverlust", 		Integer
	.valueOf("390"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_330_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, Zeitverlust", 		Integer
	.valueOf("330"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_331_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("331"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_332_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch defektes Fahrzeug, großer Zeitverlust", 		Integer
	.valueOf("332"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_435_GESPERRT_ZEITVERLUST = new AttRdsEreignisCode("gesperrt, Zeitverlust", 		Integer
	.valueOf("435"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_436_GESPERRT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("gesperrt, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("436"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_437_GESPERRT_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("gesperrt, großer Zeitverlust", 		Integer
	.valueOf("437"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_463_BLOCKIERT_ZEITVERLUST = new AttRdsEreignisCode("blockiert, Zeitverlust", 		Integer
	.valueOf("463"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_464_BLOCKIERT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("blockiert, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("464"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_465_BLOCKIERT_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("blockiert, großer Zeitverlust", 		Integer
	.valueOf("465"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_747_BAUSTELLE_ZEITVERLUST = new AttRdsEreignisCode("Baustelle, Zeitverlust", 		Integer
	.valueOf("747"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_748_BAUSTELLE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Baustelle, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("748"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_749_BAUSTELLE_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Baustelle, großer Zeitverlust", 		Integer
	.valueOf("749"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_780_FAHRBAHNERNEUERUNG_ZEITVERLUST = new AttRdsEreignisCode("Fahrbahnerneuerung, Zeitverlust", 		Integer
	.valueOf("780"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_781_FAHRBAHNERNEUERUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Fahrbahnerneuerung, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("781"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_782_FAHRBAHNERNEUERUNG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Fahrbahnerneuerung, großer Zeitverlust", 		Integer
	.valueOf("782"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_840_ARBEITEN_AN_WASSERLEITUNGEN_ZEITVERLUST = new AttRdsEreignisCode("Arbeiten an Wasserleitungen, Zeitverlust", 		Integer
	.valueOf("840"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_841_ARBEITEN_AN_WASSERLEITUNGEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Arbeiten an Wasserleitungen, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("841"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_842_ARBEITEN_AN_WASSERLEITUNGEN_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Arbeiten an Wasserleitungen, großer Zeitverlust", 		Integer
	.valueOf("842"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_843_ARBEITEN_AN_GASLEITUNGEN_ZEITVERLUST = new AttRdsEreignisCode("Arbeiten an Gasleitungen, Zeitverlust", 		Integer
	.valueOf("843"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_844_ARBEITEN_AN_GASLEITUNGEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Arbeiten an Gasleitungen, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("844"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_845_ARBEITEN_AN_GASLEITUNGEN_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Arbeiten an Gasleitungen, großer Zeitverlust", 		Integer
	.valueOf("845"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_846_ARBEITEN_AN_ERDKABELN_ZEITVERLUST = new AttRdsEreignisCode("Arbeiten an Erdkabeln, Zeitverlust", 		Integer
	.valueOf("846"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_847_ARBEITEN_AN_ERDKABELN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Arbeiten an Erdkabeln, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("847"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_848_ARBEITEN_AN_ERDKABELN_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Arbeiten an Erdkabeln, großer Zeitverlust", 		Integer
	.valueOf("848"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_849_TIEFBAUARBEITEN_ZEITVERLUST = new AttRdsEreignisCode("Tiefbauarbeiten Zeitverlust", 		Integer
	.valueOf("849"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_850_TIEFBAUARBEITEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Tiefbauarbeiten, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("850"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_851_TIEFBAUARBEITEN_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Tiefbauarbeiten, großer Zeitverlust", 		Integer
	.valueOf("851"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_939_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Hochwasser, Zeitverlust", 		Integer
	.valueOf("939"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_940_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Hochwasser, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("940"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_941_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Hochwasser, großer Zeitverlust", 		Integer
	.valueOf("941"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1027_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Unterspülung der Fahrbahn, Zeitverlust", 		Integer
	.valueOf("1027"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1028_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Unterspülung der Fahrbahn, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1028"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1029_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Unterspülung der Fahrbahn, großer Zeitverlust", 		Integer
	.valueOf("1029"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_958_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch geplatzte Wasserleitung, Zeitverlust", 		Integer
	.valueOf("958"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_959_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch geplatzte Wasserleitung, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("959"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_960_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch geplatzte Wasserleitung, großer Zeitverlust", 		Integer
	.valueOf("960"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_962_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch ausströmendes Gas, Zeitverlust", 		Integer
	.valueOf("962"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_963_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch ausströmendes Gas, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("963"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_964_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch ausströmendes Gas, großer Zeitverlust", 		Integer
	.valueOf("964"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_966_VERKEHRSBEHINDERUNG_DURCH_FEUER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Feuer, Zeitverlust", 		Integer
	.valueOf("966"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_967_VERKEHRSBEHINDERUNG_DURCH_FEUER_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Verkehrsbehinderung durch Feuer, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("967"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_968_VERKEHRSBEHINDERUNG_DURCH_FEUER_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Verkehrsbehinderung durch Feuer, großer Zeitverlust", 		Integer
	.valueOf("968"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1528_VERANSTALTUNG_ZEITVERLUST = new AttRdsEreignisCode("Veranstaltung, Zeitverlust", 		Integer
	.valueOf("1528"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1529_VERANSTALTUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Veranstaltung, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1529"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1530_VERANSTALTUNG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Veranstaltung, großer Zeitverlust", 		Integer
	.valueOf("1530"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1542_SPORTVERANSTALTUNG_ZEITVERLUST = new AttRdsEreignisCode("Sportveranstaltung, Zeitverlust", 		Integer
	.valueOf("1542"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1543_SPORTVERANSTALTUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Sportveranstaltung, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1543"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1544_SPORTVERANSTALTUNG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Sportveranstaltung, großer Zeitverlust", 		Integer
	.valueOf("1544"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1556_VOLKSFEST_ZEITVERLUST = new AttRdsEreignisCode("Volksfest, Zeitverlust", 		Integer
	.valueOf("1556"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1557_VOLKSFEST_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Volksfest, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1557"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1558_VOLKSFEST_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Volksfest, großer Zeitverlust", 		Integer
	.valueOf("1558"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1560_PARADE_ZEITVERLUST = new AttRdsEreignisCode("Parade, Zeitverlust", 		Integer
	.valueOf("1560"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1561_PARADE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Parade, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1561"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1562_PARADE_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Parade, großer Zeitverlust", 		Integer
	.valueOf("1562"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1564_STREIK_ZEITVERLUST = new AttRdsEreignisCode("Streik, Zeitverlust", 		Integer
	.valueOf("1564"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1565_STREIK_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Streik, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1565"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1566_STREIK_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Streik, großer Zeitverlust", 		Integer
	.valueOf("1566"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1568_DEMONSTRATION_ZEITVERLUST = new AttRdsEreignisCode("Demonstration, Zeitverlust", 		Integer
	.valueOf("1568"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1569_DEMONSTRATION_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Demonstration, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1569"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1570_DEMONSTRATION_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Demonstration, großer Zeitverlust", 		Integer
	.valueOf("1570"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1581_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_ZEITVERLUST = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, Zeitverlust", 		Integer
	.valueOf("1581"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1582_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1582"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1583_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Beeinträchtigung durch Sicherungsmaßnahmen, großer Zeitverlust", 		Integer
	.valueOf("1583"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1486_SICHERHEITSVORFALL_ZEITVERLUST = new AttRdsEreignisCode("Sicherheitsvorfall, Zeitverlust", 		Integer
	.valueOf("1486"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1487_SICHERHEITSVORFALL_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Sicherheitsvorfall, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1487"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1488_SICHERHEITSVORFALL_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Sicherheitsvorfall, großer Zeitverlust", 		Integer
	.valueOf("1488"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1489_POLIZEIKONTROLLE_ZEITVERLUST = new AttRdsEreignisCode("Polizeikontrolle, Zeitverlust", 		Integer
	.valueOf("1489"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1490_POLIZEIKONTROLLE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Polizeikontrolle, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1490"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1491_POLIZEIKONTROLLE_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Polizeikontrolle, großer Zeitverlust", 		Integer
	.valueOf("1491"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1609_ZEITVERLUST_FUER_SCHWERVERKEHR = new AttRdsEreignisCode("Zeitverlust für Schwerverkehr", 		Integer
	.valueOf("1609"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_91_ZEITVERLUST_FUER_PKW = new AttRdsEreignisCode("Zeitverlust für PKW", 		Integer
	.valueOf("91"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1642_ZEITVERLUST_FUER_LKW = new AttRdsEreignisCode("Zeitverlust für LKW", 		Integer
	.valueOf("1642"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1610_ZEITVERLUST_BIS_ZU_15_MIN_FUER_LKW = new AttRdsEreignisCode("Zeitverlust bis zu 15 min für LKW", 		Integer
	.valueOf("1610"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1611_ZEITVERLUST_BIS_ZU_30_MIN_FUER_LKW = new AttRdsEreignisCode("Zeitverlust bis zu 30 min für LKW", 		Integer
	.valueOf("1611"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1612_ZEITVERLUST_BIS_ZU_1_STUNDE_FUER_LKW = new AttRdsEreignisCode("Zeitverlust bis zu 1 Stunde für LKW", 		Integer
	.valueOf("1612"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1613_ZEITVERLUST_BIS_ZU_2_STUNDEN_FUER_LKW = new AttRdsEreignisCode("Zeitverlust bis zu 2 Stunden für LKW", 		Integer
	.valueOf("1613"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1614_ZEITVERLUST_MEHRERE_STUNDEN_FUER_LKW = new AttRdsEreignisCode("Zeitverlust mehrere Stunden für LKW", 		Integer
	.valueOf("1614"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1643_ZEITVERLUST_FUER_BUSSE = new AttRdsEreignisCode("Zeitverlust für Busse", 		Integer
	.valueOf("1643"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1653_ES_IST_MIT_GROSSEM_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("es ist mit großem Zeitverlust zu rechnen", 		Integer
	.valueOf("1653"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1654_ES_IST_MIT_SEHR_GROSSEM_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("es ist mit sehr großem Zeitverlust zu rechnen", 		Integer
	.valueOf("1654"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1757_SCHWERTRANSPORT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Schwertransport, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1757"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1758_SCHWERTRANSPORT_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Schwertransport, großer Zeitverlust", 		Integer
	.valueOf("1758"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1756_SCHWERTRANSPORT_ZEITVERLUST = new AttRdsEreignisCode("Schwertransport, Zeitverlust", 		Integer
	.valueOf("1756"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1740_DICHTER_VERKEHR_DURCH_SCHWERTRANSPORT_ZEITVERLUST = new AttRdsEreignisCode("dichter Verkehr durch Schwertransport, Zeitverlust", 		Integer
	.valueOf("1740"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1759_KOLONNENVERKEHR_ZEITVERLUST = new AttRdsEreignisCode("Kolonnenverkehr, Zeitverlust", 		Integer
	.valueOf("1759"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1760_KOLONNENVERKEHR_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Kolonnenverkehr, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1760"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1761_KOLONNENVERKEHR_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Kolonnenverkehr, großer Zeitverlust", 		Integer
	.valueOf("1761"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1741_DICHTER_VERKEHR_DURCH_FAHRZEUGKOLONNE_ZEITVERLUST = new AttRdsEreignisCode("dichter Verkehr durch Fahrzeugkolonne, Zeitverlust", 		Integer
	.valueOf("1741"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1817_AMPELANLAGEN_AUSSER_BETRIEB_ZEITVERLUST = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, Zeitverlust", 		Integer
	.valueOf("1817"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1818_AMPELANLAGEN_AUSSER_BETRIEB_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1818"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1819_AMPELANLAGEN_AUSSER_BETRIEB_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Ampelanlagen außer Betrieb, großer Zeitverlust", 		Integer
	.valueOf("1819"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1868_AMPELANLAGEN_GESTOERT_ZEITVERLUST = new AttRdsEreignisCode("Ampelanlagen gestört, Zeitverlust", 		Integer
	.valueOf("1868"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1869_AMPELANLAGEN_GESTOERT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Ampelanlagen gestört, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1869"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1870_AMPELANLAGEN_GESTOERT_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Ampelanlagen gestört, großer Zeitverlust", 		Integer
	.valueOf("1870"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1876_PROVISORISCHE_AMPELANLAGE_DEFEKT_ZEITVERLUST = new AttRdsEreignisCode("provisorische Ampelanlage defekt, Zeitverlust", 		Integer
	.valueOf("1876"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1877_PROVISORISCHE_AMPELANLAGE_DEFEKT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("provisorische Ampelanlage defekt, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1877"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1878_PROVISORISCHE_AMPELANLAGE_DEFEKT_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("provisorische Ampelanlage defekt, großer Zeitverlust", 		Integer
	.valueOf("1878"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1880_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS_IST_DER_VERKEHRSABLAUF_GESTOERT_ZEITVERLUST = new AttRdsEreignisCode("wegen Ausfall des Verkehrsrechners ist der Verkehrsablauf gestört, Zeitverlust", 		Integer
	.valueOf("1880"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1884_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS_IST_DER_VERKEHRSABLAUF_GESTOERT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("wegen Ausfall des Verkehrsrechners ist der Verkehrsablauf gestört, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1884"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1885_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS_IST_DER_VERKEHRSABLAUF_GESTOERT_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("wegen Ausfall des Verkehrsrechners ist der Verkehrsablauf gestört, großer Zeitverlust", 		Integer
	.valueOf("1885"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1830_STOERUNG_AM_BAHNUEBERGANG_ZEITVERLUST = new AttRdsEreignisCode("Störung am Bahnübergang, Zeitverlust", 		Integer
	.valueOf("1830"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1831_STOERUNG_AM_BAHNUEBERGANG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN = new AttRdsEreignisCode("Störung am Bahnübergang, es ist mit Zeitverlust zu rechnen", 		Integer
	.valueOf("1831"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1832_STOERUNG_AM_BAHNUEBERGANG_GROSSER_ZEITVERLUST = new AttRdsEreignisCode("Störung am Bahnübergang, großer Zeitverlust", 		Integer
	.valueOf("1832"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1858_SCHNEERAEUMUNG_ZEITVERLUST = new AttRdsEreignisCode("Schneeräumung, Zeitverlust", 		Integer
	.valueOf("1858"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1648_KEIN_ZEITVERLUST_MEHR = new AttRdsEreignisCode("kein Zeitverlust mehr", 		Integer
	.valueOf("1648"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1663_KEIN_ZEITVERLUST_MEHR_ZU_ERWARTEN = new AttRdsEreignisCode("kein Zeitverlust mehr zu erwarten", 		Integer
	.valueOf("1663"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1620_MELDUNG_AUFGEHOBEN_ZEITVERLUSTE_ = new AttRdsEreignisCode("Meldung aufgehoben (Zeitverluste)", 		Integer
	.valueOf("1620"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1634_AUSFAELLE = new AttRdsEreignisCode("Ausfälle", 		Integer
	.valueOf("1634"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1652_ES_IST_MIT_AUSFAELLEN_ZU_RECHNEN = new AttRdsEreignisCode("es ist mit Ausfällen zu rechnen", 		Integer
	.valueOf("1652"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1615_ABFAHRTEN_GESTOPPT = new AttRdsEreignisCode("Abfahrten gestoppt", 		Integer
	.valueOf("1615"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1633_VERKEHR_BIS_AUF_WEITERES_EINGESTELLT = new AttRdsEreignisCode("Verkehr bis auf weiteres eingestellt", 		Integer
	.valueOf("1633"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1616_ABFAHRT_EINGESTELLT = new AttRdsEreignisCode("Abfahrt eingestellt", 		Integer
	.valueOf("1616"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1617_ABFAHRT_AUSGEBUCHT = new AttRdsEreignisCode("Abfahrt ausgebucht", 		Integer
	.valueOf("1617"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1655_ALLE_ABFAHRTEN_AUSGEBUCHT = new AttRdsEreignisCode("alle Abfahrten ausgebucht", 		Integer
	.valueOf("1655"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1906_P_R_IN_BETRIEB = new AttRdsEreignisCode("P+R in Betrieb", 		Integer
	.valueOf("1906"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1635_P_R_NICHT_IN_BETRIEB = new AttRdsEreignisCode("P+R nicht in Betrieb", 		Integer
	.valueOf("1635"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1636_SONDERLINIE_IST_EINGERICHTET = new AttRdsEreignisCode("Sonderlinie ist eingerichtet", 		Integer
	.valueOf("1636"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1637_OEPNV_IST_EINGESTELLT = new AttRdsEreignisCode("ÖPNV ist eingestellt", 		Integer
	.valueOf("1637"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1638_SCHIENENVERKEHR_NICHT_IN_BETRIEB = new AttRdsEreignisCode("Schienenverkehr nicht in Betrieb", 		Integer
	.valueOf("1638"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1720_STOERUNGEN_IM_SCHIENENVERKEHR = new AttRdsEreignisCode("Störungen im Schienenverkehr", 		Integer
	.valueOf("1720"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1657_STOERUNGEN_IM_SCHIENENVERKEHR_ZEITVERLUST = new AttRdsEreignisCode("Störungen im Schienenverkehr, Zeitverlust", 		Integer
	.valueOf("1657"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1658_STOERUNGEN_IM_BUSVERKEHR_ZEITVERLUST = new AttRdsEreignisCode("Störungen im Busverkehr, Zeitverlust", 		Integer
	.valueOf("1658"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1639_BUSVERKEHR_NICHT_IN_BETRIEB = new AttRdsEreignisCode("Busverkehr nicht in Betrieb", 		Integer
	.valueOf("1639"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1649_S_BAHN_NICHT_IN_BETRIEB = new AttRdsEreignisCode("S-Bahn nicht in Betrieb", 		Integer
	.valueOf("1649"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1640_PENDELVERKEHR_IST_EINGERICHTET = new AttRdsEreignisCode("Pendelverkehr ist eingerichtet", 		Integer
	.valueOf("1640"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1641_KOSTENLOSER_PENDELVERKEHR = new AttRdsEreignisCode("kostenloser Pendelverkehr", 		Integer
	.valueOf("1641"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1659_STOERUNGEN_IM_U_BAHN_BETRIEB = new AttRdsEreignisCode("Störungen im U-Bahn-Betrieb", 		Integer
	.valueOf("1659"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1651_U_BAHN_NICHT_IN_BETRIEB = new AttRdsEreignisCode("U-Bahn nicht in Betrieb", 		Integer
	.valueOf("1651"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2021_SERVICE_NICHT_IN_BETRIEB_ERSATZVERKEHR = new AttRdsEreignisCode("Service nicht in Betrieb, Ersatzverkehr", 		Integer
	.valueOf("2021"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2022_AUSFALL_WEGEN_STREIK = new AttRdsEreignisCode("Ausfall wegen Streik", 		Integer
	.valueOf("2022"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1721_OEPNV_AUSSER_BETRIEB = new AttRdsEreignisCode("ÖPNV außer Betrieb", 		Integer
	.valueOf("1721"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1661_FAEHRE_AUSSER_BETRIEB = new AttRdsEreignisCode("Fähre außer Betrieb", 		Integer
	.valueOf("1661"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1618_ABFAHRT_AUSGEBUCHT_FUER_SCHWERVERKEHR = new AttRdsEreignisCode("Abfahrt ausgebucht für Schwerverkehr", 		Integer
	.valueOf("1618"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1644_ABFAHRT_AUSGEBUCHT_FUER_LKW = new AttRdsEreignisCode("Abfahrt ausgebucht für LKW", 		Integer
	.valueOf("1644"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1645_ABFAHRT_AUSGEBUCHT_FUER_BUSSE = new AttRdsEreignisCode("Abfahrt ausgebucht für Busse", 		Integer
	.valueOf("1645"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1660_OEPNV_WIEDER_IN_BETRIEB = new AttRdsEreignisCode("ÖPNV wieder in Betrieb", 		Integer
	.valueOf("1660"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1619_DIE_GEMELDETE_STOERUNG_BESTEHT_NICHT_MEHR_AUSFAELLE_ = new AttRdsEreignisCode("die gemeldete Störung besteht nicht mehr (Ausfälle)", 		Integer
	.valueOf("1619"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2034_MELDUNG_AUFGEHOBEN_AUSFAELLE_ = new AttRdsEreignisCode("Meldung aufgehoben (Ausfälle)", 		Integer
	.valueOf("2034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1662_FAHRTDAUER = new AttRdsEreignisCode("Fahrtdauer", 		Integer
	.valueOf("1662"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1695_AKTUELLE_FAHRTDAUER = new AttRdsEreignisCode("aktuelle Fahrtdauer", 		Integer
	.valueOf("1695"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1696_ERWARTETE_FAHRTDAUER = new AttRdsEreignisCode("erwartete Fahrtdauer", 		Integer
	.valueOf("1696"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1656_NAECHSTE_ANKUNFT = new AttRdsEreignisCode("nächste Ankunft", 		Integer
	.valueOf("1656"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1901_NAECHSTE_ABFAHRT = new AttRdsEreignisCode("nächste Abfahrt", 		Integer
	.valueOf("1901"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1902_NAECHSTE_ABFAHRT_FUER_SCHWERVERKEHR = new AttRdsEreignisCode("nächste Abfahrt für Schwerverkehr", 		Integer
	.valueOf("1902"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1646_NAECHSTE_ABFAHRT_FUER_LKW = new AttRdsEreignisCode("nächste Abfahrt für LKW", 		Integer
	.valueOf("1646"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1647_NAECHSTE_ABFAHRT_FUER_BUSSE = new AttRdsEreignisCode("nächste Abfahrt für Busse", 		Integer
	.valueOf("1647"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2035_MELDUNG_AUFGEHOBEN_REISEINFORMATION_ = new AttRdsEreignisCode("Meldung aufgehoben (Reiseinformation)", 		Integer
	.valueOf("2035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1701_ACHTUNG_IHNEN_KOMMT_EIN_FALSCHFAHRER_ENTGEGEN_NICHT_UEBERHOLEN_VORSICHT_AUF_BEIDEN_RICHTUNGSFAHRBAHNEN_WIR_MELDEN_WENN_DIE_GEFAHR_VORUEBER_IST_ = new AttRdsEreignisCode("Achtung, Ihnen kommt ein Falschfahrer entgegen! Nicht überholen! Vorsicht auf beiden Richtungsfahrbahnen. Wir melden, wenn die Gefahr vorüber ist.", 		Integer
	.valueOf("1701"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1704_GEFAHR_DURCH_RUECKSICHTSLOSE_FAHRER = new AttRdsEreignisCode("Gefahr durch rücksichtslose Fahrer", 		Integer
	.valueOf("1704"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1705_GEFAHR_DURCH_EIN_LANGSAM_FAHRENDES_FAHRZEUG = new AttRdsEreignisCode("Gefahr durch ein langsam fahrendes Fahrzeug", 		Integer
	.valueOf("1705"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1706_RETTUNGSFAHRZEUGE_IM_EINSATZ = new AttRdsEreignisCode("Rettungsfahrzeuge im Einsatz", 		Integer
	.valueOf("1706"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1707_ACHTUNG_SCHNELL_FAHRENDE_RETTUNGSFAHRZEUGE_IM_EINSATZ = new AttRdsEreignisCode("Achtung, schnell fahrende Rettungsfahrzeuge im Einsatz", 		Integer
	.valueOf("1707"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1708_ACHTUNG_GEFAHR_DURCH_VERFOLGUNGSJAGD_ = new AttRdsEreignisCode("Achtung, Gefahr durch Verfolgungsjagd ", 		Integer
	.valueOf("1708"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1710_FAHRZEUG_VERLIERT_LADUNG_GEFAHR = new AttRdsEreignisCode("Fahrzeug verliert Ladung, Gefahr", 		Integer
	.valueOf("1710"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_804_WANDERBAUSTELLE = new AttRdsEreignisCode("Wanderbaustelle", 		Integer
	.valueOf("804"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1765_GEFAHRGUTTRANSPORT = new AttRdsEreignisCode("Gefahrguttransport", 		Integer
	.valueOf("1765"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1736_GEFAEHRDUNG_DURCH_GEFAHRGUTFAHRZEUG = new AttRdsEreignisCode("Gefährdung durch Gefahrgutfahrzeug", 		Integer
	.valueOf("1736"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1768_GEFAHRGUTTRANSPORTE_NAECHSTE_GEEIGNETE_PARKMOEGLICHKEIT_ANFAHREN = new AttRdsEreignisCode("Gefahrguttransporte nächste geeignete Parkmöglichkeit anfahren", 		Integer
	.valueOf("1768"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_681_SCHNEERAEUMUNG = new AttRdsEreignisCode("Schneeräumung", 		Integer
	.valueOf("681"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1711_DIE_GEFAHR_DURCH_RETTUNGSFAHRZEUGE_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("die Gefahr durch Rettungsfahrzeuge besteht nicht mehr", 		Integer
	.valueOf("1711"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1702_DIE_GEFAHR_DURCH_EIN_ENTGEGENKOMMENDES_FAHRZEUG_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("die Gefahr durch ein entgegenkommendes Fahrzeug besteht nicht mehr", 		Integer
	.valueOf("1702"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1769_GEFAEHRDUNG_DURCH_GEFAHRGUTFAHRZEUG_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("Gefährdung durch Gefahrgutfahrzeug besteht nicht mehr", 		Integer
	.valueOf("1769"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_675_STREUFAHRZEUG = new AttRdsEreignisCode("Streufahrzeug", 		Integer
	.valueOf("675"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1703_MELDUNG_AUFGEHOBEN_GEFAEHRLICHE_FAHRZEUGE_ = new AttRdsEreignisCode("Meldung aufgehoben (Gefährliche Fahrzeuge)", 		Integer
	.valueOf("1703"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_347_FAHRZEUG_MIT_UEBERHOEHE = new AttRdsEreignisCode("Fahrzeug mit Überhöhe", 		Integer
	.valueOf("347"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1739_GEFAHR_DURCH_TRANSPORT_MIT_UEBERHOEHE = new AttRdsEreignisCode("Gefahr durch Transport mit Überhöhe", 		Integer
	.valueOf("1739"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1751_SCHWERTRANSPORT = new AttRdsEreignisCode("Schwertransport", 		Integer
	.valueOf("1751"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1731_GEFAHR_DURCH_SCHWERTRANSPORT = new AttRdsEreignisCode("Gefahr durch Schwertransport", 		Integer
	.valueOf("1731"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1752_TRANSPORT_MIT_UEBERBREITE = new AttRdsEreignisCode("Transport mit Überbreite", 		Integer
	.valueOf("1752"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1732_GEFAHR_DURCH_TRANSPORT_MIT_UEBERBREITE = new AttRdsEreignisCode("Gefahr durch Transport mit Überbreite", 		Integer
	.valueOf("1732"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1753_TRANSPORT_MIT_UEBERLAENGE = new AttRdsEreignisCode("Transport mit Überlänge", 		Integer
	.valueOf("1753"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1733_GEFAHR_DURCH_TRANSPORTE_MIT_UEBERLAENGE = new AttRdsEreignisCode("Gefahr durch Transporte mit Überlänge", 		Integer
	.valueOf("1733"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1754_LANGSAMES_FAHRZEUG = new AttRdsEreignisCode("langsames Fahrzeug", 		Integer
	.valueOf("1754"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1734_GEFAHR_DURCH_LANGSAMES_FAHRZEUG = new AttRdsEreignisCode("Gefahr durch langsames Fahrzeug", 		Integer
	.valueOf("1734"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1764_KETTENFAHRZEUG = new AttRdsEreignisCode("Kettenfahrzeug", 		Integer
	.valueOf("1764"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1735_GEFAHR_DURCH_KETTENFAHRZEUG = new AttRdsEreignisCode("Gefahr durch Kettenfahrzeug", 		Integer
	.valueOf("1735"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1767_SCHWERTRANSPORT_UEBERHOLEN_NICHT_MOEGLICH = new AttRdsEreignisCode("Schwertransport, Überholen nicht möglich", 		Integer
	.valueOf("1767"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1755_KOLONNENVERKEHR = new AttRdsEreignisCode("Kolonnenverkehr", 		Integer
	.valueOf("1755"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1737_GEFAHR_DURCH_KOLONNENVERKEHR = new AttRdsEreignisCode("Gefahr durch Kolonnenverkehr", 		Integer
	.valueOf("1737"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1766_MILITAERKOLONNEN = new AttRdsEreignisCode("Militärkolonnen", 		Integer
	.valueOf("1766"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1738_GEFAHR_DURCH_MILITAERKOLONNEN = new AttRdsEreignisCode("Gefahr durch Militärkolonnen", 		Integer
	.valueOf("1738"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1770_KOLONNENVERKEHR_AUFGELOEST = new AttRdsEreignisCode("Kolonnenverkehr aufgelöst", 		Integer
	.valueOf("1770"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1762_VERKEHRSSTOERUNG_BESEITIGT = new AttRdsEreignisCode("Verkehrsstörung beseitigt", 		Integer
	.valueOf("1762"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1763_MELDUNG_AUFGEHOBEN_AUSSERGEWOEHNLICHE_LADUNGEN_UND_FAHRZEUGE_ = new AttRdsEreignisCode("Meldung aufgehoben (Außergewöhnliche Ladungen und Fahrzeuge)", 		Integer
	.valueOf("1763"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1801_SPURWECHSELANLAGEN_AUSSER_BETRIEB = new AttRdsEreignisCode("Spurwechselanlagen außer Betrieb", 		Integer
	.valueOf("1801"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1838_SPURWECHSELANLAGEN_DEFEKT = new AttRdsEreignisCode("Spurwechselanlagen defekt", 		Integer
	.valueOf("1838"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1839_SPURWECHSELANLAGEN_IN_BETRIEB = new AttRdsEreignisCode("Spurwechselanlagen in Betrieb", 		Integer
	.valueOf("1839"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1840_WECHSELVERKEHRSZEICHEN_AUSSER_BETRIEB = new AttRdsEreignisCode("Wechselverkehrszeichen außer Betrieb", 		Integer
	.valueOf("1840"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1841_WECHSELVERKEHRSZEICHEN_ARBEITEN_FEHLERHAFT = new AttRdsEreignisCode("Wechselverkehrszeichen arbeiten fehlerhaft", 		Integer
	.valueOf("1841"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1842_WECHSELVERKEHRSZEICHEN_WIEDER_IN_BETRIEB = new AttRdsEreignisCode("Wechselverkehrszeichen wieder in Betrieb", 		Integer
	.valueOf("1842"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1802_NOTRUFSAEULEN_AUSGEFALLEN = new AttRdsEreignisCode("Notrufsäulen ausgefallen", 		Integer
	.valueOf("1802"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1803_NOTRUF_AUSGEFALLEN = new AttRdsEreignisCode("Notruf ausgefallen", 		Integer
	.valueOf("1803"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1865_NOTRUFSAEULEN_AUSGEFALLEN_POLIZEI_FAEHRT_VERSTAERKT_STREIFE = new AttRdsEreignisCode("Notrufsäulen ausgefallen, Polizei fährt verstärkt Streife", 		Integer
	.valueOf("1865"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1866_NOTRUFSAEULEN_AUSGEFALLEN_WARTEN_SIE_IM_NOTFALL_AUF_DIE_POLIZEI = new AttRdsEreignisCode("Notrufsäulen ausgefallen, warten Sie im Notfall auf die Polizei", 		Integer
	.valueOf("1866"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1804_AMPELANLAGE_AUSSER_BETRIEB = new AttRdsEreignisCode("Ampelanlage außer Betrieb", 		Integer
	.valueOf("1804"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1805_AMPELANLAGE_ARBEITET_FEHLERHAFT = new AttRdsEreignisCode("Ampelanlage arbeitet fehlerhaft", 		Integer
	.valueOf("1805"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1843_ZUFAHRTSREGELUNG_AUSSER_BETRIEB = new AttRdsEreignisCode("Zufahrtsregelung außer Betrieb", 		Integer
	.valueOf("1843"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1844_ZUFAHRTSREGELUNG_ARBEITET_FEHLERHAFT = new AttRdsEreignisCode("Zufahrtsregelung arbeitet fehlerhaft", 		Integer
	.valueOf("1844"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1845_PROVISORISCHE_AMPELANLAGE_DEFEKT = new AttRdsEreignisCode("provisorische Ampelanlage defekt", 		Integer
	.valueOf("1845"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1846_PROVISORISCHE_AMPELANLAGE_ARBEITET_FEHLERHAFT = new AttRdsEreignisCode("provisorische Ampelanlage arbeitet fehlerhaft", 		Integer
	.valueOf("1846"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1850_SPURWECHSELANLAGEN_AUSSER_BETRIEB_GEFAHR = new AttRdsEreignisCode("Spurwechselanlagen außer Betrieb, Gefahr", 		Integer
	.valueOf("1850"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1864_SPURWECHSELANLAGEN_ARBEITEN_FEHLERHAFT_GEFAHR = new AttRdsEreignisCode("Spurwechselanlagen arbeiten fehlerhaft, Gefahr", 		Integer
	.valueOf("1864"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1867_AMPELANLAGE_AUSSER_BETRIEB_GEFAHR = new AttRdsEreignisCode("Ampelanlage außer Betrieb, Gefahr", 		Integer
	.valueOf("1867"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1875_GEFAHR_DURCH_FEHLERHAFT_ARBEITENDE_AMPELANLAGE = new AttRdsEreignisCode("Gefahr durch fehlerhaft arbeitende Ampelanlage", 		Integer
	.valueOf("1875"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1879_GEFAHR_DURCH_DEFEKTE_PROVISORISCHE_AMPELANLAGE_ = new AttRdsEreignisCode("Gefahr durch defekte provisorische Ampelanlage ", 		Integer
	.valueOf("1879"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1847_STOERUNG_DES_VERKEHRSABLAUFES_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS = new AttRdsEreignisCode("Störung des Verkehrsablaufes wegen Ausfall des Verkehrsrechners", 		Integer
	.valueOf("1847"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1848_STEUERUNG_DER_AMPELANLAGE_GEAENDERT = new AttRdsEreignisCode("Steuerung der Ampelanlage geändert", 		Integer
	.valueOf("1848"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1806_STOERUNG_AM_BAHNUEBERGANG = new AttRdsEreignisCode("Störung am Bahnübergang", 		Integer
	.valueOf("1806"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1849_TUNNELBELUEFTUNG_AUSGEFALLEN = new AttRdsEreignisCode("Tunnelbelüftung ausgefallen", 		Integer
	.valueOf("1849"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1833_VERKEHRSSTEUERUNG_WIEDER_IN_BETRIEB = new AttRdsEreignisCode("Verkehrssteuerung wieder in Betrieb", 		Integer
	.valueOf("1833"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1834_NOTRUFSAEULE_WIEDER_IN_BETRIEB = new AttRdsEreignisCode("Notrufsäule wieder in Betrieb", 		Integer
	.valueOf("1834"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1835_AMPELANLAGEN_WIEDER_IN_BETRIEB = new AttRdsEreignisCode("Ampelanlagen wieder in Betrieb", 		Integer
	.valueOf("1835"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1836_STOERUNG_AM_BAHNUEBERGANG_BESEITIGT = new AttRdsEreignisCode("Störung am Bahnübergang beseitigt", 		Integer
	.valueOf("1836"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1983_STROMAUSFALL = new AttRdsEreignisCode("Stromausfall", 		Integer
	.valueOf("1983"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1837_MELDUNG_AUFGEHOBEN_STOERUNGEN_AN_LICHTSIGNALANLAGEN_UND_SONSTIGEN_STRASSENAUSRUESTUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Störungen an Lichtsignalanlagen und sonstigen Straßenausrüstungen)", 		Integer
	.valueOf("1837"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1917_AUTOMATISCHES_MAUTSYSTEM_AUSSER_BETRIEB_BITTE_MANUELL_ZAHLEN = new AttRdsEreignisCode("automatisches Mautsystem außer Betrieb, bitte manuell zahlen", 		Integer
	.valueOf("1917"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1851_VORUEBERGEHENDE_BEGRENZUNG_DER_BREITE = new AttRdsEreignisCode("vorübergehende Begrenzung der Breite", 		Integer
	.valueOf("1851"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1861_VORUEBERGEHENDE_BESCHRAENKUNG_DER_HOEHE = new AttRdsEreignisCode("vorübergehende Beschränkung der Höhe", 		Integer
	.valueOf("1861"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1881_VORUEBERGEHENDE_BESCHRAENKUNG_DER_LAENGE = new AttRdsEreignisCode("vorübergehende Beschränkung der Länge", 		Integer
	.valueOf("1881"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1871_VORUEBERGEHENDE_BESCHRAENKUNG_DER_ACHSLAST = new AttRdsEreignisCode("vorübergehende Beschränkung der Achslast", 		Integer
	.valueOf("1871"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1872_VORUEBERGEHENDE_BESCHRAENKUNG_DES_ZULAESSIGEN_GESAMTGEWICHTS = new AttRdsEreignisCode("vorübergehende Beschränkung des zulässigen Gesamtgewichts", 		Integer
	.valueOf("1872"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1852_VORUEBERGEHENDE_BEGRENZUNG_DER_BREITE_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("vorübergehende Begrenzung der Breite besteht nicht mehr", 		Integer
	.valueOf("1852"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1862_VORUEBERGEHENDE_BESCHRAENKUNG_DER_HOEHE_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("vorübergehende Beschränkung der Höhe besteht nicht mehr", 		Integer
	.valueOf("1862"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1882_VORUEBERGEHENDE_BESCHRAENKUNG_DER_LAENGE_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("vorübergehende Beschränkung der Länge besteht nicht mehr", 		Integer
	.valueOf("1882"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1874_VORUEBERGEHENDE_BESCHRAENKUNG_DER_ACHSLAST_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("vorübergehende Beschränkung der Achslast besteht nicht mehr", 		Integer
	.valueOf("1874"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1873_VORUEBERGEHENDE_BESCHRAENKUNG_DES_ZULAESSIGEN_GESAMTGEWICHTS_BESTEHT_NICHT_MEHR = new AttRdsEreignisCode("vorübergehende Beschränkung des zulässigen Gesamtgewichts besteht nicht mehr", 		Integer
	.valueOf("1873"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1857_MELDUNG_AUFGEHOBEN_BESCHRAENKUNGEN_DER_FAHRZEUGMASSE_UND_GEWICHTE_ = new AttRdsEreignisCode("Meldung aufgehoben (Beschränkungen der Fahrzeugmaße und -gewichte)", 		Integer
	.valueOf("1857"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1886_NORMALE_PARKREGELUNG_AUFGEHOBEN = new AttRdsEreignisCode("normale Parkregelung aufgehoben", 		Integer
	.valueOf("1886"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1887_BESONDERE_PARKREGELUNG_IN_KRAFT = new AttRdsEreignisCode("besondere  Parkregelung in Kraft", 		Integer
	.valueOf("1887"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1927_PARKVERBOT = new AttRdsEreignisCode("Parkverbot", 		Integer
	.valueOf("1927"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1928_BESONDERE_PARKREGELUNG_AUFGEHOBEN = new AttRdsEreignisCode("besondere Parkregelung aufgehoben", 		Integer
	.valueOf("1928"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1883_MELDUNG_AUFGEHOBEN_PARKREGELUNGEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Parkregelungen)", 		Integer
	.valueOf("1883"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1903_PARKPLATZ_BESETZT = new AttRdsEreignisCode("Parkplatz besetzt", 		Integer
	.valueOf("1903"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1922_PARKPLATZ_WEITGEHEND_BESETZT = new AttRdsEreignisCode("Parkplatz weitgehend besetzt", 		Integer
	.valueOf("1922"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1888_ZU_10_BESETZT = new AttRdsEreignisCode("zu 10%  besetzt", 		Integer
	.valueOf("1888"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1889_ZU_20_BESETZT = new AttRdsEreignisCode("zu 20%  besetzt", 		Integer
	.valueOf("1889"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1890_ZU_30_BESETZT = new AttRdsEreignisCode("zu 30%  besetzt", 		Integer
	.valueOf("1890"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1891_ZU_40_BESETZT = new AttRdsEreignisCode("zu 40%  besetzt", 		Integer
	.valueOf("1891"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1892_ZU_50_BESETZT = new AttRdsEreignisCode("zu 50%  besetzt", 		Integer
	.valueOf("1892"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1893_ZU_60_BESETZT = new AttRdsEreignisCode("zu 60%  besetzt", 		Integer
	.valueOf("1893"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1894_ZU_70_BESETZT = new AttRdsEreignisCode("zu 70%  besetzt", 		Integer
	.valueOf("1894"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1895_ZU_80_BESETZT = new AttRdsEreignisCode("zu 80%  besetzt", 		Integer
	.valueOf("1895"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1896_ZU_90_BESETZT = new AttRdsEreignisCode("zu 90%  besetzt", 		Integer
	.valueOf("1896"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1918_BESETZT = new AttRdsEreignisCode("besetzt", 		Integer
	.valueOf("1918"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1904_ALLE_PARKPLAETZE_BESETZT = new AttRdsEreignisCode("alle Parkplätze besetzt", 		Integer
	.valueOf("1904"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1924_ALLE_PARKHAEUSER_BESETZT = new AttRdsEreignisCode("alle Parkhäuser besetzt", 		Integer
	.valueOf("1924"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1905_SEHR_WENIGE_STELLPLAETZE_FREI = new AttRdsEreignisCode("sehr wenige Stellplätze frei", 		Integer
	.valueOf("1905"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1926_KEINE_STELLPLAETZE_MEHR_FREI = new AttRdsEreignisCode("keine Stellplätze mehr frei", 		Integer
	.valueOf("1926"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1923_ALLE_STELLPLAETZE_WEITGEHEND_BESETZT = new AttRdsEreignisCode("alle Stellplätze weitgehend besetzt", 		Integer
	.valueOf("1923"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1920_NUR_WENIGE_STELLPLAETZE_FREI = new AttRdsEreignisCode("nur wenige Stellplätze frei", 		Integer
	.valueOf("1920"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1921_STELLPLAETZE_FREI = new AttRdsEreignisCode("Stellplätze frei", 		Integer
	.valueOf("1921"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1897_WENIGER_ALS_10_STELLPLAETZE_FREI = new AttRdsEreignisCode("weniger als 10 Stellplätze frei", 		Integer
	.valueOf("1897"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1898_WENIGER_ALS_20_STELLPLAETZE_FREI = new AttRdsEreignisCode("weniger als 20 Stellplätze frei", 		Integer
	.valueOf("1898"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1899_WENIGER_ALS_30_STELLPLAETZE_FREI = new AttRdsEreignisCode("weniger als 30 Stellplätze frei", 		Integer
	.valueOf("1899"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1900_WENIGER_ALS_40_STELLPLAETZE_FREI = new AttRdsEreignisCode("weniger als 40 Stellplätze frei", 		Integer
	.valueOf("1900"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1855_WENIGER_ALS_50_STELLPLAETZE_FREI = new AttRdsEreignisCode("weniger als 50 Stellplätze frei", 		Integer
	.valueOf("1855"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1925_STOERUNGSFREIER_P_R_BETRIEB = new AttRdsEreignisCode("störungsfreier P+R-Betrieb", 		Integer
	.valueOf("1925"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1934_KEINE_INFORMATIONEN_UEBER_P_R_VERFUEGBAR = new AttRdsEreignisCode("keine Informationen über P+R verfügbar", 		Integer
	.valueOf("1934"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1990_PARKPLATZ_GESCHLOSSEN_ = new AttRdsEreignisCode("Parkplatz geschlossen ", 		Integer
	.valueOf("1990"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1938_INFORMATIONEN_UEBER_P_R_WIEDER_VERFUEGBAR = new AttRdsEreignisCode("Informationen über P+R wieder verfügbar", 		Integer
	.valueOf("1938"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1856_KEINE_PARKINFORMATIONEN_VERFUEGBAR = new AttRdsEreignisCode("keine Parkinformationen verfügbar", 		Integer
	.valueOf("1856"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2038_MELDUNG_AUFGEHOBEN_PARKEN_ = new AttRdsEreignisCode("Meldung aufgehoben (Parken)", 		Integer
	.valueOf("2038"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1913_BITTE_RADIOPROGRAMM_EINSCHALTEN = new AttRdsEreignisCode("bitte Radioprogramm einschalten", 		Integer
	.valueOf("1913"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1908_BITTE_RADIOPROGRAMM_EINSCHALTEN_INFORMATION_ = new AttRdsEreignisCode("bitte Radioprogramm einschalten (Information)", 		Integer
	.valueOf("1908"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1929_WICHTIGE_INFORMATIONEN_WERDEN_IM_GESPROCHENEN_PROGRAMM_VERLESEN = new AttRdsEreignisCode("wichtige Informationen werden im gesprochenen Programm verlesen", 		Integer
	.valueOf("1929"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1931_GENAUE_INFORMATIONEN_WERDEN_IM_GESPROCHENEN_PROGRAMM_VERLESEN = new AttRdsEreignisCode("genaue Informationen werden im gesprochenen Programm verlesen", 		Integer
	.valueOf("1931"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1909_ALARMMELDUNG_AUF_DIESER_FREQUENZ = new AttRdsEreignisCode("Alarmmeldung auf dieser Frequenz", 		Integer
	.valueOf("1909"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1910_NEUE_ALARMMELDUNG_INNERHALB_DER_FESTGESETZTEN_ZEITEN = new AttRdsEreignisCode("neue Alarmmeldung innerhalb der festgesetzten Zeiten", 		Integer
	.valueOf("1910"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1955_HINWEIS_AUF_DAS_HOERFUNKPROGRAMM_NICHT_MEHR_GUELTIG = new AttRdsEreignisCode("Hinweis auf das Hörfunkprogramm nicht mehr gültig", 		Integer
	.valueOf("1955"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1911_MELDUNG_AUFGEHOBEN_INFORMATION_ = new AttRdsEreignisCode("Meldung aufgehoben (Information)", 		Integer
	.valueOf("1911"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1940_ZUSAETZLICHE_REGIONALE_INFORMATIONEN_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR = new AttRdsEreignisCode("zusätzliche regionale Informationen bei einem anderen TMC-Service verfügbar", 		Integer
	.valueOf("1940"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1941_ZUSAETZLICHE_LOKALE_INFORMATIONEN_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR = new AttRdsEreignisCode("zusätzliche lokale Informationen bei einem anderen TMC-Service verfügbar", 		Integer
	.valueOf("1941"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1942_ZUSAETZLICHE_INFORMATIONEN_UEBER_OEPNV_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR = new AttRdsEreignisCode("zusätzliche Informationen über ÖPNV bei einem anderen TMC-Service verfügbar", 		Integer
	.valueOf("1942"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1943_NATIONALE_INFORMATIONEN_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR = new AttRdsEreignisCode("nationale Informationen bei einem anderen TMC-Service verfügbar", 		Integer
	.valueOf("1943"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1944_DIESER_SERVICE_BIETET_NUR_UEBERREGIONALE_INFORMATIONEN = new AttRdsEreignisCode("dieser Service bietet nur überregionale Informationen", 		Integer
	.valueOf("1944"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1945_DIESER_SERVICE_BIETET_NUR_REGIONALE_INFORMATIONEN = new AttRdsEreignisCode("dieser Service bietet nur regionale Informationen", 		Integer
	.valueOf("1945"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1946_DIESER_SERVICE_BIETET_NUR_LOKALE_INFORMATIONEN = new AttRdsEreignisCode("dieser Service bietet nur lokale Informationen", 		Integer
	.valueOf("1946"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1947_DIESER_SERVICE_BIETET_KEINE_DETAILLIERTE_REGIONALE_INFORMATIONEN = new AttRdsEreignisCode("dieser Service bietet keine detaillierte regionale Informationen", 		Integer
	.valueOf("1947"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1948_DIESER_SERVICE_BIETET_KEINE_DETAILLIERTE_LOKALEN_INFORMATIONEN = new AttRdsEreignisCode("dieser Service bietet keine detaillierte lokalen Informationen", 		Integer
	.valueOf("1948"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1932_DETAILINFORMATIONEN_BEI_EINEM_ANDEREM_TMC_SERVICE_VERFUEGBAR = new AttRdsEreignisCode("Detailinformationen bei einem anderem TMC-Service verfügbar", 		Integer
	.valueOf("1932"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1949_DIESER_SERVICE_BIETET_KEINE_GRENZUEBERSCHREITENDEN_INFORMATIONEN = new AttRdsEreignisCode("dieser Service bietet keine grenzüberschreitenden Informationen", 		Integer
	.valueOf("1949"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1950_INFORMATIONEN_NUR_FUER_DIESES_GEBIET = new AttRdsEreignisCode("Informationen nur für dieses Gebiet", 		Integer
	.valueOf("1950"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1951_KEINE_NEUEN_VERKEHRSINFORMATIONEN_VERFUEGBAR = new AttRdsEreignisCode("keine neuen Verkehrsinformationen verfügbar", 		Integer
	.valueOf("1951"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1952_KEINE_OEPNV_INFORMATIONEN_VERFUEGBAR = new AttRdsEreignisCode("keine ÖPNV-Informationen verfügbar", 		Integer
	.valueOf("1952"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1953_TMC_AUSSENDUNG_AUF_DIESER_FREQUENZ_WIRD_BEENDET = new AttRdsEreignisCode("TMC-Aussendung auf dieser Frequenz wird beendet", 		Integer
	.valueOf("1953"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1954_AKTUELLER_TMC_DIENST_WIRD_WIEDER_AUFGENOMMEN = new AttRdsEreignisCode("aktueller TMC-Dienst wird wieder aufgenommen", 		Integer
	.valueOf("1954"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1930_KEIN_TMC_SERVICE = new AttRdsEreignisCode("kein TMC-Service", 		Integer
	.valueOf("1930"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1914_KEINE_INFORMATION = new AttRdsEreignisCode("keine Information", 		Integer
	.valueOf("1914"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1916_WEGEN_TECHNISCHER_PROBLEME_KEINE_INFORMATION = new AttRdsEreignisCode("wegen technischer Probleme keine Information", 		Integer
	.valueOf("1916"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1939_TELEFONSERVICE_MIT_REISEINFORMATIONEN_VERFUEGBAR = new AttRdsEreignisCode("Telefonservice mit Reiseinformationen verfügbar", 		Integer
	.valueOf("1939"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1956_HINWEISE_AUF_ANDERE_TMC_DIENSTE_NICHT_MEHR_GUELTIG = new AttRdsEreignisCode("Hinweise auf andere TMC-Dienste nicht mehr gültig", 		Integer
	.valueOf("1956"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1957_FRUEHERE_AUSSAGEN_UEBER_DIESEN_ODER_ANDERE_TMC_DIENSTE_SIND_NICHT_MEHR_GUELTIG = new AttRdsEreignisCode("frühere Aussagen über diesen oder andere TMC-Dienste sind nicht mehr gültig", 		Integer
	.valueOf("1957"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1964_BAHNAUSKUNFT_NICHT_VERFUEGBAR = new AttRdsEreignisCode("Bahnauskunft nicht verfügbar", 		Integer
	.valueOf("1964"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1965_BAHNAUSKUNFT_WIEDER_VERFUEGBAR = new AttRdsEreignisCode("Bahnauskunft wieder verfügbar", 		Integer
	.valueOf("1965"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1966_NAHVERKEHRSINFORMATIONEN_NICHT_VERFUEGBAR = new AttRdsEreignisCode("Nahverkehrsinformationen nicht verfügbar", 		Integer
	.valueOf("1966"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1967_NAHVERKEHRSINFORMATIONEN_WIEDER_VERFUEGBAR = new AttRdsEreignisCode("Nahverkehrsinformationen wieder verfügbar", 		Integer
	.valueOf("1967"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2039_MELDUNG_AUFGEHOBEN_SERVICE_MELDUNG_ = new AttRdsEreignisCode("Meldung aufgehoben (Service-Meldung)", 		Integer
	.valueOf("2039"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1915_TESTMELDUNG = new AttRdsEreignisCode("Testmeldung", 		Integer
	.valueOf("1915"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_1907_NULL_MELDUNG = new AttRdsEreignisCode("Null-Meldung", 		Integer
	.valueOf("1907"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2047_NULL_MELDUNG_SPEZIELLE_MELDUNG_ = new AttRdsEreignisCode("Null-Meldung (spezielle Meldung)", 		Integer
	.valueOf("2047"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2041_ES_LIEGEN_KEINE_MELDUNGEN_VOR = new AttRdsEreignisCode("es liegen keine Meldungen vor", 		Integer
	.valueOf("2041"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsEreignisCode ZUSTAND_2040_MELDUNG_AUFGEHOBEN_SPEZIELLE_MELDUNG_ = new AttRdsEreignisCode("Meldung aufgehoben (spezielle Meldung)", 		Integer
	.valueOf("2040"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsEreignisCode getZustand(final 		Integer
	 value) {
		for (AttRdsEreignisCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsEreignisCode getZustand(final String value) {
		for (AttRdsEreignisCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsEreignisCode> getZustaende() {
		List<AttRdsEreignisCode> list = new ArrayList<AttRdsEreignisCode>();
		list.add(ZUSTAND_0_NICHT_DEFINIERT);
		list.add(ZUSTAND_1_VERKEHRSBEHINDERUNG);
		list.add(ZUSTAND_101__L_STAU);
		list.add(ZUSTAND_102__1_KM_STAU);
		list.add(ZUSTAND_103__2_KM_STAU);
		list.add(ZUSTAND_129__3_KM_STAU);
		list.add(ZUSTAND_104__4_KM_STAU);
		list.add(ZUSTAND_105__6_KM_STAU);
		list.add(ZUSTAND_106__10_KM_STAU);
		list.add(ZUSTAND_130_STAUGEFAHR);
		list.add(ZUSTAND_108__L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_109__1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_110__2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_131__3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_111__4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_112__6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_113__10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_132_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_133_LANGE_STAUS);
		list.add(ZUSTAND_115__L_DICHTER_VERKEHR);
		list.add(ZUSTAND_116__1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_117__2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_134__3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_118__4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_119__6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_120__10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_122__L_REGER_VERKEHR);
		list.add(ZUSTAND_142_DICHTERER_VERKEHR_ALS_NORMAL);
		list.add(ZUSTAND_143_SEHR_VIEL_DICHTERER_VERKEHR_ALS_NORMAL);
		list.add(ZUSTAND_124_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_125__L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_135__L_DICHTER_VERKEHR_MIT_ABNEHMENDER_TENDENZ);
		list.add(ZUSTAND_136_VERKEHRSSTOERUNG);
		list.add(ZUSTAND_70_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_10_KM_H);
		list.add(ZUSTAND_71_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_20_KM_H);
		list.add(ZUSTAND_72_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_30_KM_H);
		list.add(ZUSTAND_73_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_40_KM_H);
		list.add(ZUSTAND_74_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_50_KM_H);
		list.add(ZUSTAND_75_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_60_KM_H);
		list.add(ZUSTAND_76_VERKEHRSSTOERUNG_MITTLERE_GESCHWINDIGKEIT_70_KM_H);
		list.add(ZUSTAND_137__L_SCHWACHER_VERKEHR);
		list.add(ZUSTAND_138__L_STOCKENDER_VERKEHR_VORSICHTIG_AN_DAS_STAUENDE_HERANFAHREN);
		list.add(ZUSTAND_139__L_STOCKENDER_VERKEHR_STAUENDE_LIEGT_IM_KURVENBEREICH);
		list.add(ZUSTAND_140__L_STOCKENDER_VERKEHR_STAUENDE_LIEGT_HINTER_EINER_KUPPE);
		list.add(ZUSTAND_2__L_STOCKENDER_VERKEHR_STAUGEFAHR);
		list.add(ZUSTAND_215_UNFALL_L_STAU);
		list.add(ZUSTAND_216_UNFALL_1_KM_STAU);
		list.add(ZUSTAND_217_UNFALL_2_KM_STAU);
		list.add(ZUSTAND_348_UNFALL_3_KM_STAU);
		list.add(ZUSTAND_218_UNFALL_4_KM_STAU);
		list.add(ZUSTAND_219_UNFALL_6_KM_STAU);
		list.add(ZUSTAND_220_UNFALL_10_KM_STAU);
		list.add(ZUSTAND_221_UNFALL_STAUGEFAHR);
		list.add(ZUSTAND_222_UNFALL_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_223_UNFALL_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_224_UNFALL_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_349_UNFALL_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_225_UNFALL_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_226_UNFALL_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_227_UNFALL_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_228_UNFALL_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_229_UNFALL_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_230_UNFALL_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_231_UNFALL_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_350_UNFALL_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_232_UNFALL_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_233_UNFALL_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_234_UNFALL_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_236_UNFALL_L_REGER_VERKEHR);
		list.add(ZUSTAND_238_UNFALL_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_239_UNFALL_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_250_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_STAU);
		list.add(ZUSTAND_251_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_1_KM_STAU);
		list.add(ZUSTAND_252_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_2_KM_STAU);
		list.add(ZUSTAND_352_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_3_KM_STAU);
		list.add(ZUSTAND_253_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_4_KM_STAU);
		list.add(ZUSTAND_254_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_6_KM_STAU);
		list.add(ZUSTAND_255_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_10_KM_STAU);
		list.add(ZUSTAND_256_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_STAUGEFAHR);
		list.add(ZUSTAND_257_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_258_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_259_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_353_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_260_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_261_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_262_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_263_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_208_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE);
		list.add(ZUSTAND_264_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_265_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_266_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_354_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_267_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_268_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_269_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_271_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_REGER_VERKEHR);
		list.add(ZUSTAND_274_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_355_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_GEFAHR);
		list.add(ZUSTAND_278_VERLORENE_LADUNG_L_STAU);
		list.add(ZUSTAND_279_VERLORENE_LADUNG_1_KM_STAU);
		list.add(ZUSTAND_280_VERLORENE_LADUNG_2_KM_STAU);
		list.add(ZUSTAND_356_VERLORENE_LADUNG_3_KM_STAU);
		list.add(ZUSTAND_281_VERLORENE_LADUNG_4_KM_STAU);
		list.add(ZUSTAND_282_VERLORENE_LADUNG_6_KM_STAU);
		list.add(ZUSTAND_283_VERLORENE_LADUNG_10_KM_STAU);
		list.add(ZUSTAND_284_VERLORENE_LADUNG_STAUGEFAHR);
		list.add(ZUSTAND_285_VERLORENE_LADUNG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_286_VERLORENE_LADUNG_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_287_VERLORENE_LADUNG_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_357_VERLORENE_LADUNG_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_288_VERLORENE_LADUNG_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_289_VERLORENE_LADUNG_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_290_VERLORENE_LADUNG_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_291_VERLORENE_LADUNG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_292_VERLORENE_LADUNG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_293_VERLORENE_LADUNG_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_294_VERLORENE_LADUNG_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_358_VERLORENE_LADUNG_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_295_VERLORENE_LADUNG_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_296_VERLORENE_LADUNG_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_297_VERLORENE_LADUNG_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_299_VERLORENE_LADUNG_L_REGER_VERKEHR);
		list.add(ZUSTAND_301_VERLORENE_LADUNG_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_302_VERLORENE_LADUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_360_UMGESTUERZTES_FAHRZEUG_L_STAU);
		list.add(ZUSTAND_361_UMGESTUERZTES_FAHRZEUG_STAUGEFAHR);
		list.add(ZUSTAND_362_UMGESTUERZTES_FAHRZEUG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_363_UMGESTUERZTES_FAHRZEUG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_364_UMGESTUERZTES_FAHRZEUG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_366_UMGESTUERZTES_FAHRZEUG_L_REGER_VERKEHR);
		list.add(ZUSTAND_368_UMGESTUERZTES_FAHRZEUG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_379__L_STAU_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_380_STAUGEFAHR_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_381__L_STOCKENDER_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_382_GEFAHR_VON_STOCKENDEM_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_383__L_DICHTER_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_385__L_REGER_VERKEHR_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_387__L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ_NACH_VORAUSGEGANGENEM_UNFALL);
		list.add(ZUSTAND_313_DEFEKTES_FAHRZEUG_L_STAU);
		list.add(ZUSTAND_314_DEFEKTES_FAHRZEUG_STAUGEFAHR);
		list.add(ZUSTAND_315_DEFEKTES_FAHRZEUG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_316_DEFEKTES_FAHRZEUG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_317_DEFEKTES_FAHRZEUG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_319_DEFEKTES_FAHRZEUG_L_REGER_VERKEHR);
		list.add(ZUSTAND_321_DEFEKTES_FAHRZEUG_STOERUNGSFREIER_VERKEHRSFLUSS);
		list.add(ZUSTAND_322_DEFEKTES_FAHRZEUG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_410_GESPERRT_L_STAU);
		list.add(ZUSTAND_411_GESPERRT_1_KM_STAU);
		list.add(ZUSTAND_412_GESPERRT_2_KM_STAU);
		list.add(ZUSTAND_495_GESPERRT_3_KM_STAU);
		list.add(ZUSTAND_413_GESPERRT_4_KM_STAU);
		list.add(ZUSTAND_414_GESPERRT_6_KM_STAU);
		list.add(ZUSTAND_415_GESPERRT_10_KM_STAU);
		list.add(ZUSTAND_416_GESPERRT_STAUGEFAHR);
		list.add(ZUSTAND_417_GESPERRT_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_418_GESPERRT_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_419_GESPERRT_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_496_GESPERRT_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_420_GESPERRT_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_421_GESPERRT_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_422_GESPERRT_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_423_GESPERRT_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_424_GESPERRT_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_425_GESPERRT_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_426_GESPERRT_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_497_GESPERRT_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_427_GESPERRT_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_428_GESPERRT_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_429_GESPERRT_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_431_GESPERRT_L_REGER_VERKEHR);
		list.add(ZUSTAND_433_GESPERRT_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_434_GESPERRT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_438_BLOCKIERT_L_STAU);
		list.add(ZUSTAND_439_BLOCKIERT_1_KM_STAU);
		list.add(ZUSTAND_440_BLOCKIERT_2_KM_STAU);
		list.add(ZUSTAND_498_BLOCKIERT_3_KM_STAU);
		list.add(ZUSTAND_441_BLOCKIERT_4_KM_STAU);
		list.add(ZUSTAND_442_BLOCKIERT_6_KM_STAU);
		list.add(ZUSTAND_443_BLOCKIERT_10_KM_STAU);
		list.add(ZUSTAND_444_BLOCKIERT_STAUGEFAHR);
		list.add(ZUSTAND_445_BLOCKIERT_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_446_BLOCKIERT_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_447_BLOCKIERT_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_499_BLOCKIERT_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_448_BLOCKIERT_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_449_BLOCKIERT_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_450_BLOCKIERT_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_451_BLOCKIERT_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_452_BLOCKIERT_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_453_BLOCKIERT_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_454_BLOCKIERT_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_626_BLOCKIERT_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_455_BLOCKIERT_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_456_BLOCKIERT_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_457_BLOCKIERT_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_459_BLOCKIERT_L_REGER_VERKEHR);
		list.add(ZUSTAND_461_BLOCKIERT_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_462_BLOCKIERT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_521_FAHRSTREIFEN_GESPERRT_L_STAU);
		list.add(ZUSTAND_522_FAHRSTREIFEN_GESPERRT_1_KM_STAU);
		list.add(ZUSTAND_523_FAHRSTREIFEN_GESPERRT_2_KM_STAU);
		list.add(ZUSTAND_651_FAHRSTREIFEN_GESPERRT_3_KM_STAU);
		list.add(ZUSTAND_524_FAHRSTREIFEN_GESPERRT_4_KM_STAU);
		list.add(ZUSTAND_525_FAHRSTREIFEN_GESPERRT_6_KM_STAU);
		list.add(ZUSTAND_526_FAHRSTREIFEN_GESPERRT_10_KM_STAU);
		list.add(ZUSTAND_527_FAHRSTREIFEN_GESPERRT_STAUGEFAHR);
		list.add(ZUSTAND_528_FAHRSTREIFEN_GESPERRT_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_529_FAHRSTREIFEN_GESPERRT_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_530_FAHRSTREIFEN_GESPERRT_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_652_FAHRSTREIFEN_GESPERRT_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_531_FAHRSTREIFEN_GESPERRT_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_532_FAHRSTREIFEN_GESPERRT_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_533_FAHRSTREIFEN_GESPERRT_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_534_FAHRSTREIFEN_GESPERRT_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_535_FAHRSTREIFEN_GESPERRT_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_536_FAHRSTREIFEN_GESPERRT_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_537_FAHRSTREIFEN_GESPERRT_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_653_FAHRSTREIFEN_GESPERRT_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_538_FAHRSTREIFEN_GESPERRT_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_539_FAHRSTREIFEN_GESPERRT_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_540_FAHRSTREIFEN_GESPERRT_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_542_FAHRSTREIFEN_GESPERRT_L_REGER_VERKEHR);
		list.add(ZUSTAND_544_FAHRSTREIFEN_GESPERRT_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_545_FAHRSTREIFEN_GESPERRT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_546_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_STAU);
		list.add(ZUSTAND_547_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_STAUGEFAHR);
		list.add(ZUSTAND_548_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_549_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_550_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_552_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_REGER_VERKEHR);
		list.add(ZUSTAND_554_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_555_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_556_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_STAU);
		list.add(ZUSTAND_557_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_STAUGEFAHR);
		list.add(ZUSTAND_558_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_559_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_560_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_562_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_REGER_VERKEHR);
		list.add(ZUSTAND_564_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_565_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_566_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_STAU);
		list.add(ZUSTAND_567_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_STAUGEFAHR);
		list.add(ZUSTAND_568_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_569_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_570_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_572_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_REGER_VERKEHR);
		list.add(ZUSTAND_574_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_575_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_576_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STAU);
		list.add(ZUSTAND_577_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_1_KM_STAU_);
		list.add(ZUSTAND_578_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_2_KM_STAU);
		list.add(ZUSTAND_654_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_3_KM_STAU);
		list.add(ZUSTAND_579_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_4_KM_STAU);
		list.add(ZUSTAND_580_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_6_KM_STAU);
		list.add(ZUSTAND_581_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_10_KM_STAU);
		list.add(ZUSTAND_582_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STAUGEFAHR);
		list.add(ZUSTAND_583_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_584_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_585_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_655_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_586_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_587_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_588_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_589_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_590_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_591_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_592_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_656_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_593_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_594_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_595_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_597_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_REGER_VERKEHR);
		list.add(ZUSTAND_599_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_600_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_604_FAHRBAHNVERENGUNG_L_STAU);
		list.add(ZUSTAND_605_FAHRBAHNVERENGUNG_STAUGEFAHR);
		list.add(ZUSTAND_606_FAHRBAHNVERENGUNG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_607_FAHRBAHNVERENGUNG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_608_FAHRBAHNVERENGUNG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_610_FAHRBAHNVERENGUNG_L_REGER_VERKEHR);
		list.add(ZUSTAND_612_FAHRBAHNVERENGUNG_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_613_FAHRBAHNVERENGUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_614_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STAU);
		list.add(ZUSTAND_615_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STAUGEFAHR);
		list.add(ZUSTAND_616_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_617_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_618_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_620_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_REGER_VERKEHR);
		list.add(ZUSTAND_622_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_623_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_710_BAUSTELLE_L_STAU);
		list.add(ZUSTAND_711_BAUSTELLE_1_KM_STAU);
		list.add(ZUSTAND_712_BAUSTELLE_2_KM_STAU);
		list.add(ZUSTAND_812_BAUSTELLE_3_KM_STAU);
		list.add(ZUSTAND_713_BAUSTELLE_4_KM_STAU);
		list.add(ZUSTAND_714_BAUSTELLE_6_KM_STAU);
		list.add(ZUSTAND_715_BAUSTELLE_10_KM_STAU);
		list.add(ZUSTAND_716_BAUSTELLE_STAUGEFAHR);
		list.add(ZUSTAND_717_BAUSTELLE_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_718_BAUSTELLE_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_719_BAUSTELLE_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_813_BAUSTELLE_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_720_BAUSTELLE_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_721_BAUSTELLE_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_722_BAUSTELLE_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_723_BAUSTELLE_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_724_BAUSTELLE_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_725_BAUSTELLE_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_726_BAUSTELLE_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_814_BAUSTELLE_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_727_BAUSTELLE_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_728_BAUSTELLE_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_729_BAUSTELLE_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_731_BAUSTELLE_L_REGER_VERKEHR);
		list.add(ZUSTAND_733_BAUSTELLE_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_734_BAUSTELLE_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_750_FAHRBAHNERNEUERUNG_L_STAU);
		list.add(ZUSTAND_751_FAHRBAHNERNEUERUNG_1_KM_STAU);
		list.add(ZUSTAND_752_FAHRBAHNERNEUERUNG_2_KM_STAU);
		list.add(ZUSTAND_818_FAHRBAHNERNEUERUNG_3_KM_STAU);
		list.add(ZUSTAND_753_FAHRBAHNERNEUERUNG_4_KM_STAU);
		list.add(ZUSTAND_754_FAHRBAHNERNEUERUNG_6_KM_STAU);
		list.add(ZUSTAND_755_FAHRBAHNERNEUERUNG_10_KM_STAU);
		list.add(ZUSTAND_756_FAHRBAHNERNEUERUNG_STAUGEFAHR);
		list.add(ZUSTAND_757_FAHRBAHNERNEUERUNG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_758_FAHRBAHNERNEUERUNG_1_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_759_FAHRBAHNERNEUERUNG_2_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_819_FAHRBAHNERNEUERUNG_3_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_760_FAHRBAHNERNEUERUNG_4_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_761_FAHRBAHNERNEUERUNG_6_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_762_FAHRBAHNERNEUERUNG_10_KM_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_763_FAHRBAHNERNEUERUNG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_764_FAHRBAHNERNEUERUNG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_765_FAHRBAHNERNEUERUNG_1_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_766_FAHRBAHNERNEUERUNG_2_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_820_FAHRBAHNERNEUERUNG_3_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_767_FAHRBAHNERNEUERUNG_4_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_768_FAHRBAHNERNEUERUNG_6_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_769_FAHRBAHNERNEUERUNG_10_KM_DICHTER_VERKEHR);
		list.add(ZUSTAND_771_FAHRBAHNERNEUERUNG_L_REGER_VERKEHR);
		list.add(ZUSTAND_773_FAHRBAHNERNEUERUNG_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_774_FAHRBAHNERNEUERUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_783_MARKIERUNGSARBEITEN_L_STAU);
		list.add(ZUSTAND_784_MARKIERUNGSARBEITEN_STAUGEFAHR);
		list.add(ZUSTAND_785_MARKIERUNGSARBEITEN_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_786_MARKIERUNGSARBEITEN_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_787_MARKIERUNGSARBEITEN_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_789_MARKIERUNGSARBEITEN_L_REGER_VERKEHR);
		list.add(ZUSTAND_791_MARKIERUNGSARBEITEN_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_792_MARKIERUNGSARBEITEN_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_825_WANDERBAUSTELLE_L_STAU);
		list.add(ZUSTAND_826_WANDERBAUSTELLE_STAUGEFAHR);
		list.add(ZUSTAND_827_WANDERBAUSTELLE_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_828_WANDERBAUSTELLE_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_829_WANDERBAUSTELLE_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_831_WANDERBAUSTELLE_L_REGER_VERKEHR);
		list.add(ZUSTAND_833_WANDERBAUSTELLE_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_834_WANDERBAUSTELLE_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_928_HOCHWASSER_L_STAU);
		list.add(ZUSTAND_929_HOCHWASSER_STAUGEFAHR);
		list.add(ZUSTAND_930_HOCHWASSER_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_931_HOCHWASSER_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_932_HOCHWASSER_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_934_HOCHWASSER_L_REGER_VERKEHR);
		list.add(ZUSTAND_936_HOCHWASSER_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_937_HOCHWASSER_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_1517_VERANSTALTUNG_L_STAU);
		list.add(ZUSTAND_1518_VERANSTALTUNG_STAUGEFAHR);
		list.add(ZUSTAND_1519_VERANSTALTUNG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_1520_VERANSTALTUNG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_1521_VERANSTALTUNG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_1523_VERANSTALTUNG_L_REGER_VERKEHR);
		list.add(ZUSTAND_1525_VERANSTALTUNG_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_1526_VERANSTALTUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_1531_SPORTVERANSTALTUNG_L_STAU);
		list.add(ZUSTAND_1532_SPORTVERANSTALTUNG_STAUGEFAHR);
		list.add(ZUSTAND_1533_SPORTVERANSTALTUNG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_1534_SPORTVERANSTALTUNG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_1535_SPORTVERANSTALTUNG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_1537_SPORTVERANSTALTUNG_L_REGER_VERKEHR);
		list.add(ZUSTAND_1539_SPORTVERANSTALTUNG_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_1540_SPORTVERANSTALTUNG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_1545_VOLKSFEST_L_STAU);
		list.add(ZUSTAND_1546_VOLKSFEST_STAUGEFAHR);
		list.add(ZUSTAND_1547_VOLKSFEST_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_1548_VOLKSFEST_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_1549_VOLKSFEST_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_1551_VOKSFEST_L_REGER_VERKEHR);
		list.add(ZUSTAND_1553_VOLKSFEST_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_1554_VOLKSFEST_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_1571_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_STAU);
		list.add(ZUSTAND_1572_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_STAUGEFAHR);
		list.add(ZUSTAND_1573_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_1574_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_1575_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_1577_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_REGER_VERKEHR);
		list.add(ZUSTAND_1495_EVAKUIERUNG_REGER_VERKEHR);
		list.add(ZUSTAND_1586_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_1579_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_1807_AMPELANLAGEN_AUSSER_BETRIEB_L_STAU);
		list.add(ZUSTAND_1808_AMPELANLAGEN_AUSSER_BETRIEB_STAUGEFAHR);
		list.add(ZUSTAND_1809_AMPELANLAGEN_AUSSER_BETRIEB_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_1810_AMPELANLAGEN_AUSSER_BETRIEB_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_1811_AMPELANLAGEN_AUSSER_BETRIEB_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_1813_AMPELANLAGEN_AUSSER_BETRIEB_L_REGER_VERKEHR);
		list.add(ZUSTAND_1815_AMPELANLAGEN_AUSSER_BETRIEB_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_1816_AMPELANLAGEN_AUSSER_BETRIEB_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_1820_STOERUNG_AM_BAHNUEBERGANG_L_STAU);
		list.add(ZUSTAND_1821_STOERUNG_AM_BAHNUEBERGANG_STAUGEFAHR);
		list.add(ZUSTAND_1822_STOERUNG_AM_BAHNUEBERGANG_L_STOCKENDER_VERKEHR);
		list.add(ZUSTAND_1823_STOERUNG_AM_BAHNUEBERGANG_GEFAHR_VON_STOCKENDEM_VERKEHR);
		list.add(ZUSTAND_1824_STOERUNG_AM_BAHNUEBERGANG_L_DICHTER_VERKEHR);
		list.add(ZUSTAND_1826_STOERUNG_AM_BAHNUEBERGANG_L_REGER_VERKEHR);
		list.add(ZUSTAND_1828_STOERUNG_AM_BAHNUEBERGANG_STOERUNGSFREIER_VERKEHR);
		list.add(ZUSTAND_1829_STOERUNG_AM_BAHNUEBERGANG_L_DICHTER_VERKEHR_MIT_ZUNEHMENDER_TENDENZ);
		list.add(ZUSTAND_126_MELDUNGEN_UEBER_STOERUNGEN_LIEGEN_NICHT_VOR);
		list.add(ZUSTAND_127_DIE_GEMELDETE_VERKEHRSSTOERUNG_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1584_VERKEHR_HAT_SICH_NORMALISIERT);
		list.add(ZUSTAND_128_MELDUNG_AUFGEHOBEN);
		list.add(ZUSTAND_55_VERKEHRSBEHINDERUNG_ZU_ERWARTEN);
		list.add(ZUSTAND_107_STAU_ZU_ERWARTEN);
		list.add(ZUSTAND_114_STOCKENDER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_121_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_123_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_56_VERKEHRSSTOERUNG_ZU_ERWARTEN);
		list.add(ZUSTAND_235_UNFALL_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_237_UNFALL_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_270_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_272_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_AN_EINER_UNFALLSTELLE_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_298_VERLORENE_LADUNG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_300_VERLORENE_LADUNG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_365_UMGESTUERZTES_FAHRZEUG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_367_UMGESTUERZTES_FAHRZEUG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_318_DEFEKTES_FAHRZEUG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_320_DEFEKTES_FAHRZEUG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_430_GESPERRT_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_432_GESPERRT_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_458_BLOCKIERT_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_460_BLOCKIERT_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_541_FAHRSTREIFEN_GESPERRT_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_543_FAHRSTREIFEN_GESPERRT_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_551_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_553_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_561_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_563_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_571_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_573_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_596_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_598_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_609_FAHRBAHNVERENGUNG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_611_FAHRBAHNVERENGUNG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_619_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_621_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_730_BAUSTELLE_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_732_BAUSTELLE_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_770_FAHRBAHNERNEUERUNG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_772_FAHRBAHNERNEUERUNG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_788_MARKIERUNGSARBEITEN_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_790_MARKIERUNGSARBEITEN_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_830_WANDERBAUSTELLE_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_832_WANDERBAUSTELLE_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_933_HOCHWASSER_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_935_HOCHWASSER_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1522_VERANSTALTUNG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1524_VERANSTALTUNG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1536_SPORTVERANSTALTUNG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1538_SPORTVERANSTALTUNG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1550_VOLKSFEST_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1552_VOLKSFEST_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1576_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1578_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1812_AMPELANLAGEN_AUSSER_BETRIEB_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1814_AMPELANLAGEN_AUSSER_BETRIEB_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1825_STOERUNG_AM_BAHNUEBERGANG_DICHTER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1827_STOERUNG_AM_BAHNUEBERGANG_REGER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_57_NORMALER_VERKEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1589_MELDUNG_AUFGEHOBEN_ERWARTETE_VERKEHRSLAGE_);
		list.add(ZUSTAND_201_UNFALL);
		list.add(ZUSTAND_202_SCHWERER_UNFALL);
		list.add(ZUSTAND_203_UNFALL_MIT_MEHREREN_FAHRZEUGEN);
		list.add(ZUSTAND_204_UNFALL_MIT_LKW);
		list.add(ZUSTAND_335_UNFALL_MIT_BUS);
		list.add(ZUSTAND_205_UNFALL_MIT_GEFAHRGUTTRANSPORTER);
		list.add(ZUSTAND_206_UNFALL_GEFAHR_DURCH_AUSLAUFENDEN_KRAFTSTOFF);
		list.add(ZUSTAND_207_UNFALL_GEFAHR_DURCH_AUSLAUFENDE_CHEMIKALIEN);
		list.add(ZUSTAND_336_UNFALL_GEFAHR_DURCH_AUSLAUFENDES_OEL);
		list.add(ZUSTAND_337_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTES_FAHRZEUG);
		list.add(ZUSTAND_338_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTEN_LKW);
		list.add(ZUSTAND_339_VERKEHRSBEHINDERUNG_DURCH_QUERSTEHENDEN_ANHAENGER);
		list.add(ZUSTAND_340_VERKEHRSBEHINDERUNG_DURCH_QUERSTEHENDEN_WOHNWAGEN);
		list.add(ZUSTAND_341_VERKEHRSBEHINDERUNG_DURCH_QUERSTEHENDEN_LKW);
		list.add(ZUSTAND_213_BRENNENDES_FAHRZEUG);
		list.add(ZUSTAND_342_FAHRZEUG_VERUNGLUECKT);
		list.add(ZUSTAND_378_GEFAHR_DURCH_UMGESTUERZTES_FAHRZEUG);
		list.add(ZUSTAND_343_VORAUSGEGANGENER_UNFALL);
		list.add(ZUSTAND_344_VERKEHRSBEHINDERUNG_DURCH_UNFALLAUFNAHME);
		list.add(ZUSTAND_391_UNFALLAUFNAHME_GEFAHR);
		list.add(ZUSTAND_351_UNFALL_IM_BAUSTELLENBEREICH);
		list.add(ZUSTAND_12_UNFALL_VERKEHR_WIRD_AN_DER_UNFALLSTELLE_VORBEIGEFUEHRT);
		list.add(ZUSTAND_345_FOLGEUNFALL);
		list.add(ZUSTAND_392_FOLGEUNFALL_GEFAHR);
		list.add(ZUSTAND_209_UNFALL_IN_DER_GEGENRICHTUNG);
		list.add(ZUSTAND_141_ALLE_UNFALLSTELLEN_GERAEUMT_KEINE_VERKEHRSBEHINDERUNG_MEHR);
		list.add(ZUSTAND_333_UNFALLSTELLE_GERAEUMT);
		list.add(ZUSTAND_334_MELDUNG_AUFGEHOBEN_UNFAELLE_);
		list.add(ZUSTAND_214_VERKEHRSBEHINDERUNG_VORFAELLE_);
		list.add(ZUSTAND_211_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG);
		list.add(ZUSTAND_393_GEFAHR_DURCH_DEFEKTES_FAHRZEUG);
		list.add(ZUSTAND_212_VERKEHRSBEHINDERUNG_DURCH_DEFEKTEN_LKW);
		list.add(ZUSTAND_394_GEFAHR_DURCH_DEFEKTEN_LKW);
		list.add(ZUSTAND_346_VERKEHRSBEHINDERUNG_DURCH_DEFEKTEN_BUS);
		list.add(ZUSTAND_11_HOEHENKONTROLLE_WURDE_AUSGELOEST);
		list.add(ZUSTAND_924_VERKEHRSBEHINDERUNG_DURCH_AUFRAEUMARBEITEN);
		list.add(ZUSTAND_1034_GEFAHR_DURCH_AUFRAEUMARBEITEN);
		list.add(ZUSTAND_397_VERKEHRSBEHINDERUNG_DURCH_BERGUNGSARBEITEN);
		list.add(ZUSTAND_1066_GEFAHR_DURCH_BERGUNGSARBEITEN);
		list.add(ZUSTAND_396_DIE_GEMELDETE_STOERUNG_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_395_STRASSE_GERAEUMT);
		list.add(ZUSTAND_2028_MELDUNG_AUFGEHOBEN_VORFAELLE_);
		list.add(ZUSTAND_666_MEHRFACH_KURZFRISTIGE_SPERRUNGEN);
		list.add(ZUSTAND_401_GESPERRT);
		list.add(ZUSTAND_240_UNFALL_STRASSE_GESPERRT);
		list.add(ZUSTAND_16_WEGEN_BERGUNGSARBEITEN_GESPERRT);
		list.add(ZUSTAND_500_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_501_RECHTER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_502_MITTLERER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_503_LINKER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_504_STANDSTREIFEN_GESPERRT);
		list.add(ZUSTAND_637_SEITENSTREIFEN_GESPERRT);
		list.add(ZUSTAND_41_UEBERHOLSTREIFEN_GESPERRT);
		list.add(ZUSTAND_641_EIN_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_505_ZWEI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_506_DREI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_514_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_515_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_516_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_601_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_602_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_603_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_735_WEGEN_BAUSTELLE_GESPERRT);
		list.add(ZUSTAND_736_BAUSTELLE_RECHTER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_737_BAUSTELLE_MITTLERER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_738_BAUSTELLE_LINKER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_739_BAUSTELLE_STANDSTREIFEN_GESPERRT);
		list.add(ZUSTAND_740_BAUSTELLE_ZWEI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_741_BAUSTELLE_DREI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_51_BAUSTELLE_UEBERHOLSTREIFEN_GESPERRT);
		list.add(ZUSTAND_743_BAUSTELLE_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_744_BAUSTELLE_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_745_BAUSTELLE_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_776_FAHRBAHNERNEUERUNG_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_777_FAHRBAHNERNEUERUNG_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_778_FAHRBAHNERNEUERUNG_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_793_MARKIERUNGSARBEITEN_RECHTER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_794_MARKIERUNGSARBEITEN_MITTLERER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_795_MARKIERUNGSARBEITEN_LINKER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_796_MARKIERUNGSARBEITEN_STANDSTREIFEN_GESPERRT);
		list.add(ZUSTAND_797_MARKIERUNGSARBEITEN_ZWEI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_798_MARKIERUNGSARBEITEN_DREI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_835_WANDERBAUSTELLE_RECHTER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_836_WANDERBAUSTELLE_MITTLERER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_837_WANDERBAUSTELLE_LINKER_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_838_WANDERBAUSTELLE_ZWEI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_839_WANDERBAUSTELLE_DREI_FAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_799_BRUECKENABRISS_STRASSE_GESPERRT);
		list.add(ZUSTAND_947_ERDRUTSCH_STRASSE_GESPERRT);
		list.add(ZUSTAND_957_GEPLATZTE_WASSERLEITUNG_STRASSE_GESPERRT);
		list.add(ZUSTAND_965_FEUER_STRASSE_GESPERRT);
		list.add(ZUSTAND_951_ABSENKUNG_DER_FAHRBAHN_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_952_ABSENKUNG_DER_FAHRBAHN_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_953_ABSENKUNG_DER_FAHRBAHN_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_956_STOERUNG_IN_DER_KANALISATION_STRASSE_GESPERRT);
		list.add(ZUSTAND_961_AUSSTROEMENDES_GAS_STRASSE_GESPERRT);
		list.add(ZUSTAND_969_AUFRAEUMARBEITEN_STRASSE_GESPERRT);
		list.add(ZUSTAND_1021_SCHNEEGLAETTE_FAHRBAHN_AUF_EINEN_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_1022_SCHNEEGLAETTE_FAHRBAHN_AUF_ZWEI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_1023_SCHNEEGLAETTE_FAHRBAHN_AUF_DREI_FAHRSTREIFEN_VERENGT);
		list.add(ZUSTAND_241_UNFALL_RECHTER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_242_UNFALL_MITTLERER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_243_UNFALL_LINKER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_244_UNFALL_STANDSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_245_UNFALL_ZWEI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_246_UNFALL_DREI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_303_DURCH_VERLORENE_LADUNG_BLOCKIERT);
		list.add(ZUSTAND_304_VERLORENE_LADUNG_RECHTER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_305_VERLORENE_LADUNG_MITTLERER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_306_VERLORENE_LADUNG_LINKER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_307_VERLORENE_LADUNG_STANDSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_308_VERLORENE_LADUNG_ZWEI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_309_VERLORENE_LADUNG_DREI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_369_DURCH_UMGESTUERZTES_FAHRZEUG_BLOCKIERT);
		list.add(ZUSTAND_370_UMGESTUERZTES_FAHRZEUG_RECHTER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_371_UMGESTUERZTES_FAHRZEUG_MITTLERER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_372_UMGESTUERZTES_FAHRZEUG_LINKER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_373_UMGESTUERZTES_FAHRZEUG_ZWEI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_374_UMGESTUERZTES_FAHRZEUG_DREI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_323_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_STRASSE_BLOCKIERT);
		list.add(ZUSTAND_324_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_RECHTER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_325_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_MITTLERER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_326_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_LINKER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_327_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_STANDSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_328_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_ZWEI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_329_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_DREI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_402_BLOCKIERT);
		list.add(ZUSTAND_520_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_507_RECHTER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_508_MITTLERER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_509_LINKER_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_510_STANDSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_642_NOTFALLSPUR_BLOCKIERT);
		list.add(ZUSTAND_42_UEBERHOLSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_646_EIN_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_511_ZWEI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_512_DREI_FAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_980_STRASSE_DURCH_HINDERNISSE_BLOCKIERT);
		list.add(ZUSTAND_982_STRASSE_DURCH_AUSGELAUFENE_FLUESSIGKEITEN_BLOCKIERT);
		list.add(ZUSTAND_925_WEGEN_STURMSCHAEDEN_BLOCKIERT);
		list.add(ZUSTAND_926_DURCH_UMGESTUERZTE_BAEUME_BLOCKIERT);
		list.add(ZUSTAND_987_BLOCKIERT_DURCH_HERUNTERHAENGENDE_STROMKABEL);
		list.add(ZUSTAND_517_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_518_FAHRBAHNVERENGUNG);
		list.add(ZUSTAND_519_FAHRBAHNVERENGUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_513_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI);
		list.add(ZUSTAND_746_BAUSTELLE_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_742_BAUSTELLE_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI);
		list.add(ZUSTAND_779_FAHRBAHNERNEUERUNG_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_775_FAHRBAHNERNEUERUNG_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI);
		list.add(ZUSTAND_954_VERKEHRSBEHINDERUNG_DURCH_ABSENKUNG_DER_FAHRBAHN_VERKEHR_WIRD_UEBER_DIE_GEGENFAHRBAHN_GELEITET);
		list.add(ZUSTAND_638_WENDESPUR_GESPERRT);
		list.add(ZUSTAND_643_WENDESPUR_BLOCKIERT);
		list.add(ZUSTAND_639_KRIECHSPUR_GESPERRT);
		list.add(ZUSTAND_640_LANGSAMFAHRSTREIFEN_GESPERRT);
		list.add(ZUSTAND_678_SCHWERVERKEHRSSPUR_GESPERRT);
		list.add(ZUSTAND_644_KRIECHSPUR_BLOCKIERT);
		list.add(ZUSTAND_645_LANGSAMFAHRSTREIFEN_BLOCKIERT);
		list.add(ZUSTAND_679_SCHWERVERKEHRSSPUR_BLOCKIERT);
		list.add(ZUSTAND_657_FAHRSTREIFENBLOCKIERUNG_BESEITIGT);
		list.add(ZUSTAND_631_STRASSE_GERAEUMT_STRASSEN_UND_FAHRBAHNSPERRUNGEN_);
		list.add(ZUSTAND_658_UMLEITUNG_UEBER_DIE_GEGENFAHRBAHN_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_467_WIEDER_FREI);
		list.add(ZUSTAND_630_FREI);
		list.add(ZUSTAND_624_FAHRSTREIFENSPERRUNG_WIEDER_AUFGEHOBEN);
		list.add(ZUSTAND_664_RICHTUNGSFAHRBAHN_GESPERRT);
		list.add(ZUSTAND_665_BEIDE_FAHRTRICHTUNGEN_GESPERRT);
		list.add(ZUSTAND_625_MELDUNG_AUFGEHOBEN_STRASSEN_UND_FAHRBAHNSPERRUNGEN_);
		list.add(ZUSTAND_479_PARALLELFAHRBAHN_GESPERRT);
		list.add(ZUSTAND_480_RECHTE_PARALLELFAHRBAHN_GESPERRT);
		list.add(ZUSTAND_481_LINKE_PARALLELFAHRBAHN_GESPERRT);
		list.add(ZUSTAND_482_SCHNELLSPUR_GESPERRT);
		list.add(ZUSTAND_483_FERNVERKEHRSSPUR_GESPERRT);
		list.add(ZUSTAND_484_NAHVERKEHRSSPUR_GESPERRT);
		list.add(ZUSTAND_486_PARALLELFAHRBAHN_BLOCKIERT);
		list.add(ZUSTAND_487_RECHTE_PARALLELFAHRBAHN_BLOCKIERT);
		list.add(ZUSTAND_488_LINKE_PARALLELFAHRBAHN_BLOCKIERT);
		list.add(ZUSTAND_489_SCHNELLSPUR_BLOCKIERT);
		list.add(ZUSTAND_490_FERNVERKEHRSSPUR_BLOCKIERT);
		list.add(ZUSTAND_491_NAHVERKEHRSSPUR_BLOCKIERT);
		list.add(ZUSTAND_1982_BUSSPUR_GESPERRT);
		list.add(ZUSTAND_676_BUSSPUR_BLOCKIERT);
		list.add(ZUSTAND_26_BRUECKE_BLOCKIERT);
		list.add(ZUSTAND_27_TUNNEL_BLOCKIERT);
		list.add(ZUSTAND_663_ALLE_FAHRBAHNEN_GERAEUMT);
		list.add(ZUSTAND_634_ALLE_FAHRBAHNEN_WIEDER_FREI);
		list.add(ZUSTAND_672_MELDUNG_AUFGEHOBEN_FAHRBAHNBESCHRAENKUNGEN_);
		list.add(ZUSTAND_407_AUSFAHRT_GESPERRT);
		list.add(ZUSTAND_474_AUSFAHRT_GESPERRT_BESCHRAENKUNGEN_DER_AUSFAHRT_);
		list.add(ZUSTAND_475_AUSFAHRT_BLOCKIERT);
		list.add(ZUSTAND_476_AUSFAHRT_BLOCKIERT_BESCHRAENKUNGEN_DER_AUSFAHRT_);
		list.add(ZUSTAND_408_ANSCHLUSSSTELLE_GESPERRT);
		list.add(ZUSTAND_477_ANSCHLUSSSTELLE_BLOCKIERT);
		list.add(ZUSTAND_409_BESCHRAENKUNG_DER_ANSCHLUSSSTELLE);
		list.add(ZUSTAND_478_VERBINDUNGSFAHRBAHN_GESPERRT);
		list.add(ZUSTAND_485_VERBINDUNGSFAHRBAHN_BLOCKIERT);
		list.add(ZUSTAND_1998_GEFAEHRLICHE_SITUATION_IN_DER_AUSFAHRT);
		list.add(ZUSTAND_633_AUSFAHRT_WIEDER_FREI);
		list.add(ZUSTAND_466_ANSCHLUSSSTELLE_WIEDER_FREI);
		list.add(ZUSTAND_673_MELDUNG_AUFGEHOBEN_BESCHRAENKUNGEN_DER_AUSFAHRT_);
		list.add(ZUSTAND_406_EINFAHRT_GESPERRT);
		list.add(ZUSTAND_471_EINFAHRT_GESPERRT_BESCHRAENKUNGEN_DER_EINFAHRT_);
		list.add(ZUSTAND_472_EINFAHRT_BLOCKIERT);
		list.add(ZUSTAND_473_EINFAHRT_BLOCKIERT_BESCHRAENKUNGEN_DER_EINFAHRT_);
		list.add(ZUSTAND_1999_GEFAEHRLICHE_SITUATION_IN_DER_EINFAHRT);
		list.add(ZUSTAND_632_EINFAHRT_WIEDER_FREI);
		list.add(ZUSTAND_399_MELDUNG_AUFGEHOBEN_BESCHRAENKUNGEN_DER_EINFAHRT_);
		list.add(ZUSTAND_492_FAHRVERBOT_FUER_KRAFTFAHRZEUGE);
		list.add(ZUSTAND_493_BESCHRAENKUNGEN);
		list.add(ZUSTAND_627_FAHRVERBOT_FUER_KRAFTFAHRZEUGE_OHNE_KATALYSATOR);
		list.add(ZUSTAND_628_GESPERRT_FUER_KRAFTFAHRZEUGE_MIT_GERADZAHLIGEN_KENNZEICHEN);
		list.add(ZUSTAND_629_GESPERRT_FUER_KRAFTFAHRZEUGE_MIT_UNGERADZAHLIGEN_KENNZEICHEN);
		list.add(ZUSTAND_405_GESPERRT_FUER_DURCHGANGSVERKEHR);
		list.add(ZUSTAND_404_DURCHFAHRT_GESPERRT_FUER_LKW);
		list.add(ZUSTAND_1332_SMOG_ALARM);
		list.add(ZUSTAND_1338_SMOG_ALARM_FAHRVERBOT_FUER_KRAFTFAHRZEUGE);
		list.add(ZUSTAND_469_GESPERRT_VERKEHRSBESCHRAENKUNGEN_);
		list.add(ZUSTAND_470_BLOCKIERT_VERKEHRSBESCHRAENKUNGEN_);
		list.add(ZUSTAND_2000_WEGEN_SMOG_ALARMS_GESPERRT);
		list.add(ZUSTAND_1527_WEGEN_VERANSTALTUNG_GESPERRT);
		list.add(ZUSTAND_1541_WEGEN_SPORTVERANSTALTUNG_GESPERRT);
		list.add(ZUSTAND_1555_WEGEN_VOLKSFEST_GESPERRT);
		list.add(ZUSTAND_1559_WEGEN_PARADE_GESPERRT);
		list.add(ZUSTAND_1563_WEGEN_STREIKS_GESPERRT);
		list.add(ZUSTAND_1567_WEGEN_DEMONSTRATION_GESPERRT);
		list.add(ZUSTAND_1580_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_STRASSE_GESPERRT);
		list.add(ZUSTAND_1485_SICHERHEITSVORFALL_STRASSE_GESPERRT);
		list.add(ZUSTAND_938_WEGEN_HOCHWASSERS_GESPERRT);
		list.add(ZUSTAND_943_WEGEN_LAWINEN_GESPERRT);
		list.add(ZUSTAND_993_WEGEN_LAWINENGEFAHR_GESPERRT);
		list.add(ZUSTAND_995_WEGEN_GLATTEISBILDUNG_GESPERRT);
		list.add(ZUSTAND_945_WEGEN_STEINSCHLAGS_GESPERRT);
		list.add(ZUSTAND_949_WEGEN_FAHRBAHNABSENKUNG_GESPERRT);
		list.add(ZUSTAND_2013_TANK_UND_RASTANLAGE_AUSGELASTET);
		list.add(ZUSTAND_20_TANK_UND_RASTANLAGE_UEBERFUELLT_FAHREN_SIE_EINE_ANDERE_TANK_ODER_RASTANLAGE_AN);
		list.add(ZUSTAND_22_TANK_UND_RASTANLAGE_TANKSTELLE_GESCHLOSSEN);
		list.add(ZUSTAND_23_TANK_UND_RASTANLAGE_RASTSTAETTE_GESCHLOSSEN);
		list.add(ZUSTAND_24_BRUECKE_GESPERRT);
		list.add(ZUSTAND_25_TUNNEL_GESPERRT);
		list.add(ZUSTAND_403_GESPERRT_FUER_SCHWERVERKEHR);
		list.add(ZUSTAND_494_GESPERRT_FUER_LKW_);
		list.add(ZUSTAND_661_BENUTZUNG_DER_STANDSPUR_ERLAUBT);
		list.add(ZUSTAND_1854_GEAENDERTE_VERKEHRSREGELUNG);
		list.add(ZUSTAND_28_STRASSE_WIRD_MEHRFACH_GESPERRT);
		list.add(ZUSTAND_1971_POLIZEI_REGELT_DEN_VERKEHR);
		list.add(ZUSTAND_1972_BUSSPUR_OFFEN_FUER_ALLE_FAHRZEUGE);
		list.add(ZUSTAND_1973_POLIZEI_FUEHRT_DEN_VERKEHR_UEBER_BUSSPUR);
		list.add(ZUSTAND_1978_SCHWERVERKEHRSSPUR_OFFEN_FUER_ALLE_FAHRZEUGE);
		list.add(ZUSTAND_1979_POLIZEI_FUEHRT_DEN_VERKEHR_UEBER_SCHWERVERKEHRSSPUR_);
		list.add(ZUSTAND_662_NORMALE_FAHRSPURREGELUNG_WIEDER_IN_KRAFT);
		list.add(ZUSTAND_1974_GASSE_FUER_RETTUNGS_UND_EINSATZFAHRZEUGE_BILDEN);
		list.add(ZUSTAND_1977_RETTUNGS_UND_EINSATZFAHRZEUGE_AUF_SCHWERVERKEHRSSPUR_UEBERHOLEN_LASSEN);
		list.add(ZUSTAND_1961_RETTUNGS_UND_EINSATZFAHRZEUGE_AUF_FAHRGEMEINSCHAFTSSPUR_UEBERHOLEN_LASSEN);
		list.add(ZUSTAND_1212_STARKER_WIND_STRASSE_GESPERRT_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN);
		list.add(ZUSTAND_1976_UEBERHOLVERBOT);
		list.add(ZUSTAND_1985_UEBERHOLVERBOT_AUFGEHOBEN);
		list.add(ZUSTAND_1981_LKW_WIRD_EMPFOHLEN_DIE_NAECHSTE_GEEIGNETE_HALTEMOEGLICHKEIT_ANZUFAHREN);
		list.add(ZUSTAND_1975_UEBERHOLVERBOT_FUER_SCHWERVERKEHR);
		list.add(ZUSTAND_660_FAHRBAHNBESCHRAENKUNG_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1215_BESCHRAENKUNGEN_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN_BESTEHEN_NICHT_MEHR);
		list.add(ZUSTAND_680_SPERRUNG_FUER_DURCHGANGSVERKEHR_IST_AUFGEHOBEN);
		list.add(ZUSTAND_36_TANKSTELLE_WIEDER_GEOEFFNET);
		list.add(ZUSTAND_37_RASTSTAETTE_WIEDER_GEOEFFNET);
		list.add(ZUSTAND_635_FAHRVERBOT_FUER_KRAFTFAHRZEUGE_AUFGEHOBEN);
		list.add(ZUSTAND_40_FAHRVERBOT_WEGEN_SMOG_ALARM_AUFGEHOBEN);
		list.add(ZUSTAND_636_FAHRVERBOT_AUFGEHOBEN);
		list.add(ZUSTAND_2046_AUFGRUND_SCHLECHTEN_WETTERS_FAHREN_IM_KOLONNENVERBAND_VORGESCHRIEBEN);
		list.add(ZUSTAND_468_MELDUNG_AUFGEHOBEN_VERKEHRSBESCHRAENKUNGEN_);
		list.add(ZUSTAND_647_SONDERSPUR_FUER_FAHRGEMEINSCHAFTEN_OFFEN);
		list.add(ZUSTAND_648_SONDERSPUR_FUER_FAHRGEMEINSCHAFTEN_GESPERRT);
		list.add(ZUSTAND_649_SONDERSPUR_FUER_FAHRGEMEINSCHAFTEN_BLOCKIERT);
		list.add(ZUSTAND_671_NUTZUNG_DER_BUSSPUR_FUER_FAHRGEMEINSCHAFTEN_ERLAUBT);
		list.add(ZUSTAND_650_BEDINGUNGEN_FUER_FAHRGEMEINSCHAFTEN_GEAENDERT);
		list.add(ZUSTAND_1962_FAHRGEMEINSCHAFTSSPUR_OFFEN_FUER_ALLE_FAHRZEUGE);
		list.add(ZUSTAND_1963_POLIZEI_FUEHRT_DEN_VERKEHR_UEBER_FAHRGEMEINSCHAFTSSPUR);
		list.add(ZUSTAND_2006_GESPERRT_FUER_FAHRZEUGE_MIT_WENIGER_ALS_3_INSASSEN);
		list.add(ZUSTAND_2007_GESPERRT_FUER_FAHRZEUGE_MIT_NUR_EINEM_INSASSEN);
		list.add(ZUSTAND_659_BESCHRAENKUNG_DER_FAHRGEMEINSCHAFTEN_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_2029_MELDUNG_AUFGEHOBEN_INFORMATIONEN_FUER_FAHRGEMEINSCHAFTEN_);
		list.add(ZUSTAND_701_BAUSTELLE);
		list.add(ZUSTAND_702_GROSSBAUSTELLE);
		list.add(ZUSTAND_802_DAUERBAUSTELLE);
		list.add(ZUSTAND_803_BAUARBEITEN);
		list.add(ZUSTAND_704_FAHRBAHNERNEUERUNG);
		list.add(ZUSTAND_705_ARBEITEN_AM_MITTELSTREIFEN);
		list.add(ZUSTAND_703_WARTUNGSARBEITEN);
		list.add(ZUSTAND_853_VERKEHRSBEHINDERUNG_DURCH_ABBAU_DER_BAUSTELLE);
		list.add(ZUSTAND_707_BRUECKENARBEITEN);
		list.add(ZUSTAND_805_BRUECKENABRISS);
		list.add(ZUSTAND_709_SPRENGARBEITEN);
		list.add(ZUSTAND_52_ARBEITEN_AM_STANDSTREIFEN);
		list.add(ZUSTAND_53_ARBEITEN_AUF_DER_NOTFALLSPUR);
		list.add(ZUSTAND_815_TAGESBAUSTELLE);
		list.add(ZUSTAND_816_BAUSTELLE_IN_VERKEHRSARMEN_ZEITEN);
		list.add(ZUSTAND_817_NACHTBAUSTELLE);
		list.add(ZUSTAND_821_FAHRBAHNERNEUERUNG_AM_TAGE);
		list.add(ZUSTAND_822_FAHRBAHNERNEUERUNG_IN_VERKEHRSARMEN_ZEITEN);
		list.add(ZUSTAND_823_FAHRBAHNERNEUERUNG_IN_DER_NACHT);
		list.add(ZUSTAND_708_VORUEBERGEHENDE_REGELUNG_MIT_PROVISORISCHEN_AMPELANLAGEN);
		list.add(ZUSTAND_806_ARBEITEN_AN_WASSERLEITUNGEN);
		list.add(ZUSTAND_807_ARBEITEN_AN_GASLEITUNGEN);
		list.add(ZUSTAND_808_ARBEITEN_AN_ERDKABELN);
		list.add(ZUSTAND_809_TIEFBAUARBEITEN);
		list.add(ZUSTAND_810_GEAENDERTE_VERKEHRSFUEHRUNG_IM_BAUSTELLENBEREICH);
		list.add(ZUSTAND_855_KEINE_GEAENDERTE_VERKEHRSFUEHRUNG);
		list.add(ZUSTAND_811_GEAENDERTE_VERKEHRSFUEHRUNG);
		list.add(ZUSTAND_854_WARTUNGSARBEITEN_BEENDET_);
		list.add(ZUSTAND_800_BAUSTELLE_BESEITIGT);
		list.add(ZUSTAND_801_MELDUNG_AUFGEHOBEN_BAUARBEITEN_);
		list.add(ZUSTAND_901_VERKEHRSBEHINDERUNG_DURCH_HINDERNISSE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_902_GEFAHR_DURCH_HINDERNISSE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_981_VERKEHRSBEHINDERUNG_DURCH_HINDERNISSE_AUF_DER_FAHRBAHN_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_61_VERKEHRSBEHINDERUNG_DURCH_GEGENSTAENDE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_63_GEFAHR_DURCH_GEGENSTAENDE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_210_VERKEHRSBEHINDERUNG_DURCH_VERLORENE_LADUNG);
		list.add(ZUSTAND_359_GEFAHR_DURCH_VERLORENE_LADUNG);
		list.add(ZUSTAND_903_VERKEHRSBEHINDERUNG_DURCH_AUSGELAUFENE_FLUESSIGKEITEN_AUF_DER_STRASSE);
		list.add(ZUSTAND_984_GEFAHR_DURCH_AUSGELAUFENE_FLUESSIGKEITEN_AUF_DER_STRASSE);
		list.add(ZUSTAND_904_VERKEHRSBEHINDERUNG_DURCH_STURMSCHAEDEN);
		list.add(ZUSTAND_986_GEFAHR_DURCH_STURMSCHAEDEN);
		list.add(ZUSTAND_972_MIT_STURMSCHAEDEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_905_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTE_BAEUME);
		list.add(ZUSTAND_906_GEFAHR_DURCH_UMGESTUERZTE_BAEUME);
		list.add(ZUSTAND_973_VERKEHRSBEHINDERUNG_DURCH_HERUNTERHAENGENDE_STROMKABEL);
		list.add(ZUSTAND_989_GEFAHR_DURCH_HERUNTERHAENGENDE_STROMKABEL);
		list.add(ZUSTAND_907_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER);
		list.add(ZUSTAND_900_MIT_HOCHWASSER_IST_ZU_RECHNEN);
		list.add(ZUSTAND_908_GEFAHR_DURCH_HOCHWASSER);
		list.add(ZUSTAND_974_VERKEHRSBEHINDERUNG_DURCH_UEBERLASTETE_ABFLUSSKANAELE);
		list.add(ZUSTAND_990_GEFAHR_DURCH_UEBERLASTETE_ABFLUSSKANAELE);
		list.add(ZUSTAND_909_VERKEHRSBEHINDERUNG_DURCH_UEBERFLUTUNG);
		list.add(ZUSTAND_910_UEBERFLUTUNGSGEFAHR);
		list.add(ZUSTAND_991_GEFAHR_DURCH_UEBERFLUTUNG);
		list.add(ZUSTAND_911_VERKEHRSBEHINDERUNG_DURCH_LAWINEN);
		list.add(ZUSTAND_992_GEFAHR_DURCH_LAWINEN);
		list.add(ZUSTAND_912_VERKEHRSBEHINDERUNG_DURCH_DROHENDE_LAWINEN);
		list.add(ZUSTAND_994_LAWINENGEFAHR);
		list.add(ZUSTAND_975_VERKEHRSBEHINDERUNG_DURCH_EISGLAETTE);
		list.add(ZUSTAND_913_VERKEHRSBEHINDERUNG_DURCH_STEINSCHLAG);
		list.add(ZUSTAND_998_GEFAHR_DURCH_STEINSCHLAG);
		list.add(ZUSTAND_914_VERKEHRSBEHINDERUNG_DURCH_ERDRUTSCH);
		list.add(ZUSTAND_999_GEFAHR_DURCH_ERDRUTSCH);
		list.add(ZUSTAND_976_VERKEHRSBEHINDERUNG_DURCH_SCHLAMMLAWINE);
		list.add(ZUSTAND_915_VERKEHRSBEHINDERUNG_DURCH_ERDBEBENSCHAEDEN);
		list.add(ZUSTAND_1000_GEFAHR_DURCH_ERDBEBENSCHAEDEN);
		list.add(ZUSTAND_917_VERKEHRSBEHINDERUNG_DURCH_ABSENKUNG_DER_FAHRBAHN);
		list.add(ZUSTAND_1026_GEFAHR_DURCH_ABSENKUNG_DER_FAHRBAHN);
		list.add(ZUSTAND_918_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN);
		list.add(ZUSTAND_1030_GEFAHR_DURCH_UNTERSPUELUNG_DER_FAHRBAHN);
		list.add(ZUSTAND_919_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG);
		list.add(ZUSTAND_1031_GEFAHR_DURCH_GEPLATZTE_WASSERLEITUNG);
		list.add(ZUSTAND_62_VERKEHRSBEHINDERUNG_DURCH_ROHRBRUCH);
		list.add(ZUSTAND_64_GEFAHR_DURCH_ROHRBRUCH);
		list.add(ZUSTAND_920_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS);
		list.add(ZUSTAND_1032_GEFAHR_DURCH_AUSSTROEMENDES_GAS);
		list.add(ZUSTAND_977_VERKEHRSBEHINDERUNG_DURCH_GRASBRAND);
		list.add(ZUSTAND_921_VERKEHRSBEHINDERUNG_DURCH_GROSSBRAND);
		list.add(ZUSTAND_1033_GEFAHR_DURCH_GROSSBRAND);
		list.add(ZUSTAND_978_FLUGZEUGABSTURZ);
		list.add(ZUSTAND_979_ZUGUNGLUECK);
		list.add(ZUSTAND_983_VERKEHRSBEHINDERUNG_DURCH_VERLORENE_LADUNG_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_985_VERKEHRSBEHINDERUNG_DURCH_STURMSCHAEDEN_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_927_VERKEHRSBEHINDERUNG_DURCH_UMGESTUERZTE_BAEUME_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_988_VERKEHRSBEHINDERUNG_DURCH_HERUNTERHAENGENDE_STROMKABEL_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_942_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_944_VERKEHRSBEHINDERUNG_DURCH_LAWINEN_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_996_GLATTEISGEFAHR_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_946_VERKEHRSBEHINDERUNG_DURCH_STEINSCHLAG_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_948_VERKEHRSBEHINDERUNG_DURCH_ERDRUTSCH_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_955_VERKEHRSBEHINDERUNG_DURCH_ABSENKUNG_DER_FAHRBAHN_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_950_ABSENKUNG_DER_FAHRBAHN_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI);
		list.add(ZUSTAND_997_EISGLAETTE_FUER_BEIDE_RICHTUNGEN_NUR_EIN_FAHRSTREIFEN_ABWECHSELND_FREI);
		list.add(ZUSTAND_1709_VERSCHMUTZUNG_DURCH_EIN_FAHRENDES_FAHRZEUG);
		list.add(ZUSTAND_1700_VERKEHRSBEHINDERUNG_DURCH_LANGSAM_FAHRENDES_WARTUNGSFAHRZEUG);
		list.add(ZUSTAND_898_HINDERNISSE_BESEITIGT_);
		list.add(ZUSTAND_899_VERKEHRSBEHINDERUNG_DURCH_AUFRAEUMARBEITEN_STRASSE_WIEDER_FREI);
		list.add(ZUSTAND_970_STRASSE_WIEDER_FREI);
		list.add(ZUSTAND_1712_STRASSE_GERAEUMT_BEHINDERUNGEN_AUF_DER_FAHRBAHN_);
		list.add(ZUSTAND_1084_VERKEHRSBEHINDERUNG_DURCH_FEUER);
		list.add(ZUSTAND_1085_WALDBRAND);
		list.add(ZUSTAND_1086_FAHRZEUG_UNTER_EINER_BRUECKE_EINGEKLEMMT);
		list.add(ZUSTAND_971_MELDUNG_AUFGEHOBEN_BEHINDERUNGEN_AUF_DER_FAHRBAHN_);
		list.add(ZUSTAND_922_VERKEHRSBEHINDERUNG_DURCH_TIERE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1471_SCHAULUSTIGE_BEHINDERN_ZUGANG);
		list.add(ZUSTAND_1472_VERKEHRSBEHINDERUNG_DURCH_PERSONEN_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1473_VERKEHRSBEHINDERUNG_DURCH_KINDER_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1474_VERKEHRSBEHINDERUNG_DURCH_FAHRRADFAHRER_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_923_GEFAHR_DURCH_TIERE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1482_GEFAHR_DURCH_PERSONEN_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1483_KINDER_AUF_DER_FAHRBAHN_GEFAHR);
		list.add(ZUSTAND_1484_GEFAHR_DURCH_FAHRRADFAHRER_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1067_VERKEHRSBEHINDERUNG_DURCH_GROESSERE_TIERE_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1068_VERKEHRSBEHINDERUNG_DURCH_TIERHERDEN_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_852_VERKEHRSBEHINDERUNG_DURCH_BAUSTELLENFAHRZEUGE);
		list.add(ZUSTAND_856_GEFAHR_DURCH_BAUSTELLENFAHRZEUGE);
		list.add(ZUSTAND_706_MARKIERUNGSARBEITEN);
		list.add(ZUSTAND_824_GEFAHR_DURCH_MARKIERUNGSARBEITEN);
		list.add(ZUSTAND_1771_GEFAHR_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_857_UNGESICHERTE_UNFALLSTELLE);
		list.add(ZUSTAND_858_GEFAHR_DURCH_UNGESICHERTE_UNFALLSTELLE);
		list.add(ZUSTAND_859_UNBELEUCHTETES_FAHRZEUG_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_860_GEFAHR_DURCH_UNBELEUCHTETES_FAHRZEUG_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_861_SCHNEEBRUCH);
		list.add(ZUSTAND_862_GEFAHR_DURCH_SCHNEEBRUCH);
		list.add(ZUSTAND_897_ACHTUNG_PERSONEN_WERFEN_GEGENSTAENDE_AUF_DIE_FAHRBAHN);
		list.add(ZUSTAND_1991_GEFAHR_DURCH_AUF_DER_FAHRBAHN_ABGESTELLTE_FAHRZEUGE);
		list.add(ZUSTAND_1498_POLIZEIEINSATZ);
		list.add(ZUSTAND_1499_NOTARZTTEAM_IM_EINSATZ);
		list.add(ZUSTAND_2030_MELDUNG_AUFGEHOBEN_GEFAEHRLICHE_SITUATIONEN_);
		list.add(ZUSTAND_1035_NICHT_PASSIERBAR);
		list.add(ZUSTAND_1036_FAST_NICHT_PASSIERBAR);
		list.add(ZUSTAND_1037_SEHR_GEFAEHRLICHE_FAHRBEDINGUNGEN);
		list.add(ZUSTAND_1073_MIT_SEHR_GEFAEHRLICHEN_FAHRBEDINGUNGEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1001_GEFAEHRLICHE_FAHRBEDINGUNGEN);
		list.add(ZUSTAND_1038_SCHWIERIGE_FAHRBEDINGUNGEN);
		list.add(ZUSTAND_1039_MIT_VORSICHT_PASSIERBAR);
		list.add(ZUSTAND_1040_PASSIERBAR);
		list.add(ZUSTAND_1063_FUER_SCHWERVERKEHR_NICHT_PASSIERBAR);
		list.add(ZUSTAND_1064_NICHT_PASSIERBAR_FUER_FAHRZEUGE_MIT_ANHAENGER);
		list.add(ZUSTAND_1041_VERKEHRSBEHINDERUNG_DURCH_WASSER_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1002_AQUAPLANINGGEFAHR);
		list.add(ZUSTAND_1003_STRASSENGLAETTE);
		list.add(ZUSTAND_1004_VERKEHRSBEHINDERUNG_DURCH_VERSCHMUTZTE_FAHRBAHN);
		list.add(ZUSTAND_1055_GEFAHR_DURCH_VERSCHMUTZTE_FAHRBAHN);
		list.add(ZUSTAND_1005_RUTSCHGEFAHR_DURCH_LAUB);
		list.add(ZUSTAND_1042_VERKEHRSBEHINDERUNG_DURCH_SAND);
		list.add(ZUSTAND_1043_VERKEHRSBEHINDERUNG_DURCH_ROLLSPLITT);
		list.add(ZUSTAND_1056_GEFAHR_DURCH_ROLLSPLITT);
		list.add(ZUSTAND_1044_VERKEHRSBEHINDERUNG_DURCH_OELSPUR);
		list.add(ZUSTAND_1057_GEFAHR_DURCH_OELSPUR);
		list.add(ZUSTAND_1045_VERKEHRSBEHINDERUNG_DURCH_AUSLAUFENDEN_KRAFTSTOFF);
		list.add(ZUSTAND_1058_GEFAHR_DURCH_AUSLAUFENDEN_KRAFTSTOFF);
		list.add(ZUSTAND_916_STRASSENSCHAEDEN);
		list.add(ZUSTAND_1059_GEFAHR_DURCH_STRASSENSCHAEDEN);
		list.add(ZUSTAND_1006_GLATTEIS);
		list.add(ZUSTAND_1007_GLATTEISGEFAHR);
		list.add(ZUSTAND_1047_TEILWEISE_VEREISTE_FAHRBAHN);
		list.add(ZUSTAND_1048_GEFAHR_DURCH_STRASSENGLAETTE);
		list.add(ZUSTAND_1008_BLITZEIS);
		list.add(ZUSTAND_1050_GEFAHR_DURCH_BLITZEIS);
		list.add(ZUSTAND_1009_UEBERFRIERENDE_NAESSE);
		list.add(ZUSTAND_1074_MIT_UEBERFRIERENDER_NAESSE_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1010_TEILWEISE_NASSE_UND_VEREISTE_FAHRBAHN);
		list.add(ZUSTAND_1011_SCHNEEMATSCH);
		list.add(ZUSTAND_1012_SCHNEEBEDECKTE_FAHRBAHN);
		list.add(ZUSTAND_1013_SCHNEEGLAETTE);
		list.add(ZUSTAND_1014_NEUSCHNEE);
		list.add(ZUSTAND_1015_TIEFER_SCHNEE);
		list.add(ZUSTAND_1016_SCHNEEVERWEHUNGEN);
		list.add(ZUSTAND_1018_RUTSCHGEFAHR_DURCH_SCHNEEGLAETTE);
		list.add(ZUSTAND_1019_REIFGLAETTE);
		list.add(ZUSTAND_1017_RUTSCHGEFAHR_DURCH_AUSGELAUFENE_FLUESSIGKEITEN);
		list.add(ZUSTAND_1054_RUTSCHGEFAHR_DURCH_SAND_AUF_DER_FAHRBAHN);
		list.add(ZUSTAND_1060_TEILWEISE_VEREISTE_FAHRBAHN_AUF_BRUECKEN);
		list.add(ZUSTAND_1061_GEFAHR_DURCH_STRASSENGLAETTE_AUF_BRUECKEN);
		list.add(ZUSTAND_1062_TEILWEISE_VEREISTE_FAHRBAHN_AUF_BRUECKEN_IN_SCHATTIGEN_BEREICHEN_UND_IN_ANSCHLUSSSTELLEN);
		list.add(ZUSTAND_1020_SCHNEE_STRASSE_BLOCKIERT);
		list.add(ZUSTAND_1075_SCHNEE_GEFAHR_VON_BLOCKIERTEN_STRASSEN);
		list.add(ZUSTAND_1024_STRASSENVERHAELTNISSE_HABEN_SICH_WIEDER_GEBESSERT);
		list.add(ZUSTAND_1070_SCHNEE_GERAEUMT);
		list.add(ZUSTAND_1065_FAHRBEDINGUNGEN_HABEN_SICH_GEBESSERT);
		list.add(ZUSTAND_1069_RUTSCHGEFAHR_HAT_ABGENOMMEN);
		list.add(ZUSTAND_1165_REGEN_GEHT_IN_SCHNEE_UEBER);
		list.add(ZUSTAND_1166_SCHNEE_GEHT_IN_REGEN_UEBER);
		list.add(ZUSTAND_1025_MELDUNG_AUFGEHOBEN_STRASSENZUSTAND_);
		list.add(ZUSTAND_2043_STRASSE_GESTREUT);
		list.add(ZUSTAND_2044_GEFAHR_DURCH_SCHNEERESTE);
		list.add(ZUSTAND_2045_SCHNEERESTE);
		list.add(ZUSTAND_1083_AKTUELLE_TEMPERATUR);
		list.add(ZUSTAND_1115_STARKER_FROST);
		list.add(ZUSTAND_1116_FROST);
		list.add(ZUSTAND_1079_SCHNELL_FALLENDE_TEMPERATUR);
		list.add(ZUSTAND_1080_EXTREME_HITZE);
		list.add(ZUSTAND_1081_EXTREME_KAELTE);
		list.add(ZUSTAND_1082_TEMPERATUREN_HABEN_SICH_NORMALISIERT);
		list.add(ZUSTAND_1127_MELDUNG_AUFGEHOBEN_TEMPERATUREN_);
		list.add(ZUSTAND_1132_STARKER_HAGEL);
		list.add(ZUSTAND_1174_STARKER_HAGEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1106_HAGEL);
		list.add(ZUSTAND_1107_SCHNEEREGEN);
		list.add(ZUSTAND_1108_GEWITTER);
		list.add(ZUSTAND_1128_SCHNEESTURM);
		list.add(ZUSTAND_1130_BLIZZARD);
		list.add(ZUSTAND_1173_BLIZZARD_ZU_ERWARTEN);
		list.add(ZUSTAND_1101_STARKER_SCHNEEFALL);
		list.add(ZUSTAND_1170_STARKER_SCHNEEFALL_ZU_ERWARTEN);
		list.add(ZUSTAND_1134_STARKER_SCHNEEFALL_SICHTBEHINDERUNG);
		list.add(ZUSTAND_1102_STARKER_SCHNEEFALL_SICHTWEITEN_UNTER_30_M);
		list.add(ZUSTAND_1103_STARKER_SCHNEEFALL_SICHTWEITEN_UNTER_50_M);
		list.add(ZUSTAND_1104_SCHNEEFALL);
		list.add(ZUSTAND_1135_SICHTBEHINDERUNG_DURCH_SCHNEEFALL);
		list.add(ZUSTAND_1105_SCHNEEFALL_SICHTWEITEN_UNTER_100_M);
		list.add(ZUSTAND_1109_STARKER_REGEN);
		list.add(ZUSTAND_1171_STARKER_REGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1136_SICHTBEHINDERUNG_DURCH_STARKEN_REGEN);
		list.add(ZUSTAND_1110_STARKER_REGEN_SICHTWEITEN_UNTER_30_M);
		list.add(ZUSTAND_1111_STARKER_REGEN_SICHTWEITEN_UNTER_50_M);
		list.add(ZUSTAND_1112_REGEN);
		list.add(ZUSTAND_1137_SICHTBEHINDERUNG_DURCH_REGEN);
		list.add(ZUSTAND_1113_REGEN_SICHTWEITEN_UNTER_100_M);
		list.add(ZUSTAND_1114_REGENSCHAUER);
		list.add(ZUSTAND_1318_SICHTBEHINDERUNG);
		list.add(ZUSTAND_1319_SICHTWEITEN_UNTER_30_M);
		list.add(ZUSTAND_1320_SICHTWEITEN_UNTER_50_M);
		list.add(ZUSTAND_1321_SICHTWEITEN_UNTER_100_M);
		list.add(ZUSTAND_1175_SICHTBEHINDERUNGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1322_NEBEL);
		list.add(ZUSTAND_1323_SCHNEETREIBEN);
		list.add(ZUSTAND_1309_SICHTBEHINDERUNG_DURCH_RAUCH);
		list.add(ZUSTAND_1324_GEFAHR_DURCH_SPRITZWASSER);
		list.add(ZUSTAND_1325_SICHTBEHINDERUNG_DURCH_TIEFSTEHENDE_SONNE);
		list.add(ZUSTAND_1310_SICHTBEHINDERUNG_DURCH_STAUB);
		list.add(ZUSTAND_1326_SICHTBEHINDERUNG_DURCH_SANDSTURM);
		list.add(ZUSTAND_1340_SICHTBEHINDERUNG_DURCH_INSEKTENSCHWAERME);
		list.add(ZUSTAND_1301_SICHTBEHINDERUNG_DURCH_DICHTEN_NEBEL);
		list.add(ZUSTAND_1177_SICHTBEHINDERUNG_DURCH_DICHTEN_NEBEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1304_SICHTBEHINDERUNG_DURCH_NEBEL);
		list.add(ZUSTAND_1307_SICHTBEHINDERUNG_DURCH_NEBELBAENKE);
		list.add(ZUSTAND_1178_SICHTBEHINDERUNG_DURCH_NEBELBAENKE_ZU_ERWARTEN);
		list.add(ZUSTAND_1308_SICHTBEHINDERUNG_DURCH_GEFRIERENDEN_NEBEL);
		list.add(ZUSTAND_1337_SICHTBEHINDERUNG_DURCH_GEFRIERENDEN_NEBEL_STRASSENGLAETTE);
		list.add(ZUSTAND_1176_SICHTBEHINDERUNG_DURCH_GEFRIERENDEN_NEBEL_ZU_ERWARTEN_GEFAHR_VON_STRASSENGLAETTE);
		list.add(ZUSTAND_1302_DICHTER_NEBEL_SICHTWEITEN_UNTER_30_M);
		list.add(ZUSTAND_1303_DICHTER_NEBEL_SICHTWEITEN_UNTER_50_M);
		list.add(ZUSTAND_1305_NEBEL_SICHTWEITEN_UNTER_100_M);
		list.add(ZUSTAND_1312_SICHTBEHINDERUNG_DURCH_SCHNEEFALL_UND_NEBEL);
		list.add(ZUSTAND_1346_NEBELWARNUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1345_NEBEL_LOEST_SICH_AUF);
		list.add(ZUSTAND_1313_DIE_SICHT_HAT_SICH_VERBESSERT);
		list.add(ZUSTAND_1179_VERBESSERTE_SICHTBEDINGUNGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1172_WETTERBESSERUNG_ZU_ERWARTEN);
		list.add(ZUSTAND_1126_WETTERSITUATION_HAT_SICH_GEBESSERT);
		list.add(ZUSTAND_1180_SCHLECHTWETTERWARNUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1314_MELDUNG_AUFGEHOBEN_NIEDERSCHLAG_UND_SICHTBEHINDERUNGEN_);
		list.add(ZUSTAND_1201_WIRBELSTURM);
		list.add(ZUSTAND_1202_ORKAN);
		list.add(ZUSTAND_1203_ORKANARTIGE_STUERME);
		list.add(ZUSTAND_1204_STURM);
		list.add(ZUSTAND_1205_STARKER_WIND);
		list.add(ZUSTAND_1209_WINDBOEEN);
		list.add(ZUSTAND_1210_SEITENWIND);
		list.add(ZUSTAND_1211_STARKER_WIND_BEHINDERUNG_FUER_FAHRZEUGE_MIT_HOHEN_AUFBAUTEN);
		list.add(ZUSTAND_1190_STARKER_SMOG);
		list.add(ZUSTAND_1191_STARKE_LUFTVERSCHMUTZUNG);
		list.add(ZUSTAND_1217_WIRBELSTURMWARNUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1213_STARKE_WINDE_HABEN_NACHGELASSEN);
		list.add(ZUSTAND_1214_MELDUNG_AUFGEHOBEN_WIND_UND_LUFTQUALITAET_);
		list.add(ZUSTAND_1664_FAHRZEUGKORSO);
		list.add(ZUSTAND_1497_MANOEVER);
		list.add(ZUSTAND_1449_SICHERHEITSUEBUNG);
		list.add(ZUSTAND_1501_VERANSTALTUNG);
		list.add(ZUSTAND_1590_MEHRERE_VERANSTALTUNGEN);
		list.add(ZUSTAND_1502_SPORTVERANSTALTUNG);
		list.add(ZUSTAND_1450_INTERNATIONALE_SPORTVERANSTALTUNG);
		list.add(ZUSTAND_1451_SPIEL);
		list.add(ZUSTAND_1452_TURNIER);
		list.add(ZUSTAND_1453_LEICHTATHLETIKVERANSTALTUNG);
		list.add(ZUSTAND_1454_BALLSPIEL);
		list.add(ZUSTAND_1455_BOXTURNIER);
		list.add(ZUSTAND_1456_STIERKAMPF);
		list.add(ZUSTAND_1457_CRICKET_SPIEL);
		list.add(ZUSTAND_1458_RADRENNEN);
		list.add(ZUSTAND_1459_FUSSBALLSPIEL);
		list.add(ZUSTAND_1460_GOLFTURNIER);
		list.add(ZUSTAND_1461_MARATHONLAUF);
		list.add(ZUSTAND_1462_PFERDERENNEN);
		list.add(ZUSTAND_1463_RUGBYSPIEL);
		list.add(ZUSTAND_1464_SPRINGREITEN);
		list.add(ZUSTAND_1465_TENNISTURNIER);
		list.add(ZUSTAND_1466_WASSERSPORTVERANSTALTUNG);
		list.add(ZUSTAND_1467_WINTERSPORTVERANSTALTUNG);
		list.add(ZUSTAND_1503_AUFFUEHRUNG);
		list.add(ZUSTAND_1504_FESTSPIELE);
		list.add(ZUSTAND_1505_AUSSTELLUNG);
		list.add(ZUSTAND_1507_MARKT);
		list.add(ZUSTAND_1506_VOLKSFEST);
		list.add(ZUSTAND_1468_JAHRMARKT);
		list.add(ZUSTAND_1469_MESSE);
		list.add(ZUSTAND_1508_FEIERLICHE_VERANSTALTUNG);
		list.add(ZUSTAND_1509_STAATSBESUCH);
		list.add(ZUSTAND_1510_PARADE);
		list.add(ZUSTAND_1470_PROZESSION);
		list.add(ZUSTAND_1511_MENSCHENANSAMMLUNG);
		list.add(ZUSTAND_1475_STREIK);
		list.add(ZUSTAND_1512_UMZUG);
		list.add(ZUSTAND_1513_DEMONSTRATION);
		list.add(ZUSTAND_1514_STOERUNG_DER_OEFFENTLICHEN_SICHERHEIT);
		list.add(ZUSTAND_1591_INFORMATION_UEBER_VERANSTALTUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1493_DIE_DURCH_EINE_SPORTVERANSTALTUNG_BEDINGTE_VERKEHRSBELASTUNG_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1496_VERKEHRSBEHINDERUNG_BESEITIGT);
		list.add(ZUSTAND_1592_MOTORSPORTVERANSTALTUNG);
		list.add(ZUSTAND_1593_BASEBALLSPIEL);
		list.add(ZUSTAND_1594_BASKETBALLSPIEL);
		list.add(ZUSTAND_1595_BOOTSRENNEN);
		list.add(ZUSTAND_1596_KONZERTVERANSTALTUNG);
		list.add(ZUSTAND_1597_HOCKEYSPIEL);
		list.add(ZUSTAND_1585_MELDUNG_AUFGEHOBEN_VERANSTALTUNGEN_);
		list.add(ZUSTAND_1515_SICHERHEITSMASSNAHMEN);
		list.add(ZUSTAND_1476_SICHERHEITSVORFALL);
		list.add(ZUSTAND_1477_POLIZEIKONTROLLE);
		list.add(ZUSTAND_1516_BOMBENENTSCHAERFUNG);
		list.add(ZUSTAND_1478_TERRORANSCHLAG);
		list.add(ZUSTAND_1479_GEFAHR_DURCH_SCHUSSWECHSEL);
		list.add(ZUSTAND_1480_KATASTROPHENALARM);
		list.add(ZUSTAND_1481_GEFAHR_DURCH_LUFTANGRIFF);
		list.add(ZUSTAND_1494_EVAKUIERUNG);
		list.add(ZUSTAND_1500_KINDESENTFUEHRUNG);
		list.add(ZUSTAND_1587_LUFTALARM_AUFGEHOBEN);
		list.add(ZUSTAND_1492_KEINE_BEEINTRAECHTIGUNGEN_DURCH_SICHERHEITSMASSNAHMEN_MEHR);
		list.add(ZUSTAND_1588_KATASTROPHENALARM_AUFGEHOBEN);
		list.add(ZUSTAND_2033_MELDUNG_AUFGEHOBEN_SICHERHEITSVORFAELLE_);
		list.add(ZUSTAND_1601_ZEITVERLUST);
		list.add(ZUSTAND_1607_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1650_ES_KANN_ZU_VERZOEGERUNGEN_KOMMEN);
		list.add(ZUSTAND_1621_ZEITVERLUST_BIS_ZU_5_MIN);
		list.add(ZUSTAND_1622_ZEITVERLUST_BIS_ZU_10_MIN);
		list.add(ZUSTAND_1602_ZEITVERLUST_BIS_ZU_15_MIN);
		list.add(ZUSTAND_1623_ZEITVERLUST_BIS_ZU_20_MIN);
		list.add(ZUSTAND_1624_ZEITVERLUST_BIS_ZU_25_MIN);
		list.add(ZUSTAND_1603_ZEITVERLUST_BIS_ZU_30_MIN);
		list.add(ZUSTAND_1625_ZEITVERLUST_BIS_ZU_40_MIN);
		list.add(ZUSTAND_1626_ZEITVERLUST_BIS_ZU_50_MIN);
		list.add(ZUSTAND_1604_ZEITVERLUST_BIS_ZU_1_STUNDE);
		list.add(ZUSTAND_1627_ZEITVERLUST_BIS_ZU_90_MIN);
		list.add(ZUSTAND_1605_ZEITVERLUST_BIS_ZU_2_STUNDEN);
		list.add(ZUSTAND_1628_ZEITVERLUST_BIS_ZU_3_STUNDEN);
		list.add(ZUSTAND_1629_ZEITVERLUST_BIS_ZU_4_STUNDEN);
		list.add(ZUSTAND_1630_ZEITVERLUST_BIS_ZU_5_STUNDEN);
		list.add(ZUSTAND_1606_ZEITVERLUST_MEHRERE_STUNDEN);
		list.add(ZUSTAND_1608_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1631_SEHR_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1632_ZEITVERLUST_UNBESTIMMTER_DAUER);
		list.add(ZUSTAND_247_UNFALL_ZEITVERLUST);
		list.add(ZUSTAND_248_UNFALL_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_249_UNFALL_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_200_UNFALL_MIT_MEHREREN_FAHRZEUGEN_ZEITVERLUST);
		list.add(ZUSTAND_275_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_ZEITVERLUST);
		list.add(ZUSTAND_276_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_277_VERKEHRSBEHINDERUNG_DURCH_NEUGIERIGE_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_310_VERLORENE_LADUNG_ZEITVERLUST);
		list.add(ZUSTAND_311_VERLORENE_LADUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_312_VERLORENE_LADUNG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_375_UMGESTUERZTES_FAHRZEUG_ZEITVERLUST);
		list.add(ZUSTAND_376_UMGESTUERZTES_FAHRZEUG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_377_UMGESTUERZTES_FAHRZEUG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_388_VORAUSGEGANGENER_UNFALL_ZEITVERLUST);
		list.add(ZUSTAND_390_VORAUSGEGANGENER_UNFALL_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_330_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_ZEITVERLUST);
		list.add(ZUSTAND_331_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_332_VERKEHRSBEHINDERUNG_DURCH_DEFEKTES_FAHRZEUG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_435_GESPERRT_ZEITVERLUST);
		list.add(ZUSTAND_436_GESPERRT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_437_GESPERRT_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_463_BLOCKIERT_ZEITVERLUST);
		list.add(ZUSTAND_464_BLOCKIERT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_465_BLOCKIERT_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_747_BAUSTELLE_ZEITVERLUST);
		list.add(ZUSTAND_748_BAUSTELLE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_749_BAUSTELLE_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_780_FAHRBAHNERNEUERUNG_ZEITVERLUST);
		list.add(ZUSTAND_781_FAHRBAHNERNEUERUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_782_FAHRBAHNERNEUERUNG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_840_ARBEITEN_AN_WASSERLEITUNGEN_ZEITVERLUST);
		list.add(ZUSTAND_841_ARBEITEN_AN_WASSERLEITUNGEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_842_ARBEITEN_AN_WASSERLEITUNGEN_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_843_ARBEITEN_AN_GASLEITUNGEN_ZEITVERLUST);
		list.add(ZUSTAND_844_ARBEITEN_AN_GASLEITUNGEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_845_ARBEITEN_AN_GASLEITUNGEN_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_846_ARBEITEN_AN_ERDKABELN_ZEITVERLUST);
		list.add(ZUSTAND_847_ARBEITEN_AN_ERDKABELN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_848_ARBEITEN_AN_ERDKABELN_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_849_TIEFBAUARBEITEN_ZEITVERLUST);
		list.add(ZUSTAND_850_TIEFBAUARBEITEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_851_TIEFBAUARBEITEN_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_939_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_ZEITVERLUST);
		list.add(ZUSTAND_940_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_941_VERKEHRSBEHINDERUNG_DURCH_HOCHWASSER_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1027_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN_ZEITVERLUST);
		list.add(ZUSTAND_1028_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1029_VERKEHRSBEHINDERUNG_DURCH_UNTERSPUELUNG_DER_FAHRBAHN_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_958_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG_ZEITVERLUST);
		list.add(ZUSTAND_959_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_960_VERKEHRSBEHINDERUNG_DURCH_GEPLATZTE_WASSERLEITUNG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_962_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS_ZEITVERLUST);
		list.add(ZUSTAND_963_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_964_VERKEHRSBEHINDERUNG_DURCH_AUSSTROEMENDES_GAS_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_966_VERKEHRSBEHINDERUNG_DURCH_FEUER_ZEITVERLUST);
		list.add(ZUSTAND_967_VERKEHRSBEHINDERUNG_DURCH_FEUER_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_968_VERKEHRSBEHINDERUNG_DURCH_FEUER_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1528_VERANSTALTUNG_ZEITVERLUST);
		list.add(ZUSTAND_1529_VERANSTALTUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1530_VERANSTALTUNG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1542_SPORTVERANSTALTUNG_ZEITVERLUST);
		list.add(ZUSTAND_1543_SPORTVERANSTALTUNG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1544_SPORTVERANSTALTUNG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1556_VOLKSFEST_ZEITVERLUST);
		list.add(ZUSTAND_1557_VOLKSFEST_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1558_VOLKSFEST_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1560_PARADE_ZEITVERLUST);
		list.add(ZUSTAND_1561_PARADE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1562_PARADE_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1564_STREIK_ZEITVERLUST);
		list.add(ZUSTAND_1565_STREIK_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1566_STREIK_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1568_DEMONSTRATION_ZEITVERLUST);
		list.add(ZUSTAND_1569_DEMONSTRATION_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1570_DEMONSTRATION_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1581_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_ZEITVERLUST);
		list.add(ZUSTAND_1582_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1583_BEEINTRAECHTIGUNG_DURCH_SICHERUNGSMASSNAHMEN_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1486_SICHERHEITSVORFALL_ZEITVERLUST);
		list.add(ZUSTAND_1487_SICHERHEITSVORFALL_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1488_SICHERHEITSVORFALL_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1489_POLIZEIKONTROLLE_ZEITVERLUST);
		list.add(ZUSTAND_1490_POLIZEIKONTROLLE_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1491_POLIZEIKONTROLLE_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1609_ZEITVERLUST_FUER_SCHWERVERKEHR);
		list.add(ZUSTAND_91_ZEITVERLUST_FUER_PKW);
		list.add(ZUSTAND_1642_ZEITVERLUST_FUER_LKW);
		list.add(ZUSTAND_1610_ZEITVERLUST_BIS_ZU_15_MIN_FUER_LKW);
		list.add(ZUSTAND_1611_ZEITVERLUST_BIS_ZU_30_MIN_FUER_LKW);
		list.add(ZUSTAND_1612_ZEITVERLUST_BIS_ZU_1_STUNDE_FUER_LKW);
		list.add(ZUSTAND_1613_ZEITVERLUST_BIS_ZU_2_STUNDEN_FUER_LKW);
		list.add(ZUSTAND_1614_ZEITVERLUST_MEHRERE_STUNDEN_FUER_LKW);
		list.add(ZUSTAND_1643_ZEITVERLUST_FUER_BUSSE);
		list.add(ZUSTAND_1653_ES_IST_MIT_GROSSEM_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1654_ES_IST_MIT_SEHR_GROSSEM_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1757_SCHWERTRANSPORT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1758_SCHWERTRANSPORT_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1756_SCHWERTRANSPORT_ZEITVERLUST);
		list.add(ZUSTAND_1740_DICHTER_VERKEHR_DURCH_SCHWERTRANSPORT_ZEITVERLUST);
		list.add(ZUSTAND_1759_KOLONNENVERKEHR_ZEITVERLUST);
		list.add(ZUSTAND_1760_KOLONNENVERKEHR_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1761_KOLONNENVERKEHR_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1741_DICHTER_VERKEHR_DURCH_FAHRZEUGKOLONNE_ZEITVERLUST);
		list.add(ZUSTAND_1817_AMPELANLAGEN_AUSSER_BETRIEB_ZEITVERLUST);
		list.add(ZUSTAND_1818_AMPELANLAGEN_AUSSER_BETRIEB_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1819_AMPELANLAGEN_AUSSER_BETRIEB_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1868_AMPELANLAGEN_GESTOERT_ZEITVERLUST);
		list.add(ZUSTAND_1869_AMPELANLAGEN_GESTOERT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1870_AMPELANLAGEN_GESTOERT_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1876_PROVISORISCHE_AMPELANLAGE_DEFEKT_ZEITVERLUST);
		list.add(ZUSTAND_1877_PROVISORISCHE_AMPELANLAGE_DEFEKT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1878_PROVISORISCHE_AMPELANLAGE_DEFEKT_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1880_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS_IST_DER_VERKEHRSABLAUF_GESTOERT_ZEITVERLUST);
		list.add(ZUSTAND_1884_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS_IST_DER_VERKEHRSABLAUF_GESTOERT_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1885_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS_IST_DER_VERKEHRSABLAUF_GESTOERT_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1830_STOERUNG_AM_BAHNUEBERGANG_ZEITVERLUST);
		list.add(ZUSTAND_1831_STOERUNG_AM_BAHNUEBERGANG_ES_IST_MIT_ZEITVERLUST_ZU_RECHNEN);
		list.add(ZUSTAND_1832_STOERUNG_AM_BAHNUEBERGANG_GROSSER_ZEITVERLUST);
		list.add(ZUSTAND_1858_SCHNEERAEUMUNG_ZEITVERLUST);
		list.add(ZUSTAND_1648_KEIN_ZEITVERLUST_MEHR);
		list.add(ZUSTAND_1663_KEIN_ZEITVERLUST_MEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1620_MELDUNG_AUFGEHOBEN_ZEITVERLUSTE_);
		list.add(ZUSTAND_1634_AUSFAELLE);
		list.add(ZUSTAND_1652_ES_IST_MIT_AUSFAELLEN_ZU_RECHNEN);
		list.add(ZUSTAND_1615_ABFAHRTEN_GESTOPPT);
		list.add(ZUSTAND_1633_VERKEHR_BIS_AUF_WEITERES_EINGESTELLT);
		list.add(ZUSTAND_1616_ABFAHRT_EINGESTELLT);
		list.add(ZUSTAND_1617_ABFAHRT_AUSGEBUCHT);
		list.add(ZUSTAND_1655_ALLE_ABFAHRTEN_AUSGEBUCHT);
		list.add(ZUSTAND_1906_P_R_IN_BETRIEB);
		list.add(ZUSTAND_1635_P_R_NICHT_IN_BETRIEB);
		list.add(ZUSTAND_1636_SONDERLINIE_IST_EINGERICHTET);
		list.add(ZUSTAND_1637_OEPNV_IST_EINGESTELLT);
		list.add(ZUSTAND_1638_SCHIENENVERKEHR_NICHT_IN_BETRIEB);
		list.add(ZUSTAND_1720_STOERUNGEN_IM_SCHIENENVERKEHR);
		list.add(ZUSTAND_1657_STOERUNGEN_IM_SCHIENENVERKEHR_ZEITVERLUST);
		list.add(ZUSTAND_1658_STOERUNGEN_IM_BUSVERKEHR_ZEITVERLUST);
		list.add(ZUSTAND_1639_BUSVERKEHR_NICHT_IN_BETRIEB);
		list.add(ZUSTAND_1649_S_BAHN_NICHT_IN_BETRIEB);
		list.add(ZUSTAND_1640_PENDELVERKEHR_IST_EINGERICHTET);
		list.add(ZUSTAND_1641_KOSTENLOSER_PENDELVERKEHR);
		list.add(ZUSTAND_1659_STOERUNGEN_IM_U_BAHN_BETRIEB);
		list.add(ZUSTAND_1651_U_BAHN_NICHT_IN_BETRIEB);
		list.add(ZUSTAND_2021_SERVICE_NICHT_IN_BETRIEB_ERSATZVERKEHR);
		list.add(ZUSTAND_2022_AUSFALL_WEGEN_STREIK);
		list.add(ZUSTAND_1721_OEPNV_AUSSER_BETRIEB);
		list.add(ZUSTAND_1661_FAEHRE_AUSSER_BETRIEB);
		list.add(ZUSTAND_1618_ABFAHRT_AUSGEBUCHT_FUER_SCHWERVERKEHR);
		list.add(ZUSTAND_1644_ABFAHRT_AUSGEBUCHT_FUER_LKW);
		list.add(ZUSTAND_1645_ABFAHRT_AUSGEBUCHT_FUER_BUSSE);
		list.add(ZUSTAND_1660_OEPNV_WIEDER_IN_BETRIEB);
		list.add(ZUSTAND_1619_DIE_GEMELDETE_STOERUNG_BESTEHT_NICHT_MEHR_AUSFAELLE_);
		list.add(ZUSTAND_2034_MELDUNG_AUFGEHOBEN_AUSFAELLE_);
		list.add(ZUSTAND_1662_FAHRTDAUER);
		list.add(ZUSTAND_1695_AKTUELLE_FAHRTDAUER);
		list.add(ZUSTAND_1696_ERWARTETE_FAHRTDAUER);
		list.add(ZUSTAND_1656_NAECHSTE_ANKUNFT);
		list.add(ZUSTAND_1901_NAECHSTE_ABFAHRT);
		list.add(ZUSTAND_1902_NAECHSTE_ABFAHRT_FUER_SCHWERVERKEHR);
		list.add(ZUSTAND_1646_NAECHSTE_ABFAHRT_FUER_LKW);
		list.add(ZUSTAND_1647_NAECHSTE_ABFAHRT_FUER_BUSSE);
		list.add(ZUSTAND_2035_MELDUNG_AUFGEHOBEN_REISEINFORMATION_);
		list.add(ZUSTAND_1701_ACHTUNG_IHNEN_KOMMT_EIN_FALSCHFAHRER_ENTGEGEN_NICHT_UEBERHOLEN_VORSICHT_AUF_BEIDEN_RICHTUNGSFAHRBAHNEN_WIR_MELDEN_WENN_DIE_GEFAHR_VORUEBER_IST_);
		list.add(ZUSTAND_1704_GEFAHR_DURCH_RUECKSICHTSLOSE_FAHRER);
		list.add(ZUSTAND_1705_GEFAHR_DURCH_EIN_LANGSAM_FAHRENDES_FAHRZEUG);
		list.add(ZUSTAND_1706_RETTUNGSFAHRZEUGE_IM_EINSATZ);
		list.add(ZUSTAND_1707_ACHTUNG_SCHNELL_FAHRENDE_RETTUNGSFAHRZEUGE_IM_EINSATZ);
		list.add(ZUSTAND_1708_ACHTUNG_GEFAHR_DURCH_VERFOLGUNGSJAGD_);
		list.add(ZUSTAND_1710_FAHRZEUG_VERLIERT_LADUNG_GEFAHR);
		list.add(ZUSTAND_804_WANDERBAUSTELLE);
		list.add(ZUSTAND_1765_GEFAHRGUTTRANSPORT);
		list.add(ZUSTAND_1736_GEFAEHRDUNG_DURCH_GEFAHRGUTFAHRZEUG);
		list.add(ZUSTAND_1768_GEFAHRGUTTRANSPORTE_NAECHSTE_GEEIGNETE_PARKMOEGLICHKEIT_ANFAHREN);
		list.add(ZUSTAND_681_SCHNEERAEUMUNG);
		list.add(ZUSTAND_1711_DIE_GEFAHR_DURCH_RETTUNGSFAHRZEUGE_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1702_DIE_GEFAHR_DURCH_EIN_ENTGEGENKOMMENDES_FAHRZEUG_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1769_GEFAEHRDUNG_DURCH_GEFAHRGUTFAHRZEUG_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_675_STREUFAHRZEUG);
		list.add(ZUSTAND_1703_MELDUNG_AUFGEHOBEN_GEFAEHRLICHE_FAHRZEUGE_);
		list.add(ZUSTAND_347_FAHRZEUG_MIT_UEBERHOEHE);
		list.add(ZUSTAND_1739_GEFAHR_DURCH_TRANSPORT_MIT_UEBERHOEHE);
		list.add(ZUSTAND_1751_SCHWERTRANSPORT);
		list.add(ZUSTAND_1731_GEFAHR_DURCH_SCHWERTRANSPORT);
		list.add(ZUSTAND_1752_TRANSPORT_MIT_UEBERBREITE);
		list.add(ZUSTAND_1732_GEFAHR_DURCH_TRANSPORT_MIT_UEBERBREITE);
		list.add(ZUSTAND_1753_TRANSPORT_MIT_UEBERLAENGE);
		list.add(ZUSTAND_1733_GEFAHR_DURCH_TRANSPORTE_MIT_UEBERLAENGE);
		list.add(ZUSTAND_1754_LANGSAMES_FAHRZEUG);
		list.add(ZUSTAND_1734_GEFAHR_DURCH_LANGSAMES_FAHRZEUG);
		list.add(ZUSTAND_1764_KETTENFAHRZEUG);
		list.add(ZUSTAND_1735_GEFAHR_DURCH_KETTENFAHRZEUG);
		list.add(ZUSTAND_1767_SCHWERTRANSPORT_UEBERHOLEN_NICHT_MOEGLICH);
		list.add(ZUSTAND_1755_KOLONNENVERKEHR);
		list.add(ZUSTAND_1737_GEFAHR_DURCH_KOLONNENVERKEHR);
		list.add(ZUSTAND_1766_MILITAERKOLONNEN);
		list.add(ZUSTAND_1738_GEFAHR_DURCH_MILITAERKOLONNEN);
		list.add(ZUSTAND_1770_KOLONNENVERKEHR_AUFGELOEST);
		list.add(ZUSTAND_1762_VERKEHRSSTOERUNG_BESEITIGT);
		list.add(ZUSTAND_1763_MELDUNG_AUFGEHOBEN_AUSSERGEWOEHNLICHE_LADUNGEN_UND_FAHRZEUGE_);
		list.add(ZUSTAND_1801_SPURWECHSELANLAGEN_AUSSER_BETRIEB);
		list.add(ZUSTAND_1838_SPURWECHSELANLAGEN_DEFEKT);
		list.add(ZUSTAND_1839_SPURWECHSELANLAGEN_IN_BETRIEB);
		list.add(ZUSTAND_1840_WECHSELVERKEHRSZEICHEN_AUSSER_BETRIEB);
		list.add(ZUSTAND_1841_WECHSELVERKEHRSZEICHEN_ARBEITEN_FEHLERHAFT);
		list.add(ZUSTAND_1842_WECHSELVERKEHRSZEICHEN_WIEDER_IN_BETRIEB);
		list.add(ZUSTAND_1802_NOTRUFSAEULEN_AUSGEFALLEN);
		list.add(ZUSTAND_1803_NOTRUF_AUSGEFALLEN);
		list.add(ZUSTAND_1865_NOTRUFSAEULEN_AUSGEFALLEN_POLIZEI_FAEHRT_VERSTAERKT_STREIFE);
		list.add(ZUSTAND_1866_NOTRUFSAEULEN_AUSGEFALLEN_WARTEN_SIE_IM_NOTFALL_AUF_DIE_POLIZEI);
		list.add(ZUSTAND_1804_AMPELANLAGE_AUSSER_BETRIEB);
		list.add(ZUSTAND_1805_AMPELANLAGE_ARBEITET_FEHLERHAFT);
		list.add(ZUSTAND_1843_ZUFAHRTSREGELUNG_AUSSER_BETRIEB);
		list.add(ZUSTAND_1844_ZUFAHRTSREGELUNG_ARBEITET_FEHLERHAFT);
		list.add(ZUSTAND_1845_PROVISORISCHE_AMPELANLAGE_DEFEKT);
		list.add(ZUSTAND_1846_PROVISORISCHE_AMPELANLAGE_ARBEITET_FEHLERHAFT);
		list.add(ZUSTAND_1850_SPURWECHSELANLAGEN_AUSSER_BETRIEB_GEFAHR);
		list.add(ZUSTAND_1864_SPURWECHSELANLAGEN_ARBEITEN_FEHLERHAFT_GEFAHR);
		list.add(ZUSTAND_1867_AMPELANLAGE_AUSSER_BETRIEB_GEFAHR);
		list.add(ZUSTAND_1875_GEFAHR_DURCH_FEHLERHAFT_ARBEITENDE_AMPELANLAGE);
		list.add(ZUSTAND_1879_GEFAHR_DURCH_DEFEKTE_PROVISORISCHE_AMPELANLAGE_);
		list.add(ZUSTAND_1847_STOERUNG_DES_VERKEHRSABLAUFES_WEGEN_AUSFALL_DES_VERKEHRSRECHNERS);
		list.add(ZUSTAND_1848_STEUERUNG_DER_AMPELANLAGE_GEAENDERT);
		list.add(ZUSTAND_1806_STOERUNG_AM_BAHNUEBERGANG);
		list.add(ZUSTAND_1849_TUNNELBELUEFTUNG_AUSGEFALLEN);
		list.add(ZUSTAND_1833_VERKEHRSSTEUERUNG_WIEDER_IN_BETRIEB);
		list.add(ZUSTAND_1834_NOTRUFSAEULE_WIEDER_IN_BETRIEB);
		list.add(ZUSTAND_1835_AMPELANLAGEN_WIEDER_IN_BETRIEB);
		list.add(ZUSTAND_1836_STOERUNG_AM_BAHNUEBERGANG_BESEITIGT);
		list.add(ZUSTAND_1983_STROMAUSFALL);
		list.add(ZUSTAND_1837_MELDUNG_AUFGEHOBEN_STOERUNGEN_AN_LICHTSIGNALANLAGEN_UND_SONSTIGEN_STRASSENAUSRUESTUNGEN_);
		list.add(ZUSTAND_1917_AUTOMATISCHES_MAUTSYSTEM_AUSSER_BETRIEB_BITTE_MANUELL_ZAHLEN);
		list.add(ZUSTAND_1851_VORUEBERGEHENDE_BEGRENZUNG_DER_BREITE);
		list.add(ZUSTAND_1861_VORUEBERGEHENDE_BESCHRAENKUNG_DER_HOEHE);
		list.add(ZUSTAND_1881_VORUEBERGEHENDE_BESCHRAENKUNG_DER_LAENGE);
		list.add(ZUSTAND_1871_VORUEBERGEHENDE_BESCHRAENKUNG_DER_ACHSLAST);
		list.add(ZUSTAND_1872_VORUEBERGEHENDE_BESCHRAENKUNG_DES_ZULAESSIGEN_GESAMTGEWICHTS);
		list.add(ZUSTAND_1852_VORUEBERGEHENDE_BEGRENZUNG_DER_BREITE_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1862_VORUEBERGEHENDE_BESCHRAENKUNG_DER_HOEHE_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1882_VORUEBERGEHENDE_BESCHRAENKUNG_DER_LAENGE_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1874_VORUEBERGEHENDE_BESCHRAENKUNG_DER_ACHSLAST_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1873_VORUEBERGEHENDE_BESCHRAENKUNG_DES_ZULAESSIGEN_GESAMTGEWICHTS_BESTEHT_NICHT_MEHR);
		list.add(ZUSTAND_1857_MELDUNG_AUFGEHOBEN_BESCHRAENKUNGEN_DER_FAHRZEUGMASSE_UND_GEWICHTE_);
		list.add(ZUSTAND_1886_NORMALE_PARKREGELUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1887_BESONDERE_PARKREGELUNG_IN_KRAFT);
		list.add(ZUSTAND_1927_PARKVERBOT);
		list.add(ZUSTAND_1928_BESONDERE_PARKREGELUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1883_MELDUNG_AUFGEHOBEN_PARKREGELUNGEN_);
		list.add(ZUSTAND_1903_PARKPLATZ_BESETZT);
		list.add(ZUSTAND_1922_PARKPLATZ_WEITGEHEND_BESETZT);
		list.add(ZUSTAND_1888_ZU_10_BESETZT);
		list.add(ZUSTAND_1889_ZU_20_BESETZT);
		list.add(ZUSTAND_1890_ZU_30_BESETZT);
		list.add(ZUSTAND_1891_ZU_40_BESETZT);
		list.add(ZUSTAND_1892_ZU_50_BESETZT);
		list.add(ZUSTAND_1893_ZU_60_BESETZT);
		list.add(ZUSTAND_1894_ZU_70_BESETZT);
		list.add(ZUSTAND_1895_ZU_80_BESETZT);
		list.add(ZUSTAND_1896_ZU_90_BESETZT);
		list.add(ZUSTAND_1918_BESETZT);
		list.add(ZUSTAND_1904_ALLE_PARKPLAETZE_BESETZT);
		list.add(ZUSTAND_1924_ALLE_PARKHAEUSER_BESETZT);
		list.add(ZUSTAND_1905_SEHR_WENIGE_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1926_KEINE_STELLPLAETZE_MEHR_FREI);
		list.add(ZUSTAND_1923_ALLE_STELLPLAETZE_WEITGEHEND_BESETZT);
		list.add(ZUSTAND_1920_NUR_WENIGE_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1921_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1897_WENIGER_ALS_10_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1898_WENIGER_ALS_20_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1899_WENIGER_ALS_30_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1900_WENIGER_ALS_40_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1855_WENIGER_ALS_50_STELLPLAETZE_FREI);
		list.add(ZUSTAND_1925_STOERUNGSFREIER_P_R_BETRIEB);
		list.add(ZUSTAND_1934_KEINE_INFORMATIONEN_UEBER_P_R_VERFUEGBAR);
		list.add(ZUSTAND_1990_PARKPLATZ_GESCHLOSSEN_);
		list.add(ZUSTAND_1938_INFORMATIONEN_UEBER_P_R_WIEDER_VERFUEGBAR);
		list.add(ZUSTAND_1856_KEINE_PARKINFORMATIONEN_VERFUEGBAR);
		list.add(ZUSTAND_2038_MELDUNG_AUFGEHOBEN_PARKEN_);
		list.add(ZUSTAND_1913_BITTE_RADIOPROGRAMM_EINSCHALTEN);
		list.add(ZUSTAND_1908_BITTE_RADIOPROGRAMM_EINSCHALTEN_INFORMATION_);
		list.add(ZUSTAND_1929_WICHTIGE_INFORMATIONEN_WERDEN_IM_GESPROCHENEN_PROGRAMM_VERLESEN);
		list.add(ZUSTAND_1931_GENAUE_INFORMATIONEN_WERDEN_IM_GESPROCHENEN_PROGRAMM_VERLESEN);
		list.add(ZUSTAND_1909_ALARMMELDUNG_AUF_DIESER_FREQUENZ);
		list.add(ZUSTAND_1910_NEUE_ALARMMELDUNG_INNERHALB_DER_FESTGESETZTEN_ZEITEN);
		list.add(ZUSTAND_1955_HINWEIS_AUF_DAS_HOERFUNKPROGRAMM_NICHT_MEHR_GUELTIG);
		list.add(ZUSTAND_1911_MELDUNG_AUFGEHOBEN_INFORMATION_);
		list.add(ZUSTAND_1940_ZUSAETZLICHE_REGIONALE_INFORMATIONEN_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR);
		list.add(ZUSTAND_1941_ZUSAETZLICHE_LOKALE_INFORMATIONEN_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR);
		list.add(ZUSTAND_1942_ZUSAETZLICHE_INFORMATIONEN_UEBER_OEPNV_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR);
		list.add(ZUSTAND_1943_NATIONALE_INFORMATIONEN_BEI_EINEM_ANDEREN_TMC_SERVICE_VERFUEGBAR);
		list.add(ZUSTAND_1944_DIESER_SERVICE_BIETET_NUR_UEBERREGIONALE_INFORMATIONEN);
		list.add(ZUSTAND_1945_DIESER_SERVICE_BIETET_NUR_REGIONALE_INFORMATIONEN);
		list.add(ZUSTAND_1946_DIESER_SERVICE_BIETET_NUR_LOKALE_INFORMATIONEN);
		list.add(ZUSTAND_1947_DIESER_SERVICE_BIETET_KEINE_DETAILLIERTE_REGIONALE_INFORMATIONEN);
		list.add(ZUSTAND_1948_DIESER_SERVICE_BIETET_KEINE_DETAILLIERTE_LOKALEN_INFORMATIONEN);
		list.add(ZUSTAND_1932_DETAILINFORMATIONEN_BEI_EINEM_ANDEREM_TMC_SERVICE_VERFUEGBAR);
		list.add(ZUSTAND_1949_DIESER_SERVICE_BIETET_KEINE_GRENZUEBERSCHREITENDEN_INFORMATIONEN);
		list.add(ZUSTAND_1950_INFORMATIONEN_NUR_FUER_DIESES_GEBIET);
		list.add(ZUSTAND_1951_KEINE_NEUEN_VERKEHRSINFORMATIONEN_VERFUEGBAR);
		list.add(ZUSTAND_1952_KEINE_OEPNV_INFORMATIONEN_VERFUEGBAR);
		list.add(ZUSTAND_1953_TMC_AUSSENDUNG_AUF_DIESER_FREQUENZ_WIRD_BEENDET);
		list.add(ZUSTAND_1954_AKTUELLER_TMC_DIENST_WIRD_WIEDER_AUFGENOMMEN);
		list.add(ZUSTAND_1930_KEIN_TMC_SERVICE);
		list.add(ZUSTAND_1914_KEINE_INFORMATION);
		list.add(ZUSTAND_1916_WEGEN_TECHNISCHER_PROBLEME_KEINE_INFORMATION);
		list.add(ZUSTAND_1939_TELEFONSERVICE_MIT_REISEINFORMATIONEN_VERFUEGBAR);
		list.add(ZUSTAND_1956_HINWEISE_AUF_ANDERE_TMC_DIENSTE_NICHT_MEHR_GUELTIG);
		list.add(ZUSTAND_1957_FRUEHERE_AUSSAGEN_UEBER_DIESEN_ODER_ANDERE_TMC_DIENSTE_SIND_NICHT_MEHR_GUELTIG);
		list.add(ZUSTAND_1964_BAHNAUSKUNFT_NICHT_VERFUEGBAR);
		list.add(ZUSTAND_1965_BAHNAUSKUNFT_WIEDER_VERFUEGBAR);
		list.add(ZUSTAND_1966_NAHVERKEHRSINFORMATIONEN_NICHT_VERFUEGBAR);
		list.add(ZUSTAND_1967_NAHVERKEHRSINFORMATIONEN_WIEDER_VERFUEGBAR);
		list.add(ZUSTAND_2039_MELDUNG_AUFGEHOBEN_SERVICE_MELDUNG_);
		list.add(ZUSTAND_1915_TESTMELDUNG);
		list.add(ZUSTAND_1907_NULL_MELDUNG);
		list.add(ZUSTAND_2047_NULL_MELDUNG_SPEZIELLE_MELDUNG_);
		list.add(ZUSTAND_2041_ES_LIEGEN_KEINE_MELDUNGEN_VOR);
		list.add(ZUSTAND_2040_MELDUNG_AUFGEHOBEN_SPEZIELLE_MELDUNG_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsEreignisCode(final 		Integer
	 value) {
		super(value);
	}
	
	private AttRdsEreignisCode(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
