/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Vorhersage-Code.
<p>
Vorhersage-Code entsprechend DIN EN ISO 14819-2 (Tabelle 'FORECAST EVENT LIST', Spalte 'Code')
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
@Wertebereich(
	minimum = 0L,
	maximum = 65535L,
	einheit = ""
)
public class AttRdsVorhersageCode extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("65535");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_0_NICHT_DEFINIERT = new AttRdsVorhersageCode("nicht definiert", 		Integer
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_80_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("80"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_81_MIT_VERKEHRSSTOERUNGEN_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Verkehrsstörungen ist zu rechnen", 		Integer
	.valueOf("81"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_82_BAUSTELLE_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("Baustelle, mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("82"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_83_GESPERRT_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("gesperrt, mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("83"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_84_VERANSTALTUNG_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("Veranstaltung, mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("84"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_85_SPORTVERANSTALTUNG_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("Sportveranstaltung, mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("85"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_86_MESSE_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("Messe, mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("86"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_87_EVAKUIERUNG_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN = new AttRdsVorhersageCode("Evakuierung, mit regem Verkehr ist zu rechnen", 		Integer
	.valueOf("87"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_88_MIT_VERKEHRSSTOERUNGEN_IST_NICHT_MEHR_ZU_RECHNEN = new AttRdsVorhersageCode("mit Verkehrsstörungen ist nicht mehr zu rechnen", 		Integer
	.valueOf("88"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_89_MELDUNG_AUFGEHOBEN = new AttRdsVorhersageCode("Meldung aufgehoben", 		Integer
	.valueOf("89"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1151_STARKER_SCHNEEFALL_ZU_ERWARTEN = new AttRdsVorhersageCode("starker Schneefall zu erwarten", 		Integer
	.valueOf("1151"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1152_SCHNEEFALL_ZU_ERWARTEN = new AttRdsVorhersageCode("Schneefall zu erwarten", 		Integer
	.valueOf("1152"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1129_SCHNEESTURM_ZU_ERWARTEN = new AttRdsVorhersageCode("Schneesturm zu erwarten", 		Integer
	.valueOf("1129"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1131_BLIZZARD_ZU_ERWARTEN = new AttRdsVorhersageCode("Blizzard zu erwarten", 		Integer
	.valueOf("1131"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1133_STARKER_HAGEL_ZU_ERWARTEN = new AttRdsVorhersageCode("starker Hagel zu erwarten", 		Integer
	.valueOf("1133"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1153_HAGEL_ZU_ERWARTEN = new AttRdsVorhersageCode("Hagel zu erwarten", 		Integer
	.valueOf("1153"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1154_SCHNEEREGEN_ZU_ERWARTEN = new AttRdsVorhersageCode("Schneeregen zu erwarten", 		Integer
	.valueOf("1154"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1155_GEWITTER_ZU_ERWARTEN = new AttRdsVorhersageCode("Gewitter zu erwarten", 		Integer
	.valueOf("1155"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1327_SANDSTURM_ZU_ERWARTEN = new AttRdsVorhersageCode("Sandsturm zu erwarten", 		Integer
	.valueOf("1327"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1156_STARKER_REGEN_ZU_ERWARTEN = new AttRdsVorhersageCode("starker Regen zu erwarten", 		Integer
	.valueOf("1156"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1157_REGEN_ZU_ERWARTEN = new AttRdsVorhersageCode("Regen zu erwarten", 		Integer
	.valueOf("1157"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1158_REGENSCHAUER_ZU_ERWARTEN = new AttRdsVorhersageCode("Regenschauer zu erwarten", 		Integer
	.valueOf("1158"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1159_STARKER_FROST_ZU_ERWARTEN = new AttRdsVorhersageCode("starker Frost zu erwarten", 		Integer
	.valueOf("1159"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1160_FROST_ZU_ERWARTEN = new AttRdsVorhersageCode("Frost zu erwarten", 		Integer
	.valueOf("1160"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1117_BEDECKTER_HIMMEL_ZU_ERWARTEN = new AttRdsVorhersageCode("bedeckter Himmel zu erwarten", 		Integer
	.valueOf("1117"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1118_MEIST_BEWOELKTER_HIMMEL_ZU_ERWARTEN = new AttRdsVorhersageCode("meist bewölkter Himmel zu erwarten", 		Integer
	.valueOf("1118"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1119_TEILWEISE_BEWOELKTER_HIMMEL_ZU_ERWARTEN = new AttRdsVorhersageCode("teilweise bewölkter Himmel zu erwarten", 		Integer
	.valueOf("1119"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1120_SONNIGE_ABSCHNITTE_ZU_ERWARTEN = new AttRdsVorhersageCode("sonnige Abschnitte zu erwarten", 		Integer
	.valueOf("1120"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1121_KLARER_HIMMEL_ZU_ERWARTEN = new AttRdsVorhersageCode("klarer Himmel zu erwarten", 		Integer
	.valueOf("1121"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1122_SONNIGES_WETTER_ZU_ERWARTEN = new AttRdsVorhersageCode("sonniges Wetter zu erwarten", 		Integer
	.valueOf("1122"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1123_MEIST_TROCKENES_WETTER_ZU_ERWARTEN = new AttRdsVorhersageCode("meist trockenes Wetter zu erwarten", 		Integer
	.valueOf("1123"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1124_TROCKENES_WETTER_ZU_ERWARTEN = new AttRdsVorhersageCode("trockenes Wetter zu erwarten", 		Integer
	.valueOf("1124"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1125_TEILS_SONNIGES_WETTER_TEILS_REGEN_ZU_ERWARTEN = new AttRdsVorhersageCode("teils sonniges Wetter, teils Regen zu erwarten", 		Integer
	.valueOf("1125"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1315_DICHTER_NEBEL_ZU_ERWARTEN = new AttRdsVorhersageCode("dichter Nebel zu erwarten", 		Integer
	.valueOf("1315"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1306_NEBEL_ZU_ERWARTEN = new AttRdsVorhersageCode("Nebel zu erwarten", 		Integer
	.valueOf("1306"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1316_NEBELBAENKE_ZU_ERWARTEN = new AttRdsVorhersageCode("Nebelbänke zu erwarten", 		Integer
	.valueOf("1316"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1317_GEFRIERENDER_NEBEL_ZU_ERWARTEN = new AttRdsVorhersageCode("gefrierender Nebel zu erwarten", 		Integer
	.valueOf("1317"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1300_MIT_SCHNEEFALL_UND_NEBEL_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Schneefall und Nebel ist zu rechnen", 		Integer
	.valueOf("1300"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1140_WETTERVORHERSAGE_AUFGEHOBEN = new AttRdsVorhersageCode("Wettervorhersage aufgehoben", 		Integer
	.valueOf("1140"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1141_NEBELVORHERSAGE_AUFGEHOBEN = new AttRdsVorhersageCode("Nebelvorhersage aufgehoben", 		Integer
	.valueOf("1141"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1138_SCHLECHTWETTERWARNUNG_AUFGEHOBEN = new AttRdsVorhersageCode("Schlechtwetterwarnung aufgehoben", 		Integer
	.valueOf("1138"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1139_MELDUNG_AUFGEHOBEN_VORHERSAGE_WETTER_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Wetter)", 		Integer
	.valueOf("1139"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1046_GLATTEIS_ERWARTET = new AttRdsVorhersageCode("Glatteis erwartet", 		Integer
	.valueOf("1046"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1049_MIT_TEILWEISE_VEREISTER_FAHRBAHN_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit teilweise vereister Fahrbahn ist zu rechnen", 		Integer
	.valueOf("1049"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1051_MIT_BLITZEIS_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Blitzeis ist zu rechnen", 		Integer
	.valueOf("1051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1052_MIT_GEFRIERENDEM_REGEN_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit gefrierendem Regen ist zu rechnen", 		Integer
	.valueOf("1052"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1053_MIT_SCHNEEVERWEHUNGEN_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Schneeverwehungen ist zu rechnen", 		Integer
	.valueOf("1053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1143_MIT_STRASSENGLAETTE_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Straßenglätte ist zu rechnen", 		Integer
	.valueOf("1143"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1071_STRASSENZUSTANDSVORHERSAGE_AUFGEHOBEN = new AttRdsVorhersageCode("Straßenzustandsvorhersage aufgehoben", 		Integer
	.valueOf("1071"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1072_MELDUNG_AUFGEHOBEN_VORHERSAGE_STRASSENZUSTAND_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Straßenzustand)", 		Integer
	.valueOf("1072"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1328_GUTE_LUFTQUALITAET_ZU_ERWARTEN = new AttRdsVorhersageCode("gute Luftqualität zu erwarten", 		Integer
	.valueOf("1328"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1329_NORMALE_LUFTQUALITAET_ZU_ERWARTEN = new AttRdsVorhersageCode("normale Luftqualität zu erwarten", 		Integer
	.valueOf("1329"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1330_SCHLECHTE_LUFTQUALITAET_ZU_ERWARTEN = new AttRdsVorhersageCode("schlechte Luftqualität zu erwarten", 		Integer
	.valueOf("1330"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1331_SEHR_SCHLECHTE_LUFTQUALITAET_ZU_ERWARTEN = new AttRdsVorhersageCode("sehr schlechte Luftqualität zu erwarten", 		Integer
	.valueOf("1331"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1311_STARKE_LUFTVERSCHMUTZUNG_DURCH_ABGASE_ZU_ERWARTEN = new AttRdsVorhersageCode("starke Luftverschmutzung durch Abgase zu erwarten", 		Integer
	.valueOf("1311"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1333_SMOG_ZU_ERWARTEN = new AttRdsVorhersageCode("Smog zu erwarten", 		Integer
	.valueOf("1333"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1334_STARKER_POLLENFLUG_ZU_ERWARTEN = new AttRdsVorhersageCode("starker Pollenflug zu erwarten", 		Integer
	.valueOf("1334"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1335_MITTLERER_POLLENFLUG_ZU_ERWARTEN = new AttRdsVorhersageCode("mittlerer Pollenflug zu erwarten", 		Integer
	.valueOf("1335"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1336_SCHWACHER_POLLENFLUG_ZU_ERWARTEN = new AttRdsVorhersageCode("schwacher Pollenflug zu erwarten", 		Integer
	.valueOf("1336"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1339_LUFTQUALITAET_HAT_SICH_VERBESSERT = new AttRdsVorhersageCode("Luftqualität hat sich verbessert", 		Integer
	.valueOf("1339"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_2032_MELDUNG_AUFGEHOBEN_VORHERSAGE_LUFTQUALITAET_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Luftqualität)", 		Integer
	.valueOf("2032"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1251_WIRBELSTURM_ZU_ERWARTEN = new AttRdsVorhersageCode("Wirbelsturm zu erwarten", 		Integer
	.valueOf("1251"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1252_ORKAN_ZU_ERWARTEN = new AttRdsVorhersageCode("Orkan zu erwarten", 		Integer
	.valueOf("1252"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1253_ORKANARTIGE_STUERME_ZU_ERWARTEN = new AttRdsVorhersageCode("orkanartige Stürme zu erwarten", 		Integer
	.valueOf("1253"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1254_STURM_ZU_ERWARTEN = new AttRdsVorhersageCode("Sturm zu erwarten", 		Integer
	.valueOf("1254"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1255_STARKER_WIND_ZU_ERWARTEN = new AttRdsVorhersageCode("starker Wind zu erwarten", 		Integer
	.valueOf("1255"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1206_WIND_ZU_ERWARTEN = new AttRdsVorhersageCode("Wind zu erwarten", 		Integer
	.valueOf("1206"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1207_LEICHTER_WIND_ZU_ERWARTEN = new AttRdsVorhersageCode("leichter Wind zu erwarten", 		Integer
	.valueOf("1207"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1208_RUHIGES_WETTER_ZU_ERWARTEN = new AttRdsVorhersageCode("ruhiges Wetter zu erwarten", 		Integer
	.valueOf("1208"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1256_KEINE_STARKEN_WINDE_MEHR_ZU_ERWARTEN = new AttRdsVorhersageCode("keine starken Winde mehr zu erwarten", 		Integer
	.valueOf("1256"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1216_KEIN_WIRBELSTURM_MEHR_ERWARTET = new AttRdsVorhersageCode("kein Wirbelsturm mehr erwartet", 		Integer
	.valueOf("1216"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1218_WINDVORHERSAGE_AUFGEHOBEN = new AttRdsVorhersageCode("Windvorhersage aufgehoben", 		Integer
	.valueOf("1218"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1219_MELDUNG_AUFGEHOBEN_VORHERSAGE_WIND_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Wind)", 		Integer
	.valueOf("1219"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1351_AM_TAG_HOHE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag hohe Temperaturen zu erwarten", 		Integer
	.valueOf("1351"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1359_ANSTEIGENDE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("ansteigende Temperaturen zu erwarten", 		Integer
	.valueOf("1359"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1401_NIEDRIGSTE_TEMPERATUR_ZU_ERWARTEN = new AttRdsVorhersageCode("niedrigste Temperatur zu erwarten", 		Integer
	.valueOf("1401"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1360_FALLENDE_TEMPERATUR_ZU_ERWARTEN = new AttRdsVorhersageCode("fallende Temperatur zu erwarten", 		Integer
	.valueOf("1360"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1361_TEMPERATUR_ZU_ERWARTEN = new AttRdsVorhersageCode("Temperatur zu erwarten", 		Integer
	.valueOf("1361"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1362_KALTER_WIND_ZU_ERWARTEN = new AttRdsVorhersageCode("kalter Wind zu erwarten", 		Integer
	.valueOf("1362"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1364_EXTREME_HITZE_ZU_ERWARTEN = new AttRdsVorhersageCode("extreme Hitze zu erwarten", 		Integer
	.valueOf("1364"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1352_AM_TAG_HEISSE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag heiße Temperaturen zu erwarten", 		Integer
	.valueOf("1352"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1353_AM_TAG_WARME_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag warme Temperaturen zu erwarten", 		Integer
	.valueOf("1353"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1354_AM_TAG_MILDE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag milde Temperaturen zu erwarten", 		Integer
	.valueOf("1354"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1355_AM_TAG_KUEHLE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag kühle Temperaturen zu erwarten", 		Integer
	.valueOf("1355"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1356_AM_TAG_KALTE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag kalte Temperaturen zu erwarten", 		Integer
	.valueOf("1356"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1357_AM_TAG_FROSTIGE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("am Tag frostige Temperaturen zu erwarten", 		Integer
	.valueOf("1357"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1365_EXTREME_KAELTE_ZU_ERWARTEN = new AttRdsVorhersageCode("extreme Kälte zu erwarten", 		Integer
	.valueOf("1365"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1402_SEHR_WARME_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("sehr warme Temperaturen zu erwarten", 		Integer
	.valueOf("1402"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1403_WARME_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("warme Temperaturen zu erwarten", 		Integer
	.valueOf("1403"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1404_MILDE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("milde Temperaturen zu erwarten", 		Integer
	.valueOf("1404"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1405_KUEHLE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("kühle Temperaturen zu erwarten", 		Integer
	.valueOf("1405"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1406_KALTE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("kalte Temperaturen zu erwarten", 		Integer
	.valueOf("1406"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1407_SEHR_KALTE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("sehr kalte Temperaturen zu erwarten", 		Integer
	.valueOf("1407"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1408_GEMAESSIGTERE_TEMPERATUREN_ZU_ERWARTEN = new AttRdsVorhersageCode("gemäßigtere Temperaturen zu erwarten", 		Integer
	.valueOf("1408"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1358_MELDUNG_AUFGEHOBEN_VORHERSAGE_TEMPERATUREN_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Temperaturen)", 		Integer
	.valueOf("1358"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1680_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("mit Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1680"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1681_MIT_MEHREREN_STUNDEN_ZEITVERLUST_MUSS_GERECHNET_WERDEN_ = new AttRdsVorhersageCode("mit mehreren Stunden Zeitverlust muss gerechnet werden ", 		Integer
	.valueOf("1681"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1682_GESPERRT_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("gesperrt, mit Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1682"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1683_BAUSTELLE_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("Baustelle, mit Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1683"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1684_UEBERFLUTUNG_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("Überflutung, mit Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1684"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1685_VERANSTALTUNG_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("Veranstaltung, mit Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1685"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1686_STREIK_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("Streik, mit Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1686"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1687_MIT_MEHREREN_STUNDEN_ZEITVERLUST_FUER_LKW_MUSS_GERECHNET_WERDEN_ = new AttRdsVorhersageCode("mit mehreren Stunden Zeitverlust für LKW muss gerechnet werden ", 		Integer
	.valueOf("1687"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1688_MIT_GROSSEM_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("mit großem Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1688"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1689_MIT_SEHR_GROSSEM_ZEITVERLUST_MUSS_GERECHNET_WERDEN = new AttRdsVorhersageCode("mit sehr großem Zeitverlust muss gerechnet werden", 		Integer
	.valueOf("1689"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1690_KEIN_ZEITVERLUST_MEHR_ZU_ERWARTEN = new AttRdsVorhersageCode("kein Zeitverlust mehr zu erwarten", 		Integer
	.valueOf("1690"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1691_MELDUNG_AUFGEHOBEN_VORHERSAGE_ZEITVERLUSTE_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Zeitverluste)", 		Integer
	.valueOf("1691"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1780_MIT_AUSFAELLEN_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Ausfällen ist zu rechnen", 		Integer
	.valueOf("1780"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1781_VORAUSSICHTLICH_ALLES_AUSGEBUCHT = new AttRdsVorhersageCode("voraussichtlich alles ausgebucht", 		Integer
	.valueOf("1781"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1782_P_R_VORAUSSICHTLICH_EINGESTELLT = new AttRdsVorhersageCode("P+R voraussichtlich eingestellt", 		Integer
	.valueOf("1782"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1783_MIT_STOERUNGEN_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit Störungen ist zu rechnen", 		Integer
	.valueOf("1783"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1784_SCHIENENVERKEHR_VORAUSSICHTLICH_AUSSER_BETRIEB = new AttRdsVorhersageCode("Schienenverkehr voraussichtlich außer Betrieb", 		Integer
	.valueOf("1784"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1785_S_BAHN_VORAUSSICHTLICH_AUSSER_BETRIEB = new AttRdsVorhersageCode("S-Bahn voraussichtlich außer Betrieb", 		Integer
	.valueOf("1785"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1786_U_BAHN_VORAUSSICHTLICH_AUSSER_BETRIEB = new AttRdsVorhersageCode("U-Bahn voraussichtlich außer Betrieb", 		Integer
	.valueOf("1786"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1787_OEPNV_STREIK_ZU_ERWARTEN = new AttRdsVorhersageCode("ÖPNV-Streik zu erwarten", 		Integer
	.valueOf("1787"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1788_FAEHRVERKEHR_VORAUSSICHTLICH_AUSSER_BETRIEB = new AttRdsVorhersageCode("Fährverkehr voraussichtlich außer Betrieb", 		Integer
	.valueOf("1788"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_39_WIEDEREROEFFNUNG_DER_BUECKE_ERWARTET = new AttRdsVorhersageCode("Wiedereröffnung der Bücke erwartet", 		Integer
	.valueOf("39"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1789_MIT_NORMALEM_BETRIEB_IST_ZU_RECHNEN = new AttRdsVorhersageCode("mit normalem Betrieb ist zu rechnen", 		Integer
	.valueOf("1789"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsVorhersageCode ZUSTAND_1790_MELDUNG_AUFGEHOBEN_VORHERSAGE_AUSFAELLE_ = new AttRdsVorhersageCode("Meldung aufgehoben (Vorhersage Ausfälle)", 		Integer
	.valueOf("1790"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsVorhersageCode getZustand(final 		Integer
	 value) {
		for (AttRdsVorhersageCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsVorhersageCode getZustand(final String value) {
		for (AttRdsVorhersageCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsVorhersageCode> getZustaende() {
		List<AttRdsVorhersageCode> list = new ArrayList<AttRdsVorhersageCode>();
		list.add(ZUSTAND_0_NICHT_DEFINIERT);
		list.add(ZUSTAND_80_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_81_MIT_VERKEHRSSTOERUNGEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_82_BAUSTELLE_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_83_GESPERRT_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_84_VERANSTALTUNG_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_85_SPORTVERANSTALTUNG_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_86_MESSE_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_87_EVAKUIERUNG_MIT_REGEM_VERKEHR_IST_ZU_RECHNEN);
		list.add(ZUSTAND_88_MIT_VERKEHRSSTOERUNGEN_IST_NICHT_MEHR_ZU_RECHNEN);
		list.add(ZUSTAND_89_MELDUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1151_STARKER_SCHNEEFALL_ZU_ERWARTEN);
		list.add(ZUSTAND_1152_SCHNEEFALL_ZU_ERWARTEN);
		list.add(ZUSTAND_1129_SCHNEESTURM_ZU_ERWARTEN);
		list.add(ZUSTAND_1131_BLIZZARD_ZU_ERWARTEN);
		list.add(ZUSTAND_1133_STARKER_HAGEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1153_HAGEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1154_SCHNEEREGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1155_GEWITTER_ZU_ERWARTEN);
		list.add(ZUSTAND_1327_SANDSTURM_ZU_ERWARTEN);
		list.add(ZUSTAND_1156_STARKER_REGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1157_REGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1158_REGENSCHAUER_ZU_ERWARTEN);
		list.add(ZUSTAND_1159_STARKER_FROST_ZU_ERWARTEN);
		list.add(ZUSTAND_1160_FROST_ZU_ERWARTEN);
		list.add(ZUSTAND_1117_BEDECKTER_HIMMEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1118_MEIST_BEWOELKTER_HIMMEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1119_TEILWEISE_BEWOELKTER_HIMMEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1120_SONNIGE_ABSCHNITTE_ZU_ERWARTEN);
		list.add(ZUSTAND_1121_KLARER_HIMMEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1122_SONNIGES_WETTER_ZU_ERWARTEN);
		list.add(ZUSTAND_1123_MEIST_TROCKENES_WETTER_ZU_ERWARTEN);
		list.add(ZUSTAND_1124_TROCKENES_WETTER_ZU_ERWARTEN);
		list.add(ZUSTAND_1125_TEILS_SONNIGES_WETTER_TEILS_REGEN_ZU_ERWARTEN);
		list.add(ZUSTAND_1315_DICHTER_NEBEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1306_NEBEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1316_NEBELBAENKE_ZU_ERWARTEN);
		list.add(ZUSTAND_1317_GEFRIERENDER_NEBEL_ZU_ERWARTEN);
		list.add(ZUSTAND_1300_MIT_SCHNEEFALL_UND_NEBEL_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1140_WETTERVORHERSAGE_AUFGEHOBEN);
		list.add(ZUSTAND_1141_NEBELVORHERSAGE_AUFGEHOBEN);
		list.add(ZUSTAND_1138_SCHLECHTWETTERWARNUNG_AUFGEHOBEN);
		list.add(ZUSTAND_1139_MELDUNG_AUFGEHOBEN_VORHERSAGE_WETTER_);
		list.add(ZUSTAND_1046_GLATTEIS_ERWARTET);
		list.add(ZUSTAND_1049_MIT_TEILWEISE_VEREISTER_FAHRBAHN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1051_MIT_BLITZEIS_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1052_MIT_GEFRIERENDEM_REGEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1053_MIT_SCHNEEVERWEHUNGEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1143_MIT_STRASSENGLAETTE_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1071_STRASSENZUSTANDSVORHERSAGE_AUFGEHOBEN);
		list.add(ZUSTAND_1072_MELDUNG_AUFGEHOBEN_VORHERSAGE_STRASSENZUSTAND_);
		list.add(ZUSTAND_1328_GUTE_LUFTQUALITAET_ZU_ERWARTEN);
		list.add(ZUSTAND_1329_NORMALE_LUFTQUALITAET_ZU_ERWARTEN);
		list.add(ZUSTAND_1330_SCHLECHTE_LUFTQUALITAET_ZU_ERWARTEN);
		list.add(ZUSTAND_1331_SEHR_SCHLECHTE_LUFTQUALITAET_ZU_ERWARTEN);
		list.add(ZUSTAND_1311_STARKE_LUFTVERSCHMUTZUNG_DURCH_ABGASE_ZU_ERWARTEN);
		list.add(ZUSTAND_1333_SMOG_ZU_ERWARTEN);
		list.add(ZUSTAND_1334_STARKER_POLLENFLUG_ZU_ERWARTEN);
		list.add(ZUSTAND_1335_MITTLERER_POLLENFLUG_ZU_ERWARTEN);
		list.add(ZUSTAND_1336_SCHWACHER_POLLENFLUG_ZU_ERWARTEN);
		list.add(ZUSTAND_1339_LUFTQUALITAET_HAT_SICH_VERBESSERT);
		list.add(ZUSTAND_2032_MELDUNG_AUFGEHOBEN_VORHERSAGE_LUFTQUALITAET_);
		list.add(ZUSTAND_1251_WIRBELSTURM_ZU_ERWARTEN);
		list.add(ZUSTAND_1252_ORKAN_ZU_ERWARTEN);
		list.add(ZUSTAND_1253_ORKANARTIGE_STUERME_ZU_ERWARTEN);
		list.add(ZUSTAND_1254_STURM_ZU_ERWARTEN);
		list.add(ZUSTAND_1255_STARKER_WIND_ZU_ERWARTEN);
		list.add(ZUSTAND_1206_WIND_ZU_ERWARTEN);
		list.add(ZUSTAND_1207_LEICHTER_WIND_ZU_ERWARTEN);
		list.add(ZUSTAND_1208_RUHIGES_WETTER_ZU_ERWARTEN);
		list.add(ZUSTAND_1256_KEINE_STARKEN_WINDE_MEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1216_KEIN_WIRBELSTURM_MEHR_ERWARTET);
		list.add(ZUSTAND_1218_WINDVORHERSAGE_AUFGEHOBEN);
		list.add(ZUSTAND_1219_MELDUNG_AUFGEHOBEN_VORHERSAGE_WIND_);
		list.add(ZUSTAND_1351_AM_TAG_HOHE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1359_ANSTEIGENDE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1401_NIEDRIGSTE_TEMPERATUR_ZU_ERWARTEN);
		list.add(ZUSTAND_1360_FALLENDE_TEMPERATUR_ZU_ERWARTEN);
		list.add(ZUSTAND_1361_TEMPERATUR_ZU_ERWARTEN);
		list.add(ZUSTAND_1362_KALTER_WIND_ZU_ERWARTEN);
		list.add(ZUSTAND_1364_EXTREME_HITZE_ZU_ERWARTEN);
		list.add(ZUSTAND_1352_AM_TAG_HEISSE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1353_AM_TAG_WARME_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1354_AM_TAG_MILDE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1355_AM_TAG_KUEHLE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1356_AM_TAG_KALTE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1357_AM_TAG_FROSTIGE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1365_EXTREME_KAELTE_ZU_ERWARTEN);
		list.add(ZUSTAND_1402_SEHR_WARME_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1403_WARME_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1404_MILDE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1405_KUEHLE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1406_KALTE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1407_SEHR_KALTE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1408_GEMAESSIGTERE_TEMPERATUREN_ZU_ERWARTEN);
		list.add(ZUSTAND_1358_MELDUNG_AUFGEHOBEN_VORHERSAGE_TEMPERATUREN_);
		list.add(ZUSTAND_1680_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1681_MIT_MEHREREN_STUNDEN_ZEITVERLUST_MUSS_GERECHNET_WERDEN_);
		list.add(ZUSTAND_1682_GESPERRT_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1683_BAUSTELLE_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1684_UEBERFLUTUNG_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1685_VERANSTALTUNG_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1686_STREIK_MIT_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1687_MIT_MEHREREN_STUNDEN_ZEITVERLUST_FUER_LKW_MUSS_GERECHNET_WERDEN_);
		list.add(ZUSTAND_1688_MIT_GROSSEM_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1689_MIT_SEHR_GROSSEM_ZEITVERLUST_MUSS_GERECHNET_WERDEN);
		list.add(ZUSTAND_1690_KEIN_ZEITVERLUST_MEHR_ZU_ERWARTEN);
		list.add(ZUSTAND_1691_MELDUNG_AUFGEHOBEN_VORHERSAGE_ZEITVERLUSTE_);
		list.add(ZUSTAND_1780_MIT_AUSFAELLEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1781_VORAUSSICHTLICH_ALLES_AUSGEBUCHT);
		list.add(ZUSTAND_1782_P_R_VORAUSSICHTLICH_EINGESTELLT);
		list.add(ZUSTAND_1783_MIT_STOERUNGEN_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1784_SCHIENENVERKEHR_VORAUSSICHTLICH_AUSSER_BETRIEB);
		list.add(ZUSTAND_1785_S_BAHN_VORAUSSICHTLICH_AUSSER_BETRIEB);
		list.add(ZUSTAND_1786_U_BAHN_VORAUSSICHTLICH_AUSSER_BETRIEB);
		list.add(ZUSTAND_1787_OEPNV_STREIK_ZU_ERWARTEN);
		list.add(ZUSTAND_1788_FAEHRVERKEHR_VORAUSSICHTLICH_AUSSER_BETRIEB);
		list.add(ZUSTAND_39_WIEDEREROEFFNUNG_DER_BUECKE_ERWARTET);
		list.add(ZUSTAND_1789_MIT_NORMALEM_BETRIEB_IST_ZU_RECHNEN);
		list.add(ZUSTAND_1790_MELDUNG_AUFGEHOBEN_VORHERSAGE_AUSFAELLE_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsVorhersageCode(final 		Integer
	 value) {
		super(value);
	}
	
	private AttRdsVorhersageCode(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
