/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Atrribute der RDS-TMC-Codes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class KdRdsTmcCode extends AbstractKonfigurationsDatensatz<KdRdsTmcCode.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
				 _ereignisCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
				 _vorhersageCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
				 _empfehlungsCode
				;
				private String
				 _text
				= new String
				()
				;
				private String
				 _textQuantitaetEinzahl
				= new String
				()
				;
				private String
				 _textQuantitaetMehrzahl
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisArt
				 _ereignisart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
				 _ereignisdauer
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
				 _quantitaetReferenz
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ereignisInBeidenRichtungen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
				 _prioritaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
				 _kategorie
				;
				private String
				 _phrasenCode
				= new String
				()
				;
		
			/**
			Ereignis-Code.
			<p>
			Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section, Spalte 'C')
			</p>
			
			@return der Wert von EreignisCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
				 getEreignisCode() {
				return _ereignisCode;
			}
		
			/**
			Ereignis-Code.
			<p>
			Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section, Spalte 'C')
			</p>
			
			@param _ereignisCode der neue Wert von EreignisCode.
			*/
			public void setEreignisCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
			 _ereignisCode) {
				this._ereignisCode = _ereignisCode;
			}
		
			/**
			Vorhersage-Code.
			<p>
			Vorhersage-Code entsprechend DIN EN ISO 14819-2 (Tabelle 'FORECAST EVENT LIST', Spalte 'Code')
			</p>
			
			@return der Wert von VorhersageCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
				 getVorhersageCode() {
				return _vorhersageCode;
			}
		
			/**
			Vorhersage-Code.
			<p>
			Vorhersage-Code entsprechend DIN EN ISO 14819-2 (Tabelle 'FORECAST EVENT LIST', Spalte 'Code')
			</p>
			
			@param _vorhersageCode der neue Wert von VorhersageCode.
			*/
			public void setVorhersageCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
			 _vorhersageCode) {
				this._vorhersageCode = _vorhersageCode;
			}
		
			/**
			Empfehlungs-Code.
			<p>
			Empfehlungs-Code entsprechend DIN EN ISO 14819-2 (Tabelle 'SUPPLEMENTARY INFORMATION LIST', Spalte 'Code')
			</p>
			
			@return der Wert von EmpfehlungsCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
				 getEmpfehlungsCode() {
				return _empfehlungsCode;
			}
		
			/**
			Empfehlungs-Code.
			<p>
			Empfehlungs-Code entsprechend DIN EN ISO 14819-2 (Tabelle 'SUPPLEMENTARY INFORMATION LIST', Spalte 'Code')
			</p>
			
			@param _empfehlungsCode der neue Wert von EmpfehlungsCode.
			*/
			public void setEmpfehlungsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
			 _empfehlungsCode) {
				this._empfehlungsCode = _empfehlungsCode;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Text.
			*/
				public String
				 getText() {
				return _text;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _text der neue Wert von Text.
			*/
			public void setText(String
			 _text) {
				if (_text.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._text = _text;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von TextQuantitaetEinzahl.
			*/
				public String
				 getTextQuantitaetEinzahl() {
				return _textQuantitaetEinzahl;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _textQuantitaetEinzahl der neue Wert von TextQuantitaetEinzahl.
			*/
			public void setTextQuantitaetEinzahl(String
			 _textQuantitaetEinzahl) {
				if (_textQuantitaetEinzahl.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._textQuantitaetEinzahl = _textQuantitaetEinzahl;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von TextQuantitaetMehrzahl.
			*/
				public String
				 getTextQuantitaetMehrzahl() {
				return _textQuantitaetMehrzahl;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _textQuantitaetMehrzahl der neue Wert von TextQuantitaetMehrzahl.
			*/
			public void setTextQuantitaetMehrzahl(String
			 _textQuantitaetMehrzahl) {
				if (_textQuantitaetMehrzahl.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._textQuantitaetMehrzahl = _textQuantitaetMehrzahl;
			}
		
			/**
			Art des Ereignisses nach Spalte 'N' EN ISO DIN14819-2.
			<p>
			
			</p>
			
			@return der Wert von Ereignisart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisArt
				 getEreignisart() {
				return _ereignisart;
			}
		
			/**
			Art des Ereignisses nach Spalte 'N' EN ISO DIN14819-2.
			<p>
			
			</p>
			
			@param _ereignisart der neue Wert von Ereignisart.
			*/
			public void setEreignisart(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisArt
			 _ereignisart) {
				this._ereignisart = _ereignisart;
			}
		
			/**
			Typ der Dauer des Ereignises.
			<p>
			
			</p>
			
			@return der Wert von Ereignisdauer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
				 getEreignisdauer() {
				return _ereignisdauer;
			}
		
			/**
			Typ der Dauer des Ereignises.
			<p>
			
			</p>
			
			@param _ereignisdauer der neue Wert von Ereignisdauer.
			*/
			public void setEreignisdauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
			 _ereignisdauer) {
				this._ereignisdauer = _ereignisdauer;
			}
		
			/**
			Quantitäts-Kennung als Referenz auf ein Objekt vom Typ: &lt;verweis pid="typ.rdsQuantität"&gt;&lt;&#47;verweis&gt;.
			<p>
			
			</p>
			
			@return der Wert von QuantitaetReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
				 getQuantitaetReferenz() {
				return _quantitaetReferenz;
			}
		
			/**
			Quantitäts-Kennung als Referenz auf ein Objekt vom Typ: &lt;verweis pid="typ.rdsQuantität"&gt;&lt;&#47;verweis&gt;.
			<p>
			
			</p>
			
			@param _quantitaetReferenz der neue Wert von QuantitaetReferenz.
			*/
			public void setQuantitaetReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
			 _quantitaetReferenz) {
				this._quantitaetReferenz = _quantitaetReferenz;
			}
		
			/**
			Das Ereignis beeinflusst normalerweise beide (ja) oder nur eine Verkehrsrichtung (nein).
			<p>
			
			</p>
			
			@return der Wert von EreignisInBeidenRichtungen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getEreignisInBeidenRichtungen() {
				return _ereignisInBeidenRichtungen;
			}
		
			/**
			Das Ereignis beeinflusst normalerweise beide (ja) oder nur eine Verkehrsrichtung (nein).
			<p>
			
			</p>
			
			@param _ereignisInBeidenRichtungen der neue Wert von EreignisInBeidenRichtungen.
			*/
			public void setEreignisInBeidenRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ereignisInBeidenRichtungen) {
				this._ereignisInBeidenRichtungen = _ereignisInBeidenRichtungen;
			}
		
			/**
			Priorität der Version.
			<p>
			
			</p>
			
			@return der Wert von Prioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
				 getPrioritaet() {
				return _prioritaet;
			}
		
			/**
			Priorität der Version.
			<p>
			
			</p>
			
			@param _prioritaet der neue Wert von Prioritaet.
			*/
			public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
			 _prioritaet) {
				this._prioritaet = _prioritaet;
			}
		
			/**
			Ereignis-Kategorie.
			<p>
			&lt;absatz&gt;TIC Info XML Element: EventDataCategory, numerischer Wert der Ereignis-Kategorie&lt;&#47;absatz&gt;
								 	&lt;absatz&gt;1 - 31: Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section bzw. Spalte 'C')&lt;&#47;absatz&gt;
									&lt;absatz&gt;32- 39: Vorhersage-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section bzw. Spalte 'C')&lt;&#47;absatz&gt;
									&lt;absatz&gt;40 - 49: nicht benutzt&lt;&#47;absatz&gt;
									&lt;absatz&gt;50: spezielle Kategorie, kennzeichnet dieses Ereignis als eine Empfehlung (GEWI)&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Kategorie.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
				 getKategorie() {
				return _kategorie;
			}
		
			/**
			Ereignis-Kategorie.
			<p>
			&lt;absatz&gt;TIC Info XML Element: EventDataCategory, numerischer Wert der Ereignis-Kategorie&lt;&#47;absatz&gt;
								 	&lt;absatz&gt;1 - 31: Ereignis-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section bzw. Spalte 'C')&lt;&#47;absatz&gt;
									&lt;absatz&gt;32- 39: Vorhersage-Kategorie entsprechend DIN EN ISO 14819-2 (Event List Section bzw. Spalte 'C')&lt;&#47;absatz&gt;
									&lt;absatz&gt;40 - 49: nicht benutzt&lt;&#47;absatz&gt;
									&lt;absatz&gt;50: spezielle Kategorie, kennzeichnet dieses Ereignis als eine Empfehlung (GEWI)&lt;&#47;absatz&gt;
			</p>
			
			@param _kategorie der neue Wert von Kategorie.
			*/
			public void setKategorie(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
			 _kategorie) {
				this._kategorie = _kategorie;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von PhrasenCode.
			*/
				public String
				 getPhrasenCode() {
				return _phrasenCode;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _phrasenCode der neue Wert von PhrasenCode.
			*/
			public void setPhrasenCode(String
			 _phrasenCode) {
				if (_phrasenCode.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._phrasenCode = _phrasenCode;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getEreignisCode() != null) {
		                if (getEreignisCode().isZustand()) {
		                    datum.getUnscaledValue("EreignisCode").setText(getEreignisCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisCode").set(getEreignisCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVorhersageCode() != null) {
		                if (getVorhersageCode().isZustand()) {
		                    datum.getUnscaledValue("VorhersageCode").setText(getVorhersageCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VorhersageCode").set(getVorhersageCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEmpfehlungsCode() != null) {
		                if (getEmpfehlungsCode().isZustand()) {
		                    datum.getUnscaledValue("EmpfehlungsCode").setText(getEmpfehlungsCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EmpfehlungsCode").set(getEmpfehlungsCode().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getText() != null) {
						datum.getTextValue("Text").setText(getText());
					}
					// ZeichenkettenAttributTyp
					if (getTextQuantitaetEinzahl() != null) {
						datum.getTextValue("TextQuantitätEinzahl").setText(getTextQuantitaetEinzahl());
					}
					// ZeichenkettenAttributTyp
					if (getTextQuantitaetMehrzahl() != null) {
						datum.getTextValue("TextQuantitätMehrzahl").setText(getTextQuantitaetMehrzahl());
					}
					// GanzzahlAttributTyp
					if (getEreignisart() != null) {
		                if (getEreignisart().isZustand()) {
		                    datum.getUnscaledValue("Ereignisart").setText(getEreignisart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Ereignisart").set(getEreignisart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEreignisdauer() != null) {
		                if (getEreignisdauer().isZustand()) {
		                    datum.getUnscaledValue("Ereignisdauer").setText(getEreignisdauer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Ereignisdauer").set(getEreignisdauer().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soQuantitaetReferenz = getQuantitaetReferenz();
						final SystemObject tmpQuantitaetReferenz;
							if (soQuantitaetReferenz instanceof SystemObject) {
								tmpQuantitaetReferenz = (SystemObject)soQuantitaetReferenz;
							} else if(soQuantitaetReferenz instanceof SystemObjekt){
								tmpQuantitaetReferenz = ((SystemObjekt)soQuantitaetReferenz).getSystemObject();
							} else{
								tmpQuantitaetReferenz = null;
							}
						datum.getReferenceValue("QuantitätReferenz").setSystemObject(tmpQuantitaetReferenz);
					// GanzzahlAttributTyp
					if (getEreignisInBeidenRichtungen() != null) {
		                if (getEreignisInBeidenRichtungen().isZustand()) {
		                    datum.getUnscaledValue("EreignisInBeidenRichtungen").setText(getEreignisInBeidenRichtungen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisInBeidenRichtungen").set(getEreignisInBeidenRichtungen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPrioritaet() != null) {
		                if (getPrioritaet().isZustand()) {
		                    datum.getUnscaledValue("Priorität").setText(getPrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Priorität").set(getPrioritaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKategorie() != null) {
		                if (getKategorie().isZustand()) {
		                    datum.getUnscaledValue("Kategorie").setText(getKategorie().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Kategorie").set(getKategorie().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getPhrasenCode() != null) {
						datum.getTextValue("PhrasenCode").setText(getPhrasenCode());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisCode").isState()) {
								setEreignisCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
								.getZustand(daten.getScaledValue("EreignisCode").getText()));
							} else {
							setEreignisCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisCode
							(daten.
								getUnscaledValue
							("EreignisCode").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VorhersageCode").isState()) {
								setVorhersageCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
								.getZustand(daten.getScaledValue("VorhersageCode").getText()));
							} else {
							setVorhersageCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsVorhersageCode
							(daten.
								getUnscaledValue
							("VorhersageCode").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EmpfehlungsCode").isState()) {
								setEmpfehlungsCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
								.getZustand(daten.getScaledValue("EmpfehlungsCode").getText()));
							} else {
							setEmpfehlungsCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEmpfehlungsCode
							(daten.
								getUnscaledValue
							("EmpfehlungsCode").
									intValue
							()));
							}
					// ZeichenkettenAttributTyp
						setText(daten.getTextValue("Text").getText());
					// ZeichenkettenAttributTyp
						setTextQuantitaetEinzahl(daten.getTextValue("TextQuantitätEinzahl").getText());
					// ZeichenkettenAttributTyp
						setTextQuantitaetMehrzahl(daten.getTextValue("TextQuantitätMehrzahl").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Ereignisart").isState()) {
								setEreignisart(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisArt
								.getZustand(daten.getScaledValue("Ereignisart").getText()));
							} else {
							setEreignisart(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmsttmccodes.attribute.AttRdsEreignisArt
							(daten.
								getUnscaledValue
							("Ereignisart").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Ereignisdauer").isState()) {
								setEreignisdauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
								.getZustand(daten.getScaledValue("Ereignisdauer").getText()));
							} else {
							setEreignisdauer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisDauer
							(daten.
								getUnscaledValue
							("Ereignisdauer").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idQuantitaetReferenz = daten.getReferenceValue("QuantitätReferenz").getId();
						final SystemObjekt tmpQuantitaetReferenz;
						if (idQuantitaetReferenz == 0) {
							tmpQuantitaetReferenz = null;
						} else {
							final SystemObject soQuantitaetReferenz = factory.getDav().getDataModel().getObject(idQuantitaetReferenz);
							if (soQuantitaetReferenz == null) {
									tmpQuantitaetReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.impl.RdsQuantitaetUngueltig(idQuantitaetReferenz);
							} else {
								tmpQuantitaetReferenz = factory.getModellobjekt(soQuantitaetReferenz);
							}
						}
						setQuantitaetReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet
						) tmpQuantitaetReferenz);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EreignisInBeidenRichtungen").isState()) {
								setEreignisInBeidenRichtungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("EreignisInBeidenRichtungen").getText()));
							} else {
							setEreignisInBeidenRichtungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("EreignisInBeidenRichtungen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Priorität").isState()) {
								setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
								.getZustand(daten.getScaledValue("Priorität").getText()));
							} else {
							setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
							(daten.
								getUnscaledValue
							("Priorität").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Kategorie").isState()) {
								setKategorie(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
								.getZustand(daten.getScaledValue("Kategorie").getText()));
							} else {
							setKategorie(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsEreignisKategorie
							(daten.
								getUnscaledValue
							("Kategorie").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setPhrasenCode(daten.getTextValue("PhrasenCode").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setEreignisCode(getEreignisCode());
							klon.setVorhersageCode(getVorhersageCode());
							klon.setEmpfehlungsCode(getEmpfehlungsCode());
							klon.setText(getText());
							klon.setTextQuantitaetEinzahl(getTextQuantitaetEinzahl());
							klon.setTextQuantitaetMehrzahl(getTextQuantitaetMehrzahl());
							klon.setEreignisart(getEreignisart());
							klon.setEreignisdauer(getEreignisdauer());
							klon.setQuantitaetReferenz(getQuantitaetReferenz());
							klon.setEreignisInBeidenRichtungen(getEreignisInBeidenRichtungen());
							klon.setPrioritaet(getPrioritaet());
							klon.setKategorie(getKategorie());
							klon.setPhrasenCode(getPhrasenCode());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.rdsTmcCode";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdRdsTmcCode(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
