/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ZRA Pro Verkehrsstufen (FG 1 &#47; Typ 224 Hersteller Dürr).
<p>
&lt;sektion&gt;
						&lt;titel&gt;FG 1: DE-Block-Struktur im Typ 224 "Verkehrsstufen"&lt;&#47;titel&gt;
						&lt;absatz&gt;Die Nachricht überträgt die aktuell errechneten Verkehrsstufen.
							Wird versendet mit Zeitstempel Typ 48 der FG 1.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsLveProVerkehrsStufen extends AbstractOnlineDatensatz<OdTlsLveProVerkehrsStufen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 _hersteller
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeMARZ
				 _verkehrsStufeMARZ
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoDP
				 _verkehrsStufeInfoDP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoVKfzP
				 _verkehrsStufeInfoVKfzP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve01
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve02
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve03
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _dP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qBP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKfzP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKfzNeu
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfzP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfzNeu
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkwP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkwNeu
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwNeu
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwNeu
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwNeu
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve04
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve05
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve06
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve07
				;
		
			/**
			Herstellercode: Dürr = 48.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Herstellercode: Dürr = 48.
			<p>
			
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
			/**
			Verkehrsstufe nach MARZ.
			<p>
			
			</p>
			
			@return der Wert von VerkehrsStufeMARZ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeMARZ
				 getVerkehrsStufeMARZ() {
				return _verkehrsStufeMARZ;
			}
		
			/**
			Verkehrsstufe nach MARZ.
			<p>
			
			</p>
			
			@param _verkehrsStufeMARZ der neue Wert von VerkehrsStufeMARZ.
			*/
			public void setVerkehrsStufeMARZ(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeMARZ
			 _verkehrsStufeMARZ) {
				this._verkehrsStufeMARZ = _verkehrsStufeMARZ;
			}
		
			/**
			Zusatzinformationen zum Bereich DP.
			<p>
			
			</p>
			
			@return der Wert von VerkehrsStufeInfoDP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoDP
				 getVerkehrsStufeInfoDP() {
				return _verkehrsStufeInfoDP;
			}
		
			/**
			Zusatzinformationen zum Bereich DP.
			<p>
			
			</p>
			
			@param _verkehrsStufeInfoDP der neue Wert von VerkehrsStufeInfoDP.
			*/
			public void setVerkehrsStufeInfoDP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoDP
			 _verkehrsStufeInfoDP) {
				this._verkehrsStufeInfoDP = _verkehrsStufeInfoDP;
			}
		
			/**
			Zusatzinformationen zum Bereich VKfzP.
			<p>
			
			</p>
			
			@return der Wert von VerkehrsStufeInfoVKfzP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoVKfzP
				 getVerkehrsStufeInfoVKfzP() {
				return _verkehrsStufeInfoVKfzP;
			}
		
			/**
			Zusatzinformationen zum Bereich VKfzP.
			<p>
			
			</p>
			
			@param _verkehrsStufeInfoVKfzP der neue Wert von VerkehrsStufeInfoVKfzP.
			*/
			public void setVerkehrsStufeInfoVKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoVKfzP
			 _verkehrsStufeInfoVKfzP) {
				this._verkehrsStufeInfoVKfzP = _verkehrsStufeInfoVKfzP;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve01.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve01() {
				return _reserve01;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve01 der neue Wert von Reserve01.
			*/
			public void setReserve01(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve01) {
				this._reserve01 = _reserve01;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve02.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve02() {
				return _reserve02;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve02 der neue Wert von Reserve02.
			*/
			public void setReserve02(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve02) {
				this._reserve02 = _reserve02;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve03.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve03() {
				return _reserve03;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve03 der neue Wert von Reserve03.
			*/
			public void setReserve03(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve03) {
				this._reserve03 = _reserve03;
			}
		
			/**
			Prognoseverkehrsdichte.
			<p>
			
			</p>
			
			@return der Wert von DP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getDP() {
				return _dP;
			}
		
			/**
			Prognoseverkehrsdichte.
			<p>
			
			</p>
			
			@param _dP der neue Wert von DP.
			*/
			public void setDP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _dP) {
				this._dP = _dP;
			}
		
			/**
			Prognose Bemessungsverkehrsstärke.
			<p>
			
			</p>
			
			@return der Wert von QBP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQBP() {
				return _qBP;
			}
		
			/**
			Prognose Bemessungsverkehrsstärke.
			<p>
			
			</p>
			
			@param _qBP der neue Wert von QBP.
			*/
			public void setQBP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qBP) {
				this._qBP = _qBP;
			}
		
			/**
			Prognose Verkehrsstärke für Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfzP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKfzP() {
				return _qKfzP;
			}
		
			/**
			Prognose Verkehrsstärke für Kfz.
			<p>
			
			</p>
			
			@param _qKfzP der neue Wert von QKfzP.
			*/
			public void setQKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKfzP) {
				this._qKfzP = _qKfzP;
			}
		
			/**
			Prognose Verkehrsstärke für KfzNeu.
			<p>
			
			</p>
			
			@return der Wert von QKfzNeu.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKfzNeu() {
				return _qKfzNeu;
			}
		
			/**
			Prognose Verkehrsstärke für KfzNeu.
			<p>
			
			</p>
			
			@param _qKfzNeu der neue Wert von QKfzNeu.
			*/
			public void setQKfzNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKfzNeu) {
				this._qKfzNeu = _qKfzNeu;
			}
		
			/**
			Prognose Geschwindigkeit für Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfzP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfzP() {
				return _vKfzP;
			}
		
			/**
			Prognose Geschwindigkeit für Kfz.
			<p>
			
			</p>
			
			@param _vKfzP der neue Wert von VKfzP.
			*/
			public void setVKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfzP) {
				this._vKfzP = _vKfzP;
			}
		
			/**
			Geglättete mittlere Reisegeschwindigkeit für Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfzNeu.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfzNeu() {
				return _vKfzNeu;
			}
		
			/**
			Geglättete mittlere Reisegeschwindigkeit für Kfz.
			<p>
			
			</p>
			
			@param _vKfzNeu der neue Wert von VKfzNeu.
			*/
			public void setVKfzNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfzNeu) {
				this._vKfzNeu = _vKfzNeu;
			}
		
			/**
			Prognose Verkehrsstärke für Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkwP() {
				return _qPkwP;
			}
		
			/**
			Prognose Verkehrsstärke für Pkw.
			<p>
			
			</p>
			
			@param _qPkwP der neue Wert von QPkwP.
			*/
			public void setQPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkwP) {
				this._qPkwP = _qPkwP;
			}
		
			/**
			Prognose Verkehrsstärke für PkwNeu.
			<p>
			
			</p>
			
			@return der Wert von QPkwNeu.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkwNeu() {
				return _qPkwNeu;
			}
		
			/**
			Prognose Verkehrsstärke für PkwNeu.
			<p>
			
			</p>
			
			@param _qPkwNeu der neue Wert von QPkwNeu.
			*/
			public void setQPkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkwNeu) {
				this._qPkwNeu = _qPkwNeu;
			}
		
			/**
			Prognose Verkehrsstärke für Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwP() {
				return _qLkwP;
			}
		
			/**
			Prognose Verkehrsstärke für Lkw.
			<p>
			
			</p>
			
			@param _qLkwP der neue Wert von QLkwP.
			*/
			public void setQLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwP) {
				this._qLkwP = _qLkwP;
			}
		
			/**
			Prognose Verkehrsstärke für LkwNeu.
			<p>
			
			</p>
			
			@return der Wert von QLkwNeu.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwNeu() {
				return _qLkwNeu;
			}
		
			/**
			Prognose Verkehrsstärke für LkwNeu.
			<p>
			
			</p>
			
			@param _qLkwNeu der neue Wert von QLkwNeu.
			*/
			public void setQLkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwNeu) {
				this._qLkwNeu = _qLkwNeu;
			}
		
			/**
			Prognose Geschwindigkeit für Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwP() {
				return _vPkwP;
			}
		
			/**
			Prognose Geschwindigkeit für Pkw.
			<p>
			
			</p>
			
			@param _vPkwP der neue Wert von VPkwP.
			*/
			public void setVPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwP) {
				this._vPkwP = _vPkwP;
			}
		
			/**
			Geglättete mittlere Reisegeschwindigkeit für Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkwNeu.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwNeu() {
				return _vPkwNeu;
			}
		
			/**
			Geglättete mittlere Reisegeschwindigkeit für Pkw.
			<p>
			
			</p>
			
			@param _vPkwNeu der neue Wert von VPkwNeu.
			*/
			public void setVPkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwNeu) {
				this._vPkwNeu = _vPkwNeu;
			}
		
			/**
			Prognose Geschwindigkeit für Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkwP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwP() {
				return _vLkwP;
			}
		
			/**
			Prognose Geschwindigkeit für Lkw.
			<p>
			
			</p>
			
			@param _vLkwP der neue Wert von VLkwP.
			*/
			public void setVLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwP) {
				this._vLkwP = _vLkwP;
			}
		
			/**
			Geglättete mittlere Reisegeschwindigkeit für Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkwNeu.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwNeu() {
				return _vLkwNeu;
			}
		
			/**
			Geglättete mittlere Reisegeschwindigkeit für Lkw.
			<p>
			
			</p>
			
			@param _vLkwNeu der neue Wert von VLkwNeu.
			*/
			public void setVLkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwNeu) {
				this._vLkwNeu = _vLkwNeu;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve04.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve04() {
				return _reserve04;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve04 der neue Wert von Reserve04.
			*/
			public void setReserve04(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve04) {
				this._reserve04 = _reserve04;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve05.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve05() {
				return _reserve05;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve05 der neue Wert von Reserve05.
			*/
			public void setReserve05(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve05) {
				this._reserve05 = _reserve05;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve06.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve06() {
				return _reserve06;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve06 der neue Wert von Reserve06.
			*/
			public void setReserve06(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve06) {
				this._reserve06 = _reserve06;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve07.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve07() {
				return _reserve07;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve07 der neue Wert von Reserve07.
			*/
			public void setReserve07(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve07) {
				this._reserve07 = _reserve07;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getHersteller() != null) {
		                if (getHersteller().isZustand()) {
		                    datum.getUnscaledValue("Hersteller").setText(getHersteller().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hersteller").set(getHersteller().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVerkehrsStufeMARZ() != null) {
		                if (getVerkehrsStufeMARZ().isZustand()) {
		                    datum.getUnscaledValue("VerkehrsStufeMARZ").setText(getVerkehrsStufeMARZ().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VerkehrsStufeMARZ").set(getVerkehrsStufeMARZ().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVerkehrsStufeInfoDP() != null) {
		                if (getVerkehrsStufeInfoDP().isZustand()) {
		                    datum.getUnscaledValue("VerkehrsStufeInfoDP").setText(getVerkehrsStufeInfoDP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VerkehrsStufeInfoDP").set(getVerkehrsStufeInfoDP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVerkehrsStufeInfoVKfzP() != null) {
		                if (getVerkehrsStufeInfoVKfzP().isZustand()) {
		                    datum.getUnscaledValue("VerkehrsStufeInfoVKfzP").setText(getVerkehrsStufeInfoVKfzP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VerkehrsStufeInfoVKfzP").set(getVerkehrsStufeInfoVKfzP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve01() != null) {
		                if (getReserve01().isZustand()) {
		                    datum.getUnscaledValue("Reserve01").setText(getReserve01().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve01").set(getReserve01().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve02() != null) {
		                if (getReserve02().isZustand()) {
		                    datum.getUnscaledValue("Reserve02").setText(getReserve02().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve02").set(getReserve02().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve03() != null) {
		                if (getReserve03().isZustand()) {
		                    datum.getUnscaledValue("Reserve03").setText(getReserve03().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve03").set(getReserve03().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDP() != null) {
		                if (getDP().isZustand()) {
		                    datum.getUnscaledValue("DP").setText(getDP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DP").set(getDP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQBP() != null) {
		                if (getQBP().isZustand()) {
		                    datum.getUnscaledValue("QBP").setText(getQBP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QBP").set(getQBP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKfzP() != null) {
		                if (getQKfzP().isZustand()) {
		                    datum.getUnscaledValue("QKfzP").setText(getQKfzP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QKfzP").set(getQKfzP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKfzNeu() != null) {
		                if (getQKfzNeu().isZustand()) {
		                    datum.getUnscaledValue("QKfzNeu").setText(getQKfzNeu().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QKfzNeu").set(getQKfzNeu().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzP() != null) {
		                if (getVKfzP().isZustand()) {
		                    datum.getUnscaledValue("VKfzP").setText(getVKfzP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKfzP").set(getVKfzP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzNeu() != null) {
		                if (getVKfzNeu().isZustand()) {
		                    datum.getUnscaledValue("VKfzNeu").setText(getVKfzNeu().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKfzNeu").set(getVKfzNeu().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwP() != null) {
		                if (getQPkwP().isZustand()) {
		                    datum.getUnscaledValue("QPkwP").setText(getQPkwP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QPkwP").set(getQPkwP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwNeu() != null) {
		                if (getQPkwNeu().isZustand()) {
		                    datum.getUnscaledValue("QPkwNeu").setText(getQPkwNeu().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QPkwNeu").set(getQPkwNeu().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwP() != null) {
		                if (getQLkwP().isZustand()) {
		                    datum.getUnscaledValue("QLkwP").setText(getQLkwP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QLkwP").set(getQLkwP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwNeu() != null) {
		                if (getQLkwNeu().isZustand()) {
		                    datum.getUnscaledValue("QLkwNeu").setText(getQLkwNeu().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QLkwNeu").set(getQLkwNeu().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwP() != null) {
		                if (getVPkwP().isZustand()) {
		                    datum.getUnscaledValue("VPkwP").setText(getVPkwP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VPkwP").set(getVPkwP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwNeu() != null) {
		                if (getVPkwNeu().isZustand()) {
		                    datum.getUnscaledValue("VPkwNeu").setText(getVPkwNeu().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VPkwNeu").set(getVPkwNeu().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwP() != null) {
		                if (getVLkwP().isZustand()) {
		                    datum.getUnscaledValue("VLkwP").setText(getVLkwP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VLkwP").set(getVLkwP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwNeu() != null) {
		                if (getVLkwNeu().isZustand()) {
		                    datum.getUnscaledValue("VLkwNeu").setText(getVLkwNeu().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VLkwNeu").set(getVLkwNeu().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve04() != null) {
		                if (getReserve04().isZustand()) {
		                    datum.getUnscaledValue("Reserve04").setText(getReserve04().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve04").set(getReserve04().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve05() != null) {
		                if (getReserve05().isZustand()) {
		                    datum.getUnscaledValue("Reserve05").setText(getReserve05().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve05").set(getReserve05().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve06() != null) {
		                if (getReserve06().isZustand()) {
		                    datum.getUnscaledValue("Reserve06").setText(getReserve06().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve06").set(getReserve06().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve07() != null) {
		                if (getReserve07().isZustand()) {
		                    datum.getUnscaledValue("Reserve07").setText(getReserve07().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve07").set(getReserve07().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hersteller").isState()) {
								setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
								.getZustand(daten.getScaledValue("Hersteller").getText()));
							} else {
							setHersteller(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
							(daten.
								getUnscaledValue
							("Hersteller").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VerkehrsStufeMARZ").isState()) {
								setVerkehrsStufeMARZ(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeMARZ
								.getZustand(daten.getScaledValue("VerkehrsStufeMARZ").getText()));
							} else {
							setVerkehrsStufeMARZ(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeMARZ
							(daten.
								getUnscaledValue
							("VerkehrsStufeMARZ").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VerkehrsStufeInfoDP").isState()) {
								setVerkehrsStufeInfoDP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoDP
								.getZustand(daten.getScaledValue("VerkehrsStufeInfoDP").getText()));
							} else {
							setVerkehrsStufeInfoDP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoDP
							(daten.
								getUnscaledValue
							("VerkehrsStufeInfoDP").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VerkehrsStufeInfoVKfzP").isState()) {
								setVerkehrsStufeInfoVKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoVKfzP
								.getZustand(daten.getScaledValue("VerkehrsStufeInfoVKfzP").getText()));
							} else {
							setVerkehrsStufeInfoVKfzP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProVerkehrsStufeInfoVKfzP
							(daten.
								getUnscaledValue
							("VerkehrsStufeInfoVKfzP").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setReserve01(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve01").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve02(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve02").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve03(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve03").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DP").isState()) {
								setDP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("DP").getText()));
							} else {
							setDP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("DP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QBP").isState()) {
								setQBP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QBP").getText()));
							} else {
							setQBP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QBP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QKfzP").isState()) {
								setQKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QKfzP").getText()));
							} else {
							setQKfzP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QKfzP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QKfzNeu").isState()) {
								setQKfzNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QKfzNeu").getText()));
							} else {
							setQKfzNeu(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QKfzNeu").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKfzP").isState()) {
								setVKfzP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VKfzP").getText()));
							} else {
							setVKfzP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VKfzP").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKfzNeu").isState()) {
								setVKfzNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VKfzNeu").getText()));
							} else {
							setVKfzNeu(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VKfzNeu").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QPkwP").isState()) {
								setQPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QPkwP").getText()));
							} else {
							setQPkwP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QPkwP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QPkwNeu").isState()) {
								setQPkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QPkwNeu").getText()));
							} else {
							setQPkwNeu(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QPkwNeu").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QLkwP").isState()) {
								setQLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QLkwP").getText()));
							} else {
							setQLkwP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QLkwP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QLkwNeu").isState()) {
								setQLkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("QLkwNeu").getText()));
							} else {
							setQLkwNeu(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("QLkwNeu").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VPkwP").isState()) {
								setVPkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VPkwP").getText()));
							} else {
							setVPkwP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VPkwP").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VPkwNeu").isState()) {
								setVPkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VPkwNeu").getText()));
							} else {
							setVPkwNeu(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VPkwNeu").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VLkwP").isState()) {
								setVLkwP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VLkwP").getText()));
							} else {
							setVLkwP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VLkwP").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VLkwNeu").isState()) {
								setVLkwNeu(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VLkwNeu").getText()));
							} else {
							setVLkwNeu(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VLkwNeu").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setReserve04(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve04").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve05(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve05").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve06(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve06").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve07(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve07").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHersteller(getHersteller());
							klon.setVerkehrsStufeMARZ(getVerkehrsStufeMARZ());
							klon.setVerkehrsStufeInfoDP(getVerkehrsStufeInfoDP());
							klon.setVerkehrsStufeInfoVKfzP(getVerkehrsStufeInfoVKfzP());
							klon.setReserve01(getReserve01());
							klon.setReserve02(getReserve02());
							klon.setReserve03(getReserve03());
							klon.setDP(getDP());
							klon.setQBP(getQBP());
							klon.setQKfzP(getQKfzP());
							klon.setQKfzNeu(getQKfzNeu());
							klon.setVKfzP(getVKfzP());
							klon.setVKfzNeu(getVKfzNeu());
							klon.setQPkwP(getQPkwP());
							klon.setQPkwNeu(getQPkwNeu());
							klon.setQLkwP(getQLkwP());
							klon.setQLkwNeu(getQLkwNeu());
							klon.setVPkwP(getVPkwP());
							klon.setVPkwNeu(getVPkwNeu());
							klon.setVLkwP(getVLkwP());
							klon.setVLkwNeu(getVLkwNeu());
							klon.setReserve04(getReserve04());
							klon.setReserve05(getReserve05());
							klon.setReserve06(getReserve06());
							klon.setReserve07(getReserve07());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveProVerkehrsStufen";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsLveProVerkehrsStufen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
