/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält Korrektur-Informationen zu einem Sensor&#47;Detektor in einer
                    Parktasche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsPupKorrekturSensor implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturSensorBelegung
			 _korrekturBelegung
			;
	
		/**
		Legt die Korrektur für die Belegung des Sensors&#47;Detektors fest.
		<p>
		
		</p>
		
		@return der Wert von KorrekturBelegung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturSensorBelegung
			 getKorrekturBelegung() {
			return _korrekturBelegung;
		}
	
		/**
		Legt die Korrektur für die Belegung des Sensors&#47;Detektors fest.
		<p>
		
		</p>
		
		@param _korrekturBelegung der neue Wert von KorrekturBelegung.
		*/
		public void setKorrekturBelegung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturSensorBelegung
		 _korrekturBelegung) {
			this._korrekturBelegung = _korrekturBelegung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getKorrekturBelegung() != null) {
	                if (getKorrekturBelegung().isZustand()) {
	                    datum.getUnscaledValue("KorrekturBelegung").setText(getKorrekturBelegung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KorrekturBelegung").set(getKorrekturBelegung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("KorrekturBelegung").isState()) {
							setKorrekturBelegung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturSensorBelegung
							.getZustand(daten.getScaledValue("KorrekturBelegung").getText()));
						} else {
						setKorrekturBelegung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturSensorBelegung
						(daten.
							getUnscaledValue
						("KorrekturBelegung").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsPupKorrekturSensor clone() {
		AtlTlsPupKorrekturSensor klon = new AtlTlsPupKorrekturSensor();
		
						klon.setKorrekturBelegung(getKorrekturBelegung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
