/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält Informationen zu einem Sensor&#47;Detektor in einer Parktasche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsPupSensor implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorBelegung
			 _belegung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorZustand
			 _zustand
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorReserve
			 _reserve
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorHerstellerInfo
			 _herstellerInfo
			;
	
		/**
		Gibt an, ob der Sensor&#47;Detektor belegt ist.
		<p>
		
		</p>
		
		@return der Wert von Belegung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorBelegung
			 getBelegung() {
			return _belegung;
		}
	
		/**
		Gibt an, ob der Sensor&#47;Detektor belegt ist.
		<p>
		
		</p>
		
		@param _belegung der neue Wert von Belegung.
		*/
		public void setBelegung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorBelegung
		 _belegung) {
			this._belegung = _belegung;
		}
	
		/**
		Gibt den Zustand des Sensors&#47;Detektors an.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorZustand
			 getZustand() {
			return _zustand;
		}
	
		/**
		Gibt den Zustand des Sensors&#47;Detektors an.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorZustand
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Reserve.
		<p>
		
		</p>
		
		@return der Wert von Reserve.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorReserve
			 getReserve() {
			return _reserve;
		}
	
		/**
		Reserve.
		<p>
		
		</p>
		
		@param _reserve der neue Wert von Reserve.
		*/
		public void setReserve(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorReserve
		 _reserve) {
			this._reserve = _reserve;
		}
	
		/**
		Herstellerspezifische Informationen.
		<p>
		
		</p>
		
		@return der Wert von HerstellerInfo.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorHerstellerInfo
			 getHerstellerInfo() {
			return _herstellerInfo;
		}
	
		/**
		Herstellerspezifische Informationen.
		<p>
		
		</p>
		
		@param _herstellerInfo der neue Wert von HerstellerInfo.
		*/
		public void setHerstellerInfo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorHerstellerInfo
		 _herstellerInfo) {
			this._herstellerInfo = _herstellerInfo;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBelegung() != null) {
	                if (getBelegung().isZustand()) {
	                    datum.getUnscaledValue("Belegung").setText(getBelegung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Belegung").set(getBelegung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getReserve() != null) {
	                if (getReserve().isZustand()) {
	                    datum.getUnscaledValue("Reserve").setText(getReserve().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Reserve").set(getReserve().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getHerstellerInfo() != null) {
	                if (getHerstellerInfo().isZustand()) {
	                    datum.getUnscaledValue("HerstellerInfo").setText(getHerstellerInfo().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("HerstellerInfo").set(getHerstellerInfo().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Belegung").isState()) {
							setBelegung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorBelegung
							.getZustand(daten.getScaledValue("Belegung").getText()));
						} else {
						setBelegung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorBelegung
						(daten.
							getUnscaledValue
						("Belegung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorZustand
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorZustand
						(daten.
							getUnscaledValue
						("Zustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setReserve(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorReserve
						(daten.
							getUnscaledValue
						("Reserve").
								byteValue
						()));
				// GanzzahlAttributTyp
						setHerstellerInfo(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorHerstellerInfo
						(daten.
							getUnscaledValue
						("HerstellerInfo").
								byteValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsPupSensor clone() {
		AtlTlsPupSensor klon = new AtlTlsPupSensor();
		
						klon.setBelegung(getBelegung());
						klon.setZustand(getZustand());
						klon.setReserve(getReserve());
						klon.setHerstellerInfo(getHerstellerInfo());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
