/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrzeugklassencodes gemäß TLS.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsPupFahrzeugKlassenCode extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_1_PKWG = new AttTlsPupFahrzeugKlassenCode("PkwG", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_2_PKWA = new AttTlsPupFahrzeugKlassenCode("PkwA", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_3_LKW = new AttTlsPupFahrzeugKlassenCode("Lkw", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_4_LKWK = new AttTlsPupFahrzeugKlassenCode("LkwK", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_5_BUSSE = new AttTlsPupFahrzeugKlassenCode("Busse", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_6_NKKFZ = new AttTlsPupFahrzeugKlassenCode("nkKfz", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_7_PKW = new AttTlsPupFahrzeugKlassenCode("Pkw", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_8_LKWA = new AttTlsPupFahrzeugKlassenCode("LkwA", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_9_SATTELKFZ = new AttTlsPupFahrzeugKlassenCode("SattelKfz", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_10_MRAD = new AttTlsPupFahrzeugKlassenCode("MRad", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_11_LFW = new AttTlsPupFahrzeugKlassenCode("Lfw", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_32_PKWAE = new AttTlsPupFahrzeugKlassenCode("PkwÄ", 		Byte
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_33_LKWAE = new AttTlsPupFahrzeugKlassenCode("LkwÄ", 		Byte
	.valueOf("33"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_34_BPA = new AttTlsPupFahrzeugKlassenCode("BPA", 		Byte
	.valueOf("34"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_35_SGV = new AttTlsPupFahrzeugKlassenCode("SGV", 		Byte
	.valueOf("35"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_36_LVO = new AttTlsPupFahrzeugKlassenCode("LVo", 		Byte
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCode ZUSTAND_64_KFZ = new AttTlsPupFahrzeugKlassenCode("Kfz", 		Byte
	.valueOf("64"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPupFahrzeugKlassenCode getZustand(final 		Byte
	 value) {
		for (AttTlsPupFahrzeugKlassenCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPupFahrzeugKlassenCode getZustand(final String value) {
		for (AttTlsPupFahrzeugKlassenCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPupFahrzeugKlassenCode> getZustaende() {
		List<AttTlsPupFahrzeugKlassenCode> list = new ArrayList<AttTlsPupFahrzeugKlassenCode>();
		list.add(ZUSTAND_1_PKWG);
		list.add(ZUSTAND_2_PKWA);
		list.add(ZUSTAND_3_LKW);
		list.add(ZUSTAND_4_LKWK);
		list.add(ZUSTAND_5_BUSSE);
		list.add(ZUSTAND_6_NKKFZ);
		list.add(ZUSTAND_7_PKW);
		list.add(ZUSTAND_8_LKWA);
		list.add(ZUSTAND_9_SATTELKFZ);
		list.add(ZUSTAND_10_MRAD);
		list.add(ZUSTAND_11_LFW);
		list.add(ZUSTAND_32_PKWAE);
		list.add(ZUSTAND_33_LKWAE);
		list.add(ZUSTAND_34_BPA);
		list.add(ZUSTAND_35_SGV);
		list.add(ZUSTAND_36_LVO);
		list.add(ZUSTAND_64_KFZ);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsPupFahrzeugKlassenCode.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPupFahrzeugKlassenCode(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsPupFahrzeugKlassenCode(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
