/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Anzahl der Fahrzeuge kann je Fahrzeugklasse (gemäß ANHANG 2.2)
                    unterschiedlich korrigiert werden. Bei Verwendung einer nicht zugelassenen
                    Fahrzeugklasse antwortet das DE mit einer negativen Quittung (Fehlerursache
                    6). Folgende Fahrzeugklassencodes sind für eine Korrektur zulässig: nk Kfz
                    (6), Krad (10), Pkw (7), Lfw (11), Lkw (3), LkwA (8), Sattel-Kfz (9), Bus
                    (5), PkwA (2), Sollte das System, z.B. nur zwischen Pkw- ähnlichen und Lkw-
                    ähnlichen Fahrzeugen unterscheiden, kann die Korrektur der Pkw- ähnlichen
                    Fahrzeuge mit den Codes 6, 7 ,10 oder 11 durchgeführt werden (gemäß ANHANG
                    2.2, Pkw-Ähnliche Fahrzeuge).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsPupFahrzeugKlassenCodeKorrektur extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_2_PKWA = new AttTlsPupFahrzeugKlassenCodeKorrektur("PkwA", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_3_LKW = new AttTlsPupFahrzeugKlassenCodeKorrektur("Lkw", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_5_BUSSE = new AttTlsPupFahrzeugKlassenCodeKorrektur("Busse", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_6_NKKFZ = new AttTlsPupFahrzeugKlassenCodeKorrektur("nkKfz", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_7_PKW = new AttTlsPupFahrzeugKlassenCodeKorrektur("Pkw", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_8_LKWA = new AttTlsPupFahrzeugKlassenCodeKorrektur("LkwA", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_9_SATTELKFZ = new AttTlsPupFahrzeugKlassenCodeKorrektur("SattelKfz", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_10_MRAD = new AttTlsPupFahrzeugKlassenCodeKorrektur("MRad", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupFahrzeugKlassenCodeKorrektur ZUSTAND_11_LFW = new AttTlsPupFahrzeugKlassenCodeKorrektur("Lfw", 		Byte
	.valueOf("11"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPupFahrzeugKlassenCodeKorrektur getZustand(final 		Byte
	 value) {
		for (AttTlsPupFahrzeugKlassenCodeKorrektur e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPupFahrzeugKlassenCodeKorrektur getZustand(final String value) {
		for (AttTlsPupFahrzeugKlassenCodeKorrektur e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPupFahrzeugKlassenCodeKorrektur> getZustaende() {
		List<AttTlsPupFahrzeugKlassenCodeKorrektur> list = new ArrayList<AttTlsPupFahrzeugKlassenCodeKorrektur>();
		list.add(ZUSTAND_2_PKWA);
		list.add(ZUSTAND_3_LKW);
		list.add(ZUSTAND_5_BUSSE);
		list.add(ZUSTAND_6_NKKFZ);
		list.add(ZUSTAND_7_PKW);
		list.add(ZUSTAND_8_LKWA);
		list.add(ZUSTAND_9_SATTELKFZ);
		list.add(ZUSTAND_10_MRAD);
		list.add(ZUSTAND_11_LFW);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsPupFahrzeugKlassenCodeKorrektur.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPupFahrzeugKlassenCodeKorrektur(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsPupFahrzeugKlassenCodeKorrektur(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
