/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Wert "Max. Anzahl nicht StVO konformen Parkplätze" gibt die max.
                    Anzahl der verfügbaren nicht StVO konformen Parkplätze an. Unter nicht StVO
                    konformen Parkplätzen versteht man die sogenannten Wildparker (Standflächen,
                    welche nicht als Parkflächen ausgewiesen sind). Sollten keine nicht StVO
                    konformen Parkplätze verfügbar sein, wird der Wert auf 0 gesetzt. Da max. 40
                    Parkplatzbereiche pro Parkplatz erlaubt sind, ergibt sich eine max. Anzahl
                    von 40x254=10160 Parkplätzen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 10160L,
	einheit = "Parkplätze"
)
public class AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("10160");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "Parkplätze";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze ZUSTAND_0_KEINE_PARKPLAETZE_VORHANDEN = new AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze("Keine Parkplätze vorhanden", 		Integer
	.valueOf("0"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze getZustand(final 		Integer
	 value) {
		for (AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze getZustand(final String value) {
		for (AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze> getZustaende() {
		List<AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze> list = new ArrayList<AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze>();
		list.add(ZUSTAND_0_KEINE_PARKPLAETZE_VORHANDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsPupMaxAnzahlNichtStVOkonformerParkPlätze.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze(final 		Integer
	 value) {
		super(value);
	}
	
	private AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
