/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Antwort auf ein nicht auswertbares Telegramm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsPupNegativeQuittung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_0_SONSTIGE_FEHLERURSACHE = new AttTlsPupNegativeQuittung("sonstige Fehlerursache", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID = new AttTlsPupNegativeQuittung("unbekannte oder nicht auswertbare ID", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP = new AttTlsPupNegativeQuittung("unbekannter oder nicht auswertbarer Typ", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_3_UEBERTRAGUNGSVERFAHREN_FUER_DIESEN_TYP_NICHT_ZULAESSIG = new AttTlsPupNegativeQuittung("Übertragungsverfahren für diesen Typ nicht zulässig", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_4_ERFASSUNGSINTERVALLDAUER_FEHLERHAFT = new AttTlsPupNegativeQuittung("Erfassungsintervalldauer fehlerhaft", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_5_VERSIONSNUMMER_NICHT_ZULAESSIG_BZW_WIRD_NICHT_UNTERSTUETZT = new AttTlsPupNegativeQuittung("Versionsnummer nicht zulässig bzw. wird nicht unterstützt", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_6_FAHRZEUGKLASSE_GRUPPE_NICHT_ZUGELASSENEN = new AttTlsPupNegativeQuittung("Fahrzeugklasse/-gruppe nicht zugelassenen", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_7_KORREKTURMETHODE_UNBEKANNT = new AttTlsPupNegativeQuittung("Korrekturmethode unbekannt", 		Short
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_8_KEINE_ERFASSUNG_DER_PARKTASCHENBELEGUNG = new AttTlsPupNegativeQuittung("keine Erfassung der Parktaschenbelegung", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_9_FEHLERHAFTE_KORREKTUR_DER_PARKTASCHENBELEGUNG_PARKPLATZBELEGUNG = new AttTlsPupNegativeQuittung("fehlerhafte Korrektur der Parktaschenbelegung/Parkplatzbelegung", 		Short
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_10_FEHLERHAFTE_MINDESTRESTLAENGE_DER_PARKSTANDSREIHEN = new AttTlsPupNegativeQuittung("fehlerhafte Mindestrestlänge der Parkstandsreihen", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_11_KEINE_PARKSTANDSREIHEN_VORHANDEN = new AttTlsPupNegativeQuittung("keine Parkstandsreihen vorhanden", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_12_FEHLERHAFTE_ANZAHL_STVO_KONFORMER_PARKPLAETZE = new AttTlsPupNegativeQuittung("fehlerhafte Anzahl StVO konformer Parkplätze", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_13_FEHLERHAFTE_ANZAHL_NICHT_STVO_KONFORMER_PARKPLAETZE = new AttTlsPupNegativeQuittung("fehlerhafte Anzahl nicht StVO konformer Parkplätze", 		Short
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_14_ANZAHL_STVO_KONFORMER_UND_NICHT_STVO_KONFORMER_PARKPLAETZE_IST_NULL = new AttTlsPupNegativeQuittung("Anzahl StVO konformer und nicht StVO konformer Parkplätze ist Null", 		Short
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupNegativeQuittung ZUSTAND_15_FEHLERHAFTE_ANZAHL_PARKPLATZBEREICHE = new AttTlsPupNegativeQuittung("fehlerhafte Anzahl Parkplatzbereiche", 		Short
	.valueOf("15"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPupNegativeQuittung getZustand(final 		Short
	 value) {
		for (AttTlsPupNegativeQuittung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPupNegativeQuittung getZustand(final String value) {
		for (AttTlsPupNegativeQuittung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPupNegativeQuittung> getZustaende() {
		List<AttTlsPupNegativeQuittung> list = new ArrayList<AttTlsPupNegativeQuittung>();
		list.add(ZUSTAND_0_SONSTIGE_FEHLERURSACHE);
		list.add(ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID);
		list.add(ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP);
		list.add(ZUSTAND_3_UEBERTRAGUNGSVERFAHREN_FUER_DIESEN_TYP_NICHT_ZULAESSIG);
		list.add(ZUSTAND_4_ERFASSUNGSINTERVALLDAUER_FEHLERHAFT);
		list.add(ZUSTAND_5_VERSIONSNUMMER_NICHT_ZULAESSIG_BZW_WIRD_NICHT_UNTERSTUETZT);
		list.add(ZUSTAND_6_FAHRZEUGKLASSE_GRUPPE_NICHT_ZUGELASSENEN);
		list.add(ZUSTAND_7_KORREKTURMETHODE_UNBEKANNT);
		list.add(ZUSTAND_8_KEINE_ERFASSUNG_DER_PARKTASCHENBELEGUNG);
		list.add(ZUSTAND_9_FEHLERHAFTE_KORREKTUR_DER_PARKTASCHENBELEGUNG_PARKPLATZBELEGUNG);
		list.add(ZUSTAND_10_FEHLERHAFTE_MINDESTRESTLAENGE_DER_PARKSTANDSREIHEN);
		list.add(ZUSTAND_11_KEINE_PARKSTANDSREIHEN_VORHANDEN);
		list.add(ZUSTAND_12_FEHLERHAFTE_ANZAHL_STVO_KONFORMER_PARKPLAETZE);
		list.add(ZUSTAND_13_FEHLERHAFTE_ANZAHL_NICHT_STVO_KONFORMER_PARKPLAETZE);
		list.add(ZUSTAND_14_ANZAHL_STVO_KONFORMER_UND_NICHT_STVO_KONFORMER_PARKPLAETZE_IST_NULL);
		list.add(ZUSTAND_15_FEHLERHAFTE_ANZAHL_PARKPLATZBEREICHE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsPupNegativeQuittung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPupNegativeQuittung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsPupNegativeQuittung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
