/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Belegung der Parkstandsreihen (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 62).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;
                            FG 210: TLS-DE-Block-Struktur im Typ 62 "Belegung der Parkstandsreihen"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;
                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Übertragung der Belegung der Parkstandsreihen (Status,
                            Belegungszustand und Restlänge) geschieht nur spontan nach
                            "Meldeintervall der Parkstandsreihen" (siehe DE-Block Typ33,
                            AddOn-Parameter). Die Daten können nicht ab-gerufen werden. Dieser
                            DE-Block muss immer mit Zeitstempel Typ 30 gesendet werden. Lassen sich
                            (z. B. aufgrund von Sensor- oder Detektorfehlern) einige Restlängen bzw.
                            Belegungszustände von Parkstandsreihen nicht ermitteln, ohne dass ein
                            Totalausfall des Systems vorliegt, werden die betroffenen Restlängen auf
                            den Wert 2047 (7FFh) bzw. für den Belegungszustand auf den Wert 3 (3h)
                            gesetzt.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupBelegungParkStandsReihen extends AbstractOnlineDatensatz<OdTlsPupBelegungParkStandsReihen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupZustandParkStandsReihe
				> _zustandParkStandsReihe = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupZustandParkStandsReihe
				>(109, true);
		
			/**
			Der Wert "Anzahl der Parkstandsreihen" überträgt die Anzahl der
			                        nachfolgenden Parkstandsreihen. Jede Parkstandsreihe setzt sich aus zwei
			                        Byte zusammen. Es können max. 109 Parkstandsreihen übertragen werden. Werden
			                        mehr als 109 Parkstandsreihen benötigt, hat dies über eine neue DE-Adresse
			                        zu erfolgen. Da max. 75 DEs in einem EAK zulässig sind (siehe Definition in
			                        ANHANG 6, Teil 2, 2.2.10 - "DE-Zuordnung"), ergibt sich eine max. Kapazität
			                        von 8066 Parkstandsreihen pro EAK (75 DEs - Cluster = 74 * 109
			                        Parkstandsreihen = 8066 Parkstandsreihen).
			<p>
			
			</p>
			
			@return der Wert von ZustandParkStandsReihe.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupZustandParkStandsReihe
				> getZustandParkStandsReihe() {
				return _zustandParkStandsReihe;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayZustandParkStandsReihe = datum.getArray("ZustandParkStandsReihe");
						arrayZustandParkStandsReihe.setLength(getZustandParkStandsReihe().size());
						for (int i = 0; i < arrayZustandParkStandsReihe.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupZustandParkStandsReihe
							 atl = getZustandParkStandsReihe().get(i);
							atl.bean2Atl(arrayZustandParkStandsReihe.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayZustandParkStandsReihe = daten.getArray("ZustandParkStandsReihe");
						for (int i = 0; i < arrayZustandParkStandsReihe.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupZustandParkStandsReihe
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupZustandParkStandsReihe
							 ();
							atl.atl2Bean(arrayZustandParkStandsReihe.getItem(i), factory);
							getZustandParkStandsReihe().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._zustandParkStandsReihe = getZustandParkStandsReihe().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupBelegungParkStandsReihen";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupBelegungParkStandsReihen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
