/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Fahrzeugidentifikation (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 63).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;
                            FG 210: TLS-DE-Block-Struktur im Typ 63 "Ergebnismeldung Fahrzeugidentifikation"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;
                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Mit Hilfe von Sensoren und Detektoren (z.B. Induktionsschleifen,
                            Videodetektion) werden Profile von Fahrzeugen (z.B. beim Ein- oder
                            Ausfahren auf den Parkplatz) ermittelt. Jedem Fahrzeug&#47;Profil wird eine
                            eindeutige ID- Nummer zugeordnet. Sollte das Fahrzeug erneut beim
                            Durchqueren einer Identifikationsstelle auf dem Parkplatz erkannt
                            werden, bekommt es wieder die gleiche ID- Nummer zugeordnet. Jede
                            Identifikation eines Fahrzeuges auf den Parkplatz wird an die Zentrale
                            gemeldet. Ein Profil verliert 72 Stunden nach seiner letzten Detektion
                            seine Gültigkeit und die zugehörige ID- Nummer wird wieder freigegeben.
                            Anhand der Detektionsdaten (z.B.: erste- und letzte Detektion) kann
                            später in der Zentrale die Verweildauer einzelner Fahrzeuge ermittelt
                            werden.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupFahrzeugIdentifikation extends AbstractOnlineDatensatz<OdTlsPupFahrzeugIdentifikation.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupID
				 _iD
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsZaehler
				 _detektionsZaehler
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsOrt
				 _detektionsOrt
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCode
				 _fahrzeugKlassenCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupGeschwindigkeit
				 _geschwindigkeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegtZeit
				 _belegtZeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugLaenge
				 _fahrzeugLaenge
				;
		
			/**
			Die ID- Nummer ist eine laufende Nummer im Bereich von 0...4294967295 (4
			                        Byte). Jedem neu erkannten Fahrzeug&#47;Profil wird eine eindeutige ID- Nummer
			                        zugeordnet. Nach Erreichen des Wertes 4294967295 wird mit der kleinsten
			                        freien ID- Nummer fortgesetzt. Für Fahrzeuge, bei denen keine
			                        Identifizierung möglich war, wird die ID- Nummer 0 verwendet.
			<p>
			
			</p>
			
			@return der Wert von ID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupID
				 getID() {
				return _iD;
			}
		
			/**
			Die ID- Nummer ist eine laufende Nummer im Bereich von 0...4294967295 (4
			                        Byte). Jedem neu erkannten Fahrzeug&#47;Profil wird eine eindeutige ID- Nummer
			                        zugeordnet. Nach Erreichen des Wertes 4294967295 wird mit der kleinsten
			                        freien ID- Nummer fortgesetzt. Für Fahrzeuge, bei denen keine
			                        Identifizierung möglich war, wird die ID- Nummer 0 verwendet.
			<p>
			
			</p>
			
			@param _iD der neue Wert von ID.
			*/
			public void setID(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupID
			 _iD) {
				this._iD = _iD;
			}
		
			/**
			Bei der erstmaligen Detektion eines Fahrzeuges und der damit
			                        verbundenen Zuweisung einer ID- Nummer, wird der Detektionszähler auf 1
			                        gesetzt. Durchquert das Fahrzeug anschließend weitere Detektionspunkte auf
			                        dem Parkplatz, wird der Detektionszähler immer um eins erhöht.
			<p>
			
			</p>
			
			@return der Wert von DetektionsZaehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsZaehler
				 getDetektionsZaehler() {
				return _detektionsZaehler;
			}
		
			/**
			Bei der erstmaligen Detektion eines Fahrzeuges und der damit
			                        verbundenen Zuweisung einer ID- Nummer, wird der Detektionszähler auf 1
			                        gesetzt. Durchquert das Fahrzeug anschließend weitere Detektionspunkte auf
			                        dem Parkplatz, wird der Detektionszähler immer um eins erhöht.
			<p>
			
			</p>
			
			@param _detektionsZaehler der neue Wert von DetektionsZaehler.
			*/
			public void setDetektionsZaehler(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsZaehler
			 _detektionsZaehler) {
				this._detektionsZaehler = _detektionsZaehler;
			}
		
			/**
			Zusätzlich wird in den beiden oberen Bits der Detektionsort
			                        signalisiert: 0 Detektionsort nicht näher spezifiziert; 1 Detektionsort ist
			                        eine Einfahrt; 2 Detektionsort ist eine Ausfahrt; 3 Detektionsort befindet
			                        sich auf dem Parkplatz.
			<p>
			
			</p>
			
			@return der Wert von DetektionsOrt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsOrt
				 getDetektionsOrt() {
				return _detektionsOrt;
			}
		
			/**
			Zusätzlich wird in den beiden oberen Bits der Detektionsort
			                        signalisiert: 0 Detektionsort nicht näher spezifiziert; 1 Detektionsort ist
			                        eine Einfahrt; 2 Detektionsort ist eine Ausfahrt; 3 Detektionsort befindet
			                        sich auf dem Parkplatz.
			<p>
			
			</p>
			
			@param _detektionsOrt der neue Wert von DetektionsOrt.
			*/
			public void setDetektionsOrt(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsOrt
			 _detektionsOrt) {
				this._detektionsOrt = _detektionsOrt;
			}
		
			/**
			Welche Fahrzeugklassen detektiert werden können, ist vom Sensor bzw.
			                        Detektor abhängig. Bei Detektoren ohne Typunterscheidung wird die Codenummer
			                        64 bzw. 6 verwendet. Bei Detektoren mit einfacher Unterscheidung zwischen
			                        Pkw-Ähnlichen und Lkw-Ähnlichen Fahrzeugen werden nur die Codenummern 32 und
			                        33 verwendet bzw. bei einer Klassifizierung in 3 Klassen, werden die
			                        Codenummern 34, 35 und 36 verwendet. Bei Detektoren, die eine
			                        Klassifizierung in 5+1 Klassen vornehmen, werden die Codenummern 1 bis 6
			                        verwendet. Bei Detektoren, die eine Klassifizierung in 8+1 Klassen
			                        vornehmen, werden die Codenummern 2, 3 und 5 bis 11 verwendet.
			<p>
			
			</p>
			
			@return der Wert von FahrzeugKlassenCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCode
				 getFahrzeugKlassenCode() {
				return _fahrzeugKlassenCode;
			}
		
			/**
			Welche Fahrzeugklassen detektiert werden können, ist vom Sensor bzw.
			                        Detektor abhängig. Bei Detektoren ohne Typunterscheidung wird die Codenummer
			                        64 bzw. 6 verwendet. Bei Detektoren mit einfacher Unterscheidung zwischen
			                        Pkw-Ähnlichen und Lkw-Ähnlichen Fahrzeugen werden nur die Codenummern 32 und
			                        33 verwendet bzw. bei einer Klassifizierung in 3 Klassen, werden die
			                        Codenummern 34, 35 und 36 verwendet. Bei Detektoren, die eine
			                        Klassifizierung in 5+1 Klassen vornehmen, werden die Codenummern 1 bis 6
			                        verwendet. Bei Detektoren, die eine Klassifizierung in 8+1 Klassen
			                        vornehmen, werden die Codenummern 2, 3 und 5 bis 11 verwendet.
			<p>
			
			</p>
			
			@param _fahrzeugKlassenCode der neue Wert von FahrzeugKlassenCode.
			*/
			public void setFahrzeugKlassenCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCode
			 _fahrzeugKlassenCode) {
				this._fahrzeugKlassenCode = _fahrzeugKlassenCode;
			}
		
			/**
			Die Geschwindigkeit wird in km&#47;h mit einer Auflösung von 1 km&#47;h
			                        übertragen Bei ermittelten Geschwindigkeiten von 0-253 km&#47;h wird der
			                        ermittelte Wert übertragen, bei ermittelten Geschwindigkeiten größer 253
			                        km&#47;h wird 254 übertragen. Kann die Geschwindigkeit nicht ermittelt werden,
			                        wird 255 übertragen.
			<p>
			
			</p>
			
			@return der Wert von Geschwindigkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupGeschwindigkeit
				 getGeschwindigkeit() {
				return _geschwindigkeit;
			}
		
			/**
			Die Geschwindigkeit wird in km&#47;h mit einer Auflösung von 1 km&#47;h
			                        übertragen Bei ermittelten Geschwindigkeiten von 0-253 km&#47;h wird der
			                        ermittelte Wert übertragen, bei ermittelten Geschwindigkeiten größer 253
			                        km&#47;h wird 254 übertragen. Kann die Geschwindigkeit nicht ermittelt werden,
			                        wird 255 übertragen.
			<p>
			
			</p>
			
			@param _geschwindigkeit der neue Wert von Geschwindigkeit.
			*/
			public void setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupGeschwindigkeit
			 _geschwindigkeit) {
				this._geschwindigkeit = _geschwindigkeit;
			}
		
			/**
			Die Belegtzeit ist der Quotient aus ermittelter Fahrzeuglänge und
			                        Fahrzeuggeschwindigkeit. Sie ist unabhängig von dem Detektionsbereich und
			                        entspricht der Zeit, die ein Fahrzeug zur Überquerung einer gedachten Linie
			                        auf der Fahrbahn senkrecht zur Fahrtrichtung benötigt. Die Belegtzeit wird
			                        im Bereich von 0 bis 65534 Millisekunden mit der Auflösung von 1
			                        Millisekunde als vorzeichen-loser Wert (0000h-FFFEh) übertragen. Bei Werten
			                        größer als 65534 Millisekunden wird der Wert 65534 übertragen. Lässt sich
			                        die Belegtzeit vom Detektor nicht ermitteln, wird der Wert 65535 (=FFFFh)
			                        übertragen.
			<p>
			
			</p>
			
			@return der Wert von BelegtZeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegtZeit
				 getBelegtZeit() {
				return _belegtZeit;
			}
		
			/**
			Die Belegtzeit ist der Quotient aus ermittelter Fahrzeuglänge und
			                        Fahrzeuggeschwindigkeit. Sie ist unabhängig von dem Detektionsbereich und
			                        entspricht der Zeit, die ein Fahrzeug zur Überquerung einer gedachten Linie
			                        auf der Fahrbahn senkrecht zur Fahrtrichtung benötigt. Die Belegtzeit wird
			                        im Bereich von 0 bis 65534 Millisekunden mit der Auflösung von 1
			                        Millisekunde als vorzeichen-loser Wert (0000h-FFFEh) übertragen. Bei Werten
			                        größer als 65534 Millisekunden wird der Wert 65534 übertragen. Lässt sich
			                        die Belegtzeit vom Detektor nicht ermitteln, wird der Wert 65535 (=FFFFh)
			                        übertragen.
			<p>
			
			</p>
			
			@param _belegtZeit der neue Wert von BelegtZeit.
			*/
			public void setBelegtZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegtZeit
			 _belegtZeit) {
				this._belegtZeit = _belegtZeit;
			}
		
			/**
			Die ermittelte Fahrzeuglänge wird mit der Auflösung von 1 Dezimeter im
			                        Bereich von 0 bis 254 dm als vorzeichen-loser Wert übertragen. Kann die
			                        Fahrzeuglänge nicht ermittelt werden, wird 255 übertragen.
			<p>
			
			</p>
			
			@return der Wert von FahrzeugLaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugLaenge
				 getFahrzeugLaenge() {
				return _fahrzeugLaenge;
			}
		
			/**
			Die ermittelte Fahrzeuglänge wird mit der Auflösung von 1 Dezimeter im
			                        Bereich von 0 bis 254 dm als vorzeichen-loser Wert übertragen. Kann die
			                        Fahrzeuglänge nicht ermittelt werden, wird 255 übertragen.
			<p>
			
			</p>
			
			@param _fahrzeugLaenge der neue Wert von FahrzeugLaenge.
			*/
			public void setFahrzeugLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugLaenge
			 _fahrzeugLaenge) {
				this._fahrzeugLaenge = _fahrzeugLaenge;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getID() != null) {
		                if (getID().isZustand()) {
		                    datum.getUnscaledValue("ID").setText(getID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ID").set(getID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDetektionsZaehler() != null) {
		                if (getDetektionsZaehler().isZustand()) {
		                    datum.getUnscaledValue("DetektionsZähler").setText(getDetektionsZaehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DetektionsZähler").set(getDetektionsZaehler().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDetektionsOrt() != null) {
		                if (getDetektionsOrt().isZustand()) {
		                    datum.getUnscaledValue("DetektionsOrt").setText(getDetektionsOrt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DetektionsOrt").set(getDetektionsOrt().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrzeugKlassenCode() != null) {
		                if (getFahrzeugKlassenCode().isZustand()) {
		                    datum.getUnscaledValue("FahrzeugKlassenCode").setText(getFahrzeugKlassenCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FahrzeugKlassenCode").set(getFahrzeugKlassenCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGeschwindigkeit() != null) {
		                if (getGeschwindigkeit().isZustand()) {
		                    datum.getUnscaledValue("Geschwindigkeit").setText(getGeschwindigkeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Geschwindigkeit").set(getGeschwindigkeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZeit() != null) {
		                if (getBelegtZeit().isZustand()) {
		                    datum.getUnscaledValue("BelegtZeit").setText(getBelegtZeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZeit").set(getBelegtZeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrzeugLaenge() != null) {
		                if (getFahrzeugLaenge().isZustand()) {
		                    datum.getUnscaledValue("FahrzeugLänge").setText(getFahrzeugLaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FahrzeugLänge").set(getFahrzeugLaenge().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ID").isState()) {
								setID(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupID
								.getZustand(daten.getScaledValue("ID").getText()));
							} else {
							setID(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupID
							(daten.
								getUnscaledValue
							("ID").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DetektionsZähler").isState()) {
								setDetektionsZaehler(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsZaehler
								.getZustand(daten.getScaledValue("DetektionsZähler").getText()));
							} else {
							setDetektionsZaehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsZaehler
							(daten.
								getUnscaledValue
							("DetektionsZähler").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DetektionsOrt").isState()) {
								setDetektionsOrt(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsOrt
								.getZustand(daten.getScaledValue("DetektionsOrt").getText()));
							} else {
							setDetektionsOrt(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupDetektionsOrt
							(daten.
								getUnscaledValue
							("DetektionsOrt").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FahrzeugKlassenCode").isState()) {
								setFahrzeugKlassenCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCode
								.getZustand(daten.getScaledValue("FahrzeugKlassenCode").getText()));
							} else {
							setFahrzeugKlassenCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCode
							(daten.
								getUnscaledValue
							("FahrzeugKlassenCode").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Geschwindigkeit").isState()) {
								setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupGeschwindigkeit
								.getZustand(daten.getScaledValue("Geschwindigkeit").getText()));
							} else {
							setGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupGeschwindigkeit
							(daten.
								getUnscaledValue
							("Geschwindigkeit").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZeit").isState()) {
								setBelegtZeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegtZeit
								.getZustand(daten.getScaledValue("BelegtZeit").getText()));
							} else {
							setBelegtZeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegtZeit
							(daten.
								getUnscaledValue
							("BelegtZeit").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FahrzeugLänge").isState()) {
								setFahrzeugLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugLaenge
								.getZustand(daten.getScaledValue("FahrzeugLänge").getText()));
							} else {
							setFahrzeugLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugLaenge
							(daten.
								getUnscaledValue
							("FahrzeugLänge").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setID(getID());
							klon.setDetektionsZaehler(getDetektionsZaehler());
							klon.setDetektionsOrt(getDetektionsOrt());
							klon.setFahrzeugKlassenCode(getFahrzeugKlassenCode());
							klon.setGeschwindigkeit(getGeschwindigkeit());
							klon.setBelegtZeit(getBelegtZeit());
							klon.setFahrzeugLaenge(getFahrzeugLaenge());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupFahrzeugIdentifikation";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupFahrzeugIdentifikation(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
