/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Freie Parkplatzbereichszonen (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 61).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;
                            FG 210: TLS-DE-Block-Struktur im Typ 61 "Freie Parkplatzbereichszonen"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;
                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt die freien Parkplatzbereichszonen. Lassen
                            sich (z. B. aufgrund von Sensor- oder Detektorfehlern) einzelne Werte
                            des Blockes nicht ermitteln, ohne dass ein Totalausfall des DE vorliegt,
                            werden die betroffenen Bytes auf den Wert 255 (65535) gesetzt.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupFreieParkPlatzBereichsZonen extends AbstractOnlineDatensatz<OdTlsPupFreieParkPlatzBereichsZonen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
				 _parkPlatzBereich
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupNrParkPlatzBereichsZone
				 _parkPlatzBereichsZone
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
				 _maxParkPlaetze
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
				 _qfPB
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
				 _qbfPB
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSegmentVerweilDauer
				> _segmentVerweilDauer = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSegmentVerweilDauer
				>(200, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _reserve1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _reserve2
				;
		
			/**
			Der Wert "Parkplatzbereich" enthält die Nummer des Parkplatzbereiches
			                        1..40.
			<p>
			
			</p>
			
			@return der Wert von ParkPlatzBereich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
				 getParkPlatzBereich() {
				return _parkPlatzBereich;
			}
		
			/**
			Der Wert "Parkplatzbereich" enthält die Nummer des Parkplatzbereiches
			                        1..40.
			<p>
			
			</p>
			
			@param _parkPlatzBereich der neue Wert von ParkPlatzBereich.
			*/
			public void setParkPlatzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
			 _parkPlatzBereich) {
				this._parkPlatzBereich = _parkPlatzBereich;
			}
		
			/**
			Der Wert "Parkplatzbereichszone" enthält die Nummer der
			                        Parkplatzbereichszone 1..100. Eine Parkplatzbereichszone kann z.B. ein oder
			                        mehrere Lkw-Einzelstellplätze sein.
			<p>
			
			</p>
			
			@return der Wert von ParkPlatzBereichsZone.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupNrParkPlatzBereichsZone
				 getParkPlatzBereichsZone() {
				return _parkPlatzBereichsZone;
			}
		
			/**
			Der Wert "Parkplatzbereichszone" enthält die Nummer der
			                        Parkplatzbereichszone 1..100. Eine Parkplatzbereichszone kann z.B. ein oder
			                        mehrere Lkw-Einzelstellplätze sein.
			<p>
			
			</p>
			
			@param _parkPlatzBereichsZone der neue Wert von ParkPlatzBereichsZone.
			*/
			public void setParkPlatzBereichsZone(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupNrParkPlatzBereichsZone
			 _parkPlatzBereichsZone) {
				this._parkPlatzBereichsZone = _parkPlatzBereichsZone;
			}
		
			/**
			Der Wert "Max. Anzahl Parkplätze" gibt die max. Anzahl der verfügbaren
			                        Parkplätze in diesem Parkplatzbereich an.
			<p>
			
			</p>
			
			@return der Wert von MaxParkPlaetze.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
				 getMaxParkPlaetze() {
				return _maxParkPlaetze;
			}
		
			/**
			Der Wert "Max. Anzahl Parkplätze" gibt die max. Anzahl der verfügbaren
			                        Parkplätze in diesem Parkplatzbereich an.
			<p>
			
			</p>
			
			@param _maxParkPlaetze der neue Wert von MaxParkPlaetze.
			*/
			public void setMaxParkPlaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
			 _maxParkPlaetze) {
				this._maxParkPlaetze = _maxParkPlaetze;
			}
		
			/**
			Der Wert "Anzahl freie Parkplätze" überträgt die Anzahl der freien
			                        Parkplätze, unabhängig vom Typ des Parkplatzbereiches.
			<p>
			
			</p>
			
			@return der Wert von QfPB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
				 getQfPB() {
				return _qfPB;
			}
		
			/**
			Der Wert "Anzahl freie Parkplätze" überträgt die Anzahl der freien
			                        Parkplätze, unabhängig vom Typ des Parkplatzbereiches.
			<p>
			
			</p>
			
			@param _qfPB der neue Wert von QfPB.
			*/
			public void setQfPB(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
			 _qfPB) {
				this._qfPB = _qfPB;
			}
		
			/**
			Der Wert "Anzahl blockierte freie Parkplätze" überträgt die Anzahl der
			                        blockierten freien Parkplätze, unabhängig vom Typ des Parkplatzbereiches.
			                        Diese Parkplätze werden als besetzt bzw. nicht anfahrbar gewertet und sind
			                        nicht im Wert QfPB enthalten.
			<p>
			
			</p>
			
			@return der Wert von QbfPB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
				 getQbfPB() {
				return _qbfPB;
			}
		
			/**
			Der Wert "Anzahl blockierte freie Parkplätze" überträgt die Anzahl der
			                        blockierten freien Parkplätze, unabhängig vom Typ des Parkplatzbereiches.
			                        Diese Parkplätze werden als besetzt bzw. nicht anfahrbar gewertet und sind
			                        nicht im Wert QfPB enthalten.
			<p>
			
			</p>
			
			@param _qbfPB der neue Wert von QbfPB.
			*/
			public void setQbfPB(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
			 _qbfPB) {
				this._qbfPB = _qbfPB;
			}
		
			/**
			Die Werte "SegmentVerweilDauer 1...x" enthalten den Segmentstatus in Form
			                        einer Verweildauer, der in angefangenen Stunden übertragen wird: 0:
			                        Segment nicht belegt; 1: Segment belegt, Verweildauer 1min ...&lt;=1h;
			                        2:
			                        Segment belegt, Verweildauer &gt;1h ...&lt;=2h; 3...254:
			                        Segment belegt,
			                        Verweildauer &gt;2h ...&lt;=254h bzw. wenn größer 254h dann
			                        254 255: Wert nicht
			                        ermittelbar.
			<p>
			
			</p>
			
			@return der Wert von SegmentVerweilDauer.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSegmentVerweilDauer
				> getSegmentVerweilDauer() {
				return _segmentVerweilDauer;
			}
		
		
			/**
			Reserve1.
			<p>
			
			</p>
			
			@return der Wert von Reserve1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getReserve1() {
				return _reserve1;
			}
		
			/**
			Reserve1.
			<p>
			
			</p>
			
			@param _reserve1 der neue Wert von Reserve1.
			*/
			public void setReserve1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _reserve1) {
				this._reserve1 = _reserve1;
			}
		
			/**
			Reserve2.
			<p>
			
			</p>
			
			@return der Wert von Reserve2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getReserve2() {
				return _reserve2;
			}
		
			/**
			Reserve2.
			<p>
			
			</p>
			
			@param _reserve2 der neue Wert von Reserve2.
			*/
			public void setReserve2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _reserve2) {
				this._reserve2 = _reserve2;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getParkPlatzBereich() != null) {
		                if (getParkPlatzBereich().isZustand()) {
		                    datum.getUnscaledValue("ParkPlatzBereich").setText(getParkPlatzBereich().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ParkPlatzBereich").set(getParkPlatzBereich().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getParkPlatzBereichsZone() != null) {
		                if (getParkPlatzBereichsZone().isZustand()) {
		                    datum.getUnscaledValue("ParkPlatzBereichsZone").setText(getParkPlatzBereichsZone().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ParkPlatzBereichsZone").set(getParkPlatzBereichsZone().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxParkPlaetze() != null) {
		                if (getMaxParkPlaetze().isZustand()) {
		                    datum.getUnscaledValue("MaxParkPlätze").setText(getMaxParkPlaetze().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxParkPlätze").set(getMaxParkPlaetze().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQfPB() != null) {
		                if (getQfPB().isZustand()) {
		                    datum.getUnscaledValue("QfPB").setText(getQfPB().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QfPB").set(getQfPB().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQbfPB() != null) {
		                if (getQbfPB().isZustand()) {
		                    datum.getUnscaledValue("QbfPB").setText(getQbfPB().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QbfPB").set(getQbfPB().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSegmentVerweilDauer() != null) {
						final Data.NumberArray arraySegmentVerweilDauer = datum.
							getUnscaledArray
							("SegmentVerweilDauer");
						arraySegmentVerweilDauer.setLength(getSegmentVerweilDauer().size());
						for (int i = 0; i < arraySegmentVerweilDauer.getLength(); ++i) {
							arraySegmentVerweilDauer.getValue(i).set(getSegmentVerweilDauer().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getReserve1() != null) {
		                if (getReserve1().isZustand()) {
		                    datum.getUnscaledValue("Reserve1").setText(getReserve1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve1").set(getReserve1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve2() != null) {
		                if (getReserve2().isZustand()) {
		                    datum.getUnscaledValue("Reserve2").setText(getReserve2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve2").set(getReserve2().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ParkPlatzBereich").isState()) {
								setParkPlatzBereich(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
								.getZustand(daten.getScaledValue("ParkPlatzBereich").getText()));
							} else {
							setParkPlatzBereich(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
							(daten.
								getUnscaledValue
							("ParkPlatzBereich").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setParkPlatzBereichsZone(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupNrParkPlatzBereichsZone
							(daten.
								getUnscaledValue
							("ParkPlatzBereichsZone").
									byteValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxParkPlätze").isState()) {
								setMaxParkPlaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
								.getZustand(daten.getScaledValue("MaxParkPlätze").getText()));
							} else {
							setMaxParkPlaetze(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
							(daten.
								getUnscaledValue
							("MaxParkPlätze").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QfPB").isState()) {
								setQfPB(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
								.getZustand(daten.getScaledValue("QfPB").getText()));
							} else {
							setQfPB(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
							(daten.
								getUnscaledValue
							("QfPB").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QbfPB").isState()) {
								setQbfPB(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
								.getZustand(daten.getScaledValue("QbfPB").getText()));
							} else {
							setQbfPB(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetzeParkBereich
							(daten.
								getUnscaledValue
							("QbfPB").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arraySegmentVerweilDauer = daten.
							getUnscaledArray
						("SegmentVerweilDauer");
		
						for (int i = 0; i < arraySegmentVerweilDauer.getLength(); ++i) {
		                    if (arraySegmentVerweilDauer.getValue(i).isState()) {
		                        getSegmentVerweilDauer().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSegmentVerweilDauer
		                        .getZustand(arraySegmentVerweilDauer.getValue(i).getState().getName()));
		                    } else {
		                    getSegmentVerweilDauer().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSegmentVerweilDauer
		                    (arraySegmentVerweilDauer.
		                    		shortValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
							setReserve1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("Reserve1").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("Reserve2").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setParkPlatzBereich(getParkPlatzBereich());
							klon.setParkPlatzBereichsZone(getParkPlatzBereichsZone());
							klon.setMaxParkPlaetze(getMaxParkPlaetze());
							klon.setQfPB(getQfPB());
							klon.setQbfPB(getQbfPB());
						klon._segmentVerweilDauer = getSegmentVerweilDauer().clone();
							klon.setReserve1(getReserve1());
							klon.setReserve2(getReserve2());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupFreieParkPlatzBereichsZonen";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupFreieParkPlatzBereichsZonen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
