/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Korrektur der Parkplatzbelegung (Parken und
                    Parkplatzüberwachung - FG 210 &#47; Typ 38).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 38 "korrektur der
                            Parkplatzbelegung"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abrufrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt den Korrekturfaktor der Parkplatzbelegung
                            bzw. den Absolutbetrag an Fahrzeugen für eine Fahrzeugklasse. Als
                            Antworttelegramm wird der DE-Block mit der aktuell eingestellten
                            Versionsnummer (z.B. "Ergebnismeldung Parkplatzbelegung Version 1",
                            "...2", "...") gesendet.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupKorrekturParkPlatzBelegung extends AbstractOnlineDatensatz<OdTlsPupKorrekturParkPlatzBelegung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabeArchiv,
					Aspekte.TlsVorgabe,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.tlsVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsVorgabeArchiv");
			
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCodeKorrektur
				 _fahrzeugKlassenCode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturMethode
				 _korrekturMethode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturFaktor
				 _korrekturFaktor
				;
		
			/**
			Die Anzahl der Fahrzeuge kann je Fahrzeugklasse (gemäß ANHANG 2.2)
			                        unterschiedlich korrigiert werden. Bei Verwendung einer nicht zugelassenen
			                        Fahrzeugklasse antwortet das DE mit einer negativen Quittung (Fehlerursache
			                        6). Folgende Fahrzeugklassencodes sind für eine Korrektur zulässig: nk Kfz
			                        (6), Krad (10), Pkw (7), Lfw (11), Lkw (3), LkwA (8), Sattel-Kfz (9), Bus
			                        (5), PkwA (2), Sollte das System, z.B. nur zwischen Pkw- ähnlichen und Lkw-
			                        ähnlichen Fahrzeugen unterscheiden, kann die Korrektur der Pkw- ähnlichen
			                        Fahrzeuge mit den Codes 6, 7 ,10 oder 11 durchgeführt werden (gemäß ANHANG
			                        2.2, Pkw-Ähnliche Fahrzeuge).
			<p>
			
			</p>
			
			@return der Wert von FahrzeugKlassenCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCodeKorrektur
				 getFahrzeugKlassenCode() {
				return _fahrzeugKlassenCode;
			}
		
			/**
			Die Anzahl der Fahrzeuge kann je Fahrzeugklasse (gemäß ANHANG 2.2)
			                        unterschiedlich korrigiert werden. Bei Verwendung einer nicht zugelassenen
			                        Fahrzeugklasse antwortet das DE mit einer negativen Quittung (Fehlerursache
			                        6). Folgende Fahrzeugklassencodes sind für eine Korrektur zulässig: nk Kfz
			                        (6), Krad (10), Pkw (7), Lfw (11), Lkw (3), LkwA (8), Sattel-Kfz (9), Bus
			                        (5), PkwA (2), Sollte das System, z.B. nur zwischen Pkw- ähnlichen und Lkw-
			                        ähnlichen Fahrzeugen unterscheiden, kann die Korrektur der Pkw- ähnlichen
			                        Fahrzeuge mit den Codes 6, 7 ,10 oder 11 durchgeführt werden (gemäß ANHANG
			                        2.2, Pkw-Ähnliche Fahrzeuge).
			<p>
			
			</p>
			
			@param _fahrzeugKlassenCode der neue Wert von FahrzeugKlassenCode.
			*/
			public void setFahrzeugKlassenCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCodeKorrektur
			 _fahrzeugKlassenCode) {
				this._fahrzeugKlassenCode = _fahrzeugKlassenCode;
			}
		
			/**
			Die "Korrekturmethode" beschreibt die Art und Weise der zu korrigierenden
			                        Fahrzeugklasse: 0: Die Anzahl der Fahrzeuge für die angegebene
			                        Fahrzeugklasse wird auf den Wert von "Korrekturfaktor" gesetzt
			                        (Absolutbetrag); 1: Die Anzahl der Fahrzeuge für die angegebene
			                        Fahrzeugklasse wird mit dem Wert von "Korrekturfaktor" addiert (Anzahl der
			                        aktuellen Fahrzeuge + Korrekturfaktor); 2: Die Anzahl der Fahrzeuge für die
			                        angegebene Fahrzeugklasse wird mit dem Wert von "Korrekturfaktor"
			                        subtrahiert (Anzahl der aktuellen Fahrzeuge - Korrekturfaktor); 3..255:
			                        reserviert, negative Quittung (Fehlerursache 7).
			<p>
			
			</p>
			
			@return der Wert von KorrekturMethode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturMethode
				 getKorrekturMethode() {
				return _korrekturMethode;
			}
		
			/**
			Die "Korrekturmethode" beschreibt die Art und Weise der zu korrigierenden
			                        Fahrzeugklasse: 0: Die Anzahl der Fahrzeuge für die angegebene
			                        Fahrzeugklasse wird auf den Wert von "Korrekturfaktor" gesetzt
			                        (Absolutbetrag); 1: Die Anzahl der Fahrzeuge für die angegebene
			                        Fahrzeugklasse wird mit dem Wert von "Korrekturfaktor" addiert (Anzahl der
			                        aktuellen Fahrzeuge + Korrekturfaktor); 2: Die Anzahl der Fahrzeuge für die
			                        angegebene Fahrzeugklasse wird mit dem Wert von "Korrekturfaktor"
			                        subtrahiert (Anzahl der aktuellen Fahrzeuge - Korrekturfaktor); 3..255:
			                        reserviert, negative Quittung (Fehlerursache 7).
			<p>
			
			</p>
			
			@param _korrekturMethode der neue Wert von KorrekturMethode.
			*/
			public void setKorrekturMethode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturMethode
			 _korrekturMethode) {
				this._korrekturMethode = _korrekturMethode;
			}
		
			/**
			Der "Korrekturfaktor" ist die Anzahl der zu korrigierenden Fahrzeuge für die
			                        angegebene Fahrzeugklasse. Abhängig von der "Korrekturmethode" wird dieser
			                        Wert entweder als Absolutbetrag für die jeweilige Fahrzeugklasse eingesetzt
			                        oder ausgehend von der aktuellen Anzahl von Fahrzeugen addiert oder
			                        subtrahiert. Sollte bei der Addition oder Subtraktion ein Wert &gt;65534
			                        bzw.&lt;0 entstehen, ist die Anzahl der Fahrzeuge auf 65534 bzw. 0 zu
			                        setzen. Der Wert 65535 ist nicht zulässig.
			<p>
			
			</p>
			
			@return der Wert von KorrekturFaktor.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturFaktor
				 getKorrekturFaktor() {
				return _korrekturFaktor;
			}
		
			/**
			Der "Korrekturfaktor" ist die Anzahl der zu korrigierenden Fahrzeuge für die
			                        angegebene Fahrzeugklasse. Abhängig von der "Korrekturmethode" wird dieser
			                        Wert entweder als Absolutbetrag für die jeweilige Fahrzeugklasse eingesetzt
			                        oder ausgehend von der aktuellen Anzahl von Fahrzeugen addiert oder
			                        subtrahiert. Sollte bei der Addition oder Subtraktion ein Wert &gt;65534
			                        bzw.&lt;0 entstehen, ist die Anzahl der Fahrzeuge auf 65534 bzw. 0 zu
			                        setzen. Der Wert 65535 ist nicht zulässig.
			<p>
			
			</p>
			
			@param _korrekturFaktor der neue Wert von KorrekturFaktor.
			*/
			public void setKorrekturFaktor(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturFaktor
			 _korrekturFaktor) {
				this._korrekturFaktor = _korrekturFaktor;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getFahrzeugKlassenCode() != null) {
		                if (getFahrzeugKlassenCode().isZustand()) {
		                    datum.getUnscaledValue("FahrzeugKlassenCode").setText(getFahrzeugKlassenCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FahrzeugKlassenCode").set(getFahrzeugKlassenCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKorrekturMethode() != null) {
		                if (getKorrekturMethode().isZustand()) {
		                    datum.getUnscaledValue("KorrekturMethode").setText(getKorrekturMethode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KorrekturMethode").set(getKorrekturMethode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKorrekturFaktor() != null) {
		                if (getKorrekturFaktor().isZustand()) {
		                    datum.getUnscaledValue("KorrekturFaktor").setText(getKorrekturFaktor().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KorrekturFaktor").set(getKorrekturFaktor().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FahrzeugKlassenCode").isState()) {
								setFahrzeugKlassenCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCodeKorrektur
								.getZustand(daten.getScaledValue("FahrzeugKlassenCode").getText()));
							} else {
							setFahrzeugKlassenCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupFahrzeugKlassenCodeKorrektur
							(daten.
								getUnscaledValue
							("FahrzeugKlassenCode").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KorrekturMethode").isState()) {
								setKorrekturMethode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturMethode
								.getZustand(daten.getScaledValue("KorrekturMethode").getText()));
							} else {
							setKorrekturMethode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturMethode
							(daten.
								getUnscaledValue
							("KorrekturMethode").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setKorrekturFaktor(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKorrekturFaktor
							(daten.
								getUnscaledValue
							("KorrekturFaktor").
									intValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setFahrzeugKlassenCode(getFahrzeugKlassenCode());
							klon.setKorrekturMethode(getKorrekturMethode());
							klon.setKorrekturFaktor(getKorrekturFaktor());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupKorrekturParkPlatzBelegung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupKorrekturParkPlatzBelegung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
