/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Parkplatzbelegung für die Versionen 0 (Parken und
                    Parkplatzüberwachung - FG 210 &#47; Typ 48).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 48 "Ergebnismeldung
                            Parkplatzbelegung"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt den aktuellen Zustand der Parktaschen inkl.
                            ihrer Sensoren (z.B. Magnetkopfsensoren oder Induktionsschleifen). Die
                            Detektion der Belegung muss mittels einer Verzögerung so realisiert
                            werden, dass fahrende Fahrzeuge ignoriert werden.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Jede Parktasche besteht aus ein bis max. vier Sensoren&#47;Detektoren.
                            Auf Grund der begrenzten Kapazität von max. 109 Parktaschen
                            (Anwendungsfall: jeweils eine Parktasche mit einem Sensor&#47;Detektor) pro
                            DE-Block, wird dieser DE-Typ in der Regel mehrmals pro EAK verwendet. Da
                            max. 75 DEs in einem EAK zulässig sind (siehe Definition in ANHANG 6,
                            Teil 2, 2.2.10 - "DE-Zuordnung"), ergibt sich eine max. Kapazität von
                            8066 Parktaschen pro EAK (75 DEs - Cluster = 74 * 109 Parktaschen = 8066
                            Parktaschen).
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupParkPlatzBelegungVersion0 extends AbstractOnlineDatensatz<OdTlsPupParkPlatzBelegungVersion0.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupParkTasche
				> _parkTasche = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupParkTasche
				>(109, true);
		
			/**
			Jede Parktasche besteht aus ein bis max. vier Sensoren&#47;Detektoren.
			<p>
			
			</p>
			
			@return der Wert von ParkTasche.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupParkTasche
				> getParkTasche() {
				return _parkTasche;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayParkTasche = datum.getArray("ParkTasche");
						arrayParkTasche.setLength(getParkTasche().size());
						for (int i = 0; i < arrayParkTasche.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupParkTasche
							 atl = getParkTasche().get(i);
							atl.bean2Atl(arrayParkTasche.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayParkTasche = daten.getArray("ParkTasche");
						for (int i = 0; i < arrayParkTasche.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupParkTasche
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupParkTasche
							 ();
							atl.atl2Bean(arrayParkTasche.getItem(i), factory);
							getParkTasche().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._parkTasche = getParkTasche().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupParkPlatzBelegungVersion0";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupParkPlatzBelegungVersion0(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
