/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Parkplatzbelegung für die Versionen 1-5 (Parken und
                    Parkplatzüberwachung - FG 210 &#47; Typ 49-53).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 49-53 "Ergebnismeldung
                            Parkplatzbelegung"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt die Anzahl der sich aktuell auf dem
                            Parkplatz befindlichen Kraftfahrzeuge. Lassen sich (z. B. aufgrund von
                            Sensor- oder Detektorfehlern) einzelne Werte des Blockes nicht
                            ermitteln, ohne dass ein Totalausfall des DE vorliegt, werden die
                            betroffenen Bytes auf den Wert 255 (65535) gesetzt.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupParkPlatzBelegungVersion1Bis5 extends AbstractOnlineDatensatz<OdTlsPupParkPlatzBelegungVersion1Bis5.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _kfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _pkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _lkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _lVoAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _sGVAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _bPAAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _nkKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _pkwG
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _lkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _lkwK
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _bus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _pkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _mRad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _pkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _lfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _lkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 _sattelKfz
				;
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von Kfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getKfz() {
				return _kfz;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _kfz der neue Wert von Kfz.
			*/
			public void setKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _kfz) {
				this._kfz = _kfz;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von PkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getPkwAe() {
				return _pkwAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _pkwAe der neue Wert von PkwAe.
			*/
			public void setPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _pkwAe) {
				this._pkwAe = _pkwAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von LkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getLkwAe() {
				return _lkwAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _lkwAe der neue Wert von LkwAe.
			*/
			public void setLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _lkwAe) {
				this._lkwAe = _lkwAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von LVoAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getLVoAe() {
				return _lVoAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _lVoAe der neue Wert von LVoAe.
			*/
			public void setLVoAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _lVoAe) {
				this._lVoAe = _lVoAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von SGVAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getSGVAe() {
				return _sGVAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _sGVAe der neue Wert von SGVAe.
			*/
			public void setSGVAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _sGVAe) {
				this._sGVAe = _sGVAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von BPAAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getBPAAe() {
				return _bPAAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _bPAAe der neue Wert von BPAAe.
			*/
			public void setBPAAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _bPAAe) {
				this._bPAAe = _bPAAe;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von NkKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getNkKfz() {
				return _nkKfz;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _nkKfz der neue Wert von NkKfz.
			*/
			public void setNkKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _nkKfz) {
				this._nkKfz = _nkKfz;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von PkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getPkwG() {
				return _pkwG;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _pkwG der neue Wert von PkwG.
			*/
			public void setPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _pkwG) {
				this._pkwG = _pkwG;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von Lkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getLkw() {
				return _lkw;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _lkw der neue Wert von Lkw.
			*/
			public void setLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _lkw) {
				this._lkw = _lkw;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von LkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getLkwK() {
				return _lkwK;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _lkwK der neue Wert von LkwK.
			*/
			public void setLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _lkwK) {
				this._lkwK = _lkwK;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von Bus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getBus() {
				return _bus;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _bus der neue Wert von Bus.
			*/
			public void setBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _bus) {
				this._bus = _bus;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von PkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getPkwA() {
				return _pkwA;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _pkwA der neue Wert von PkwA.
			*/
			public void setPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _pkwA) {
				this._pkwA = _pkwA;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von MRad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getMRad() {
				return _mRad;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _mRad der neue Wert von MRad.
			*/
			public void setMRad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _mRad) {
				this._mRad = _mRad;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von Pkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getPkw() {
				return _pkw;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _pkw der neue Wert von Pkw.
			*/
			public void setPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _pkw) {
				this._pkw = _pkw;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von Lfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getLfw() {
				return _lfw;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _lfw der neue Wert von Lfw.
			*/
			public void setLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _lfw) {
				this._lfw = _lfw;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von LkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getLkwA() {
				return _lkwA;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _lkwA der neue Wert von LkwA.
			*/
			public void setLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _lkwA) {
				this._lkwA = _lkwA;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@return der Wert von SattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
				 getSattelKfz() {
				return _sattelKfz;
			}
		
			/**
			Anzahl der Fahrzeuge unabhängig von der Klassifizierung.
			<p>
			
			</p>
			
			@param _sattelKfz der neue Wert von SattelKfz.
			*/
			public void setSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
			 _sattelKfz) {
				this._sattelKfz = _sattelKfz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getKfz() != null) {
		                if (getKfz().isZustand()) {
		                    datum.getUnscaledValue("Kfz").setText(getKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Kfz").set(getKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkwAe() != null) {
		                if (getPkwAe().isZustand()) {
		                    datum.getUnscaledValue("PkwÄ").setText(getPkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PkwÄ").set(getPkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLkwAe() != null) {
		                if (getLkwAe().isZustand()) {
		                    datum.getUnscaledValue("LkwÄ").setText(getLkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LkwÄ").set(getLkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLVoAe() != null) {
		                if (getLVoAe().isZustand()) {
		                    datum.getUnscaledValue("LVoÄ").setText(getLVoAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LVoÄ").set(getLVoAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSGVAe() != null) {
		                if (getSGVAe().isZustand()) {
		                    datum.getUnscaledValue("SGVÄ").setText(getSGVAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SGVÄ").set(getSGVAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBPAAe() != null) {
		                if (getBPAAe().isZustand()) {
		                    datum.getUnscaledValue("BPAÄ").setText(getBPAAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BPAÄ").set(getBPAAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNkKfz() != null) {
		                if (getNkKfz().isZustand()) {
		                    datum.getUnscaledValue("nkKfz").setText(getNkKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("nkKfz").set(getNkKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkwG() != null) {
		                if (getPkwG().isZustand()) {
		                    datum.getUnscaledValue("PkwG").setText(getPkwG().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PkwG").set(getPkwG().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLkw() != null) {
		                if (getLkw().isZustand()) {
		                    datum.getUnscaledValue("Lkw").setText(getLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Lkw").set(getLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLkwK() != null) {
		                if (getLkwK().isZustand()) {
		                    datum.getUnscaledValue("LkwK").setText(getLkwK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LkwK").set(getLkwK().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBus() != null) {
		                if (getBus().isZustand()) {
		                    datum.getUnscaledValue("Bus").setText(getBus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Bus").set(getBus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkwA() != null) {
		                if (getPkwA().isZustand()) {
		                    datum.getUnscaledValue("PkwA").setText(getPkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PkwA").set(getPkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMRad() != null) {
		                if (getMRad().isZustand()) {
		                    datum.getUnscaledValue("MRad").setText(getMRad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MRad").set(getMRad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkw() != null) {
		                if (getPkw().isZustand()) {
		                    datum.getUnscaledValue("Pkw").setText(getPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Pkw").set(getPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLfw() != null) {
		                if (getLfw().isZustand()) {
		                    datum.getUnscaledValue("Lfw").setText(getLfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Lfw").set(getLfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLkwA() != null) {
		                if (getLkwA().isZustand()) {
		                    datum.getUnscaledValue("LkwA").setText(getLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LkwA").set(getLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSattelKfz() != null) {
		                if (getSattelKfz().isZustand()) {
		                    datum.getUnscaledValue("SattelKfz").setText(getSattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SattelKfz").set(getSattelKfz().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Kfz").isState()) {
								setKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("Kfz").getText()));
							} else {
							setKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("Kfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PkwÄ").isState()) {
								setPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("PkwÄ").getText()));
							} else {
							setPkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("PkwÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LkwÄ").isState()) {
								setLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("LkwÄ").getText()));
							} else {
							setLkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("LkwÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LVoÄ").isState()) {
								setLVoAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("LVoÄ").getText()));
							} else {
							setLVoAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("LVoÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SGVÄ").isState()) {
								setSGVAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("SGVÄ").getText()));
							} else {
							setSGVAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("SGVÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BPAÄ").isState()) {
								setBPAAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("BPAÄ").getText()));
							} else {
							setBPAAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("BPAÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("nkKfz").isState()) {
								setNkKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("nkKfz").getText()));
							} else {
							setNkKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("nkKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PkwG").isState()) {
								setPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("PkwG").getText()));
							} else {
							setPkwG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("PkwG").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Lkw").isState()) {
								setLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("Lkw").getText()));
							} else {
							setLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("Lkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LkwK").isState()) {
								setLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("LkwK").getText()));
							} else {
							setLkwK(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("LkwK").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Bus").isState()) {
								setBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("Bus").getText()));
							} else {
							setBus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("Bus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PkwA").isState()) {
								setPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("PkwA").getText()));
							} else {
							setPkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("PkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MRad").isState()) {
								setMRad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("MRad").getText()));
							} else {
							setMRad(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("MRad").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Pkw").isState()) {
								setPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("Pkw").getText()));
							} else {
							setPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("Pkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Lfw").isState()) {
								setLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("Lfw").getText()));
							} else {
							setLfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("Lfw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LkwA").isState()) {
								setLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("LkwA").getText()));
							} else {
							setLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("LkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SattelKfz").isState()) {
								setSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
								.getZustand(daten.getScaledValue("SattelKfz").getText()));
							} else {
							setSattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlFahrzeuge
							(daten.
								getUnscaledValue
							("SattelKfz").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKfz(getKfz());
							klon.setPkwAe(getPkwAe());
							klon.setLkwAe(getLkwAe());
							klon.setLVoAe(getLVoAe());
							klon.setSGVAe(getSGVAe());
							klon.setBPAAe(getBPAAe());
							klon.setNkKfz(getNkKfz());
							klon.setPkwG(getPkwG());
							klon.setLkw(getLkw());
							klon.setLkwK(getLkwK());
							klon.setBus(getBus());
							klon.setPkwA(getPkwA());
							klon.setMRad(getMRad());
							klon.setPkw(getPkw());
							klon.setLfw(getLfw());
							klon.setLkwA(getLkwA());
							klon.setSattelKfz(getSattelKfz());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupParkPlatzBelegungVersion1Bis5";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupParkPlatzBelegungVersion1Bis5(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
