/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste mit TLS ähnlichen Kommunikationspartnern und
					den Kommunikationsparametern.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlKommunikationsPartner implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _pid
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
			 _knotenNummer
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _fG
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _dEKanal
			;
			private String
			 _umsetzungsModul
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.Geraet
			 _pidSender
			;
	
		/**
		Pid des Objektes, für den die TLS-Applikation
								Daten (TLS ähnliche Kommunikation) verarbeiten
								soll.
		<p>
		
		</p>
		
		@return der Wert von Pid.
		*/
			public 	Object
			 getPid() {
			return _pid;
		}
	
		/**
		Pid des Objektes, für den die TLS-Applikation
								Daten (TLS ähnliche Kommunikation) verarbeiten
								soll.
		<p>
		
		</p>
		
		@param _pid der neue Wert von Pid.
		*/
		public void setPid(	Object
		 _pid) {
			this._pid = _pid;
		}
	
		/**
		Knotennummer (OSI-7-Adresse) des Gerätes.
		<p>
		
		</p>
		
		@return der Wert von KnotenNummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
			 getKnotenNummer() {
			return _knotenNummer;
		}
	
		/**
		Knotennummer (OSI-7-Adresse) des Gerätes.
		<p>
		
		</p>
		
		@param _knotenNummer der neue Wert von KnotenNummer.
		*/
		public void setKnotenNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
		 _knotenNummer) {
			this._knotenNummer = _knotenNummer;
		}
	
		/**
		Funktionsgruppe der Daten für dieses Objekt.
		<p>
		
		</p>
		
		@return der Wert von FG.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getFG() {
			return _fG;
		}
	
		/**
		Funktionsgruppe der Daten für dieses Objekt.
		<p>
		
		</p>
		
		@param _fG der neue Wert von FG.
		*/
		public void setFG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _fG) {
			this._fG = _fG;
		}
	
		/**
		DE-Nummer des Datenendgerätes.
		<p>
		
		</p>
		
		@return der Wert von DEKanal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getDEKanal() {
			return _dEKanal;
		}
	
		/**
		DE-Nummer des Datenendgerätes.
		<p>
		
		</p>
		
		@param _dEKanal der neue Wert von DEKanal.
		*/
		public void setDEKanal(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _dEKanal) {
			this._dEKanal = _dEKanal;
		}
	
		/**
		Das für die Umsetzung des Protokolls (Lesen und
								Schreiben) verwendete Modul an diesem Knoten.
								Wird kein Modul angegeben, wird jeweils das
								Standardumsetzungmodul für diesen Objekttyp
								verwendet. Text ist der Klassennamen des
								UmsetzungsModuls.
		<p>
		
		</p>
		
		@return der Wert von UmsetzungsModul.
		*/
			public String
			 getUmsetzungsModul() {
			return _umsetzungsModul;
		}
	
		/**
		Das für die Umsetzung des Protokolls (Lesen und
								Schreiben) verwendete Modul an diesem Knoten.
								Wird kein Modul angegeben, wird jeweils das
								Standardumsetzungmodul für diesen Objekttyp
								verwendet. Text ist der Klassennamen des
								UmsetzungsModuls.
		<p>
		
		</p>
		
		@param _umsetzungsModul der neue Wert von UmsetzungsModul.
		*/
		public void setUmsetzungsModul(String
		 _umsetzungsModul) {
			if (_umsetzungsModul.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._umsetzungsModul = _umsetzungsModul;
		}
	
		/**
		Pid des das Telegramm sendenden Gerätes.
		<p>
		
		</p>
		
		@return der Wert von PidSender.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.Geraet
			 getPidSender() {
			return _pidSender;
		}
	
		/**
		Pid des das Telegramm sendenden Gerätes.
		<p>
		
		</p>
		
		@param _pidSender der neue Wert von PidSender.
		*/
		public void setPidSender(	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.Geraet
		 _pidSender) {
			this._pidSender = _pidSender;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soPid = getPid();
					final SystemObject tmpPid;
						if (soPid instanceof SystemObject) {
							tmpPid = (SystemObject)soPid;
						} else if(soPid instanceof SystemObjekt){
							tmpPid = ((SystemObjekt)soPid).getSystemObject();
						} else{
							tmpPid = null;
						}
					datum.getReferenceValue("Pid").setSystemObject(tmpPid);
				// GanzzahlAttributTyp
				if (getKnotenNummer() != null) {
	                if (getKnotenNummer().isZustand()) {
	                    datum.getUnscaledValue("KnotenNummer").setText(getKnotenNummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KnotenNummer").set(getKnotenNummer().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFG() != null) {
	                if (getFG().isZustand()) {
	                    datum.getUnscaledValue("FG").setText(getFG().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FG").set(getFG().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDEKanal() != null) {
	                if (getDEKanal().isZustand()) {
	                    datum.getUnscaledValue("DEKanal").setText(getDEKanal().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("DEKanal").set(getDEKanal().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getUmsetzungsModul() != null) {
					datum.getTextValue("UmsetzungsModul").setText(getUmsetzungsModul());
				}
				// ObjektReferenzAttributTyp
					final Object soPidSender = getPidSender();
					final SystemObject tmpPidSender;
						if (soPidSender instanceof SystemObject) {
							tmpPidSender = (SystemObject)soPidSender;
						} else if(soPidSender instanceof SystemObjekt){
							tmpPidSender = ((SystemObjekt)soPidSender).getSystemObject();
						} else{
							tmpPidSender = null;
						}
					datum.getReferenceValue("PidSender").setSystemObject(tmpPidSender);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idPid = daten.getReferenceValue("Pid").getId();
					final SystemObjekt tmpPid;
					if (idPid == 0) {
						tmpPid = null;
					} else {
						final SystemObject soPid = factory.getDav().getDataModel().getObject(idPid);
						if (soPid == null) {
								tmpPid = new BaseUngueltigesSystemObjekt(idPid);
						} else {
							tmpPid = factory.getModellobjekt(soPid);
						}
					}
					setPid((	Object
					) tmpPid);
				// GanzzahlAttributTyp
						setKnotenNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysKnotenNummer
						(daten.
							getUnscaledValue
						("KnotenNummer").
								intValue
						()));
				// GanzzahlAttributTyp
						setFG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("FG").
								shortValue
						()));
				// GanzzahlAttributTyp
						setDEKanal(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("DEKanal").
								shortValue
						()));
				// ZeichenkettenAttributTyp
					setUmsetzungsModul(daten.getTextValue("UmsetzungsModul").getText());
				// ObjektReferenzAttributTyp
					final long idPidSender = daten.getReferenceValue("PidSender").getId();
					final SystemObjekt tmpPidSender;
					if (idPidSender == 0) {
						tmpPidSender = null;
					} else {
						final SystemObject soPidSender = factory.getDav().getDataModel().getObject(idPidSender);
						if (soPidSender == null) {
								tmpPidSender = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.impl.GeraetUngueltig(idPidSender);
						} else {
							tmpPidSender = factory.getModellobjekt(soPidSender);
						}
					}
					setPidSender((	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.Geraet
					) tmpPidSender);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlKommunikationsPartner clone() {
		AtlKommunikationsPartner klon = new AtlKommunikationsPartner();
		
						klon.setPid(getPid());
						klon.setKnotenNummer(getKnotenNummer());
						klon.setFG(getFG());
						klon.setDEKanal(getDEKanal());
						klon.setUmsetzungsModul(getUmsetzungsModul());
						klon.setPidSender(getPidSender());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
