/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen zu überladen Fahrzeugen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 13
 */
public class AtlTlsAxlUeberlastungAchse implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
			 _ueberlastEinzelachse
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
			 _ueberlastDoppelachse
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
			 _ueberlastDreifachachse
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _achslast
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
			 _radlastLinks
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
			 _radlastRechts
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge3
			 _achsabstand
			;
	
		/**
		Überlastung einer Einzelachse.
		<p>
		
		</p>
		
		@return der Wert von UeberlastEinzelachse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
			 getUeberlastEinzelachse() {
			return _ueberlastEinzelachse;
		}
	
		/**
		Überlastung einer Einzelachse.
		<p>
		
		</p>
		
		@param _ueberlastEinzelachse der neue Wert von UeberlastEinzelachse.
		*/
		public void setUeberlastEinzelachse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
		 _ueberlastEinzelachse) {
			this._ueberlastEinzelachse = _ueberlastEinzelachse;
		}
	
		/**
		Überlastung einer Doppelachse.
		<p>
		
		</p>
		
		@return der Wert von UeberlastDoppelachse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
			 getUeberlastDoppelachse() {
			return _ueberlastDoppelachse;
		}
	
		/**
		Überlastung einer Doppelachse.
		<p>
		
		</p>
		
		@param _ueberlastDoppelachse der neue Wert von UeberlastDoppelachse.
		*/
		public void setUeberlastDoppelachse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
		 _ueberlastDoppelachse) {
			this._ueberlastDoppelachse = _ueberlastDoppelachse;
		}
	
		/**
		Überlastung einer Dreifachachse.
		<p>
		
		</p>
		
		@return der Wert von UeberlastDreifachachse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
			 getUeberlastDreifachachse() {
			return _ueberlastDreifachachse;
		}
	
		/**
		Überlastung einer Dreifachachse.
		<p>
		
		</p>
		
		@param _ueberlastDreifachachse der neue Wert von UeberlastDreifachachse.
		*/
		public void setUeberlastDreifachachse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
		 _ueberlastDreifachachse) {
			this._ueberlastDreifachachse = _ueberlastDreifachachse;
		}
	
		/**
		Achslast.
		<p>
		Die Bytes enthalten die ermittelte Achslast
								einer einzelnen Achse. Bei Mehrfachachsen wird
								für jede einzelne Achse ein gesonderter Satz
								Messwerte (jeweils Überladung&#47;Achsart, Achslast,
								Achsabstand) im DE-Block übertragen. Als Achsart
								wird bei den einzelnen Messwerten jeweils der
								Typ der Mehrfachachse (nicht Einzelachse!)
								angegeben.
		</p>
		
		@return der Wert von Achslast.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 getAchslast() {
			return _achslast;
		}
	
		/**
		Achslast.
		<p>
		Die Bytes enthalten die ermittelte Achslast
								einer einzelnen Achse. Bei Mehrfachachsen wird
								für jede einzelne Achse ein gesonderter Satz
								Messwerte (jeweils Überladung&#47;Achsart, Achslast,
								Achsabstand) im DE-Block übertragen. Als Achsart
								wird bei den einzelnen Messwerten jeweils der
								Typ der Mehrfachachse (nicht Einzelachse!)
								angegeben.
		</p>
		
		@param _achslast der neue Wert von Achslast.
		*/
		public void setAchslast(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		 _achslast) {
			this._achslast = _achslast;
		}
	
		/**
		Radlast des linken Rads.
		<p>
		Die Bytes enthalten die ermittelte linke&#47; rechte
								Radlast einer einzelnen Achse, gesehen in
								Fahrtrichtung. Als Radlast gilt dabei die Last
								aller Räder (auch bei Doppelreifen) einer
								Achsenseite. Bei Mehrfachachsen wird für jede
								einzelne Achse ein gesonderter Satz Messwerte
								(jeweils Überladung&#47;Achsart, Radasten,
								Achsabstand) im DE-Block übertragen. Als Achsart
								wird bei den einzelnen Messwerten jeweils der
								Typ der Mehrfachachse (nicht Einzelachse!)
								angegeben.
		</p>
		
		@return der Wert von RadlastLinks.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
			 getRadlastLinks() {
			return _radlastLinks;
		}
	
		/**
		Radlast des linken Rads.
		<p>
		Die Bytes enthalten die ermittelte linke&#47; rechte
								Radlast einer einzelnen Achse, gesehen in
								Fahrtrichtung. Als Radlast gilt dabei die Last
								aller Räder (auch bei Doppelreifen) einer
								Achsenseite. Bei Mehrfachachsen wird für jede
								einzelne Achse ein gesonderter Satz Messwerte
								(jeweils Überladung&#47;Achsart, Radasten,
								Achsabstand) im DE-Block übertragen. Als Achsart
								wird bei den einzelnen Messwerten jeweils der
								Typ der Mehrfachachse (nicht Einzelachse!)
								angegeben.
		</p>
		
		@param _radlastLinks der neue Wert von RadlastLinks.
		*/
		public void setRadlastLinks(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
		 _radlastLinks) {
			this._radlastLinks = _radlastLinks;
		}
	
		/**
		Radlast des rechten Rads.
		<p>
		Die Bytes enthalten die ermittelte linke&#47; rechte
								Radlast einer einzelnen Achse, gesehen in
								Fahrtrichtung. Als Radlast gilt dabei die Last
								aller Räder (auch bei Doppelreifen) einer
								Achsenseite. Bei Mehrfachachsen wird für jede
								einzelne Achse ein gesonderter Satz Messwerte
								(jeweils Überladung&#47;Achsart, Radasten,
								Achsabstand) im DE-Block übertragen. Als Achsart
								wird bei den einzelnen Messwerten jeweils der
								Typ der Mehrfachachse (nicht Einzelachse!)
								angegeben.
		</p>
		
		@return der Wert von RadlastRechts.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
			 getRadlastRechts() {
			return _radlastRechts;
		}
	
		/**
		Radlast des rechten Rads.
		<p>
		Die Bytes enthalten die ermittelte linke&#47; rechte
								Radlast einer einzelnen Achse, gesehen in
								Fahrtrichtung. Als Radlast gilt dabei die Last
								aller Räder (auch bei Doppelreifen) einer
								Achsenseite. Bei Mehrfachachsen wird für jede
								einzelne Achse ein gesonderter Satz Messwerte
								(jeweils Überladung&#47;Achsart, Radasten,
								Achsabstand) im DE-Block übertragen. Als Achsart
								wird bei den einzelnen Messwerten jeweils der
								Typ der Mehrfachachse (nicht Einzelachse!)
								angegeben.
		</p>
		
		@param _radlastRechts der neue Wert von RadlastRechts.
		*/
		public void setRadlastRechts(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
		 _radlastRechts) {
			this._radlastRechts = _radlastRechts;
		}
	
		/**
		Abstand zur vorherfahrenden Achse.
		<p>
		In diesem Byte wird der gemessene Abstand
								zwischen der vorherfahrenden Achse und der
								jetzigen Achse abgespeichert. Bei der ersten
								Achse eines Fahrzeugs wird der Abstand zur
								letzten Achse der vorherfahrenden Fahrzeugs
								angebeben. Bei der ersten Achse des ersten
								Fahrzeug wird der Wert 65535 eingetragen
		</p>
		
		@return der Wert von Achsabstand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge3
			 getAchsabstand() {
			return _achsabstand;
		}
	
		/**
		Abstand zur vorherfahrenden Achse.
		<p>
		In diesem Byte wird der gemessene Abstand
								zwischen der vorherfahrenden Achse und der
								jetzigen Achse abgespeichert. Bei der ersten
								Achse eines Fahrzeugs wird der Abstand zur
								letzten Achse der vorherfahrenden Fahrzeugs
								angebeben. Bei der ersten Achse des ersten
								Fahrzeug wird der Wert 65535 eingetragen
		</p>
		
		@param _achsabstand der neue Wert von Achsabstand.
		*/
		public void setAchsabstand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge3
		 _achsabstand) {
			this._achsabstand = _achsabstand;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getUeberlastEinzelachse() != null) {
	                if (getUeberlastEinzelachse().isZustand()) {
	                    datum.getUnscaledValue("ÜberlastEinzelachse").setText(getUeberlastEinzelachse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ÜberlastEinzelachse").set(getUeberlastEinzelachse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUeberlastDoppelachse() != null) {
	                if (getUeberlastDoppelachse().isZustand()) {
	                    datum.getUnscaledValue("ÜberlastDoppelachse").setText(getUeberlastDoppelachse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ÜberlastDoppelachse").set(getUeberlastDoppelachse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUeberlastDreifachachse() != null) {
	                if (getUeberlastDreifachachse().isZustand()) {
	                    datum.getUnscaledValue("ÜberlastDreifachachse").setText(getUeberlastDreifachachse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ÜberlastDreifachachse").set(getUeberlastDreifachachse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAchslast() != null) {
	                if (getAchslast().isZustand()) {
	                    datum.getUnscaledValue("Achslast").setText(getAchslast().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Achslast").set(getAchslast().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRadlastLinks() != null) {
	                if (getRadlastLinks().isZustand()) {
	                    datum.getUnscaledValue("RadlastLinks").setText(getRadlastLinks().toString());
	                } else {
						datum.
						getScaledValue
	                	("RadlastLinks").set(getRadlastLinks().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRadlastRechts() != null) {
	                if (getRadlastRechts().isZustand()) {
	                    datum.getUnscaledValue("RadlastRechts").setText(getRadlastRechts().toString());
	                } else {
						datum.
						getScaledValue
	                	("RadlastRechts").set(getRadlastRechts().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAchsabstand() != null) {
	                if (getAchsabstand().isZustand()) {
	                    datum.getUnscaledValue("Achsabstand").setText(getAchsabstand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Achsabstand").set(getAchsabstand().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ÜberlastEinzelachse").isState()) {
							setUeberlastEinzelachse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
							.getZustand(daten.getScaledValue("ÜberlastEinzelachse").getText()));
						} else {
						setUeberlastEinzelachse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
						(daten.
							getUnscaledValue
						("ÜberlastEinzelachse").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ÜberlastDoppelachse").isState()) {
							setUeberlastDoppelachse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
							.getZustand(daten.getScaledValue("ÜberlastDoppelachse").getText()));
						} else {
						setUeberlastDoppelachse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
						(daten.
							getUnscaledValue
						("ÜberlastDoppelachse").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ÜberlastDreifachachse").isState()) {
							setUeberlastDreifachachse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
							.getZustand(daten.getScaledValue("ÜberlastDreifachachse").getText()));
						} else {
						setUeberlastDreifachachse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlAchsartUeberlastung
						(daten.
							getUnscaledValue
						("ÜberlastDreifachachse").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Achslast").isState()) {
							setAchslast(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							.getZustand(daten.getScaledValue("Achslast").getText()));
						} else {
						setAchslast(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
						(daten.
							getUnscaledValue
						("Achslast").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RadlastLinks").isState()) {
							setRadlastLinks(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
							.getZustand(daten.getScaledValue("RadlastLinks").getText()));
						} else {
						setRadlastLinks(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
						(daten.
							getScaledValue
						("RadlastLinks").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RadlastRechts").isState()) {
							setRadlastRechts(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
							.getZustand(daten.getScaledValue("RadlastRechts").getText()));
						} else {
						setRadlastRechts(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht1
						(daten.
							getScaledValue
						("RadlastRechts").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Achsabstand").isState()) {
							setAchsabstand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge3
							.getZustand(daten.getScaledValue("Achsabstand").getText()));
						} else {
						setAchsabstand(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge3
						(daten.
							getUnscaledValue
						("Achsabstand").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsAxlUeberlastungAchse clone() {
		AtlTlsAxlUeberlastungAchse klon = new AtlTlsAxlUeberlastungAchse();
		
						klon.setUeberlastEinzelachse(getUeberlastEinzelachse());
						klon.setUeberlastDoppelachse(getUeberlastDoppelachse());
						klon.setUeberlastDreifachachse(getUeberlastDreifachachse());
						klon.setAchslast(getAchslast());
						klon.setRadlastLinks(getRadlastLinks());
						klon.setRadlastRechts(getRadlastRechts());
						klon.setAchsabstand(getAchsabstand());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
