/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen zur Konfigurationstabelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsSysKonfigurationsTabellenZeile implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _oSI2Adresse
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _kanal
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _fG
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _dE
			;
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@return der Wert von OSI2Adresse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getOSI2Adresse() {
			return _oSI2Adresse;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@param _oSI2Adresse der neue Wert von OSI2Adresse.
		*/
		public void setOSI2Adresse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _oSI2Adresse) {
			this._oSI2Adresse = _oSI2Adresse;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@return der Wert von Kanal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getKanal() {
			return _kanal;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@param _kanal der neue Wert von Kanal.
		*/
		public void setKanal(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _kanal) {
			this._kanal = _kanal;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@return der Wert von FG.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getFG() {
			return _fG;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@param _fG der neue Wert von FG.
		*/
		public void setFG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _fG) {
			this._fG = _fG;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@return der Wert von DE.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getDE() {
			return _dE;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@param _dE der neue Wert von DE.
		*/
		public void setDE(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _dE) {
			this._dE = _dE;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOSI2Adresse() != null) {
	                if (getOSI2Adresse().isZustand()) {
	                    datum.getUnscaledValue("OSI2Adresse").setText(getOSI2Adresse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("OSI2Adresse").set(getOSI2Adresse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKanal() != null) {
	                if (getKanal().isZustand()) {
	                    datum.getUnscaledValue("Kanal").setText(getKanal().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kanal").set(getKanal().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFG() != null) {
	                if (getFG().isZustand()) {
	                    datum.getUnscaledValue("FG").setText(getFG().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FG").set(getFG().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDE() != null) {
	                if (getDE().isZustand()) {
	                    datum.getUnscaledValue("DE").setText(getDE().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("DE").set(getDE().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setOSI2Adresse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("OSI2Adresse").
								shortValue
						()));
				// GanzzahlAttributTyp
						setKanal(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("Kanal").
								shortValue
						()));
				// GanzzahlAttributTyp
						setFG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("FG").
								shortValue
						()));
				// GanzzahlAttributTyp
						setDE(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("DE").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsSysKonfigurationsTabellenZeile clone() {
		AtlTlsSysKonfigurationsTabellenZeile klon = new AtlTlsSysKonfigurationsTabellenZeile();
		
						klon.setOSI2Adresse(getOSI2Adresse());
						klon.setKanal(getKanal());
						klon.setFG(getFG());
						klon.setDE(getDE());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
