/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Adresspaar für das OSI-3-Routing. Reihenfolge der
					Adressen ist immer von Streckenstation zur
					Unterzentrale (nach "oben").
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsSysOSI3AdressPaar implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _adresse1
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _adresse2
			;
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@return der Wert von Adresse1.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getAdresse1() {
			return _adresse1;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@param _adresse1 der neue Wert von Adresse1.
		*/
		public void setAdresse1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _adresse1) {
			this._adresse1 = _adresse1;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@return der Wert von Adresse2.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getAdresse2() {
			return _adresse2;
		}
	
		/**
		TLS-Byte (0-255).
		<p>
		
		</p>
		
		@param _adresse2 der neue Wert von Adresse2.
		*/
		public void setAdresse2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _adresse2) {
			this._adresse2 = _adresse2;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAdresse1() != null) {
	                if (getAdresse1().isZustand()) {
	                    datum.getUnscaledValue("Adresse1").setText(getAdresse1().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Adresse1").set(getAdresse1().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAdresse2() != null) {
	                if (getAdresse2().isZustand()) {
	                    datum.getUnscaledValue("Adresse2").setText(getAdresse2().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Adresse2").set(getAdresse2().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setAdresse1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("Adresse1").
								shortValue
						()));
				// GanzzahlAttributTyp
						setAdresse2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("Adresse2").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsSysOSI3AdressPaar clone() {
		AtlTlsSysOSI3AdressPaar klon = new AtlTlsSysOSI3AdressPaar();
		
						klon.setAdresse1(getAdresse1());
						klon.setAdresse2(getAdresse2());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
