/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
OSI-3-Routingblock für die Vermittlung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsSysOSI3RoutingBlock implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _fG
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsSysOSI3AdressPaar
			> _vermittlungsAbschnitt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsSysOSI3AdressPaar
			>(7, true);
	
		/**
		Funktionsgruppe, für die der Routingblock glit
								(FG=255 gilt für alle FG, die nicht speziell
								umdefiniert wurden).
		<p>
		
		</p>
		
		@return der Wert von FG.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getFG() {
			return _fG;
		}
	
		/**
		Funktionsgruppe, für die der Routingblock glit
								(FG=255 gilt für alle FG, die nicht speziell
								umdefiniert wurden).
		<p>
		
		</p>
		
		@param _fG der neue Wert von FG.
		*/
		public void setFG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _fG) {
			this._fG = _fG;
		}
	
		/**
		Adresspaar für das OSI-3-Routing. Reihenfolge der
							Adressen ist immer von Streckenstation zur
							Unterzentrale (nach "oben").
		<p>
		
		</p>
		
		@return der Wert von VermittlungsAbschnitt.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsSysOSI3AdressPaar
			> getVermittlungsAbschnitt() {
			return _vermittlungsAbschnitt;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFG() != null) {
	                if (getFG().isZustand()) {
	                    datum.getUnscaledValue("FG").setText(getFG().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FG").set(getFG().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayVermittlungsAbschnitt = datum.getArray("VermittlungsAbschnitt");
					arrayVermittlungsAbschnitt.setLength(getVermittlungsAbschnitt().size());
					for (int i = 0; i < arrayVermittlungsAbschnitt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsSysOSI3AdressPaar
						 atl = getVermittlungsAbschnitt().get(i);
						atl.bean2Atl(arrayVermittlungsAbschnitt.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setFG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("FG").
								shortValue
						()));
				// AttributListenDefinition
					final Data.Array arrayVermittlungsAbschnitt = daten.getArray("VermittlungsAbschnitt");
					for (int i = 0; i < arrayVermittlungsAbschnitt.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsSysOSI3AdressPaar
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsSysOSI3AdressPaar
						 ();
						atl.atl2Bean(arrayVermittlungsAbschnitt.getItem(i), factory);
						getVermittlungsAbschnitt().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsSysOSI3RoutingBlock clone() {
		AtlTlsSysOSI3RoutingBlock klon = new AtlTlsSysOSI3RoutingBlock();
		
						klon.setFG(getFG());
					klon._vermittlungsAbschnitt = getVermittlungsAbschnitt().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
