/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste mit allen Einstellmöglichkeiten für die
					WvzCOdeDefinition.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgCodeDefinition implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 _anzeigePrinzip
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeDefinition
			 _stellCode
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzLampenDefinition
			> _lampenDefinition = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzLampenDefinition
			>(852, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
			> _textDefinition = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
			>(213, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			> _gruppenDefinition = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			>(106, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzClusterDefinition
			> _clusterDefinition = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzClusterDefinition
			>(53, true);
	
		/**
		Anzeigeprinzip des WZG entsprechend TLS.
		<p>
		
		</p>
		
		@return der Wert von AnzeigePrinzip.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 getAnzeigePrinzip() {
			return _anzeigePrinzip;
		}
	
		/**
		Anzeigeprinzip des WZG entsprechend TLS.
		<p>
		
		</p>
		
		@param _anzeigePrinzip der neue Wert von AnzeigePrinzip.
		*/
		public void setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
		 _anzeigePrinzip) {
			this._anzeigePrinzip = _anzeigePrinzip;
		}
	
		/**
		Stellcode für Codelistendefinitionen.
		<p>
		
		</p>
		
		@return der Wert von StellCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeDefinition
			 getStellCode() {
			return _stellCode;
		}
	
		/**
		Stellcode für Codelistendefinitionen.
		<p>
		
		</p>
		
		@param _stellCode der neue Wert von StellCode.
		*/
		public void setStellCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeDefinition
		 _stellCode) {
			this._stellCode = _stellCode;
		}
	
		/**
		Lampenzuordnung bei Anzeigeprinzig B.
		<p>
		
		</p>
		
		@return der Wert von LampenDefinition.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzLampenDefinition
			> getLampenDefinition() {
			return _lampenDefinition;
		}
	
	
		/**
		Wechseltextdefiniton bei Anzeigeprinzig C und D.
		<p>
		
		</p>
		
		@return der Wert von TextDefinition.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
			> getTextDefinition() {
			return _textDefinition;
		}
	
	
		/**
		WVZ-Anzeigendefinition bei Anzeigeprinzip E.
		<p>
		
		</p>
		
		@return der Wert von GruppenDefinition.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			> getGruppenDefinition() {
			return _gruppenDefinition;
		}
	
	
		/**
		Komponentendefiniton an Clustern.
		<p>
		
		</p>
		
		@return der Wert von ClusterDefinition.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzClusterDefinition
			> getClusterDefinition() {
			return _clusterDefinition;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAnzeigePrinzip() != null) {
	                if (getAnzeigePrinzip().isZustand()) {
	                    datum.getUnscaledValue("AnzeigePrinzip").setText(getAnzeigePrinzip().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzeigePrinzip").set(getAnzeigePrinzip().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStellCode() != null) {
	                if (getStellCode().isZustand()) {
	                    datum.getUnscaledValue("StellCode").setText(getStellCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StellCode").set(getStellCode().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayLampenDefinition = datum.getArray("LampenDefinition");
					arrayLampenDefinition.setLength(getLampenDefinition().size());
					for (int i = 0; i < arrayLampenDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzLampenDefinition
						 atl = getLampenDefinition().get(i);
						atl.bean2Atl(arrayLampenDefinition.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayTextDefinition = datum.getArray("TextDefinition");
					arrayTextDefinition.setLength(getTextDefinition().size());
					for (int i = 0; i < arrayTextDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
						 atl = getTextDefinition().get(i);
						atl.bean2Atl(arrayTextDefinition.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayGruppenDefinition = datum.getArray("GruppenDefinition");
					arrayGruppenDefinition.setLength(getGruppenDefinition().size());
					for (int i = 0; i < arrayGruppenDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
						 atl = getGruppenDefinition().get(i);
						atl.bean2Atl(arrayGruppenDefinition.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayClusterDefinition = datum.getArray("ClusterDefinition");
					arrayClusterDefinition.setLength(getClusterDefinition().size());
					for (int i = 0; i < arrayClusterDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzClusterDefinition
						 atl = getClusterDefinition().get(i);
						atl.bean2Atl(arrayClusterDefinition.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AnzeigePrinzip").isState()) {
							setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
							.getZustand(daten.getScaledValue("AnzeigePrinzip").getText()));
						} else {
						setAnzeigePrinzip(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
						(daten.
							getUnscaledValue
						("AnzeigePrinzip").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StellCode").isState()) {
							setStellCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeDefinition
							.getZustand(daten.getScaledValue("StellCode").getText()));
						} else {
						setStellCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeDefinition
						(daten.
							getUnscaledValue
						("StellCode").
								shortValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayLampenDefinition = daten.getArray("LampenDefinition");
					for (int i = 0; i < arrayLampenDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzLampenDefinition
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzLampenDefinition
						 ();
						atl.atl2Bean(arrayLampenDefinition.getItem(i), factory);
						getLampenDefinition().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayTextDefinition = daten.getArray("TextDefinition");
					for (int i = 0; i < arrayTextDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
						 ();
						atl.atl2Bean(arrayTextDefinition.getItem(i), factory);
						getTextDefinition().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayGruppenDefinition = daten.getArray("GruppenDefinition");
					for (int i = 0; i < arrayGruppenDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
						 ();
						atl.atl2Bean(arrayGruppenDefinition.getItem(i), factory);
						getGruppenDefinition().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayClusterDefinition = daten.getArray("ClusterDefinition");
					for (int i = 0; i < arrayClusterDefinition.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzClusterDefinition
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzClusterDefinition
						 ();
						atl.atl2Bean(arrayClusterDefinition.getItem(i), factory);
						getClusterDefinition().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgCodeDefinition clone() {
		AtlTlsWzgCodeDefinition klon = new AtlTlsWzgCodeDefinition();
		
						klon.setAnzeigePrinzip(getAnzeigePrinzip());
						klon.setStellCode(getStellCode());
					klon._lampenDefinition = getLampenDefinition().clone();
					klon._textDefinition = getTextDefinition().clone();
					klon._gruppenDefinition = getGruppenDefinition().clone();
					klon._clusterDefinition = getClusterDefinition().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
