/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen bei der Anzeige eines WVZ.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgWvzAnzeige implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
			 _code
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
			 _blinken
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
			 _status
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
			()
			;
	
		/**
		WVZ Code gemäß TLS.
		<p>
		
		</p>
		
		@return der Wert von Code.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
			 getCode() {
			return _code;
		}
	
		/**
		WVZ Code gemäß TLS.
		<p>
		
		</p>
		
		@param _code der neue Wert von Code.
		*/
		public void setCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
		 _code) {
			this._code = _code;
		}
	
		/**
		Einzelinformationen zum Blinkverhalten bei der
							Anzeige des WVZ.
		<p>
		
		</p>
		
		@return der Wert von Blinken.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
			 getBlinken() {
			return _blinken;
		}
	
		/**
		Einzelinformationen zum Blinkverhalten bei der
							Anzeige des WVZ.
		<p>
		
		</p>
		
		@param _blinken der neue Wert von Blinken.
		*/
		public void setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzBlinken
		 _blinken) {
			this._blinken = _blinken;
		}
	
		/**
		Einzelinformationen zum Fehler- und Programmzustand
							bei der Anzeige eines WVZ.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Einzelinformationen zum Fehler- und Programmzustand
							bei der Anzeige eines WVZ.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
		 _status) {
			this._status = _status;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getCode() != null) {
	                if (getCode().isZustand()) {
	                    datum.getUnscaledValue("Code").setText(getCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Code").set(getCode().getValue());
	                }
				}
				// AttributListenDefinition
					getBlinken().bean2Atl(datum.getItem("Blinken"), factory);
				// AttributListenDefinition
					getStatus().bean2Atl(datum.getItem("Status"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Code").isState()) {
							setCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
							.getZustand(daten.getScaledValue("Code").getText()));
						} else {
						setCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
						(daten.
							getUnscaledValue
						("Code").
								shortValue
						()));
						}
				// AttributListenDefinition
					getBlinken().atl2Bean(daten.getItem("Blinken"), factory);
				// AttributListenDefinition
					getStatus().atl2Bean(daten.getItem("Status"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgWvzAnzeige clone() {
		AtlTlsWzgWvzAnzeige klon = new AtlTlsWzgWvzAnzeige();
		
						klon.setCode(getCode());
						klon._blinken = getBlinken().clone();
						klon._status = getStatus().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
