/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen zum Blinkverhalten bei der
					Anzeige des WVZ.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgWvzBlinken implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkStatus
			 _status
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkDauer
			 _dauer
			;
	
		/**
		Blinkstatus.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Blinkstatus.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkStatus
		 _status) {
			this._status = _status;
		}
	
		/**
		Blinkdauer (gesamte Periode in 200ms Schritten).
		<p>
		
		</p>
		
		@return der Wert von Dauer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkDauer
			 getDauer() {
			return _dauer;
		}
	
		/**
		Blinkdauer (gesamte Periode in 200ms Schritten).
		<p>
		
		</p>
		
		@param _dauer der neue Wert von Dauer.
		*/
		public void setDauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkDauer
		 _dauer) {
			this._dauer = _dauer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getStatus() != null) {
	                if (getStatus().isZustand()) {
	                    datum.getUnscaledValue("Status").setText(getStatus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Status").set(getStatus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDauer() != null) {
	                if (getDauer().isZustand()) {
	                    datum.getUnscaledValue("Dauer").setText(getDauer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Dauer").set(getDauer().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Status").isState()) {
							setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkStatus
							.getZustand(daten.getScaledValue("Status").getText()));
						} else {
						setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkStatus
						(daten.
							getUnscaledValue
						("Status").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Dauer").isState()) {
							setDauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkDauer
							.getZustand(daten.getScaledValue("Dauer").getText()));
						} else {
						setDauer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzBlinkDauer
						(daten.
							getUnscaledValue
						("Dauer").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgWvzBlinken clone() {
		AtlTlsWzgWvzBlinken klon = new AtlTlsWzgWvzBlinken();
		
						klon.setStatus(getStatus());
						klon.setDauer(getDauer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
