/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen zum Fehler- und Programmzustand
					bei der Anzeige eines WVZ.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgWvzStatus implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzFehlerStatus
			 _fehler
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzProgrammStatus
			 _programm
			;
	
		/**
		Fehlerzustand .
		<p>
		
		</p>
		
		@return der Wert von Fehler.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzFehlerStatus
			 getFehler() {
			return _fehler;
		}
	
		/**
		Fehlerzustand .
		<p>
		
		</p>
		
		@param _fehler der neue Wert von Fehler.
		*/
		public void setFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzFehlerStatus
		 _fehler) {
			this._fehler = _fehler;
		}
	
		/**
		Programmzustand.
		<p>
		
		</p>
		
		@return der Wert von Programm.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzProgrammStatus
			 getProgramm() {
			return _programm;
		}
	
		/**
		Programmzustand.
		<p>
		
		</p>
		
		@param _programm der neue Wert von Programm.
		*/
		public void setProgramm(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzProgrammStatus
		 _programm) {
			this._programm = _programm;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFehler() != null) {
	                if (getFehler().isZustand()) {
	                    datum.getUnscaledValue("Fehler").setText(getFehler().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Fehler").set(getFehler().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getProgramm() != null) {
	                if (getProgramm().isZustand()) {
	                    datum.getUnscaledValue("Programm").setText(getProgramm().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Programm").set(getProgramm().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Fehler").isState()) {
							setFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzFehlerStatus
							.getZustand(daten.getScaledValue("Fehler").getText()));
						} else {
						setFehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzFehlerStatus
						(daten.
							getUnscaledValue
						("Fehler").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Programm").isState()) {
							setProgramm(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzProgrammStatus
							.getZustand(daten.getScaledValue("Programm").getText()));
						} else {
						setProgramm(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzProgrammStatus
						(daten.
							getUnscaledValue
						("Programm").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgWvzStatus clone() {
		AtlTlsWzgWvzStatus klon = new AtlTlsWzgWvzStatus();
		
						klon.setFehler(getFehler());
						klon.setProgramm(getProgramm());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
