/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erfassungsintervalldauer.
<p>
&lt;absatz&gt;
						Byte enthält den Wert der
						Erfassungsintervalldauer in folgenden
						Zeiteinheiten:
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Bit7 = 1: Einheit = Stunde&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Bit0..6: Zeitwert in Stunden [1..120]
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Es sind nur Stundenwerte zugelassen, die
						ganzzahlige Teiler oder ganzzahlige Mehrfache
						von 24 Stunden sind (1, 2, 3, 4, 6, 8, 12, 24,
						48, 72, 96, 120 Stunden).
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Bit7 = 0: Einheit = ¼ - Stunde&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Bit0..6: Zeitwert in ¼ -Stunden [1..120]
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Es sind nur ¼ -Stundenwerte zugelassen, die
						ganzzahlige Teiler von 24 Stunden sind (1, 2, 3,
						4, 6, 8, 12, 16, 24, 32,48, 96 ¼ - Stunden)
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsAxlErfassungsintervalldauer extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_1__15_MINUTEN = new AttTlsAxlErfassungsintervalldauer("15 Minuten", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_2__30_MINUTEN = new AttTlsAxlErfassungsintervalldauer("30 Minuten", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_3__45_MINUTEN = new AttTlsAxlErfassungsintervalldauer("45 Minuten", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_4__1_STUNDE = new AttTlsAxlErfassungsintervalldauer("1 Stunde", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_6__1_5_STUNDEN = new AttTlsAxlErfassungsintervalldauer("1,5 Stunden", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_8__2_STUNDEN = new AttTlsAxlErfassungsintervalldauer("2 Stunden", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_12__3_STUNDEN = new AttTlsAxlErfassungsintervalldauer("3 Stunden", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_16__4_STUNDEN = new AttTlsAxlErfassungsintervalldauer("4 Stunden", 		Short
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_24__6_STUNDEN = new AttTlsAxlErfassungsintervalldauer("6 Stunden", 		Short
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_32__8_STUNDEN = new AttTlsAxlErfassungsintervalldauer("8 Stunden", 		Short
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_48__12_STUNDEN = new AttTlsAxlErfassungsintervalldauer("12 Stunden", 		Short
	.valueOf("48"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_96__24_STUNDEN = new AttTlsAxlErfassungsintervalldauer("24 Stunden", 		Short
	.valueOf("96"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_192__48_STUDEN = new AttTlsAxlErfassungsintervalldauer("48 Studen", 		Short
	.valueOf("192"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_288__72_STUNDEN = new AttTlsAxlErfassungsintervalldauer("72 Stunden", 		Short
	.valueOf("288"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_384__96_STUNDEN = new AttTlsAxlErfassungsintervalldauer("96 Stunden", 		Short
	.valueOf("384"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlErfassungsintervalldauer ZUSTAND_480__120_STUNDEN = new AttTlsAxlErfassungsintervalldauer("120 Stunden", 		Short
	.valueOf("480"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsAxlErfassungsintervalldauer getZustand(final 		Short
	 value) {
		for (AttTlsAxlErfassungsintervalldauer e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsAxlErfassungsintervalldauer getZustand(final String value) {
		for (AttTlsAxlErfassungsintervalldauer e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsAxlErfassungsintervalldauer> getZustaende() {
		List<AttTlsAxlErfassungsintervalldauer> list = new ArrayList<AttTlsAxlErfassungsintervalldauer>();
		list.add(ZUSTAND_1__15_MINUTEN);
		list.add(ZUSTAND_2__30_MINUTEN);
		list.add(ZUSTAND_3__45_MINUTEN);
		list.add(ZUSTAND_4__1_STUNDE);
		list.add(ZUSTAND_6__1_5_STUNDEN);
		list.add(ZUSTAND_8__2_STUNDEN);
		list.add(ZUSTAND_12__3_STUNDEN);
		list.add(ZUSTAND_16__4_STUNDEN);
		list.add(ZUSTAND_24__6_STUNDEN);
		list.add(ZUSTAND_32__8_STUNDEN);
		list.add(ZUSTAND_48__12_STUNDEN);
		list.add(ZUSTAND_96__24_STUNDEN);
		list.add(ZUSTAND_192__48_STUDEN);
		list.add(ZUSTAND_288__72_STUNDEN);
		list.add(ZUSTAND_384__96_STUNDEN);
		list.add(ZUSTAND_480__120_STUNDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSAxlErfassungsintervalldauer.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsAxlErfassungsintervalldauer(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsAxlErfassungsintervalldauer(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
